/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd.parser;

import com.ibm.dtfj.phd.PHDImage;
import com.ibm.dtfj.phd.parser.Base;
import com.ibm.dtfj.phd.parser.PortableHeapDumpListener;
import com.ibm.dtfj.phd.util.BufferedNumberStream;
import com.ibm.dtfj.phd.util.LongEnumeration;
import com.ibm.dtfj.phd.util.NumberStream;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import javax.imageio.stream.ImageInputStream;

public class HeapdumpReader
extends Base {
    private static final long MAX_UNSIGNED_INT_AS_LONG = 0xFFFFFFFFL;
    String filename;
    DataStreamAdapter dis;
    long lastAddress;
    long[] classAddressCache = new long[4];
    int classAddressCacheIndex;
    int totalObjects;
    int totalRefs;
    int version;
    int random1;
    int random2;
    int totalLong;
    int totalShort;
    int totalMedium;
    int totalPrim;
    int totalLongPrim;
    int totalClass;
    int totalArray;
    int totalHash;
    int totalActualRefs;
    int totalNegGaps;
    Vector classNames = new Vector();
    int dumpFlags;
    String full_version = "unknown";
    boolean dbg = debug;
    boolean pre78432;
    int gapShift = 3;
    boolean j9;
    NumberStream refStream = new BufferedNumberStream();
    RefEnum refEnum = new RefEnum(this.refStream);
    private static final boolean nomangle = Boolean.getBoolean("findroots.nomangle");
    boolean continueParse;
    PHDImage image = null;

    public HeapdumpReader(File file, PHDImage pHDImage) throws IOException {
        this(file.getAbsolutePath());
        this.image = pHDImage;
        if (this.image == null) {
            throw new NullPointerException("PHDImage must be provided to allow streams to be cleaned up.");
        }
        this.image.registerReader(this);
    }

    public HeapdumpReader(ImageInputStream imageInputStream, PHDImage pHDImage) throws IOException {
        this(imageInputStream);
        this.image = pHDImage;
        if (this.image == null) {
            throw new NullPointerException("PHDImage must be provided to allow streams to be cleaned up.");
        }
        this.image.registerReader(this);
    }

    protected HeapdumpReader(ImageInputStream imageInputStream) throws IOException {
        this.filename = "[data stream]";
        imageInputStream.seek(0L);
        this.dis = new DataStreamAdapter(imageInputStream);
        this.processData();
    }

    protected HeapdumpReader(String string) throws IOException {
        if (this.dbg) {
            System.out.println("opening file " + string);
        }
        this.filename = string;
        FilterInputStream filterInputStream = null;
        try {
            if (string.endsWith(".gz")) {
                filterInputStream = new BufferedInputStream(new GZIPInputStream(new FileInputStream(string)));
            } else {
                FileInputStream fileInputStream = new FileInputStream(string);
                filterInputStream = new BufferedInputStream(fileInputStream);
            }
            this.dis = new DataStreamAdapter(new DataInputStream(filterInputStream));
            this.processData();
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            try {
                UTFDataFormatException uTFDataFormatException2;
                if (string.endsWith(".gz")) {
                    filterInputStream = new GZIPInputStream(new FileInputStream(string));
                } else {
                    FileInputStream fileInputStream = new FileInputStream(string);
                    filterInputStream = new BufferedInputStream(fileInputStream);
                }
                this.dis = new DataStreamAdapter(new DataInputStream(filterInputStream));
                long l = this.dis.readLong();
                if (l == 5303217658343391L) {
                    UTFDataFormatException uTFDataFormatException3 = new UTFDataFormatException("Warning!\nThis PHD file has been ftp'd in ascii mode and is consequently unusable.\nPlease go back and ftp the original file again but this time specifying binary ftp mode.");
                    uTFDataFormatException3.initCause(uTFDataFormatException);
                    uTFDataFormatException2 = uTFDataFormatException3;
                    System.err.println(uTFDataFormatException2.getMessage());
                }
                throw uTFDataFormatException2;
            }
            catch (Exception exception) {
                IOException iOException = new IOException("Error parsing PHD file");
                iOException.initCause(exception);
                throw iOException;
            }
        }
        catch (Exception exception) {
            IOException iOException = new IOException("Error parsing PHD file");
            iOException.initCause(exception);
            throw iOException;
        }
    }

    private void processData() throws IOException {
        try {
            int n;
            this.dis.mark(2);
            int n2 = this.dis.readUnsignedShort();
            this.dis.reset();
            String string = this.readUTF();
            if (this.dbg) {
                System.out.println("read header: " + string);
            }
            if (string.equals("portable heap dump")) {
                this.version = this.dis.readInt();
                if (this.version != 4 && this.version != 5 && this.version != 6) {
                    throw new IOException("unexpected version: " + this.version);
                }
            } else {
                throw new IOException("bad header in '" + this.filename + "' : " + (char)(n2 >> 8 & 0xFF) + (char)(n2 & 0xFF) + string.substring(0, Math.min(string.length(), 50)));
            }
            if (this.dbg) {
                System.out.println("phd version: " + this.version);
            }
            if (this.version == 5) {
                this.gapShift = 2;
            }
            this.dumpFlags = this.dis.readInt();
            if ((this.dumpFlags & 4) != 0) {
                this.gapShift = 2;
                this.j9 = true;
            }
            if (this.dbg) {
                System.out.println("read dump flags 0x" + HeapdumpReader.hex(this.dumpFlags));
            }
            HeapdumpReader.Assert((n = this.dis.readUnsignedByte()) == 1);
            if (this.dbg) {
                System.out.println("read start of header tag");
            }
            block8: do {
                n = this.dis.readUnsignedByte();
                switch (n) {
                    case 1: {
                        if (this.dbg) {
                            System.out.println("read totals tag");
                        }
                        this.totalObjects = this.dis.readInt();
                        this.totalRefs = this.dis.readInt();
                        break;
                    }
                    case 2: {
                        if (!this.dbg) continue block8;
                        System.out.println("read end of header tag");
                        break;
                    }
                    case 3: {
                        if (this.dbg) {
                            System.out.println("read hashcodes tag");
                        }
                        this.random1 = this.dis.readInt();
                        this.random2 = this.dis.readInt();
                        break;
                    }
                    case 4: {
                        this.full_version = this.readUTF();
                        if (this.full_version.endsWith("0917")) {
                            this.pre78432 = true;
                        }
                        if (!this.dbg) continue block8;
                        System.out.println("read full version tag, version = " + this.full_version);
                        break;
                    }
                    default: {
                        throw new IOException("unrecognized tag: " + n);
                    }
                }
            } while (n != 2);
            n = this.dis.readUnsignedByte();
            HeapdumpReader.Assert(n == 2);
            if (this.dbg) {
                System.out.println("read start of dump tag");
            }
        }
        catch (Exception exception) {
            IOException iOException = new IOException("Error parsing PHD file");
            iOException.initCause(exception);
            throw iOException;
        }
    }

    public String full_version() {
        return this.full_version;
    }

    public int version() {
        return this.version;
    }

    public boolean is64Bit() {
        return (this.dumpFlags & 1) != 0;
    }

    public boolean isJ9() {
        return this.j9;
    }

    public boolean allObjectsHashed() {
        return (this.dumpFlags & 2) != 0;
    }

    public int totalObjects() {
        return this.totalObjects;
    }

    public int totalRefs() {
        return this.totalRefs;
    }

    int Handle2Hash(long l) {
        return (int)(l >>> 3);
    }

    int ROTATE(int n, int n2) {
        return n >>> n2 | n << 32 - n2;
    }

    int MANGLE(int n) {
        return (this.ROTATE(n ^ this.random1, 17) ^ this.random2) >>> 1;
    }

    int getHashCode(long l, int n) throws Exception {
        if (this.j9 && this.allObjectsHashed()) {
            if (this.dbg) {
                System.out.println("request to getHashCode (j9)");
            }
            int n2 = this.dis.readShort() & Short.MAX_VALUE;
            return n2 << 16 | n2;
        }
        if (n != 0) {
            if (this.dbg) {
                System.out.println("request to getHashCode (sov/J9 R26+)");
            }
            ++this.totalHash;
            return this.dis.readInt();
        }
        if (!this.j9) {
            if (this.dbg) {
                System.out.println("request to getHashCode (sov mangle)");
            }
            return nomangle ? 0 : this.MANGLE(this.Handle2Hash(l));
        }
        if (this.dbg) {
            System.out.println("request to getHashCode (J9 unset)");
        }
        return 0;
    }

    private long getInstanceSize() throws IOException {
        if (this.version >= 6) {
            int n = this.dis.readInt();
            return (0xFFFFFFFFL & (long)n) * 4L;
        }
        return -1L;
    }

    long readWord() throws Exception {
        if (this.is64Bit()) {
            return this.dis.readLong();
        }
        return this.dis.readInt();
    }

    long readUnsignedWord() throws Exception {
        if (this.is64Bit()) {
            return this.dis.readLong();
        }
        int n = this.dis.readInt();
        return 0xFFFFFFFFL & (long)n;
    }

    void readRefs(long l, long l2, int n, int n2) throws IOException {
        this.refStream.clear();
        long l3 = 0L;
        if (this.dbg) {
            System.out.println("readRefs, numRefs = " + n + " refsSize = " + n2);
        }
        for (int i = 0; i < n; ++i) {
            long l4;
            l3 = n2 == 0 ? (long)(this.dis.readByte() << this.gapShift) : (n2 == 1 ? (long)(this.dis.readShort() << this.gapShift) : (n2 == 2 ? (long)this.dis.readInt() << this.gapShift : this.dis.readLong() << this.gapShift));
            long l5 = l4 = this.is64Bit() ? l + l3 : l + l3 & 0xFFFFFFFFL;
            if (this.j9 && i == 0 && l4 == l2) continue;
            this.refStream.writeLong(l4);
            if (this.dbg) {
                System.out.println("read ref " + HeapdumpReader.hex(l4) + " with gap " + HeapdumpReader.hex(l3));
            }
            ++this.totalActualRefs;
        }
        this.refStream.rewind();
    }

    void reverseOrderOfRefs() {
        int n;
        int n2 = this.refEnum.numberOfElements();
        long[] lArray = new long[n2];
        for (n = 0; n < n2; ++n) {
            lArray[n] = (Long)this.refEnum.nextElement();
        }
        this.refStream.clear();
        for (n = n2 - 1; n >= 0; --n) {
            this.refStream.writeLong(lArray[n]);
        }
        this.refStream.rewind();
    }

    long getRelativeAddress(int n) throws IOException {
        long l = 0L;
        switch (n) {
            case 0: {
                l = this.dis.readByte() << this.gapShift;
                if (!this.dbg) break;
                System.out.println("relative address 0x" + HeapdumpReader.hex(this.lastAddress + l) + " = last address 0x" + HeapdumpReader.hex(this.lastAddress) + " + byte gap 0x" + HeapdumpReader.hex(l));
                break;
            }
            case 1: {
                l = this.dis.readShort() << this.gapShift;
                if (!this.dbg) break;
                System.out.println("relative address 0x" + HeapdumpReader.hex(this.lastAddress + l) + " = last address 0x" + HeapdumpReader.hex(this.lastAddress) + " + short gap 0x" + HeapdumpReader.hex(l));
                break;
            }
            case 2: {
                l = (long)this.dis.readInt() << this.gapShift;
                if (!this.dbg) break;
                System.out.println("relative address 0x" + HeapdumpReader.hex(this.lastAddress + l) + " = last address 0x" + HeapdumpReader.hex(this.lastAddress) + " + int gap 0x" + HeapdumpReader.hex(l));
                break;
            }
            case 3: {
                l = this.dis.readLong() << this.gapShift;
                if (!this.dbg) break;
                System.out.println("relative address 0x" + HeapdumpReader.hex(this.lastAddress + l) + " = last address 0x" + HeapdumpReader.hex(this.lastAddress) + " + long gap 0x" + HeapdumpReader.hex(l));
            }
        }
        return this.is64Bit() ? this.lastAddress + l : this.lastAddress + l & 0xFFFFFFFFL;
    }

    public void exitParse() {
        this.continueParse = false;
    }

    public boolean parse(PortableHeapDumpListener portableHeapDumpListener) throws Exception {
        long l = 0L;
        this.continueParse = true;
        block8: while (this.continueParse) {
            int n;
            int n2;
            int n3;
            int n4 = this.dis.readUnsignedByte();
            if (this.dbg) {
                System.out.println("read tag " + HeapdumpReader.hex(n4));
            }
            if ((n4 & 0x80) != 0) {
                long l2 = this.classAddressCache[(n4 &= 0x7F) >> 5];
                n3 = n4 >> 3 & 3;
                n2 = n4 & 3;
                l = this.getRelativeAddress(n4 >> 2 & 1);
                int n5 = this.getHashCode(l, 0);
                n = this.j9 || this.allObjectsHashed() ? 1 : 0;
                this.readRefs(l, l2, n3, n2);
                if (this.dbg) {
                    System.out.println(HeapdumpReader.hex(l) + ": short object, class = " + HeapdumpReader.hex(l2));
                }
                ++this.totalShort;
                this.lastAddress = l;
                portableHeapDumpListener.objectDump(l, l2, n, n5, this.refEnum, -1L);
                continue;
            }
            if ((n4 & 0x40) != 0) {
                long l3;
                int n6 = (n4 &= 0x3F) >> 3;
                int n7 = n4 & 3;
                l = this.getRelativeAddress(n4 >> 2 & 1);
                this.classAddressCache[this.classAddressCacheIndex] = l3 = this.readUnsignedWord();
                this.classAddressCacheIndex = (this.classAddressCacheIndex + 1) % 4;
                int n8 = this.getHashCode(l, 0);
                n = this.j9 || this.allObjectsHashed() ? 1 : 0;
                this.readRefs(l, l3, n6, n7);
                if (this.dbg) {
                    System.out.println(HeapdumpReader.hex(l) + ": medium object, class = " + HeapdumpReader.hex(l3));
                }
                ++this.totalMedium;
                this.lastAddress = l;
                portableHeapDumpListener.objectDump(l, l3, n, n8, this.refEnum, -1L);
                continue;
            }
            if ((n4 & 0x20) != 0) {
                int n9;
                int n10 = n4 >> 2 & 7;
                int n11 = n4 & 3;
                n3 = 0;
                if (this.pre78432 && n11 == 3) {
                    l = this.lastAddress + (long)(this.dis.readInt() << this.gapShift);
                    n3 = this.dis.readInt();
                    if (this.dbg) {
                        System.out.println("warning! bad primitive array");
                    }
                } else {
                    l = this.getRelativeAddress(n11);
                    n3 = n11 == 0 ? this.dis.readUnsignedByte() : (n11 == 1 ? this.dis.readUnsignedShort() : (n11 == 2 ? this.dis.readInt() : (int)this.dis.readLong()));
                }
                n2 = this.getHashCode(l, 0);
                long l4 = this.getInstanceSize();
                int n12 = n9 = this.j9 || this.allObjectsHashed() ? 1 : 0;
                if (this.dbg) {
                    System.out.println(HeapdumpReader.hex(l) + ": primitive array, short record, length " + n3 + ", instance size = " + l4);
                }
                ++this.totalPrim;
                this.lastAddress = l;
                portableHeapDumpListener.primitiveArrayDump(l, n10, n3, n9, n2, l4);
                continue;
            }
            switch (n4) {
                case 3: {
                    if (nomangle) {
                        System.out.println("totalLong = " + this.totalLong + " totalMedium = " + this.totalMedium + " totalShort = " + this.totalShort + " totalPrim = " + this.totalPrim + " totalHash = " + this.totalHash);
                    }
                    if (nomangle) {
                        System.out.println("totalLongPrim = " + this.totalLongPrim + " totalClass = " + this.totalClass + " totalArray = " + this.totalArray + " totalRefs = " + this.totalActualRefs);
                    }
                    if (nomangle) {
                        System.out.println("version = " + this.version);
                    }
                    return false;
                }
                case 4: {
                    long l5;
                    int n13 = this.dis.readUnsignedByte();
                    l = this.getRelativeAddress(n13 >> 6 & 3);
                    this.classAddressCache[this.classAddressCacheIndex] = l5 = this.readUnsignedWord();
                    this.classAddressCacheIndex = (this.classAddressCacheIndex + 1) % 4;
                    n2 = this.getHashCode(l, n13 & 2);
                    int n14 = (this.j9 || this.allObjectsHashed() ? 1 : 0) | n13 & 3;
                    n = this.dis.readInt();
                    int n15 = n13 >> 4 & 3;
                    this.readRefs(l, l5, n, n15);
                    long l6 = -1L;
                    if (this.dbg) {
                        System.out.println(HeapdumpReader.hex(l) + ": long object, hash code = " + HeapdumpReader.hex(n2) + " flags = " + HeapdumpReader.hex(n13) + " class = " + HeapdumpReader.hex(l5) + " numRefs = " + n + " instance size = " + l6);
                    }
                    ++this.totalLong;
                    this.lastAddress = l;
                    portableHeapDumpListener.objectDump(l, l5, n14, n2, this.refEnum, l6);
                    continue block8;
                }
                case 8: {
                    ++this.totalArray;
                }
                case 5: {
                    int n16 = this.dis.readUnsignedByte();
                    l = this.getRelativeAddress(n16 >> 6 & 3);
                    long l7 = this.readUnsignedWord();
                    n2 = this.getHashCode(l, n16 & 2);
                    int n17 = (this.j9 || this.allObjectsHashed() ? 1 : 0) | n16 & 3;
                    n = this.dis.readInt();
                    int n18 = n16 >> 4 & 3;
                    this.readRefs(l, l7, n, n18);
                    this.reverseOrderOfRefs();
                    int n19 = n;
                    if (n4 == 8) {
                        n19 = this.dis.readInt();
                    }
                    long l8 = this.getInstanceSize();
                    if (this.dbg) {
                        System.out.println(HeapdumpReader.hex(l) + ": object array, hash code = " + HeapdumpReader.hex(n2) + " flags = " + HeapdumpReader.hex(n16) + " num refs = " + n + " length = " + n19 + " instance size = " + l8);
                    }
                    this.lastAddress = l;
                    portableHeapDumpListener.objectArrayDump(l, l7, n17, n2, this.refEnum, n19, l8);
                    continue block8;
                }
                case 6: {
                    int n20 = this.dis.readUnsignedByte();
                    l = this.getRelativeAddress(n20 >> 6 & 3);
                    int n21 = this.dis.readInt();
                    n3 = this.getHashCode(l, n20 & 8);
                    n2 = (this.j9 || this.allObjectsHashed() ? 1 : 0) | ((n20 & 8) != 0 ? 3 : 0);
                    long l9 = this.readUnsignedWord();
                    if (this.dbg) {
                        System.out.println(HeapdumpReader.hex(l) + ": class flags = " + HeapdumpReader.hex(n20) + " hashCode = " + HeapdumpReader.hex(n3) + " instanceSize = " + n21 + " superAddress = " + HeapdumpReader.hex(l9));
                    }
                    String string = this.readUTF();
                    if (this.dbg) {
                        System.out.println(HeapdumpReader.hex(l) + ": class " + string);
                    }
                    int n22 = this.dis.readInt();
                    int n23 = n20 >> 4 & 3;
                    this.readRefs(l, -1L, n22, n23);
                    ++this.totalClass;
                    this.lastAddress = l;
                    portableHeapDumpListener.classDump(l, l9, string, n21, n2, n3, this.refEnum);
                    continue block8;
                }
                case 7: {
                    int n24 = this.dis.readUnsignedByte();
                    int n25 = n24 >>> 5;
                    n3 = 0;
                    if ((n24 & 0x10) == 0) {
                        l = this.lastAddress + (long)(this.dis.readByte() << this.gapShift);
                        n3 = this.dis.readUnsignedByte();
                    } else {
                        l = this.lastAddress + (this.readWord() << this.gapShift);
                        n3 = (int)this.readUnsignedWord();
                    }
                    n2 = this.getHashCode(l, n24 & 2);
                    long l10 = this.getInstanceSize();
                    int n26 = (this.j9 || this.allObjectsHashed() ? 1 : 0) | n24 & 3;
                    if (this.dbg) {
                        System.out.println(HeapdumpReader.hex(l) + ": primitive array, long record, length = " + n3 + " hash code = " + HeapdumpReader.hex(n2) + " flags = " + HeapdumpReader.hex(n24) + " instance size = " + l10);
                    }
                    ++this.totalLongPrim;
                    this.lastAddress = l;
                    portableHeapDumpListener.primitiveArrayDump(l, n25, n3, n26, n2, l10);
                    continue block8;
                }
            }
            throw new Exception("unexpected tag: " + n4);
        }
        return true;
    }

    @Override
    String className() {
        return "HeapdumpReader";
    }

    private String readUTF() throws IOException {
        int n = this.dis.readUnsignedShort();
        byte[] byArray = new byte[n];
        this.dis.readFully(byArray);
        return new String(byArray, "UTF-8");
    }

    public void close() {
        if (this.dis != null) {
            try {
                this.dis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void releaseResources() {
        if (this.dis != null) {
            try {
                this.dis.releaseResources();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void main(String[] stringArray) throws IOException {
        HeapdumpReader heapdumpReader = new HeapdumpReader(stringArray[0]);
        System.out.println("is64Bit = " + (heapdumpReader.is64Bit() ? "true" : "false"));
        System.out.println("phd version = " + heapdumpReader.version());
        System.out.println("full version = " + heapdumpReader.full_version());
        System.out.println("total objects = " + heapdumpReader.totalObjects());
        System.out.println("total refs = " + heapdumpReader.totalRefs());
        heapdumpReader.close();
    }

    private class DataStreamAdapter {
        private final DataInputStream dis;
        private final ImageInputStream iis;

        public DataStreamAdapter(ImageInputStream imageInputStream) {
            this.iis = imageInputStream;
            this.dis = null;
        }

        public DataStreamAdapter(DataInputStream dataInputStream) {
            this.dis = dataInputStream;
            this.iis = null;
        }

        public int readInt() throws IOException {
            if (this.dis == null) {
                return this.iis.readInt();
            }
            return this.dis.readInt();
        }

        public int readUnsignedShort() throws IOException {
            if (this.dis == null) {
                return this.iis.readUnsignedShort();
            }
            return this.dis.readUnsignedShort();
        }

        public int readUnsignedByte() throws IOException {
            if (this.dis == null) {
                return this.iis.readUnsignedByte();
            }
            return this.dis.readUnsignedByte();
        }

        public void mark(int n) {
            if (this.dis == null) {
                this.iis.mark();
            } else {
                this.dis.mark(n);
            }
        }

        public void reset() throws IOException {
            if (this.dis == null) {
                this.iis.reset();
            } else {
                this.dis.reset();
            }
        }

        public long readLong() throws IOException {
            if (this.dis == null) {
                return this.iis.readLong();
            }
            return this.dis.readLong();
        }

        public short readShort() throws IOException {
            if (this.dis == null) {
                return this.iis.readShort();
            }
            return this.dis.readShort();
        }

        public byte readByte() throws IOException {
            if (this.dis == null) {
                return this.iis.readByte();
            }
            return this.dis.readByte();
        }

        public void readFully(byte[] byArray) throws IOException {
            if (this.dis == null) {
                this.iis.readFully(byArray);
            } else {
                this.dis.readFully(byArray);
            }
        }

        public void close() throws IOException {
            if (this.dis != null) {
                this.dis.close();
            }
        }

        public void releaseResources() throws IOException {
            if (this.dis == null) {
                this.iis.close();
            } else {
                this.dis.close();
            }
        }
    }

    class RefEnum
    implements LongEnumeration {
        NumberStream stream;

        RefEnum(NumberStream numberStream) {
            this.stream = numberStream;
        }

        @Override
        public boolean hasMoreElements() {
            return this.stream.hasMore();
        }

        @Override
        public boolean hasNumberOfElements() {
            return true;
        }

        @Override
        public int numberOfElements() {
            return this.stream.elementCount();
        }

        public Object nextElement() {
            return this.nextLong();
        }

        @Override
        public long nextLong() {
            return this.stream.readLong();
        }

        public void reset() {
            this.stream.clear();
        }
    }
}

