/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ec;

import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import jdk.crypto.jniprovider.NativeCrypto;
import sun.security.ec.ECDSASignature;
import sun.security.ec.ECKeyFactory;
import sun.security.ec.NativeECUtil;
import sun.security.provider.Sun;
import sun.security.util.ECUtil;

abstract class NativeECDSASignature
extends SignatureSpi {
    private static NativeCrypto nativeCrypto;
    private static final boolean nativeCryptTrace;
    private final MessageDigest messageDigest;
    private SecureRandom random;
    private boolean needsReset;
    private ECPrivateKey privateKey;
    private long nativePrivateKey;
    private ECPublicKey publicKey;
    private long nativePublicKey;
    private ECParameterSpec sigParams;
    ECDSASignature javaImplementation;

    NativeECDSASignature() {
        this.messageDigest = null;
    }

    NativeECDSASignature(String string) {
        try {
            this.messageDigest = MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ProviderException(noSuchAlgorithmException);
        }
        this.needsReset = false;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        ECPublicKey eCPublicKey = (ECPublicKey)ECKeyFactory.toECKey(publicKey);
        if (!NativeECDSASignature.isCompatible(this.sigParams, eCPublicKey.getParams())) {
            throw new InvalidKeyException("Key params does not match signature params");
        }
        this.publicKey = eCPublicKey;
        this.privateKey = null;
        this.resetDigest();
        this.nativePublicKey = NativeECUtil.getPublicKeyNativePtr(eCPublicKey);
        if (this.nativePublicKey == -1L) {
            this.javaImplementation = this.getJavaInstance();
            this.javaImplementation.engineInitVerify(publicKey);
            if (nativeCryptTrace) {
                System.err.println("InitVerify: Could not create a pointer to a native key. Using Java implementation.");
            }
            return;
        }
        this.javaImplementation = null;
        if (nativeCryptTrace) {
            System.err.println("InitVerify: Keys were successfully converted to native OpenSSL format.");
        }
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.engineInitSign(privateKey, null);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        ECPrivateKey eCPrivateKey;
        if (secureRandom == null) {
            if (nativeCryptTrace) {
                System.err.println("No SecureRandom implementation was provided during initialization. Using OpenSSL.");
            }
        } else if (secureRandom.getProvider() instanceof Sun && ("NativePRNG".equals(secureRandom.getAlgorithm()) || "DRBG".equals(secureRandom.getAlgorithm()))) {
            if (nativeCryptTrace) {
                System.err.println("Default SecureRandom implementation was provided during initialization. Using OpenSSL.");
            }
        } else {
            if (nativeCryptTrace) {
                System.err.println("SecureRandom implementation was provided during initialization. Using Java implementation instead of OpenSSL.");
            }
            this.javaImplementation = this.getJavaInstance();
            this.javaImplementation.engineInitSign(privateKey, secureRandom);
            return;
        }
        if (!NativeECDSASignature.isCompatible(this.sigParams, (eCPrivateKey = (ECPrivateKey)ECKeyFactory.toECKey(privateKey)).getParams())) {
            throw new InvalidKeyException("Key params does not match signature params");
        }
        this.privateKey = eCPrivateKey;
        this.publicKey = null;
        this.random = secureRandom;
        this.resetDigest();
        this.nativePrivateKey = NativeECUtil.getPrivateKeyNativePtr(eCPrivateKey);
        if (this.nativePrivateKey == -1L) {
            this.javaImplementation = this.getJavaInstance();
            this.javaImplementation.engineInitSign(privateKey, secureRandom);
            if (nativeCryptTrace) {
                System.err.println("InitSign: Could not create a pointer to a native key. Using Java implementation.");
            }
            return;
        }
        this.javaImplementation = null;
        if (nativeCryptTrace) {
            System.err.println("InitSign: Keys were successfully converted to native OpenSSL format.");
        }
    }

    void resetDigest() {
        if (this.needsReset) {
            if (this.messageDigest != null) {
                this.messageDigest.reset();
            }
            this.needsReset = false;
        }
    }

    byte[] getDigestValue() throws SignatureException {
        this.needsReset = false;
        return this.messageDigest.digest();
    }

    @Override
    protected void engineUpdate(byte by) throws SignatureException {
        if (this.javaImplementation != null) {
            this.javaImplementation.engineUpdate(by);
        } else {
            this.messageDigest.update(by);
            this.needsReset = true;
        }
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        if (this.javaImplementation != null) {
            this.javaImplementation.engineUpdate(byArray, n, n2);
        } else {
            this.messageDigest.update(byArray, n, n2);
            this.needsReset = true;
        }
    }

    @Override
    protected void engineUpdate(ByteBuffer byteBuffer) {
        if (this.javaImplementation != null) {
            this.javaImplementation.engineUpdate(byteBuffer);
        } else {
            int n = byteBuffer.remaining();
            if (n <= 0) {
                return;
            }
            this.messageDigest.update(byteBuffer);
            this.needsReset = true;
        }
    }

    private static boolean isCompatible(ECParameterSpec eCParameterSpec, ECParameterSpec eCParameterSpec2) {
        if (eCParameterSpec == null) {
            return true;
        }
        return ECUtil.equals(eCParameterSpec, eCParameterSpec2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] engineSign() throws SignatureException {
        int n;
        if (this.javaImplementation != null) {
            return this.javaImplementation.engineSign();
        }
        byte[] byArray = this.getDigestValue();
        int n2 = byArray.length;
        ECParameterSpec eCParameterSpec = this.privateKey.getParams();
        int n3 = (eCParameterSpec.getOrder().bitLength() + 7) / 8 * 2;
        byte[] byArray2 = new byte[n3];
        if (nativeCrypto == null) {
            nativeCrypto = NativeCrypto.getNativeCrypto();
        }
        ECPrivateKey eCPrivateKey = this.privateKey;
        synchronized (eCPrivateKey) {
            n = nativeCrypto.ECDSASign(this.nativePrivateKey, byArray, n2, byArray2, byArray2.length);
        }
        if (n == -1) {
            throw new ProviderException("An error occured when creating signature");
        }
        if (nativeCryptTrace) {
            System.err.println("Sign: Signature was successfully created.");
        }
        return ECUtil.encodeSignature(byArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        int n;
        if (this.javaImplementation != null) {
            return this.javaImplementation.engineVerify(byArray);
        }
        if (nativeCrypto == null) {
            nativeCrypto = NativeCrypto.getNativeCrypto();
        }
        byte[] byArray2 = ECUtil.decodeSignature(byArray);
        byte[] byArray3 = this.getDigestValue();
        int n2 = byArray3.length;
        ECPublicKey eCPublicKey = this.publicKey;
        synchronized (eCPublicKey) {
            n = nativeCrypto.ECDSAVerify(this.nativePublicKey, byArray3, n2, byArray2, byArray2.length);
        }
        if (n == 1) {
            if (nativeCryptTrace) {
                System.err.println("Verify: Signature was successfully verified.");
            }
            return true;
        }
        if (n == 0) {
            if (nativeCryptTrace) {
                System.err.println("Verify: Signature verification was unsuccessful.");
            }
            return false;
        }
        throw new ProviderException("An error occured when verifying signature");
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new UnsupportedOperationException("setParameter() not supported");
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        Key key;
        if (algorithmParameterSpec == null) {
            this.sigParams = null;
            return;
        }
        if (!(algorithmParameterSpec instanceof ECParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Parameters must be of type ECParameterSpec");
        }
        Key key2 = key = this.privateKey == null ? this.publicKey : this.privateKey;
        if (key != null && !NativeECDSASignature.isCompatible((ECParameterSpec)algorithmParameterSpec, key.getParams())) {
            throw new InvalidAlgorithmParameterException("Signature params does not match key params");
        }
        this.sigParams = (ECParameterSpec)algorithmParameterSpec;
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new UnsupportedOperationException("getParameter() not supported");
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.sigParams == null) {
            return null;
        }
        try {
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("EC");
            algorithmParameters.init(this.sigParams);
            return algorithmParameters;
        }
        catch (Exception exception) {
            throw new ProviderException("Error retrieving EC parameters", exception);
        }
    }

    private ECDSASignature getJavaInstance() {
        String string;
        if (this.messageDigest == null) {
            return new ECDSASignature.Raw();
        }
        switch (string = this.messageDigest.getAlgorithm()) {
            case "SHA1": {
                return new ECDSASignature.SHA1();
            }
            case "SHA-224": {
                return new ECDSASignature.SHA224();
            }
            case "SHA-256": {
                return new ECDSASignature.SHA256();
            }
            case "SHA-384": {
                return new ECDSASignature.SHA384();
            }
            case "SHA-512": {
                return new ECDSASignature.SHA512();
            }
        }
        throw new ProviderException("Unexpected algorithm: " + string);
    }

    static {
        nativeCryptTrace = NativeCrypto.isTraceEnabled();
    }

    public static final class SHA512
    extends NativeECDSASignature {
        public SHA512() {
            super("SHA-512");
        }
    }

    public static final class SHA384
    extends NativeECDSASignature {
        public SHA384() {
            super("SHA-384");
        }
    }

    public static final class SHA256
    extends NativeECDSASignature {
        public SHA256() {
            super("SHA-256");
        }
    }

    public static final class SHA224
    extends NativeECDSASignature {
        public SHA224() {
            super("SHA-224");
        }
    }

    public static final class SHA1
    extends NativeECDSASignature {
        public SHA1() {
            super("SHA1");
        }
    }

    public static final class Raw
    extends NativeECDSASignature {
        private static final int RAW_ECDSA_MAX = 64;
        private final byte[] precomputedDigest = new byte[64];
        private int offset;

        @Override
        protected void engineUpdate(byte by) throws SignatureException {
            if (this.javaImplementation != null) {
                this.javaImplementation.engineUpdate(by);
            } else {
                if (this.offset >= this.precomputedDigest.length) {
                    this.offset = 65;
                    return;
                }
                this.precomputedDigest[this.offset++] = by;
            }
        }

        @Override
        protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
            if (this.javaImplementation != null) {
                this.javaImplementation.engineUpdate(byArray, n, n2);
            } else {
                if (this.offset >= this.precomputedDigest.length) {
                    this.offset = 65;
                    return;
                }
                System.arraycopy(byArray, n, this.precomputedDigest, this.offset, n2);
                this.offset += n2;
            }
        }

        @Override
        protected void engineUpdate(ByteBuffer byteBuffer) {
            if (this.javaImplementation != null) {
                this.javaImplementation.engineUpdate(byteBuffer);
            } else {
                int n = byteBuffer.remaining();
                if (n <= 0) {
                    return;
                }
                if (n >= this.precomputedDigest.length - this.offset) {
                    this.offset = 65;
                    return;
                }
                byteBuffer.get(this.precomputedDigest, this.offset, n);
                this.offset += n;
            }
        }

        @Override
        void resetDigest() {
            this.offset = 0;
        }

        @Override
        byte[] getDigestValue() throws SignatureException {
            if (this.offset > 64) {
                throw new SignatureException("Message digest is too long");
            }
            byte[] byArray = new byte[this.offset];
            System.arraycopy(this.precomputedDigest, 0, byArray, 0, this.offset);
            this.offset = 0;
            return byArray;
        }
    }
}

