/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.util.PatternString;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.HashTable;
import com.ibm.j9ddr.vm29.j9.ModuleHashTable;
import com.ibm.j9ddr.vm29.j9.gc.GCClassLoaderIterator;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ModulePointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.JavaVersionHelper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.ModularityHelper;
import java.io.PrintStream;
import java.util.Iterator;

public class FindModuleByNameCommand
extends Command {
    public FindModuleByNameCommand() {
        this.addCommand("findmodulebyname", "<moduleName>", "find the modules corresponding to a name pattern (e.g. 'java.*')");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        if (stringArray.length == 0) {
            this.printUsage(printStream);
            return;
        }
        try {
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            if (JavaVersionHelper.ensureJava9AndUp(j9JavaVMPointer, printStream)) {
                GCClassLoaderIterator gCClassLoaderIterator = GCClassLoaderIterator.from();
                int n = 0;
                String string2 = stringArray[0];
                PatternString patternString = new PatternString(string2);
                printStream.printf("Searching for modules named '%s' in VM=%s%n", string2, Long.toHexString(j9JavaVMPointer.getAddress()));
                while (gCClassLoaderIterator.hasNext()) {
                    J9ClassLoaderPointer j9ClassLoaderPointer = gCClassLoaderIterator.next();
                    HashTable<J9ModulePointer> hashTable = ModuleHashTable.fromJ9HashTable(j9ClassLoaderPointer.moduleHashTable());
                    Iterator iterator = hashTable.iterator();
                    while (iterator.hasNext()) {
                        J9ModulePointer j9ModulePointer = (J9ModulePointer)iterator.next();
                        String string3 = ModularityHelper.getModuleName(j9ModulePointer);
                        if (!patternString.isMatch(string3)) continue;
                        ++n;
                        String string4 = j9ModulePointer.getHexAddress();
                        printStream.printf("%-30s !j9module %s%n", string3, string4);
                    }
                }
                printStream.printf("Found %d module(s) named '%s'%n", n, string2);
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }

    private void printUsage(PrintStream printStream) {
        printStream.println("findmodulebyname <moduleNamePattern> - find the modules corresponding to a name pattern (e.g. 'java.*')");
    }
}

