/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.image.j9.CorruptData;
import com.ibm.dtfj.image.j9.ImageSection;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.JavaHeap;
import com.ibm.dtfj.java.JavaMonitor;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.dtfj.java.j9.JavaAbstractClass;
import com.ibm.dtfj.java.j9.JavaArrayClass;
import com.ibm.dtfj.java.j9.JavaClass;
import com.ibm.dtfj.java.j9.JavaField;
import com.ibm.dtfj.java.j9.JavaHeapRegion;
import com.ibm.dtfj.java.j9.JavaInstanceField;
import com.ibm.dtfj.java.j9.JavaReference;
import com.ibm.dtfj.java.j9.JavaRuntime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class JavaObject
implements com.ibm.dtfj.java.JavaObject {
    private JavaRuntime _javaVM;
    private ImagePointer _basePointer;
    private com.ibm.dtfj.java.j9.JavaHeap _containingHeap;
    private long _arrayletSpineSize;
    private long _arrayletLeafSize;
    private boolean _isArraylet = false;
    private int _objectAlignment;
    private byte _associatedObjectFlags = 0;
    private com.ibm.dtfj.java.JavaClass _associatedClass = null;
    private JavaMonitor _associatedMonitor = null;
    private JavaThread _associatedThread = null;
    private JavaClassLoader _associatedClassLoader = null;
    private static final byte CLASS_FLAG = 1;
    private static final byte THREAD_FLAG = 2;
    private static final byte MONITOR_FLAG = 4;
    private static final byte CLASSLOADER_FLAG = 8;
    protected static final String BOOLEAN_SIGNATURE = "Z";
    protected static final String BYTE_SIGNATURE = "B";
    protected static final String CHAR_SIGNATURE = "C";
    protected static final String SHORT_SIGNATURE = "S";
    protected static final String INTEGER_SIGNATURE = "I";
    protected static final String LONG_SIGNATURE = "J";
    protected static final String FLOAT_SIGNATURE = "F";
    protected static final String DOUBLE_SIGNATURE = "D";
    protected static final String ARRAY_PREFIX_SIGNATURE = "[";
    protected static final String OBJECT_PREFIX_SIGNATURE = "L";
    private Vector _references = null;

    JavaObject(JavaRuntime javaRuntime, ImagePointer imagePointer, com.ibm.dtfj.java.j9.JavaHeap javaHeap, long l, long l2, boolean bl, int n) throws CorruptDataException {
        if (null == javaRuntime) {
            throw new IllegalArgumentException("A Java Object cannot exist in a null VM");
        }
        this._basePointer = imagePointer;
        this._javaVM = javaRuntime;
        this._containingHeap = javaHeap;
        this._arrayletSpineSize = l;
        this._arrayletLeafSize = l2;
        this._isArraylet = bl;
        this._objectAlignment = n;
    }

    @Deprecated
    public static JavaObject createJavaObject(JavaRuntime javaRuntime, ImagePointer imagePointer) throws CorruptDataException {
        try {
            return (JavaObject)javaRuntime.getObjectAtAddress(imagePointer);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @Deprecated
    public static JavaObject createJavaObject(JavaRuntime javaRuntime, ImagePointer imagePointer, com.ibm.dtfj.java.j9.JavaHeap javaHeap, JavaHeapRegion javaHeapRegion) throws CorruptDataException {
        try {
            return (JavaObject)javaHeapRegion.getObjectAtAddress(imagePointer);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @Override
    public com.ibm.dtfj.java.JavaClass getJavaClass() throws CorruptDataException {
        if (0L != this._basePointer.getAddress()) {
            com.ibm.dtfj.java.JavaClass javaClass;
            ImagePointer imagePointer;
            if (this._containingHeap == null) {
                throw new CorruptDataException(new CorruptData("unable to access class pointer as containing heap is null", this._basePointer));
            }
            try {
                imagePointer = this._containingHeap.readClassPointerRelativeTo(this._basePointer);
            }
            catch (MemoryAccessException memoryAccessException) {
                throw new CorruptDataException(new CorruptData("unable to access class pointer", this._basePointer));
            }
            long l = imagePointer.getAddress();
            long l2 = this._containingHeap.getClassAlignment();
            long l3 = l;
            if (l2 > 0L) {
                l3 &= l2 - 1L ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if ((javaClass = this._javaVM.getClassForID(l3)) == null) {
                throw new CorruptDataException(new CorruptData("Unknown class ID " + Long.toHexString(l3) + " for object " + Long.toHexString(this._basePointer.getAddress()) + " (read class ID from " + Long.toHexString(imagePointer.getAddress()) + ", in memory value was " + Long.toHexString(l) + ")", this._basePointer));
            }
            return javaClass;
        }
        throw new NullPointerException();
    }

    @Override
    public boolean isArray() throws CorruptDataException {
        return this.getJavaClass().isArray();
    }

    @Override
    public int getArraySize() throws CorruptDataException {
        com.ibm.dtfj.java.JavaClass javaClass = this.getJavaClass();
        if (javaClass instanceof JavaArrayClass) {
            JavaArrayClass javaArrayClass = (JavaArrayClass)javaClass;
            int n = javaArrayClass.getSizeOffset();
            int n2 = javaArrayClass.getNumberOfSizeBytes();
            try {
                int n3 = 0;
                if (4 == n2) {
                    n3 = this._basePointer.getIntAt(n);
                } else if (8 == n2) {
                    long l = this._basePointer.getLongAt(n);
                    n3 = (int)l;
                    if ((long)n3 != l) {
                        System.err.println("Error:  Array element count overflow or underflow.");
                    }
                } else {
                    System.err.println("Error:  unable to read array size as we weren't expecting to read " + n2 + " bytes.");
                }
                return n3;
            }
            catch (MemoryAccessException memoryAccessException) {
                throw new CorruptDataException(new CorruptData("unable to read the number of elements", this._basePointer.add(n)));
            }
        }
        throw new IllegalArgumentException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void arraycopy(int n, Object object, int n2, int n3) throws CorruptDataException, MemoryAccessException {
        int n4;
        com.ibm.dtfj.java.JavaClass javaClass = this.getJavaClass();
        if (!(javaClass instanceof JavaArrayClass)) throw new IllegalArgumentException("this JavaObject instance is not an array");
        JavaArrayClass javaArrayClass = (JavaArrayClass)javaClass;
        String string = javaClass.getName();
        int n5 = this.getArraySize();
        if (null == object) {
            throw new NullPointerException("dst is null");
        }
        if (n3 < 0) {
            throw new ArrayIndexOutOfBoundsException("length out of range: " + n3);
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("dstStart out of range: " + n2);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("srcStart out of range: " + n);
        }
        if (n + n3 > n5) {
            throw new ArrayIndexOutOfBoundsException("source array index out of range: " + (n + n3));
        }
        if (string.equals("[B")) {
            if (!(object instanceof byte[])) throw new IllegalArgumentException("destination array type must be byte");
            byte[] byArray = (byte[])object;
            if (n2 + n3 > byArray.length) {
                throw new ArrayIndexOutOfBoundsException("destination array index out of range: " + (n2 + n3));
            }
            for (int i = 0; i < n3; ++i) {
                ImagePointer imagePointer = this.leafBaseForIndex(javaArrayClass.getFirstElementOffset(), (n + i) * 1);
                long l = this.leafIndexForIndex(javaArrayClass.getFirstElementOffset(), (n + i) * 1);
                byArray[i + n2] = imagePointer.getByteAt(l);
            }
            return;
        }
        if (string.equals("[Z")) {
            if (!(object instanceof boolean[])) throw new IllegalArgumentException("destination array type must be boolean");
            boolean[] blArray = (boolean[])object;
            if (n2 + n3 > blArray.length) {
                throw new ArrayIndexOutOfBoundsException("destination array index out of range: " + (n2 + n3));
            }
            for (int i = 0; i < n3; ++i) {
                long l;
                ImagePointer imagePointer = this.leafBaseForIndex(javaArrayClass.getFirstElementOffset(), (n + i) * 1);
                blArray[i + n2] = 0 != imagePointer.getByteAt(l = this.leafIndexForIndex(javaArrayClass.getFirstElementOffset(), (n + i) * 1));
            }
            return;
        }
        if (string.equals("[C")) {
            if (!(object instanceof char[])) throw new IllegalArgumentException("destination array type must be char");
            char[] cArray = (char[])object;
            if (n2 + n3 > cArray.length) {
                throw new ArrayIndexOutOfBoundsException("destination array index out of range: " + (n2 + n3));
            }
            for (int i = 0; i < n3; ++i) {
                ImagePointer imagePointer = this.leafBaseForIndex(javaArrayClass.getFirstElementOffset(), (n + i) * 2);
                long l = this.leafIndexForIndex(javaArrayClass.getFirstElementOffset(), (n + i) * 2);
                cArray[i + n2] = (char)imagePointer.getShortAt(l);
            }
            return;
        }
        if (string.equals("[S")) {
            if (!(object instanceof short[])) throw new IllegalArgumentException("destination array type must be short");
            short[] sArray = (short[])object;
            if (n2 + n3 > sArray.length) {
                throw new ArrayIndexOutOfBoundsException("destination array index out of range: " + (n2 + n3));
            }
            for (int i = 0; i < n3; ++i) {
                ImagePointer imagePointer = this.leafBaseForIndex(javaArrayClass.getFirstElementOffset(), (n + i) * 2);
                long l = this.leafIndexForIndex(javaArrayClass.getFirstElementOffset(), (n + i) * 2);
                sArray[i + n2] = imagePointer.getShortAt(l);
            }
            return;
        }
        if (string.equals("[I")) {
            if (!(object instanceof int[])) throw new IllegalArgumentException("destination array type must be int");
            int[] nArray = (int[])object;
            if (n2 + n3 > nArray.length) {
                throw new ArrayIndexOutOfBoundsException("destination array index out of range: " + (n2 + n3));
            }
            for (int i = 0; i < n3; ++i) {
                ImagePointer imagePointer = this.leafBaseForIndex(javaArrayClass.getFirstElementOffset(), (n + i) * 4);
                long l = this.leafIndexForIndex(javaArrayClass.getFirstElementOffset(), (n + i) * 4);
                nArray[i + n2] = imagePointer.getIntAt(l);
            }
            return;
        }
        if (string.equals("[J")) {
            if (!(object instanceof long[])) throw new IllegalArgumentException("destination array type must be long");
            long[] lArray = (long[])object;
            if (n2 + n3 > lArray.length) {
                throw new ArrayIndexOutOfBoundsException("destination array index out of range: " + (n2 + n3));
            }
            for (int i = 0; i < n3; ++i) {
                ImagePointer imagePointer = this.leafBaseForIndex(javaArrayClass.getFirstElementOffset(), (n + i) * 8);
                long l = this.leafIndexForIndex(javaArrayClass.getFirstElementOffset(), (n + i) * 8);
                lArray[i + n2] = imagePointer.getLongAt(l);
            }
            return;
        }
        if (string.equals("[F")) {
            if (!(object instanceof float[])) throw new IllegalArgumentException("destination array type must be float");
            float[] fArray = (float[])object;
            if (n2 + n3 > fArray.length) {
                throw new ArrayIndexOutOfBoundsException("destination array index out of range: " + (n2 + n3));
            }
            for (int i = 0; i < n3; ++i) {
                ImagePointer imagePointer = this.leafBaseForIndex(javaArrayClass.getFirstElementOffset(), (n + i) * 4);
                long l = this.leafIndexForIndex(javaArrayClass.getFirstElementOffset(), (n + i) * 4);
                fArray[i + n2] = imagePointer.getFloatAt(l);
            }
            return;
        }
        if (string.equals("[D")) {
            if (!(object instanceof double[])) throw new IllegalArgumentException("destination array type must be double");
            double[] dArray = (double[])object;
            if (n2 + n3 > dArray.length) {
                throw new ArrayIndexOutOfBoundsException("destination array index out of range: " + (n2 + n3));
            }
            for (int i = 0; i < n3; ++i) {
                ImagePointer imagePointer = this.leafBaseForIndex(javaArrayClass.getFirstElementOffset(), (n + i) * 8);
                long l = this.leafIndexForIndex(javaArrayClass.getFirstElementOffset(), (n + i) * 8);
                dArray[i + n2] = imagePointer.getDoubleAt(l);
            }
            return;
        }
        if (!(object instanceof Object[])) {
            throw new IllegalArgumentException("destination array type must be Object");
        }
        Object[] objectArray = (Object[])object;
        if (n2 + n3 > objectArray.length) {
            throw new ArrayIndexOutOfBoundsException("destination array index out of range: " + (n2 + n3));
        }
        Object[] objectArray2 = new Object[n3];
        for (n4 = 0; n4 < n3; ++n4) {
            int n6 = this._containingHeap.getFObjectSize();
            ImagePointer imagePointer = this.leafBaseForIndex(javaArrayClass.getFirstElementOffset(), (n + n4) * n6);
            long l = this.leafIndexForIndex(javaArrayClass.getFirstElementOffset(), (n + n4) * n6);
            ImagePointer imagePointer2 = this._containingHeap.readFObjectAt(imagePointer, l);
            try {
                if (imagePointer2.getAddress() == 0L) {
                    objectArray2[n4] = null;
                    continue;
                }
                try {
                    objectArray2[n4] = this._javaVM.getObjectAtAddress(imagePointer2);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new CorruptDataException(new CorruptData(illegalArgumentException.getMessage(), imagePointer2));
                }
            }
            catch (ArrayStoreException arrayStoreException) {
                throw new IllegalArgumentException(arrayStoreException.getMessage());
            }
        }
        for (n4 = 0; n4 < n3; ++n4) {
            try {
                objectArray[n2 + n4] = objectArray2[n4];
                continue;
            }
            catch (ArrayStoreException arrayStoreException) {
                throw new IllegalArgumentException(arrayStoreException.getMessage());
            }
        }
    }

    private long leafIndexForIndex(int n, long l) {
        long l2 = 0L;
        l2 = this.isArraylet() ? l % this._arrayletLeafSize : (long)n + l;
        return l2;
    }

    private ImagePointer leafBaseForIndex(int n, long l) throws CorruptDataException, MemoryAccessException {
        ImagePointer imagePointer = null;
        if (this.isArraylet()) {
            int n2 = this._containingHeap.getFObjectSize();
            long l2 = l / this._arrayletLeafSize;
            long l3 = (long)n + (long)n2 * l2;
            imagePointer = this._containingHeap.readFObjectAt(this._basePointer, l3);
        } else {
            imagePointer = this._basePointer;
        }
        return imagePointer;
    }

    @Override
    public long getSize() throws CorruptDataException {
        Iterator iterator = this.getSections();
        long l = 0L;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof ImageSection) {
                ImageSection imageSection = (ImageSection)e;
                l += imageSection.getSize();
                continue;
            }
            if (e instanceof CorruptData) {
                throw new CorruptDataException((CorruptData)e);
            }
            throw new RuntimeException("Found unexpected object " + e.getClass().getName());
        }
        return l;
    }

    @Override
    public long getHashcode() throws DataUnavailable, CorruptDataException {
        return this.getPersistentHashcode();
    }

    @Override
    public long getPersistentHashcode() throws DataUnavailable, CorruptDataException {
        if (this._javaVM.objectShouldInferHash()) {
            try {
                int n = ((JavaAbstractClass)this.getJavaClass()).readFlagsFromInstance(this);
                int n2 = n & 0x7FFF0000;
                long l = n2 >> 16 | n2;
                return l;
            }
            catch (MemoryAccessException memoryAccessException) {
                throw new CorruptDataException(new CorruptData("Address in object header but unreadable", this._basePointer));
            }
        }
        throw new DataUnavailable("Unknown hash strategy for this VM version");
    }

    @Override
    public ImagePointer getID() {
        return this._basePointer;
    }

    @Override
    public Iterator getSections() {
        List<Object> list;
        if (this.isArraylet()) {
            try {
                JavaArrayClass javaArrayClass = (JavaArrayClass)this.getJavaClass();
                int n = javaArrayClass.getFirstElementOffset();
                int n2 = this._javaVM.bytesPerPointer();
                try {
                    long l;
                    int n3 = javaArrayClass.getInstanceSize(this);
                    long l2 = n3 - n;
                    int n4 = (int)(l2 / this._arrayletLeafSize);
                    long l3 = l2 % this._arrayletLeafSize;
                    int n5 = 0L == l3 ? n4 : n4 + 1;
                    String string = javaArrayClass.getLeafClass().getName();
                    boolean bl = 4 == this._objectAlignment && ("double".equals(string) || "long".equals(string));
                    long l4 = l = (long)(n + n5 * n2);
                    long l5 = this._basePointer.getAddress() + l;
                    boolean bl2 = false;
                    if (bl && n5 > 0) {
                        if (0L == l5 % 8L) {
                            bl2 = true;
                        } else {
                            l4 += 4L;
                            if (0L != (l5 += 4L) % 8L) {
                                throw new CorruptDataException(new CorruptData("Arraylet leaf pointer misaligned for object", this._basePointer));
                            }
                        }
                    }
                    Vector<JavaObjectImageSection> vector = null;
                    for (int i = 0; i < n5; ++i) {
                        ImagePointer imagePointer = this._basePointer.getPointerAt(n + i * n2);
                        if (imagePointer.getAddress() == l5) {
                            long l6 = this._arrayletLeafSize;
                            if (n4 == i) {
                                l6 = l3;
                            }
                            l4 += l6;
                            l5 += l6;
                            continue;
                        }
                        if (null == vector) {
                            vector = new Vector<JavaObjectImageSection>();
                        }
                        vector.add(new JavaObjectImageSection(imagePointer, this._arrayletLeafSize));
                    }
                    if (bl2) {
                        l4 += 4L;
                    }
                    l4 = Math.max(l4, this._arrayletSpineSize);
                    JavaObjectImageSection javaObjectImageSection = new JavaObjectImageSection(this._basePointer, l4);
                    if (null == vector) {
                        list = Collections.singletonList(javaObjectImageSection);
                    } else {
                        list = new Vector<com.ibm.dtfj.image.CorruptData>();
                        list.add((com.ibm.dtfj.image.CorruptData)((Object)javaObjectImageSection));
                        list.addAll(vector);
                    }
                }
                catch (MemoryAccessException memoryAccessException) {
                    list = Collections.singletonList(new CorruptData("failed to walk arraylet spine", memoryAccessException.getPointer()));
                }
            }
            catch (CorruptDataException corruptDataException) {
                list = Collections.singletonList(corruptDataException.getCorruptData());
            }
        } else {
            long l = 0L;
            try {
                l = ((JavaAbstractClass)this.getJavaClass()).getInstanceSize(this);
                JavaObjectImageSection javaObjectImageSection = new JavaObjectImageSection(this._basePointer, l);
                list = Collections.singletonList(javaObjectImageSection);
            }
            catch (CorruptDataException corruptDataException) {
                list = Collections.singletonList(corruptDataException.getCorruptData());
            }
        }
        return list.iterator();
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof JavaObject) {
            JavaObject javaObject = (JavaObject)object;
            bl = this._javaVM.equals(javaObject._javaVM) && this._basePointer.equals(javaObject._basePointer);
        }
        return bl;
    }

    @Override
    public int hashCode() {
        return this._javaVM.hashCode() ^ this._basePointer.hashCode();
    }

    public boolean isArraylet() {
        return this._isArraylet;
    }

    public ImagePointer getFObjectAtOffset(int n) throws MemoryAccessException, CorruptDataException {
        return this._containingHeap.readFObjectAt(this._basePointer, n);
    }

    public int getFObjectSize() {
        return this._containingHeap.getFObjectSize();
    }

    @Override
    public Iterator getReferences() {
        if (null == this._references) {
            JavaArrayClass javaArrayClass;
            Object object;
            Object object2;
            this._references = new Vector();
            try {
                object2 = this.getJavaClass();
                if (null != object2) {
                    object = new JavaReference(this._javaVM, (Object)this, object2, "Class", 1, 0, 1);
                    this._references.add(object);
                }
                while (null != object2) {
                    object = null;
                    if (object2 instanceof JavaArrayClass) {
                        javaArrayClass = (JavaArrayClass)object2;
                        object = this.getArrayReferences(javaArrayClass);
                    } else if (object2 instanceof JavaClass) {
                        object = this.getFieldReferences((JavaClass)object2);
                    }
                    if (null != object) {
                        this._references.addAll(object);
                    }
                    object2 = object2.getSuperclass();
                }
            }
            catch (CorruptDataException corruptDataException) {
                this._references.add(corruptDataException.getCorruptData());
            }
            if (this.isClassLoader()) {
                object2 = this.getAssociatedClassLoader();
                object = object2.getDefinedClasses();
                while (object.hasNext()) {
                    javaArrayClass = object.next();
                    if (!(javaArrayClass instanceof com.ibm.dtfj.java.JavaClass)) continue;
                    com.ibm.dtfj.java.JavaClass javaClass = javaArrayClass;
                    JavaReference javaReference = new JavaReference(this._javaVM, (Object)this, javaClass, "Loaded class", 11, 0, 1);
                    this._references.add(javaReference);
                }
            }
            if (this.isMonitor()) {
                // empty if block
            }
            if (this.isThread()) {
                // empty if block
            }
            if (this.isClass()) {
                object2 = this.getAssociatedClass();
                object = new JavaReference(this._javaVM, (Object)this, object2, "Associated class", 13, 0, 1);
                this._references.add(object);
            }
        }
        return this._references.iterator();
    }

    public boolean isClass() {
        return (this._associatedObjectFlags & 1) > 0;
    }

    public boolean isMonitor() {
        return (this._associatedObjectFlags & 4) > 0;
    }

    public boolean isThread() {
        return (this._associatedObjectFlags & 2) > 0;
    }

    public boolean isClassLoader() {
        return (this._associatedObjectFlags & 8) > 0;
    }

    private List getFieldReferences(JavaClass javaClass) {
        ArrayList<JavaReference> arrayList = new ArrayList<JavaReference>();
        Iterator iterator = javaClass.getDeclaredFields();
        while (iterator.hasNext()) {
            JavaField javaField;
            JavaReference javaReference;
            Object e = iterator.next();
            if (!(e instanceof JavaInstanceField) || null == (javaReference = this.getFieldReference(javaField = (JavaField)e))) continue;
            arrayList.add(javaReference);
        }
        return arrayList;
    }

    private JavaReference getFieldReference(JavaField javaField) {
        JavaReference javaReference;
        block13: {
            javaReference = null;
            try {
                String string = javaField.getSignature();
                com.ibm.dtfj.java.JavaClass javaClass = this.getJavaClass();
                if (!string.startsWith(OBJECT_PREFIX_SIGNATURE) && !string.startsWith(ARRAY_PREFIX_SIGNATURE)) break block13;
                try {
                    JavaObject javaObject = (JavaObject)javaField.getReferenceType(this);
                    if (null != javaObject) {
                        String string2 = javaField.getName();
                        String string3 = "Object Reference";
                        if (null != string2) {
                            string3 = string3 + " [field name:" + string2 + "]";
                        }
                        int n = 1;
                        if ("referent".equals(string2) && "java/lang/ref/Reference".equals(javaField.getDeclaringClass().getName())) {
                            if (this._javaVM._weakReferenceClass != null && this._javaVM._weakReferenceClass.isAncestorOf(javaClass)) {
                                n = 3;
                            } else if (this._javaVM._softReferenceClass != null && this._javaVM._softReferenceClass.isAncestorOf(javaClass)) {
                                n = 2;
                            } else if (this._javaVM._phantomReferenceClass != null && this._javaVM._phantomReferenceClass.isAncestorOf(javaClass)) {
                                n = 4;
                            }
                        }
                        javaReference = new JavaReference(this._javaVM, (Object)this, javaObject, string3, 2, 0, n);
                    }
                }
                catch (CorruptDataException corruptDataException) {}
            }
            catch (CorruptDataException corruptDataException) {
            }
            catch (MemoryAccessException memoryAccessException) {
                // empty catch block
            }
        }
        return javaReference;
    }

    private List getArrayReferences(JavaArrayClass javaArrayClass) {
        ArrayList<Object> arrayList;
        block5: {
            arrayList = new ArrayList<Object>();
            try {
                String string = javaArrayClass.getComponentType().getName();
                if (string.equals("byte") || string.equals("boolean") || string.equals("char") || string.equals("short") || string.equals("int") || string.equals("long") || string.equals("float") || string.equals("double")) break block5;
                Object[] objectArray = null;
                int n = this.getArraySize();
                if (n <= 0) break block5;
                objectArray = new Object[n];
                try {
                    this.arraycopy(0, objectArray, 0, n);
                    for (int i = 0; i < objectArray.length; ++i) {
                        if (null == objectArray[i]) continue;
                        String string2 = "Array Reference";
                        string2 = string2 + " [index:" + i + "]";
                        JavaReference javaReference = new JavaReference(this._javaVM, (Object)this, objectArray[i], string2, 3, 0, 1);
                        arrayList.add(javaReference);
                    }
                }
                catch (MemoryAccessException memoryAccessException) {
                    ImagePointer imagePointer = memoryAccessException.getPointer();
                    String string3 = memoryAccessException.getMessage();
                    arrayList.add(new CorruptData(string3, imagePointer));
                }
            }
            catch (CorruptDataException corruptDataException) {
                arrayList.add(corruptDataException.getCorruptData());
            }
        }
        return arrayList;
    }

    @Override
    public JavaHeap getHeap() throws DataUnavailable {
        if (null == this._containingHeap) {
            throw new DataUnavailable("Containing heap not available for this object.");
        }
        return this._containingHeap;
    }

    public com.ibm.dtfj.java.JavaClass getAssociatedClass() {
        return this._associatedClass;
    }

    public void setAssociatedClass(com.ibm.dtfj.java.JavaClass javaClass) {
        this._associatedObjectFlags = (byte)(this._associatedObjectFlags | 1);
        this._associatedClass = javaClass;
    }

    public JavaMonitor getAssociatedMonitor() {
        return this._associatedMonitor;
    }

    public void setAssociatedMonitor(JavaMonitor javaMonitor) {
        this._associatedObjectFlags = (byte)(this._associatedObjectFlags | 4);
        this._associatedMonitor = javaMonitor;
    }

    public JavaThread getAssociatedThread() {
        return this._associatedThread;
    }

    public void setAssociatedThread(JavaThread javaThread) {
        this._associatedObjectFlags = (byte)(this._associatedObjectFlags | 2);
        this._associatedThread = javaThread;
    }

    public JavaClassLoader getAssociatedClassLoader() {
        return this._associatedClassLoader;
    }

    public void setAssociatedClassLoader(JavaClassLoader javaClassLoader) {
        this._associatedObjectFlags = (byte)(this._associatedObjectFlags | 8);
        this._associatedClassLoader = javaClassLoader;
    }

    public String toString() {
        try {
            String string = this.getJavaClass().getName();
            return "Instance of " + string + " @ " + this._basePointer;
        }
        catch (CorruptDataException corruptDataException) {
            return super.toString();
        }
    }

    class JavaObjectImageSection
    extends ImageSection {
        public JavaObjectImageSection(ImagePointer imagePointer, long l) {
            super(imagePointer, l);
        }

        @Override
        public String getName() {
            return "In-memory Object section at 0x" + Long.toHexString(this.getBaseAddress().getAddress()) + " (0x" + Long.toHexString(this.getSize()) + " bytes)";
        }
    }
}

