/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9.section.thread;

import com.ibm.dtfj.image.ImageModule;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.dtfj.javacore.builder.BuilderFailureException;
import com.ibm.dtfj.javacore.builder.IImageAddressSpaceBuilder;
import com.ibm.dtfj.javacore.builder.IImageProcessBuilder;
import com.ibm.dtfj.javacore.builder.IJavaRuntimeBuilder;
import com.ibm.dtfj.javacore.parser.framework.parser.ParserException;
import com.ibm.dtfj.javacore.parser.j9.IAttributeValueMap;
import com.ibm.dtfj.javacore.parser.j9.SectionParser;
import com.ibm.dtfj.javacore.parser.j9.section.thread.IThreadTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class ThreadSectionParser
extends SectionParser
implements IThreadTypes {
    private IJavaRuntimeBuilder fRuntimeBuilder;
    private IImageProcessBuilder fImageProcessBuilder;
    private IImageAddressSpaceBuilder fImageAddressSpaceBuilder;

    public ThreadSectionParser() {
        super("THREADS");
    }

    @Override
    protected void topLevelRule() throws ParserException {
        this.fImageAddressSpaceBuilder = this.fImageBuilder.getCurrentAddressSpaceBuilder();
        this.fImageProcessBuilder = this.fImageAddressSpaceBuilder.getCurrentImageProcessBuilder();
        this.fRuntimeBuilder = this.fImageProcessBuilder.getCurrentJavaRuntimeBuilder();
        this.currentThreadInfoSubsection();
        this.allThreadInfoSubsection();
    }

    protected void currentThreadInfoSubsection() throws ParserException {
        if (this.processTagLineOptional("1XMCURTHDINFO") != null) {
            this.threadInfo(true, true);
        }
    }

    protected void allThreadInfoSubsection() throws ParserException {
        this.processTagLineRequired("1XMTHDINFO");
        IAttributeValueMap iAttributeValueMap = this.processTagLineOptional("2XMFULLTHDDUMP");
        if (iAttributeValueMap != null) {
            int n = iAttributeValueMap.getIntValue("pointer_size");
            this.fImageProcessBuilder.setPointerSize(n);
        }
        this.threadInfo(true, false);
    }

    protected void threadInfo(boolean bl, boolean bl2) throws ParserException {
        IAttributeValueMap iAttributeValueMap = null;
        int n = this.getCurrentFileLineNumber();
        iAttributeValueMap = this.processTagLineRequired("3XMTHREADINFO");
        if (iAttributeValueMap != null) {
            this.processThreadandStackTrace(iAttributeValueMap, bl, bl2, n);
            if (!bl2) {
                while ((iAttributeValueMap = this.processTagLineOptional("3XMTHREADINFO")) != null) {
                    this.processThreadandStackTrace(iAttributeValueMap, bl, false, n);
                }
            }
        }
    }

    protected int processThreadandStackTrace(IAttributeValueMap iAttributeValueMap, boolean bl, boolean bl2, int n) throws ParserException {
        IAttributeValueMap iAttributeValueMap2;
        Object object;
        JavaThread javaThread = null;
        this.processTagLineOptional("3XMJAVALTHREAD");
        IAttributeValueMap iAttributeValueMap3 = this.processTagLineOptional("3XMJAVALTHRCCL");
        if (iAttributeValueMap3 != null) {
            object = iAttributeValueMap3.getTokenValue("context_classloader_object_full_java_name");
            long l = iAttributeValueMap3.getLongValue("context_classloader_object_address");
            try {
                this.fRuntimeBuilder.addClassLoader((String)object, l, l);
            }
            catch (BuilderFailureException builderFailureException) {
                this.handleError("Failed to add class loader: " + (String)object + " " + l + " ", builderFailureException);
            }
        }
        object = this.processTagLineOptional("3XMTHREADINFO1");
        ArrayList<IAttributeValueMap> arrayList = new ArrayList<IAttributeValueMap>();
        while ((iAttributeValueMap2 = this.processTagLineOptional("3XMTHREADINFO2")) != null) {
            arrayList.add(iAttributeValueMap2);
        }
        IAttributeValueMap iAttributeValueMap4 = this.processTagLineOptional("3XMCPUTIME");
        IAttributeValueMap iAttributeValueMap5 = this.processTagLineOptional("3XMTHREADBLOCK");
        this.processTagLineOptional("3XMHEAPALLOC");
        if (bl) {
            javaThread = this.addThread(iAttributeValueMap, (IAttributeValueMap)object, arrayList, iAttributeValueMap5, iAttributeValueMap4, n);
        }
        long l = object != null ? object.getLongValue("native_thread_id") : iAttributeValueMap.getLongValue("native_thread_id");
        long l2 = iAttributeValueMap.getLongValue("vm_thread_id");
        if (l == -1L) {
            l = l2;
        }
        this.parseStackTrace(javaThread, n, bl);
        this.parseNativeStackTrace(l, bl);
        if (bl2) {
            this.fImageProcessBuilder.setCurrentThreadID(l);
        }
        return this.getCurrentFileLineNumber();
    }

    private JavaThread addThread(IAttributeValueMap iAttributeValueMap, IAttributeValueMap iAttributeValueMap2, List list, IAttributeValueMap iAttributeValueMap3, IAttributeValueMap iAttributeValueMap4, int n) throws ParserException {
        Object object;
        long l;
        long l2 = iAttributeValueMap2 != null ? iAttributeValueMap2.getLongValue("native_thread_id") : iAttributeValueMap.getLongValue("native_thread_id");
        long l3 = iAttributeValueMap.getLongValue("vm_thread_id");
        if (l2 == -1L) {
            l2 = l3;
        }
        ImageThread imageThread = null;
        JavaThread javaThread = null;
        String string = iAttributeValueMap.getTokenValue("java_thread_name");
        if (string != null && string.length() >= 2) {
            string = string.substring(1, string.length() - 1);
        }
        String string2 = iAttributeValueMap.getTokenValue("java_thread_state");
        int n2 = iAttributeValueMap.getIntValue("vm_thread_priority");
        long l4 = iAttributeValueMap.getLongValue("abstract_thread_id");
        Properties properties = new Properties();
        if (l4 != -1L) {
            this.addAsProperty(properties, "abstract_thread_id", "0x" + Long.toHexString(l4));
        }
        if (iAttributeValueMap2 != null) {
            this.addAsProperty(properties, "native_thread_priority", iAttributeValueMap2.getTokenValue("native_thread_priority"));
            this.addAsProperty(properties, "native_thread_policy", iAttributeValueMap2.getTokenValue("native_thread_policy"));
            this.addAsProperty(properties, "scope", iAttributeValueMap2.getTokenValue("scope"));
            this.addAsProperty(properties, "vm_thread_state", iAttributeValueMap2.getTokenValue("vm_thread_state"));
            this.addAsProperty(properties, "vm_thread_flags", iAttributeValueMap2.getTokenValue("vm_thread_flags"));
        }
        if (iAttributeValueMap4 != null) {
            this.addAsProperty(properties, "cpu_time_total", iAttributeValueMap4.getTokenValue("cpu_time_total"));
            this.addAsProperty(properties, "cpu_time_user", iAttributeValueMap4.getTokenValue("cpu_time_user"));
            this.addAsProperty(properties, "cpu_time_system", iAttributeValueMap4.getTokenValue("cpu_time_system"));
        }
        String string3 = null;
        long l5 = -1L;
        if (iAttributeValueMap3 != null) {
            string3 = iAttributeValueMap3.getTokenValue("blocker_object_full_java_name");
            l5 = iAttributeValueMap3.getLongValue("blocker_object_address");
        }
        if ((l = iAttributeValueMap.getLongValue("java_thread_obj")) == -1L && iAttributeValueMap2 == null && (object = iAttributeValueMap.getTokenValue("vm_thread_id")) != null && !((String)object).startsWith("0x0")) {
            l = l3;
        }
        try {
            imageThread = this.fImageProcessBuilder.addImageThread(l2, l4, properties);
            if (string != null || l3 != -1L) {
                javaThread = this.fRuntimeBuilder.addJavaThread(imageThread, string, l3, l4, l, -1L, string2, n2, l5, string3);
            }
        }
        catch (BuilderFailureException builderFailureException) {
            this.handleErrorAtLineNumber(n, "Failed to add thread: " + string + " " + l2, builderFailureException);
        }
        for (IAttributeValueMap iAttributeValueMap5 : list) {
            long l6 = iAttributeValueMap5.getLongValue("native_stack_from");
            long l7 = iAttributeValueMap5.getLongValue("native_stack_to");
            long l8 = iAttributeValueMap5.getLongValue("native_stack_size");
            if (l6 == -1L || l8 == -1L) continue;
            ImageSection imageSection = this.fImageAddressSpaceBuilder.addImageSection("Native stack section", l6, l8);
            this.fImageProcessBuilder.addImageStackSection(imageThread, imageSection);
        }
        return javaThread;
    }

    private void parseStackTrace(JavaThread javaThread, int n, boolean bl) throws ParserException {
        IAttributeValueMap iAttributeValueMap = null;
        n = this.getCurrentFileLineNumber();
        this.processTagLineOptional("3XMTHREADINFO3");
        while ((iAttributeValueMap = this.processTagLineOptional("4XESTACKTRACE")) != null) {
            if (javaThread == null) continue;
            this.addStackTrace(iAttributeValueMap, javaThread, n);
            n = this.getCurrentFileLineNumber();
        }
        this.sovOnlyRules("3XMTHREADINFO");
    }

    private void addStackTrace(IAttributeValueMap iAttributeValueMap, JavaThread javaThread, int n) throws ParserException {
        if (iAttributeValueMap == null) {
            return;
        }
        String string = iAttributeValueMap.getTokenValue("full_location_name");
        String string2 = iAttributeValueMap.getTokenValue("method_name");
        String string3 = iAttributeValueMap.getTokenValue("stacktrace_method_type");
        String string4 = null;
        String string5 = null;
        int n2 = -1;
        if (string3.equals("stacktrace_java_method")) {
            string4 = iAttributeValueMap.getTokenValue("class_file_name");
            string5 = iAttributeValueMap.getTokenValue("comp_level");
            n2 = iAttributeValueMap.getIntValue("stacktrace_line_number");
        }
        if (string3.equals("stacktrace_native_method")) {
            string4 = "Native Method";
        }
        try {
            this.fRuntimeBuilder.addJavaStackFrame(javaThread, string, string4, string2, string3, string5, n2);
        }
        catch (BuilderFailureException builderFailureException) {
            this.handleErrorAtLineNumber(n, "Failed to add stack frame: " + string + "." + string2 + " " + n2, builderFailureException);
        }
    }

    private void parseNativeStackTrace(long l, boolean bl) throws ParserException {
        IAttributeValueMap iAttributeValueMap = null;
        this.processTagLineOptional("3XMTHREADINFO3");
        while ((iAttributeValueMap = this.processTagLineOptional("4XENATIVESTACK")) != null) {
            if (!bl) continue;
            String string = iAttributeValueMap.getTokenValue("stack_module");
            String string2 = iAttributeValueMap.getTokenValue("stack_routine");
            long l2 = iAttributeValueMap.getLongValue("stack_proc_address");
            long l3 = iAttributeValueMap.getLongValue("stack_routine_address");
            long l4 = iAttributeValueMap.getLongValue("stack_routine_offset");
            long l5 = iAttributeValueMap.getLongValue("stack_module_offset");
            String string3 = iAttributeValueMap.getTokenValue("stack_file");
            int n = iAttributeValueMap.getIntValue("stack_line");
            if (l3 == -1L && l2 != -1L && l4 != -1L) {
                l3 = l2 - l4;
            } else if (l4 == -1L && l2 != -1L && l3 != -1L) {
                l4 = l2 - l3;
            } else if (l2 == -1L && l4 != -1L && l3 != -1L) {
                l2 = l3 + l4;
            }
            String string4 = string != null ? string : "";
            if (string3 != null) {
                string4 = string4 + "(" + string3;
                if (n != -1) {
                    string4 = string4 + ":" + n;
                }
                string4 = string4 + ")";
            }
            if (string != null) {
                ImageModule imageModule = this.fImageProcessBuilder.addLibrary(string);
                if (l2 != -1L && l5 != -1L) {
                    String string5 = "0x" + Long.toHexString(l2 - l5);
                    this.fImageProcessBuilder.addProperty(imageModule, "Load address", string5);
                }
                if (string2 != null && l2 != -1L && l4 != -1L && l3 != -1L) {
                    this.fImageProcessBuilder.addRoutine(imageModule, string2, l3);
                    string4 = string4 + "::" + string2 + (l4 >= 0L ? "+" : "-") + l4;
                } else if (l4 != -1L) {
                    string4 = string4 + (l4 >= 0L ? "+" : "-") + l4;
                } else if (l2 != -1L) {
                    string4 = string4 + "::0x" + Long.toHexString(l2);
                }
            } else {
                string4 = string2 != null ? (l4 != -1L ? "::" + string2 + (l4 >= 0L ? "+" : "-") + l4 : "::" + string2) : (l2 != -1L ? "::0x" + Long.toHexString(l2) : null);
            }
            this.fImageProcessBuilder.addImageStackFrame(l, string4, 0L, l2);
        }
    }

    @Override
    protected void sovOnlyRules(String string) throws ParserException {
    }
}

