/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders.zos.util;

import com.ibm.dtfj.corereaders.zos.util.BitStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;

public final class CompressedRecordArray
implements Serializable {
    private int blockSizeLog2;
    private int blockSize;
    private int recordSize;
    private int index;
    private int[] bitStreamIndex = new int[16];
    private int[][] currentBlock;
    private int currentBlockIndex;
    private BitStream bits = new BitStream();
    private boolean[][] isNegative;
    private int[] lastValue;
    private int[] maxDelta;
    private boolean[] allSameDelta;
    private boolean[] allPositive;
    private byte[] encoding;
    private boolean closed = false;
    private int numRecords;
    private static final int GOLOMB2 = 0;
    private static final int GOLOMB7 = 1;
    private static final int GOLOMB8 = 2;
    private static final int VARIABLE_BYTE = 3;
    private static int numGolomb2;
    private static int numGolomb7;
    private static int numGolomb8;
    private static int numVariableByte;
    private static int numAllSameDelta;
    private static int numNotAllSameDelta;
    private static int numNegative;
    private static int numAllPositive;

    public CompressedRecordArray(int n, int n2) {
        this.blockSizeLog2 = n;
        this.blockSize = 1 << n;
        this.recordSize = n2;
        this.currentBlock = new int[this.blockSize][n2];
        this.isNegative = new boolean[this.blockSize][n2];
        this.lastValue = new int[n2];
        this.maxDelta = new int[n2];
        this.allSameDelta = new boolean[n2];
        this.allPositive = new boolean[n2];
        this.encoding = new byte[n2];
    }

    public void add(int[] nArray) {
        assert (!this.closed);
        for (int i = 0; i < this.recordSize; ++i) {
            this.currentBlock[this.currentBlockIndex][i] = nArray[i];
        }
        if (++this.currentBlockIndex == this.blockSize) {
            this.flushCurrentBlock();
            this.currentBlockIndex = 0;
        }
        ++this.numRecords;
    }

    public void close() {
        this.flushCurrentBlock();
        this.bits.rewind();
        this.closed = true;
    }

    private void flushCurrentBlock() {
        this.bitStreamIndex[this.index++] = this.bits.getIndex();
        if (this.index == this.bitStreamIndex.length) {
            int[] nArray = new int[this.index * 2];
            System.arraycopy(this.bitStreamIndex, 0, nArray, 0, this.index);
            this.bitStreamIndex = nArray;
        }
        this.compressBlock();
        this.bits.nextWord();
    }

    private void compressBlock() {
        int n;
        int n2;
        for (n2 = 0; n2 < this.recordSize; ++n2) {
            this.lastValue[n2] = this.currentBlock[0][n2];
            this.maxDelta[n2] = 0;
            this.allSameDelta[n2] = true;
            this.allPositive[n2] = true;
            n = 0;
            for (int i = 1; i < this.currentBlockIndex; ++i) {
                int n3 = this.currentBlock[i][n2] - this.lastValue[n2];
                if (n3 < 0) {
                    this.isNegative[i][n2] = true;
                    n3 = -n3;
                    this.allPositive[n2] = false;
                    ++numNegative;
                } else {
                    this.isNegative[i][n2] = false;
                }
                if (n3 > this.maxDelta[n2]) {
                    this.maxDelta[n2] = n3;
                }
                if (i > 1 && n3 != n) {
                    this.allSameDelta[n2] = false;
                    ++numNotAllSameDelta;
                }
                this.lastValue[n2] = this.currentBlock[i][n2];
                n = n3;
                this.currentBlock[i][n2] = n3;
            }
            if (this.allPositive[n2]) {
                ++numAllPositive;
            }
            if (!this.allSameDelta[n2]) continue;
            ++numAllSameDelta;
        }
        for (n2 = 0; n2 < this.recordSize; ++n2) {
            this.bits.writeIntBits(this.allPositive[n2] ? 1 : 0, 1);
            this.bits.writeIntBits(this.allSameDelta[n2] ? 1 : 0, 1);
            if (this.maxDelta[n2] < 24) {
                this.encoding[n2] = 0;
                ++numGolomb2;
            } else if (this.maxDelta[n2] < 384) {
                this.encoding[n2] = 1;
                ++numGolomb7;
            } else if (this.maxDelta[n2] < 2048) {
                this.encoding[n2] = 2;
                ++numGolomb8;
            } else {
                this.encoding[n2] = 3;
                ++numVariableByte;
            }
            this.bits.writeIntBits(this.encoding[n2], 2);
        }
        for (n2 = 0; n2 < this.currentBlockIndex; ++n2) {
            block10: for (n = 0; n < this.recordSize; ++n) {
                if (n2 == 0) {
                    this.bits.writeVariableByte(this.currentBlock[n2][n]);
                    continue;
                }
                if (n2 != 1 && this.allSameDelta[n]) continue;
                if (!this.allPositive[n]) {
                    this.bits.writeIntBits(this.isNegative[n2][n] ? 1 : 0, 1);
                }
                switch (this.encoding[n]) {
                    case 0: {
                        this.bits.writeGolombRice(this.currentBlock[n2][n], 2);
                        continue block10;
                    }
                    case 1: {
                        this.bits.writeGolombRice(this.currentBlock[n2][n], 7);
                        continue block10;
                    }
                    case 2: {
                        this.bits.writeGolombRice(this.currentBlock[n2][n], 8);
                        continue block10;
                    }
                    case 3: {
                        this.bits.writeVariableByte(this.currentBlock[n2][n]);
                    }
                }
            }
        }
    }

    public void get(int n, int[] nArray) {
        int n2;
        assert (this.closed);
        assert (n < this.numRecords);
        this.index = n >> this.blockSizeLog2;
        this.bits.setIndex(this.bitStreamIndex[this.index]);
        int n3 = n & this.blockSize - 1;
        for (n2 = 0; n2 < this.recordSize; ++n2) {
            this.allPositive[n2] = this.bits.readIntBits(1) == 1;
            this.allSameDelta[n2] = this.bits.readIntBits(1) == 1;
            this.encoding[n2] = (byte)this.bits.readIntBits(2);
        }
        for (n2 = 0; n2 <= n3; ++n2) {
            for (int i = 0; i < this.recordSize; ++i) {
                if (n2 == 0) {
                    this.currentBlock[n2][i] = this.bits.readVariableByte();
                    continue;
                }
                if (n2 == 1 || !this.allSameDelta[i]) {
                    int n4 = 0;
                    boolean bl = false;
                    if (!this.allPositive[i]) {
                        bl = this.bits.readIntBits(1) == 1;
                    }
                    switch (this.encoding[i]) {
                        case 0: {
                            n4 = this.bits.readGolombRice(2);
                            break;
                        }
                        case 1: {
                            n4 = this.bits.readGolombRice(7);
                            break;
                        }
                        case 2: {
                            n4 = this.bits.readGolombRice(8);
                            break;
                        }
                        case 3: {
                            n4 = this.bits.readVariableByte();
                        }
                    }
                    if (bl) {
                        n4 = -n4;
                    }
                    this.currentBlock[n2][i] = this.currentBlock[n2 - 1][i] + n4;
                    this.lastValue[i] = n4;
                    continue;
                }
                this.currentBlock[n2][i] = this.currentBlock[n2 - 1][i] + this.lastValue[i];
            }
        }
        for (n2 = 0; n2 < this.recordSize; ++n2) {
            nArray[n2] = this.currentBlock[n3][n2];
        }
    }

    public int memoryUsage() {
        return this.bits.memoryUsage() + this.bitStreamIndex.length * 4 + this.blockSize * this.recordSize * 4 * 2 + this.recordSize * 11;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 0) {
            CompressedRecordArray.fpostest(stringArray[0]);
            return;
        }
        for (int i = 0; i < 10; ++i) {
            int n = 1 << i;
            for (int j = 1; j < 20; ++j) {
                int n2;
                int n3;
                int n4;
                System.out.println("doing blockSize " + n + " recordSize " + j);
                CompressedRecordArray compressedRecordArray = new CompressedRecordArray(i, j);
                int[] nArray = new int[j];
                for (n4 = 0; n4 < n * 10 + j; ++n4) {
                    for (n3 = 0; n3 < j; ++n3) {
                        n2 = n4 * n4 * n3;
                        if (j % 3 == 0 && n3 % 3 == 0) {
                            n2 = n4 * n * j;
                        } else if (n3 % 5 == 0) {
                            n2 = -n2;
                        }
                        nArray[n3] = n2;
                    }
                    compressedRecordArray.add(nArray);
                }
                compressedRecordArray.close();
                for (n4 = 0; n4 < n * 10 + j; ++n4) {
                    compressedRecordArray.get(n4, nArray);
                    for (n3 = 0; n3 < j; ++n3) {
                        n2 = n4 * n4 * n3;
                        if (j % 3 == 0 && n3 % 3 == 0) {
                            n2 = n4 * n * j;
                        } else if (n3 % 5 == 0) {
                            n2 = -n2;
                        }
                        if (nArray[n3] == n2) continue;
                        throw new Error("found " + nArray[n3] + " expected " + n2);
                    }
                }
            }
        }
        System.out.println("numGolomb2 = " + numGolomb2);
        System.out.println("numGolomb7 = " + numGolomb7);
        System.out.println("numGolomb8 = " + numGolomb8);
        System.out.println("numVariableByte = " + numVariableByte);
        System.out.println("numAllSameDelta = " + numAllSameDelta);
        System.out.println("numNotAllSameDelta = " + numNotAllSameDelta);
        System.out.println("numNegative = " + numNegative);
        System.out.println("numAllPositive = " + numAllPositive);
    }

    private static void fpostest(String string) throws Exception {
        File file = new File(string);
        byte[] byArray = new byte[(int)file.length()];
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
        dataInputStream.readFully(byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        dataInputStream = new DataInputStream(byteArrayInputStream);
        int[] nArray = new int[8];
        for (int i = 0; i < 10; ++i) {
            int n;
            dataInputStream.reset();
            long l = System.nanoTime();
            CompressedRecordArray compressedRecordArray = new CompressedRecordArray(i, 8);
            boolean bl = false;
            int n2 = 0;
            while (true) {
                for (n = 0; n < 8; ++n) {
                    try {
                        nArray[n] = dataInputStream.readInt();
                        continue;
                    }
                    catch (EOFException eOFException) {
                        bl = true;
                        break;
                    }
                }
                if (bl) break;
                compressedRecordArray.add(nArray);
                ++n2;
            }
            compressedRecordArray.close();
            dataInputStream.reset();
            bl = false;
            n2 = 0;
            while (true) {
                for (n = 0; n < 8; ++n) {
                    try {
                        int n3 = dataInputStream.readInt();
                        if (n == 0) {
                            compressedRecordArray.get(n2, nArray);
                        }
                        if (nArray[n] == n3) continue;
                        throw new Error("data mismatch!");
                    }
                    catch (EOFException eOFException) {
                        bl = true;
                        break;
                    }
                }
                if (bl) break;
                ++n2;
            }
            long l2 = System.nanoTime() - l;
            System.out.println("block size " + (1 << i) + " uses " + compressedRecordArray.memoryUsage() + " took " + l2 + " ns");
        }
    }
}

