/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.io.OutputStream;
import java.util.Locale;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.ServiceUIFactory;
import javax.print.StreamPrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.AttributeSetUtilities;
import javax.print.attribute.HashAttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintServiceAttribute;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.ColorSupported;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.CopiesSupported;
import javax.print.attribute.standard.Fidelity;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.RequestingUserName;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;
import javax.print.event.PrintServiceAttributeListener;
import sun.print.PSPrinterJob;
import sun.print.PSStreamPrintJob;
import sun.print.PSStreamPrinterFactory;
import sun.print.SunPrinterJobService;

public class PSStreamPrintService
extends StreamPrintService
implements SunPrinterJobService {
    private static final Class[] suppAttrCats = new Class[]{Chromaticity.class, Copies.class, Fidelity.class, JobName.class, Media.class, MediaPrintableArea.class, OrientationRequested.class, PageRanges.class, RequestingUserName.class, SheetCollate.class, Sides.class};
    private static int MAXCOPIES = 1000;
    private static final MediaSizeName[] mediaSizes = new MediaSizeName[]{MediaSizeName.NA_LETTER, MediaSizeName.TABLOID, MediaSizeName.LEDGER, MediaSizeName.NA_LEGAL, MediaSizeName.EXECUTIVE, MediaSizeName.ISO_A3, MediaSizeName.ISO_A4, MediaSizeName.ISO_A5, MediaSizeName.ISO_B4, MediaSizeName.ISO_B5};

    public PSStreamPrintService(OutputStream outputStream) {
        super(outputStream);
    }

    @Override
    public String getOutputFormat() {
        return "application/postscript";
    }

    @Override
    public DocFlavor[] getSupportedDocFlavors() {
        return PSStreamPrinterFactory.getFlavors();
    }

    @Override
    public DocPrintJob createPrintJob() {
        return new PSStreamPrintJob(this);
    }

    @Override
    public boolean usesClass(Class clazz) {
        return clazz == PSPrinterJob.class;
    }

    @Override
    public String getName() {
        return "Postscript output";
    }

    @Override
    public void addPrintServiceAttributeListener(PrintServiceAttributeListener printServiceAttributeListener) {
    }

    @Override
    public void removePrintServiceAttributeListener(PrintServiceAttributeListener printServiceAttributeListener) {
    }

    @Override
    public <T extends PrintServiceAttribute> T getAttribute(Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("category");
        }
        if (!PrintServiceAttribute.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Not a PrintServiceAttribute");
        }
        if (clazz == ColorSupported.class) {
            return (T)ColorSupported.SUPPORTED;
        }
        return null;
    }

    @Override
    public PrintServiceAttributeSet getAttributes() {
        HashPrintServiceAttributeSet hashPrintServiceAttributeSet = new HashPrintServiceAttributeSet();
        hashPrintServiceAttributeSet.add(ColorSupported.SUPPORTED);
        return AttributeSetUtilities.unmodifiableView(hashPrintServiceAttributeSet);
    }

    @Override
    public boolean isDocFlavorSupported(DocFlavor docFlavor) {
        DocFlavor[] docFlavorArray = this.getSupportedDocFlavors();
        for (int i = 0; i < docFlavorArray.length; ++i) {
            if (!docFlavor.equals(docFlavorArray[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public Class<?>[] getSupportedAttributeCategories() {
        Class[] classArray = new Class[suppAttrCats.length];
        System.arraycopy((Object)suppAttrCats, 0, (Object)classArray, 0, classArray.length);
        return classArray;
    }

    @Override
    public boolean isAttributeCategorySupported(Class<? extends Attribute> clazz) {
        if (clazz == null) {
            throw new NullPointerException("null category");
        }
        if (!Attribute.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz + " is not an Attribute");
        }
        for (int i = 0; i < suppAttrCats.length; ++i) {
            if (clazz != suppAttrCats[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getDefaultAttributeValue(Class<? extends Attribute> clazz) {
        if (clazz == null) {
            throw new NullPointerException("null category");
        }
        if (!Attribute.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz + " is not an Attribute");
        }
        if (!this.isAttributeCategorySupported(clazz)) {
            return null;
        }
        if (clazz == Copies.class) {
            return new Copies(1);
        }
        if (clazz == Chromaticity.class) {
            return Chromaticity.COLOR;
        }
        if (clazz == Fidelity.class) {
            return Fidelity.FIDELITY_FALSE;
        }
        if (clazz == Media.class) {
            String string = Locale.getDefault().getCountry();
            if (string != null && (string.equals("") || string.equals(Locale.US.getCountry()) || string.equals(Locale.CANADA.getCountry()))) {
                return MediaSizeName.NA_LETTER;
            }
            return MediaSizeName.ISO_A4;
        }
        if (clazz == MediaPrintableArea.class) {
            float f;
            float f2;
            String string = Locale.getDefault().getCountry();
            float f3 = 0.5f;
            if (string != null && (string.equals("") || string.equals(Locale.US.getCountry()) || string.equals(Locale.CANADA.getCountry()))) {
                f2 = MediaSize.NA.LETTER.getX(25400) - 2.0f * f3;
                f = MediaSize.NA.LETTER.getY(25400) - 2.0f * f3;
            } else {
                f2 = MediaSize.ISO.A4.getX(25400) - 2.0f * f3;
                f = MediaSize.ISO.A4.getY(25400) - 2.0f * f3;
            }
            return new MediaPrintableArea(f3, f3, f2, f, 25400);
        }
        if (clazz == OrientationRequested.class) {
            return OrientationRequested.PORTRAIT;
        }
        if (clazz == PageRanges.class) {
            return new PageRanges(1, Integer.MAX_VALUE);
        }
        if (clazz == SheetCollate.class) {
            return SheetCollate.UNCOLLATED;
        }
        if (clazz == Sides.class) {
            return Sides.ONE_SIDED;
        }
        return null;
    }

    @Override
    public Object getSupportedAttributeValues(Class<? extends Attribute> clazz, DocFlavor docFlavor, AttributeSet attributeSet) {
        if (clazz == null) {
            throw new NullPointerException("null category");
        }
        if (!Attribute.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz + " does not implement Attribute");
        }
        if (docFlavor != null && !this.isDocFlavorSupported(docFlavor)) {
            throw new IllegalArgumentException(docFlavor + " is an unsupported flavor");
        }
        if (!this.isAttributeCategorySupported(clazz)) {
            return null;
        }
        if (clazz == Chromaticity.class) {
            Chromaticity[] chromaticityArray = new Chromaticity[]{Chromaticity.COLOR};
            return chromaticityArray;
        }
        if (clazz == JobName.class) {
            return new JobName("", null);
        }
        if (clazz == RequestingUserName.class) {
            return new RequestingUserName("", null);
        }
        if (clazz == OrientationRequested.class) {
            if (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                OrientationRequested[] orientationRequestedArray = new OrientationRequested[]{OrientationRequested.PORTRAIT, OrientationRequested.LANDSCAPE, OrientationRequested.REVERSE_LANDSCAPE};
                return orientationRequestedArray;
            }
            return null;
        }
        if (clazz == Copies.class || clazz == CopiesSupported.class) {
            return new CopiesSupported(1, MAXCOPIES);
        }
        if (clazz == Media.class) {
            Media[] mediaArray = new Media[mediaSizes.length];
            System.arraycopy((Object)mediaSizes, 0, (Object)mediaArray, 0, mediaSizes.length);
            return mediaArray;
        }
        if (clazz == Fidelity.class) {
            Fidelity[] fidelityArray = new Fidelity[]{Fidelity.FIDELITY_FALSE, Fidelity.FIDELITY_TRUE};
            return fidelityArray;
        }
        if (clazz == MediaPrintableArea.class) {
            MediaPrintableArea[] mediaPrintableAreaArray;
            if (attributeSet == null) {
                return null;
            }
            MediaSize mediaSize = (MediaSize)attributeSet.get(MediaSize.class);
            if (mediaSize == null && (mediaPrintableAreaArray = (MediaPrintableArea[])attributeSet.get(Media.class)) != null && mediaPrintableAreaArray instanceof MediaSizeName) {
                MediaSizeName mediaSizeName = (MediaSizeName)mediaPrintableAreaArray;
                mediaSize = MediaSize.getMediaSizeForName(mediaSizeName);
            }
            if (mediaSize == null) {
                return null;
            }
            mediaPrintableAreaArray = new MediaPrintableArea[1];
            float f = mediaSize.getX(25400);
            float f2 = mediaSize.getY(25400);
            float f3 = 0.5f;
            float f4 = 0.5f;
            if (f < 5.0f) {
                f3 = f / 10.0f;
            }
            if (f2 < 5.0f) {
                f4 = f2 / 10.0f;
            }
            mediaPrintableAreaArray[0] = new MediaPrintableArea(f3, f4, f - 2.0f * f3, f2 - 2.0f * f4, 25400);
            return mediaPrintableAreaArray;
        }
        if (clazz == PageRanges.class) {
            if (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                PageRanges[] pageRangesArray = new PageRanges[]{new PageRanges(1, Integer.MAX_VALUE)};
                return pageRangesArray;
            }
            return null;
        }
        if (clazz == SheetCollate.class) {
            if (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                SheetCollate[] sheetCollateArray = new SheetCollate[]{SheetCollate.UNCOLLATED, SheetCollate.COLLATED};
                return sheetCollateArray;
            }
            SheetCollate[] sheetCollateArray = new SheetCollate[]{SheetCollate.UNCOLLATED};
            return sheetCollateArray;
        }
        if (clazz == Sides.class) {
            if (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                Sides[] sidesArray = new Sides[]{Sides.ONE_SIDED, Sides.TWO_SIDED_LONG_EDGE, Sides.TWO_SIDED_SHORT_EDGE};
                return sidesArray;
            }
            return null;
        }
        return null;
    }

    private boolean isSupportedCopies(Copies copies) {
        int n = copies.getValue();
        return n > 0 && n < MAXCOPIES;
    }

    private boolean isSupportedMedia(MediaSizeName mediaSizeName) {
        for (int i = 0; i < mediaSizes.length; ++i) {
            if (!mediaSizeName.equals(mediaSizes[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAttributeValueSupported(Attribute attribute, DocFlavor docFlavor, AttributeSet attributeSet) {
        if (attribute == null) {
            throw new NullPointerException("null attribute");
        }
        if (docFlavor != null && !this.isDocFlavorSupported(docFlavor)) {
            throw new IllegalArgumentException(docFlavor + " is an unsupported flavor");
        }
        Class<? extends Attribute> clazz = attribute.getCategory();
        if (!this.isAttributeCategorySupported(clazz)) {
            return false;
        }
        if (attribute.getCategory() == Chromaticity.class) {
            return attribute == Chromaticity.COLOR;
        }
        if (attribute.getCategory() == Copies.class) {
            return this.isSupportedCopies((Copies)attribute);
        }
        if (attribute.getCategory() == Media.class && attribute instanceof MediaSizeName) {
            return this.isSupportedMedia((MediaSizeName)attribute);
        }
        return !(attribute.getCategory() == OrientationRequested.class ? attribute == OrientationRequested.REVERSE_PORTRAIT || docFlavor != null && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE) : (attribute.getCategory() == PageRanges.class ? docFlavor != null && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE) : (attribute.getCategory() == SheetCollate.class ? docFlavor != null && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE) : attribute.getCategory() == Sides.class && docFlavor != null && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE))));
    }

    @Override
    public AttributeSet getUnsupportedAttributes(DocFlavor docFlavor, AttributeSet attributeSet) {
        if (docFlavor != null && !this.isDocFlavorSupported(docFlavor)) {
            throw new IllegalArgumentException("flavor " + docFlavor + "is not supported");
        }
        if (attributeSet == null) {
            return null;
        }
        HashAttributeSet hashAttributeSet = new HashAttributeSet();
        Attribute[] attributeArray = attributeSet.toArray();
        for (int i = 0; i < attributeArray.length; ++i) {
            try {
                Attribute attribute = attributeArray[i];
                if (!this.isAttributeCategorySupported(attribute.getCategory())) {
                    hashAttributeSet.add(attribute);
                    continue;
                }
                if (this.isAttributeValueSupported(attribute, docFlavor, attributeSet)) continue;
                hashAttributeSet.add(attribute);
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (hashAttributeSet.isEmpty()) {
            return null;
        }
        return hashAttributeSet;
    }

    @Override
    public ServiceUIFactory getServiceUIFactory() {
        return null;
    }

    public String toString() {
        return "PSStreamPrintService: " + this.getName();
    }

    @Override
    public boolean equals(Object object) {
        return object == this || object instanceof PSStreamPrintService && ((PSStreamPrintService)object).getName().equals(this.getName());
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode() + this.getName().hashCode();
    }
}

