/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands;

import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import com.ibm.jvm.dtfjview.commands.FindCommand;
import java.io.PrintStream;

@DTFJPlugin(version="1.*", runtime=false)
public class FindNextCommand
extends BaseJdmpviewCommand {
    public FindNextCommand() {
        this.addCommand("findnext", "", "finds the next instance of the last string passed to \"find\"");
    }

    public void run(String string, String[] stringArray, IContext iContext, PrintStream printStream) throws CommandException {
        if (this.initCommand(string, stringArray, iContext, printStream)) {
            return;
        }
        FindCommand.FindAttribute findAttribute = (FindCommand.FindAttribute)this.ctx.getProperties().get("FindAttributes");
        if (null == findAttribute) {
            printStream.println("No find command has been executed.");
            return;
        }
        String string2 = Long.toHexString(findAttribute.lastMatch + 1L);
        String string3 = Long.toHexString(findAttribute.endAddress);
        this.ctx.execute("find " + findAttribute.pattern + "," + string2 + "," + string3 + "," + findAttribute.boundary + "," + findAttribute.numBytesToPrint + "," + findAttribute.numMatchesToDisplay, printStream);
    }

    @Override
    public void printDetailedHelp(PrintStream printStream) {
        printStream.println("finds the next instance of the last string passed to \"find\"\n\nparameters: none\n\nThe findnext command is used in conjunction with find or findptr command to continue searching for upcoming matches. It repeats the previous find or findptr command (depending on which command is most recently issued) starting from the last match.");
    }
}

