/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands;

import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.IDTFJContext;
import com.ibm.java.diagnostics.utils.commands.BaseCommand;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.jvm.dtfjview.commands.ExceptionHandler;
import java.io.PrintStream;
import java.util.logging.Logger;

public abstract class BaseJdmpviewCommand
extends BaseCommand {
    private static final String CMD_HELP = "help";
    private static final String CMD_QMARK = "?";
    private static final String HEX_PREFIX = "0x";
    protected PrintStream out = null;
    protected IDTFJContext ctx = null;
    protected Logger logger = Logger.getLogger("com.ibm.jvm.dtfjview.logger.command");
    protected String hexfmt = "0x%016x";

    public abstract void printDetailedHelp(PrintStream var1);

    public final boolean initCommand(String string, String[] stringArray, IContext iContext, PrintStream printStream) throws CommandException {
        if (!(iContext instanceof IDTFJContext)) {
            throw new CommandException("This command works within a DTFJ context, the supplied context was an instance of " + iContext.getClass().getName());
        }
        this.out = printStream;
        this.ctx = (IDTFJContext)iContext;
        if (this.ctx.getProcess() != null) {
            this.hexfmt = "0x%0" + this.ctx.getProcess().getPointerSize() / 8 * 2 + "x";
        }
        if (stringArray.length == 1 && (stringArray[0].equalsIgnoreCase(CMD_HELP) || stringArray[0].equalsIgnoreCase(CMD_QMARK))) {
            this.printDetailedHelp(printStream);
            return true;
        }
        return false;
    }

    public long toLong(String string) {
        if (string.toLowerCase().startsWith(HEX_PREFIX)) {
            return Long.parseLong(string.substring(HEX_PREFIX.length()), 16);
        }
        return Long.parseLong(string);
    }

    protected ArtifactType getArtifactType() {
        String string;
        String string2 = this.ctx.getAddressSpace().getClass().getName();
        int n = string2.lastIndexOf(46);
        if ((string = string2.substring(++n)).startsWith("JC")) {
            return ArtifactType.javacore;
        }
        if (string.startsWith("PHD")) {
            return ArtifactType.phd;
        }
        if (string.startsWith("J9DDR")) {
            return ArtifactType.core;
        }
        if (string.startsWith("Image")) {
            return ArtifactType.core;
        }
        return ArtifactType.unknown;
    }

    public String toHexStringAddr(long l) {
        return String.format(this.hexfmt, l);
    }

    public String handleException(Throwable throwable) {
        return ExceptionHandler.handleException(this, throwable);
    }

    public String decodeThreadState(int n) {
        int[] nArray = new int[]{1, 1024, 0x400000, 256, 0x200000, 512, 4, 64, 0x100000, 2, 0x10000000, 0x20000000, 0x40000000, 128, 16, 32};
        String[] stringArray = new String[]{"STATE_ALIVE", "STATE_BLOCKED_ON_MONITOR_ENTER", "STATE_IN_NATIVE", "STATE_IN_OBJECT_WAIT", "STATE_INTERRUPTED", "STATE_PARKED", "STATE_RUNNABLE", "STATE_SLEEPING", "STATE_SUSPENDED", "STATE_TERMINATED", "STATE_VENDOR_1", "STATE_VENDOR_2", "STATE_VENDOR_3", "STATE_WAITING", "STATE_WAITING_INDEFINITELY", "STATE_WAITING_WITH_TIMEOUT"};
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            if ((n & nArray[i]) != nArray[i]) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    public String toHexString(long l) {
        return String.format(FormatEnum.HEX_LONG.getFormat(), l);
    }

    public String toHexString(short s) {
        return String.format(FormatEnum.HEX_SHORT.getFormat(), s);
    }

    public String toHexString(int n) {
        return String.format(FormatEnum.HEX_INT.getFormat(), n);
    }

    public String toHexString(byte by) {
        return String.format(FormatEnum.HEX_BYTE.getFormat(), by);
    }

    public String toString(float f) {
        return String.format(FormatEnum.DEC_FLOAT.getFormat(), Float.valueOf(f));
    }

    public String toString(double d) {
        return String.format(FormatEnum.DEC_DOUBLE.getFormat(), d);
    }

    private static enum FormatEnum {
        HEX_LONG("0x%016x"),
        HEX_SHORT("0x%04x"),
        HEX_BYTE("0x%02x"),
        HEX_INT("0x%08x"),
        DEC_FLOAT("%e"),
        DEC_DOUBLE("%e");

        private final String format;

        private FormatEnum(String string2) {
            this.format = string2;
        }

        public String getFormat() {
            return this.format;
        }
    }

    protected static enum ArtifactType {
        core,
        phd,
        javacore,
        unknown;

    }
}

