/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands;

import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.commands.ICommand;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import java.io.PrintStream;
import java.util.TreeSet;

@DTFJPlugin(version=".*", runtime=false, image=false)
public class HelpCommand
extends BaseJdmpviewCommand {
    private static final String CMD_NAME = "help";

    public HelpCommand() {
        this.addCommand(CMD_NAME, "[command name]", "displays list of commands or help for a specific command");
    }

    public void run(String string, String[] stringArray, IContext iContext, PrintStream printStream) throws CommandException {
        if (this.initCommand(string, stringArray, iContext, printStream)) {
            return;
        }
        if (stringArray.length == 0) {
            this.printHelpSummary();
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            if (stringArray[0].equalsIgnoreCase("context")) {
                printStream.println("switches to another context when more than one context is available. For z/OS the ASID can be specified with the 'asid' flag e.g. context asid <ID>. Execute 'context' to see the list of currently available contexts");
            } else {
                for (String string2 : stringArray) {
                    stringBuilder.append(string2);
                    stringBuilder.append(" ");
                }
                if (!this.ctx.isCommandRecognised(stringBuilder.toString().trim())) {
                    printStream.println("Unrecognised command: " + stringBuilder.toString().trim());
                } else {
                    stringBuilder.append(" ?");
                    this.ctx.execute(stringBuilder.toString().trim(), printStream);
                }
            }
        }
    }

    private void printHelpSummary() {
        TreeSet<String> treeSet = new TreeSet<String>();
        String string = String.format("%-25s %-20s %s\n", "context", "[ID|asid ID]", "switch to the selected context");
        treeSet.add(string);
        for (ICommand object : this.ctx.getCommands()) {
            for (String string2 : object.getCommandDescriptions()) {
                if (!string2.endsWith("\n")) {
                    string2 = string2 + "\n";
                }
                treeSet.add(string2);
            }
        }
        for (String string3 : treeSet) {
            this.out.print(string3);
        }
    }

    @Override
    public void printDetailedHelp(PrintStream printStream) {
        printStream.println("displays list of commands or help for a specific command \n\nparameters: none, <command_name>\n\nWith no parameters, \"help\" displays the complete list of commands currently supported.  When a <command_name> is specified, \"help\" will list that command's sub-commands if it has sub-commands; otherwise, the command's complete description will be displayed.\n\nTo view help on a command's sub-command, specify both the command name and the sub-command name.  For example, \"help info thread\" will display \"info thread\"'s description.");
    }
}

