/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders.zos.le;

import com.ibm.dtfj.corereaders.zos.dumpreader.AddressSpace;
import com.ibm.dtfj.corereaders.zos.dumpreader.AddressSpaceImageInputStream;
import com.ibm.dtfj.corereaders.zos.le.Caa;
import com.ibm.dtfj.corereaders.zos.le.CeedsaTemplate;
import com.ibm.dtfj.corereaders.zos.le.Ceedsahp32Template;
import com.ibm.dtfj.corereaders.zos.le.Ceedsahp64Template;
import com.ibm.dtfj.corereaders.zos.le.CeedsahpTemplate;
import com.ibm.dtfj.corereaders.zos.le.Ceedsahp_transitionTemplate;
import com.ibm.dtfj.corereaders.zos.le.CeexcibTemplate;
import com.ibm.dtfj.corereaders.zos.le.CeexcibhTemplate;
import com.ibm.dtfj.corereaders.zos.le.Ceexhcom32Template;
import com.ibm.dtfj.corereaders.zos.le.Ceexhcom64Template;
import com.ibm.dtfj.corereaders.zos.le.CeexhcomTemplate;
import com.ibm.dtfj.corereaders.zos.le.CeexhepvTemplate;
import com.ibm.dtfj.corereaders.zos.le.Ceexhp1bTemplate;
import com.ibm.dtfj.corereaders.zos.le.CeexoepvTemplate;
import com.ibm.dtfj.corereaders.zos.le.Ceexpp1bTemplate;
import com.ibm.dtfj.corereaders.zos.le.Ceexrcb32Template;
import com.ibm.dtfj.corereaders.zos.le.Ceexrcb64Template;
import com.ibm.dtfj.corereaders.zos.le.CeexrcbTemplate;
import com.ibm.dtfj.corereaders.zos.le.CeexsfxmTemplate;
import com.ibm.dtfj.corereaders.zos.le.Function;
import com.ibm.dtfj.corereaders.zos.mvs.RegisterSet;
import java.io.IOException;
import java.util.HashSet;
import java.util.logging.Logger;

public class DsaStackFrame {
    private long address;
    private boolean isDownStack;
    private boolean isParentDownStack;
    private boolean isParentTransitionFrame;
    private long parentAddress;
    private long parentCallingAddress;
    private DsaStackFrame childDsa;
    private RegisterSet registers;
    private long entryPoint;
    private long entryOffset;
    private String entryName;
    private AddressSpace space;
    private AddressSpaceImageInputStream inputStream;
    private Caa caa;
    CeedsahpTemplate ceedsahpTemplate;
    CeexhcomTemplate ceexhcomTemplate;
    CeexrcbTemplate ceexrcbTemplate;
    static final long Ceedsahp_UpTran_Ind = 0xFFFFFFFFL;
    private static final long Ceedsahp_UpToDown = 2L;
    private static final long Ceedsahp_DownToUp = 3L;
    private static final long Hpcl_Basr_Call = 0L;
    private static final long Hpcl_Bras_Call = 1L;
    private static final long Hpcl_Brasl_Call = 3L;
    private static final int US_FORMAT = 0;
    private static final int DS_FORMAT = 1;
    private static final int UK_FORMAT = -1;
    private static final int CEEEYECAT = 0xC3C5C5;
    private static final short BASSM1415 = 3311;
    private static final int L14DSAMODE = 1491128428;
    private static Logger log = Logger.getLogger(DsaStackFrame.class.getName());

    public DsaStackFrame(long l, boolean bl, RegisterSet registerSet, AddressSpace addressSpace, Caa caa) throws IOException {
        this.address = l;
        this.isDownStack = bl;
        this.registers = registerSet;
        this.space = addressSpace;
        this.inputStream = addressSpace.getImageInputStream();
        this.caa = caa;
        this.createTemplates(addressSpace);
        this.ceextbck(l, bl, caa);
    }

    void createTemplates(AddressSpace addressSpace) {
        if (this.ceedsahpTemplate == null) {
            if (addressSpace.is64bit()) {
                this.ceedsahpTemplate = new Ceedsahp64Template();
                this.ceexhcomTemplate = new Ceexhcom64Template();
                this.ceexrcbTemplate = new Ceexrcb64Template();
            } else {
                this.ceedsahpTemplate = new Ceedsahp32Template();
                this.ceexhcomTemplate = new Ceexhcom32Template();
                this.ceexrcbTemplate = new Ceexrcb32Template();
            }
        }
    }

    public AddressSpace getAddressSpace() {
        return this.space;
    }

    public long getDsaAddress() {
        return this.address;
    }

    public RegisterSet getRegisterSet() {
        return this.registers;
    }

    public long getEntryOffset() {
        if (this.registers != null) {
            return this.space.stripTopBit(this.registers.getPSW() & Integer.MAX_VALUE) - this.getEntryPoint();
        }
        if (this.childDsa != null) {
            return this.childDsa.parentCallingAddress - this.entryPoint;
        }
        return this.entryOffset;
    }

    public long getEntryPoint() {
        return this.entryPoint;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public DsaStackFrame getParentFrame() {
        if (this.parentAddress == 0L || this.parentAddress == this.caa.ceecaaddsa()) {
            return null;
        }
        try {
            DsaStackFrame dsaStackFrame = new DsaStackFrame(this.parentAddress, this.isParentDownStack, null, this.space, this.caa);
            dsaStackFrame.childDsa = this;
            return dsaStackFrame;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public Function getFunction() {
        return new Function(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void ceextbck(long l, boolean bl, Caa caa) throws IOException {
        long l2;
        int n;
        int n2;
        int n3;
        boolean bl2;
        long l3;
        log.fine("ceextbck, dsaptr = " + DsaStackFrame.hex(l) + " downstack = " + bl);
        int n4 = bl ? 1 : 0;
        long l4 = -4995072469322842385L;
        int n5 = n4;
        if (n4 == -1) {
            throw new Error("tbc");
        }
        int n6 = n5;
        boolean bl3 = this.verifyFormat(l, n4);
        if (l < 0L) {
            throw new Error("tbc");
        }
        Ceexdsaf ceexdsaf = new Ceexdsaf(this.space, l, n4);
        n6 = ceexdsaf.DSA_Format;
        this.parentAddress = l3 = ceexdsaf.DSA_Prev;
        this.isParentDownStack = n6 == 1;
        long l5 = this.findCib(l);
        long l6 = this.findCib(l3);
        long l7 = this.findSfxm(l, n5);
        long l8 = this.findSfxm(l3, n6);
        if (n5 == 1) {
            this.processDsfmt(l, n5, l3, n6, bl3, l5, l6, l7);
            return;
        }
        if (!bl3) {
            int n7 = this.space.readInt(l + 72L);
            if ((n7 & 0xFFFFFFF0) == 134794976) {
                throw new Error("tbc");
            }
            l4 = CeedsaTemplate.getCeedsar15(this.inputStream, l3);
            log.fine("upstack entry address = " + DsaStackFrame.hex(l4));
        } else {
            long l9 = CeedsaTemplate.getCeedsatran(this.inputStream, l);
            l4 = Ceedsahp_transitionTemplate.getCeedsahp_tran_ep(this.inputStream, l9);
            log.fine("upstack transition entry address = " + DsaStackFrame.hex(l4));
        }
        try {
            this.space.readLong(l4);
        }
        catch (IOException iOException) {
            l4 = 0L;
        }
        long l10 = l4;
        if (l4 == 0L) {
            bl2 = false;
        } else {
            n3 = 0;
            try {
                n3 = (int)CeexoepvTemplate.getOepv_eyecatch(this.inputStream, l10);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            log.fine("signature = " + DsaStackFrame.hex(n3));
            n2 = n3 >>> 24;
            if ((n2 == 0 || n2 == 1) && (n3 & 0xFFFFFF) == 0xC3C5C5) {
                try {
                    n3 = this.getPpa1Sig(l10);
                }
                catch (IOException iOException) {
                    n3 = 0;
                }
                bl2 = (n3 & 0xFF) == 206;
            } else {
                bl2 = false;
                try {
                    n3 = (int)CeexoepvTemplate.getOepv_oldep(this.inputStream, l10);
                    log.fine("oldep signature = " + DsaStackFrame.hex(n3));
                    int n8 = n3 >>> 12;
                    if (n8 == 294671) {
                        n = n3 & 0xFFF;
                        int n9 = CeexoepvTemplate.length();
                        assert (n9 == 20) : n9;
                        n3 = (int)CeexoepvTemplate.getOepv_oldep(this.inputStream, l10 = l10 + (long)n - (long)n9);
                        if (n3 == 0) {
                            n3 = (int)CeexoepvTemplate.getOepv_eyecatch(this.inputStream, l10);
                            if ((n3 & 0xFFFFFF) != 0xC3C5C5) throw new Error("tbc");
                            n3 = this.getPpa1Sig(l10);
                            if ((n3 & 0xFF) != 206) throw new Error("tbc");
                            bl2 = true;
                            log.fine("found a good ppa1 eyecatcher");
                        } else {
                            l10 = l4;
                        }
                    } else {
                        l10 = l4;
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    throw new Error("tbc");
                }
            }
        }
        n3 = 0;
        if (bl2 && (n2 = (int)CeexoepvTemplate.getOepv_cnameoffs(this.inputStream, l10)) == 1) {
            n3 = 1;
        }
        this.parentCallingAddress = l2 = this.getCallingAddr(l3, n6, l, n5, bl3, l6, l8);
        if (bl2) {
            if (this.registers != null) {
                long l11 = this.getCallingAddr(l, n5, 0L, 0, false, l5, l7);
                log.fine("found call_instruction_address at top of stack: 0x" + DsaStackFrame.hex(l11));
            }
            if ((n = this.getPpa1Nmo(l10)) == 0) {
                throw new Error("tbc");
            }
            int n10 = (int)CeexoepvTemplate.getOepv_ppa1offset(this.inputStream, l10);
            long l12 = l10 + (long)n10;
            long l13 = n3 != 0 ? l12 + (long)(n * 2) : l12 + (long)n;
            this.entryName = this.space.readEbcdicString(l13);
            log.fine("read entry name: " + this.entryName);
        } else {
            this.entryName = "(unknown)";
        }
        this.entryPoint = this.space.stripTopBit(l4);
    }

    void processDsfmt(long l, int n, long l2, int n2, boolean bl, long l3, long l4, long l5) throws IOException {
        Ceexepaf ceexepaf = new Ceexepaf(l, n);
        this.entryPoint = this.space.stripTopBit(ceexepaf.entry_address);
        if (ceexepaf.ppa1_addr != 0L) {
            long l6;
            if (this.registers != null) {
                l6 = this.getCallingAddr(l, n, 0L, 0, false, l3, 0L);
                log.fine("found call_instruction_address at top of stack: 0x" + DsaStackFrame.hex(l6));
            }
            this.parentCallingAddress = l6 = this.getCallingAddr(l2, n2, l, n, bl, l4, l5);
            assert (this.parentCallingAddress != 0L);
        } else {
            throw new Error("tbc");
        }
        Ceexppaf ceexppaf = new Ceexppaf(ceexepaf.ppa1_addr, "NAM");
        this.entryName = ceexppaf.opt_ptr == 0L ? "(unknown)" : this.space.readEbcdicString(ceexppaf.opt_ptr);
        log.fine("read entry name: " + this.entryName);
    }

    private int getPpa1Sig(long l) throws IOException {
        int n = (int)CeexoepvTemplate.getOepv_ppa1offset(this.inputStream, l);
        long l2 = l + (long)n;
        int n2 = (int)Ceexpp1bTemplate.getPpa1_sig(this.inputStream, l2);
        log.fine("read ppa1 signature " + DsaStackFrame.hex(n2) + " from entry point " + DsaStackFrame.hex(l));
        return n2;
    }

    private int getPpa1Nmo(long l) throws IOException {
        int n = (int)CeexoepvTemplate.getOepv_ppa1offset(this.inputStream, l);
        long l2 = l + (long)n;
        int n2 = (int)Ceexpp1bTemplate.getPpa1_nmo(this.inputStream, l2);
        log.fine("read ppa1 nmo " + DsaStackFrame.hex(n2 &= 0xFF) + " from entry point " + DsaStackFrame.hex(l));
        return n2;
    }

    boolean verifyFormat(long l, int n) throws IOException {
        long l2;
        long l3;
        long l4;
        if (n == 0) {
            long l5 = CeedsaTemplate.getCeedsabkc(this.inputStream, l);
            log.fine("read ceedsabkc " + DsaStackFrame.hex(l5));
            if (l5 == 0xFFFFFFFFL) {
                long l6 = CeedsaTemplate.getCeedsatran(this.inputStream, l);
                log.fine("read ceedsatran " + DsaStackFrame.hex(l6));
                long l7 = Ceedsahp_transitionTemplate.getCeedsahp_trtype(this.inputStream, l6);
                if (l7 > 0L && l7 <= 6L) {
                    return true;
                }
            }
        } else if (n == 1 && (l4 = this.ceedsahpTemplate.getCeedsahpr7(this.inputStream, l)) == 0L && (l3 = Ceedsahp_transitionTemplate.getCeedsahp_trtype(this.inputStream, l2 = this.ceedsahpTemplate.getCeedsahptran(this.inputStream, l))) > 0L && l3 <= 6L) {
            return true;
        }
        return false;
    }

    long getCallingAddr(long l, int n, long l2, int n2, boolean bl, long l3, long l4) throws IOException {
        long l5 = -4995072469322842385L;
        long l6 = 0L;
        if (l3 != 0L) {
            l5 = CeexcibTemplate.getCib_int(this.inputStream, l3);
            log.fine("got calling address " + DsaStackFrame.hex(l5) + " from cib");
        } else {
            long l7;
            if (l4 != 0L) {
                throw new Error("tbc");
            }
            if (n == 0) {
                l6 = CeedsaTemplate.getCeedsar14(this.inputStream, l);
            } else if (l2 != 0L) {
                if (n2 == 0 && bl) {
                    l7 = CeedsaTemplate.getCeedsatran(this.inputStream, l2);
                    l6 = Ceedsahp_transitionTemplate.getCeedsahp_retaddr(this.inputStream, l7);
                } else if (n2 == 1 && bl) {
                    l7 = this.ceedsahpTemplate.getCeedsahptran(this.inputStream, l2);
                    l6 = Ceedsahp_transitionTemplate.getCeedsahp_retaddr(this.inputStream, l7);
                } else {
                    l6 = this.ceedsahpTemplate.getCeedsahpr7(this.inputStream, l2);
                }
            }
            if (l6 != 0L) {
                if (!this.space.is64bit()) {
                    l6 = n == 0 && (l6 & Integer.MIN_VALUE) == 0L ? (l6 &= 0xFFFFFFL) : (l6 &= Integer.MAX_VALUE);
                }
                if (n == 0) {
                    if (l6 == this.caa.getEdb().ceeedb_ceeosigr()) {
                        throw new Error("tbc");
                    }
                    try {
                        int n3;
                        short s = this.space.readShort(l6 - 2L);
                        if (s == 3311 && (n3 = this.space.readInt(l6)) == 1491128428) {
                            l6 = CeedsaTemplate.getCeedsamode(this.inputStream, l);
                            if (!this.space.is64bit()) {
                                l6 = (l6 & Integer.MIN_VALUE) == 0L ? (l6 &= 0xFFFFFFL) : (l6 &= Integer.MAX_VALUE);
                            }
                        }
                        n3 = 0;
                        int n4 = this.space.readInt(l6);
                        if (n4 >>> 16 == 18176) {
                            n3 = 1;
                        }
                        l5 = l6 - 2L;
                        log.fine("found callingaddr = 0x" + DsaStackFrame.hex(l5));
                    }
                    catch (IOException iOException) {
                        log.fine("could not read next_instruction_address at " + DsaStackFrame.hex(l6));
                        l5 = 0L;
                        throw iOException;
                    }
                } else {
                    l7 = this.caa.ceecaarcb();
                    long l8 = this.ceexrcbTemplate.getCeercb_ceeosigx(this.inputStream, l7);
                    if (l6 == l8) {
                        throw new Error("tbc");
                    }
                    int n5 = this.space.readInt(l6);
                    int n6 = n5 >> 16 & 0xF;
                    if (n5 >>> 20 != (this.space.is64bit() ? 112 : 1136)) {
                        l5 = 0L;
                        log.fine("did not find expected nop");
                    } else if ((long)n6 == 0L) {
                        l5 = l6 - 2L;
                    } else if ((long)n6 == 1L) {
                        l5 = l6 - 4L;
                    } else if ((long)n6 == 3L) {
                        l5 = l6 - 6L;
                    } else {
                        l5 = 0L;
                        log.fine("did not recognize call type " + n6);
                    }
                }
            } else {
                log.fine("next_instruction_address zero, cannot get calling address");
            }
        }
        return l5;
    }

    long findCib(long l) {
        try {
            long l2 = 0L;
            long l3 = this.caa.ceecaaerrcm();
            long l4 = this.ceexhcomTemplate.getHcom_cibh(this.inputStream, l3);
            while (l4 != 0L) {
                boolean bl = CeexcibhTemplate.getCibh_in_use(this.inputStream, l4) != 0L;
                l2 = CeexcibhTemplate.getCibh_ptr_cib(this.inputStream, l4);
                long l5 = CeexcibTemplate.getCib_sv1(this.inputStream, l2);
                if (bl && l5 == l) break;
                l4 = CeexcibhTemplate.getCibh_back(this.inputStream, l4);
            }
            if (l4 == 0L) {
                return 0L;
            }
            log.fine("found a cib: " + DsaStackFrame.hex(l2));
            return l2;
        }
        catch (Exception exception) {
            throw new Error("oops: " + exception);
        }
    }

    long findSfxm(long l, int n) throws IOException {
        long l2;
        block10: {
            l2 = 0L;
            HashSet<Long> hashSet = new HashSet<Long>();
            try {
                if (n == 0) {
                    log.fine("findSfxm processing upstack dsa");
                    long l3 = this.ceexhcomTemplate.getHcom_exit_stk(this.inputStream, this.caa.ceecaaerrcm());
                    log.fine("findSfxm hcom_exit_stk = 0x" + DsaStackFrame.hex(l3));
                    long l4 = l3;
                    while (l4 != 0L) {
                        long l5;
                        long l6;
                        if (!hashSet.add(l4)) {
                            log.fine("back-link cycle found in upstack dsm at " + DsaStackFrame.hex(l4));
                            break block10;
                        }
                        long l7 = CeexsfxmTemplate.getSfxm_code_eyecatch(this.inputStream, l4);
                        if (l7 >>> 8 != 214408072578304L && (l6 = CeedsaTemplate.getCeedsabkc(this.inputStream, l5 = CeexsfxmTemplate.getSfxm_parm_sf(this.inputStream, l4))) == l) {
                            log.fine("found the upstack sfxm at " + DsaStackFrame.hex(l4));
                            l2 = l4;
                        }
                        l4 = CeexsfxmTemplate.getSfxm_next(this.inputStream, l4);
                    }
                    break block10;
                }
                log.fine("findSfxm processing downstack dsa");
                long l8 = this.ceexhcomTemplate.getHcom_exit_stk(this.inputStream, this.caa.ceecaaerrcm());
                log.fine("findSfxm hcom_exit_stk = 0x" + DsaStackFrame.hex(l8));
                int n2 = CeexsfxmTemplate.getSfxm_code_return_pt$offset();
                long l9 = this.ceedsahpTemplate.getCeedsahpr7(this.inputStream, l);
                l9 = this.space.stripTopBit(l9);
                long l10 = l8;
                while (l10 != 0L) {
                    if (!hashSet.add(l10)) {
                        log.fine("back-link cycle found in downstack dsm at " + DsaStackFrame.hex(l10));
                        break;
                    }
                    if (l10 + (long)n2 == l9) {
                        throw new Error("tbc");
                    }
                    l10 = CeexsfxmTemplate.getSfxm_next(this.inputStream, l10);
                }
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new Error("oops: " + exception);
            }
        }
        return l2;
    }

    static long hpclEntryPoint(AddressSpace addressSpace, long l, long l2, CeedsahpTemplate ceedsahpTemplate) throws Exception {
        long l3;
        log.fine("ceedsahpr7: " + DsaStackFrame.hex(l2));
        AddressSpaceImageInputStream addressSpaceImageInputStream = addressSpace.getImageInputStream();
        int n = addressSpace.readInt(l2) >> 16 & 0xF;
        if ((long)n == 0L) {
            l3 = ceedsahpTemplate.getCeedsahpr6(addressSpaceImageInputStream, l);
            log.fine("BASR 7,6: " + DsaStackFrame.hex(l3));
        } else if ((long)n == 1L) {
            short s = addressSpace.readShort(l2 - 2L);
            log.fine("offset: " + DsaStackFrame.hex(s));
            l3 = l2 - 4L + (long)(s * 2);
            log.fine("BRAS 7,xxx: " + DsaStackFrame.hex(l3) + (l3 < 0L ? " (neg)" : "") + " offset = " + s);
        } else if ((long)n == 3L) {
            int n2 = addressSpace.readInt(l2 - 4L);
            l3 = l2 - 6L + (long)(n2 * 2);
            log.fine("BRASL 7,xxx: " + DsaStackFrame.hex(l3));
        } else {
            return 0L;
        }
        if (addressSpace.readInt(l3 - 16L) != 12779717) {
            l3 = 0L;
        }
        return l3;
    }

    public static String getEntryPointName(AddressSpace addressSpace, long l) throws IOException {
        Long l2 = l;
        String string = (String)addressSpace.getUserMap().get(l2);
        if (string != null) {
            return string;
        }
        int n = addressSpace.readInt(l + 4L);
        if (n == 0xC3C5C5 || n == 29607365) {
            long l3 = l + (long)addressSpace.readInt(l + 12L);
            int n2 = addressSpace.readUnsignedByte(l3);
            if (n == 29607365) {
                n2 <<= 1;
            }
            string = addressSpace.readEbcdicString(l3 + (long)n2);
        } else if ((n & 0xFF0000) == 0xCE0000) {
            long l4 = l;
            int n3 = n >>> 24;
            string = addressSpace.readEbcdicString(l4 + (long)n3);
        } else if ((addressSpace.readInt(l) & 0xFFFFF000) == 1206972416) {
            int n4 = addressSpace.readUnsignedByte(l + 4L);
            string = addressSpace.readEbcdicString(l + 5L, n4);
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (Character.isLetterOrDigit(c) || Character.isSpaceChar(c)) continue;
                string = "(unknown)";
                break;
            }
        } else {
            long l5 = l - 16L;
            long l6 = addressSpace.readLong(l5);
            if (l6 == 54888466580046065L) {
                int n5 = addressSpace.readInt(l5 + 8L);
                long l7 = l5 + (long)n5;
                long l8 = l7 + 20L;
                int n6 = addressSpace.readUnsignedByte(l7 + 10L);
                int n7 = addressSpace.readUnsignedByte(l7 + 11L);
                if ((n6 & 0x80) != 0) {
                    l8 += 4L;
                }
                if ((n6 & 0x40) != 0) {
                    l8 += 4L;
                }
                if ((n6 & 0x20) != 0) {
                    l8 += 4L;
                }
                if ((n6 & 0x10) != 0) {
                    l8 += 4L;
                }
                if ((n6 & 8) != 0) {
                    l8 += 4L;
                }
                if ((n6 & 4) != 0) {
                    l8 += 4L;
                }
                if ((n6 & 2) != 0) {
                    l8 += 4L;
                }
                if ((n6 & 1) != 0) {
                    l8 += 8L;
                }
                string = (n7 & 1) == 0 ? "(bad ppa1flags4)" : addressSpace.readEbcdicString(l8);
            } else {
                string = "(unknown)";
            }
        }
        addressSpace.getUserMap().put(l2, string);
        return string;
    }

    private static String hex(long l) {
        return Long.toHexString(l);
    }

    class Ceexppaf {
        long opt_ptr;

        Ceexppaf(long l, String string) throws IOException {
            try {
                int n;
                int n2 = Ceexhp1bTemplate.length();
                assert (n2 == 20) : n2;
                this.opt_ptr = l + (long)n2;
                if (string.equals("NAM")) {
                    long l2 = DsaStackFrame.this.caa.ceecaarcb();
                    log.fine("ceecaarcb = " + DsaStackFrame.hex(l2));
                    long l3 = DsaStackFrame.this.ceexrcbTemplate.getCeercb_ppa1tabl(DsaStackFrame.this.inputStream, l2);
                    log.fine("tabl_ptr = " + DsaStackFrame.hex(l3));
                    long l4 = Ceexhp1bTemplate.getPpa1h_flag3(DsaStackFrame.this.inputStream, l);
                    log.fine("ppa1h_flag3 = " + DsaStackFrame.hex(l4));
                    n = DsaStackFrame.this.space.readUnsignedByte(l3 + (l4 & 0xFFL));
                    this.opt_ptr += (long)n;
                } else {
                    throw new Error("unsupported option: " + string);
                }
                log.fine("found offset of " + n + ", opt_ptr now " + DsaStackFrame.hex(this.opt_ptr));
            }
            catch (IOException iOException) {
                this.opt_ptr = 0L;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new Error("oops: " + exception);
            }
        }
    }

    class Ceexepaf {
        long ppa1_addr;
        long ppa2_addr;
        long entry_address;

        Ceexepaf(long l, int n) throws IOException {
            try {
                long l2 = DsaStackFrame.this.ceedsahpTemplate.getCeedsahpr7(DsaStackFrame.this.inputStream, l);
                if (l2 == 0L) {
                    this.entry_address = DsaStackFrame.this.ceedsahpTemplate.getCeedsahpr6(DsaStackFrame.this.inputStream, l);
                } else {
                    this.entry_address = DsaStackFrame.hpclEntryPoint(DsaStackFrame.this.space, l, l2, DsaStackFrame.this.ceedsahpTemplate);
                    assert (this.entry_address != 0L);
                }
                log.fine("read entry_address 0x" + DsaStackFrame.hex(this.entry_address));
                int n2 = CeexhepvTemplate.getHepv_entry_point$offset();
                long l3 = this.entry_address - (long)n2;
                long l4 = CeexhepvTemplate.getHepv_ppa1_offset_p(DsaStackFrame.this.inputStream, l3);
                this.ppa1_addr = l3 + l4;
                log.fine("ppa1 = 0x" + DsaStackFrame.hex(this.ppa1_addr));
                long l5 = Ceexhp1bTemplate.getPpa1h_ppa2_off(DsaStackFrame.this.inputStream, this.ppa1_addr);
                this.ppa2_addr = this.ppa1_addr + l5;
                log.fine("ppa2 = 0x" + DsaStackFrame.hex(this.ppa2_addr));
            }
            catch (IOException iOException) {
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new Error("oops: " + exception);
            }
        }
    }

    static class Ceexdsaf {
        long DSA_Prev;
        int DSA_Format;
        private AddressSpaceImageInputStream inputStream;

        Ceexdsaf(AddressSpace addressSpace, long l, int n) throws IOException {
            log.fine("enter Ceexdsaf for dsa " + DsaStackFrame.hex(l));
            CeedsahpTemplate ceedsahpTemplate = addressSpace.is64bit() ? new Ceedsahp64Template() : new Ceedsahp32Template();
            this.inputStream = addressSpace.getImageInputStream();
            this.DSA_Format = n;
            try {
                if (this.DSA_Format == 0) {
                    long l2 = CeedsaTemplate.getCeedsabkc(this.inputStream, l);
                    if (l2 == 0xFFFFFFFFL) {
                        boolean bl = true;
                        long l3 = CeedsaTemplate.getCeedsatran(this.inputStream, l);
                        long l4 = Ceedsahp_transitionTemplate.getCeedsahp_trtype(this.inputStream, l3);
                        if (l4 == 3L) {
                            this.DSA_Prev = Ceedsahp_transitionTemplate.getCeedsahp_bkc(this.inputStream, l3);
                            this.DSA_Format = 1;
                        } else {
                            this.DSA_Prev = l2;
                        }
                    } else {
                        this.DSA_Prev = l2;
                    }
                } else {
                    long l5 = ceedsahpTemplate.getCeedsahpr7(this.inputStream, l);
                    if (l5 == 0L) {
                        long l6 = ceedsahpTemplate.getCeedsahptran(this.inputStream, l);
                        long l7 = Ceedsahp_transitionTemplate.getCeedsahp_trtype(this.inputStream, l6);
                        if (l7 == 2L) {
                            this.DSA_Format = 0;
                        }
                        boolean bl = true;
                        this.DSA_Prev = Ceedsahp_transitionTemplate.getCeedsahp_bkc(this.inputStream, l6);
                    } else {
                        long l8 = DsaStackFrame.hpclEntryPoint(addressSpace, l, l5, ceedsahpTemplate);
                        if (l8 == 0L) {
                            this.DSA_Prev = 0L;
                        } else {
                            int n2 = addressSpace.readInt(l8 - 4L);
                            if ((n2 & 4) == 4) {
                                this.DSA_Prev = ceedsahpTemplate.getCeedsahpr4(this.inputStream, l);
                            } else {
                                int n3 = n2 & 0xFFFFFFF0;
                                this.DSA_Prev = l + (long)n3;
                            }
                        }
                    }
                }
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new Error("oops: " + exception);
            }
        }
    }
}

