/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Iterator;
import java.util.List;
import javax.crypto.JceSecurity;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import sun.security.jca.GetInstance;

public class SecretKeyFactory {
    private Provider provider;
    private final String algorithm;
    private volatile SecretKeyFactorySpi spi;
    private final Object lock = new Object();
    private Iterator<Provider.Service> serviceIterator;

    protected SecretKeyFactory(SecretKeyFactorySpi secretKeyFactorySpi, Provider provider, String string) {
        this.spi = secretKeyFactorySpi;
        this.provider = provider;
        this.algorithm = string;
    }

    private SecretKeyFactory(String string) throws NoSuchAlgorithmException {
        this.algorithm = string;
        List<Provider.Service> list = GetInstance.getServices("SecretKeyFactory", string);
        this.serviceIterator = list.iterator();
        if (this.nextSpi(null) == null) {
            throw new NoSuchAlgorithmException(string + " SecretKeyFactory not available");
        }
    }

    public static final SecretKeyFactory getInstance(String string) throws NoSuchAlgorithmException {
        return new SecretKeyFactory(string);
    }

    public static final SecretKeyFactory getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        GetInstance.Instance instance = JceSecurity.getInstance("SecretKeyFactory", SecretKeyFactorySpi.class, string, string2);
        return new SecretKeyFactory((SecretKeyFactorySpi)instance.impl, instance.provider, string);
    }

    public static final SecretKeyFactory getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        GetInstance.Instance instance = JceSecurity.getInstance("SecretKeyFactory", SecretKeyFactorySpi.class, string, provider);
        return new SecretKeyFactory((SecretKeyFactorySpi)instance.impl, instance.provider, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Provider getProvider() {
        Object object = this.lock;
        synchronized (object) {
            this.serviceIterator = null;
            return this.provider;
        }
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecretKeyFactorySpi nextSpi(SecretKeyFactorySpi secretKeyFactorySpi) {
        Object object = this.lock;
        synchronized (object) {
            if (secretKeyFactorySpi != null && secretKeyFactorySpi != this.spi) {
                return this.spi;
            }
            if (this.serviceIterator == null) {
                return null;
            }
            while (this.serviceIterator.hasNext()) {
                Provider.Service service = this.serviceIterator.next();
                if (!JceSecurity.canUseProvider(service.getProvider())) continue;
                try {
                    Object object2 = service.newInstance(null);
                    if (!(object2 instanceof SecretKeyFactorySpi)) continue;
                    SecretKeyFactorySpi secretKeyFactorySpi2 = (SecretKeyFactorySpi)object2;
                    this.provider = service.getProvider();
                    this.spi = secretKeyFactorySpi2;
                    return secretKeyFactorySpi2;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                }
            }
            this.serviceIterator = null;
            return null;
        }
    }

    public final SecretKey generateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (this.serviceIterator == null) {
            return this.spi.engineGenerateSecret(keySpec);
        }
        Exception exception = null;
        SecretKeyFactorySpi secretKeyFactorySpi = this.spi;
        while (true) {
            try {
                return secretKeyFactorySpi.engineGenerateSecret(keySpec);
            }
            catch (Exception exception2) {
                if (exception != null) continue;
                exception = exception2;
                if ((secretKeyFactorySpi = this.nextSpi(secretKeyFactorySpi)) != null) continue;
                if (exception instanceof InvalidKeySpecException) {
                    throw (InvalidKeySpecException)exception;
                }
                throw new InvalidKeySpecException("Could not generate secret key", exception);
            }
            break;
        }
    }

    public final KeySpec getKeySpec(SecretKey secretKey, Class<?> clazz) throws InvalidKeySpecException {
        if (this.serviceIterator == null) {
            return this.spi.engineGetKeySpec(secretKey, clazz);
        }
        Exception exception = null;
        SecretKeyFactorySpi secretKeyFactorySpi = this.spi;
        while (true) {
            try {
                return secretKeyFactorySpi.engineGetKeySpec(secretKey, clazz);
            }
            catch (Exception exception2) {
                if (exception != null) continue;
                exception = exception2;
                if ((secretKeyFactorySpi = this.nextSpi(secretKeyFactorySpi)) != null) continue;
                if (exception instanceof InvalidKeySpecException) {
                    throw (InvalidKeySpecException)exception;
                }
                throw new InvalidKeySpecException("Could not get key spec", exception);
            }
            break;
        }
    }

    public final SecretKey translateKey(SecretKey secretKey) throws InvalidKeyException {
        if (this.serviceIterator == null) {
            return this.spi.engineTranslateKey(secretKey);
        }
        Exception exception = null;
        SecretKeyFactorySpi secretKeyFactorySpi = this.spi;
        while (true) {
            try {
                return secretKeyFactorySpi.engineTranslateKey(secretKey);
            }
            catch (Exception exception2) {
                if (exception != null) continue;
                exception = exception2;
                if ((secretKeyFactorySpi = this.nextSpi(secretKeyFactorySpi)) != null) continue;
                if (exception instanceof InvalidKeyException) {
                    throw (InvalidKeyException)exception;
                }
                throw new InvalidKeyException("Could not translate key", exception);
            }
            break;
        }
    }
}

