/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.j9.CorruptData;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.j9.JavaAbstractClass;
import com.ibm.dtfj.java.j9.JavaObject;
import com.ibm.dtfj.java.j9.JavaRuntime;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;

public class JavaArrayClass
extends JavaAbstractClass {
    private int _sizeOffset;
    private int _bytesForSize;
    private int _firstElementOffset;
    private long _leafClassID;
    private int _dimension;

    public JavaArrayClass(JavaRuntime javaRuntime, ImagePointer imagePointer, int n, int n2, int n3, int n4, int n5, long l, int n6, long l2, ImagePointer imagePointer2, int n7) {
        super(javaRuntime, imagePointer, n, l2, imagePointer2, n2, n7);
        this._sizeOffset = n3;
        this._bytesForSize = n4;
        this._firstElementOffset = n5;
        this._leafClassID = l;
        this._dimension = n6;
    }

    @Override
    public String getName() throws CorruptDataException {
        String string = "";
        for (int i = 0; i < this._dimension; ++i) {
            string = string + "[";
        }
        JavaClass javaClass = this.getLeafClass();
        if (null == javaClass) {
            CorruptData corruptData = new CorruptData("unable to retrieve leaf class", null);
            throw new CorruptDataException(corruptData);
        }
        String string2 = javaClass.getName();
        if (string2.equals("boolean")) {
            string = string + "Z";
        } else if (string2.equals("byte")) {
            string = string + "B";
        } else if (string2.equals("char")) {
            string = string + "C";
        } else if (string2.equals("short")) {
            string = string + "S";
        } else if (string2.equals("int")) {
            string = string + "I";
        } else if (string2.equals("long")) {
            string = string + "J";
        } else if (string2.equals("float")) {
            string = string + "F";
        } else if (string2.equals("double")) {
            string = string + "D";
        } else {
            string = string + "L";
            string = string + string2;
            string = string + ';';
        }
        return string;
    }

    @Override
    public JavaClass getSuperclass() throws CorruptDataException {
        return this._javaVM._javaLangObjectClass;
    }

    @Override
    public boolean isArray() throws CorruptDataException {
        return true;
    }

    public JavaClass getLeafClass() {
        return this._javaVM.getClassForID(this._leafClassID);
    }

    @Override
    public JavaClass getComponentType() throws CorruptDataException {
        JavaClass javaClass = null;
        javaClass = 1 == this._dimension ? this.getLeafClass() : this._javaVM.getComponentTypeForClass(this);
        if (javaClass == null) {
            throw new CorruptDataException(new CorruptData("Unable to retrieve component type for array: " + this.getName(), null));
        }
        return javaClass;
    }

    @Override
    public JavaClassLoader getClassLoader() throws CorruptDataException {
        JavaClassLoader javaClassLoader = super.getClassLoader();
        JavaClass javaClass = this.getLeafClass();
        if (null == javaClassLoader && null != javaClass) {
            javaClassLoader = this.getLeafClass().getClassLoader();
        }
        return javaClassLoader;
    }

    @Override
    public Iterator getDeclaredFields() {
        return Collections.EMPTY_LIST.iterator();
    }

    @Override
    public Iterator getDeclaredMethods() {
        return Collections.EMPTY_LIST.iterator();
    }

    @Override
    public Iterator getConstantPoolReferences() {
        return Collections.EMPTY_LIST.iterator();
    }

    @Override
    public int getInstanceSize(com.ibm.dtfj.java.JavaObject javaObject) {
        try {
            int n = javaObject.getArraySize();
            int n2 = this.getFirstElementOffset();
            int n3 = this.getBytesPerElement(((JavaObject)javaObject).getFObjectSize());
            return n2 + n * n3;
        }
        catch (CorruptDataException corruptDataException) {
            return -1;
        }
    }

    public int getBytesPerElement(int n) throws CorruptDataException {
        String string = this.getName().substring(1);
        int n2 = 0;
        n2 = string.equals("B") || string.equals("Z") ? 1 : (string.equals("C") || string.equals("S") ? 2 : (string.equals("F") || string.equals("I") ? 4 : (string.equals("D") || string.equals("J") ? 8 : n)));
        return n2;
    }

    public int getFirstElementOffset() {
        return this._firstElementOffset;
    }

    public int getSizeOffset() {
        return this._sizeOffset;
    }

    public int getNumberOfSizeBytes() {
        return this._bytesForSize;
    }

    @Override
    public Iterator getReferences() {
        Vector vector = new Vector();
        this.addSuperclassReference(vector);
        this.addClassLoaderReference(vector);
        this.addClassObjectReference(vector);
        return vector.iterator();
    }

    @Override
    public long getInstanceSize() throws CorruptDataException {
        throw new UnsupportedOperationException("JavaArrayClass does not support getInstanceSize");
    }
}

