/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders;

import com.ibm.dtfj.addressspace.IAbstractAddressSpace;
import com.ibm.dtfj.addressspace.LayeredAddressSpace;
import com.ibm.dtfj.binaryreaders.ARReader;
import com.ibm.dtfj.binaryreaders.XCOFFReader;
import com.ibm.dtfj.corereaders.Aix32Dump;
import com.ibm.dtfj.corereaders.Aix64Dump;
import com.ibm.dtfj.corereaders.Builder;
import com.ibm.dtfj.corereaders.ClosingFileReader;
import com.ibm.dtfj.corereaders.CoreReaderSupport;
import com.ibm.dtfj.corereaders.DumpReader;
import com.ibm.dtfj.corereaders.ICoreFileReader;
import com.ibm.dtfj.corereaders.MemoryAccessException;
import com.ibm.dtfj.corereaders.MemoryRange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.imageio.stream.ImageInputStream;

public abstract class NewAixDump
extends CoreReaderSupport {
    private static final long FAULTING_THREAD_OFFSET = 216L;
    private static final int S64BIT = 1;
    private static final long CORE_FILE_VERSION_OFFSET = 4L;
    private static final int CORE_DUMP_XX_VERSION = 267312562;
    private static final int CORE_DUMP_X_VERSION = 267312561;
    private static final long CORE_DUMP_X_PI_FLAGS_2_OFFSET = 1056L;
    private static final int POWER_RS1 = 1;
    private static final int POWER_RSC = 2;
    private static final int POWER_RS2 = 4;
    private static final int POWER_601 = 8;
    private static final int POWER_603 = 32;
    private static final int POWER_604 = 16;
    private static final int POWER_620 = 64;
    private static final int POWER_630 = 128;
    private static final int POWER_A35 = 256;
    private static final int POWER_RS64II = 512;
    private static final int POWER_RS64III = 1024;
    private static final int POWER_4 = 2048;
    private static final int POWER_MPC7450 = 4096;
    private static final int POWER_5 = 8192;
    private List _memoryRanges = new ArrayList();
    private Set _additionalFileNames = new TreeSet();
    private int _implementation;
    private int _threadCount;
    private long _threadOffset;
    private long _lastModified;
    private long _loaderOffset;
    private long _loaderSize;
    private LayeredAddressSpace _addressSpace;
    private MemoryRange _stackRange = null;
    private long _structTopOfStackVirtualAddress;
    private boolean _isTruncated = false;

    protected NewAixDump(DumpReader dumpReader) {
        super(dumpReader);
    }

    public static boolean isSupportedDump(ImageInputStream imageInputStream) throws IOException {
        imageInputStream.seek(8L);
        long l = imageInputStream.readLong();
        long l2 = imageInputStream.readLong();
        long l3 = imageInputStream.length();
        return l > 0L && l2 > 0L && l2 > l && l < l3 && l2 < l3;
    }

    public static ICoreFileReader dumpFromFile(ImageInputStream imageInputStream) throws IOException {
        assert (NewAixDump.isSupportedDump(imageInputStream));
        imageInputStream.seek(4L);
        int n = imageInputStream.readInt();
        boolean bl = false;
        if (n == 267312561) {
            imageInputStream.seek(1056L);
            int n2 = imageInputStream.readInt();
            bl = (1 & n2) != 0;
        } else if (n == 267312562) {
            bl = true;
        } else {
            throw new IOException("Unrecognised core file version: " + Long.toHexString(n));
        }
        DumpReader dumpReader = new DumpReader(imageInputStream, bl);
        if (bl) {
            return new Aix64Dump(dumpReader);
        }
        return new Aix32Dump(dumpReader);
    }

    protected void readCore() throws IOException {
        this.coreSeek(0L);
        this.coreReadByte();
        byte by = this.coreReadByte();
        if ((by & 0x80) != 0) {
            this._isTruncated = true;
        }
        this.coreReadShort();
        this.coreReadInt();
        this.coreReadLong();
        this._loaderOffset = this.coreReadLong();
        this._loaderSize = this.coreReadLong();
        this._threadCount = this.coreReadInt();
        this.coreReadInt();
        this._threadOffset = this.coreReadLong();
        long l = this.coreReadLong();
        long l2 = this.coreReadLong();
        long l3 = this.coreReadLong();
        long l4 = this.coreReadLong();
        long l5 = this.coreReadLong();
        this._structTopOfStackVirtualAddress = l4 + l5 - (long)this.sizeofTopOfStack();
        MemoryRange memoryRange = new MemoryRange(l4, l3, l5);
        this._memoryRanges.add(memoryRange);
        this._stackRange = memoryRange;
        long l6 = this.coreReadLong();
        long l7 = this.coreReadLong();
        long l8 = this.coreReadLong();
        MemoryRange memoryRange2 = new MemoryRange(l7, l6, l8);
        this._memoryRanges.add(memoryRange2);
        this.coreReadLong();
        this.coreReadLong();
        long l9 = this.coreReadLong();
        long l10 = this.coreReadLong();
        this._implementation = this.coreReadInt();
        this.coreReadInt();
        this.coreReadLong();
        this.coreReadLong();
        this.coreReadBytes(48);
        this.readVMRegions(l10, l9);
        this.readSegments(l2, l);
        this.readLoaderInfoAsMemoryRanges();
        MemoryRange memoryRange3 = this.getHighestRange();
        if (null != memoryRange3) {
            this._isTruncated |= !this.coreCheckOffset(memoryRange3.getFileOffset());
        }
    }

    private MemoryRange getHighestRange() {
        long l = -1L;
        MemoryRange memoryRange = null;
        for (MemoryRange memoryRange2 : this._memoryRanges) {
            if (memoryRange2.getFileOffset() <= l) continue;
            l = memoryRange2.getFileOffset();
            memoryRange = memoryRange2;
        }
        return memoryRange;
    }

    private void readVMRegions(long l, long l2) throws IOException {
        this.coreSeek(l);
        int n = 0;
        while ((long)n < l2) {
            long l3 = this.coreReadLong();
            long l4 = this.coreReadLong();
            long l5 = this.coreReadLong();
            MemoryRange memoryRange = new MemoryRange(l3, l5, l4);
            this._memoryRanges.add(memoryRange);
            ++n;
        }
    }

    private void readSegments(long l, long l2) throws IOException {
        this.coreSeek(l);
        int n = 0;
        while ((long)n < l2) {
            long l3 = this.coreReadLong();
            long l4 = this.coreReadLong();
            long l5 = this.coreReadLong();
            this.coreReadInt();
            this.coreReadInt();
            MemoryRange memoryRange = new MemoryRange(l3, l5, l4);
            this._memoryRanges.add(memoryRange);
            ++n;
        }
    }

    private void readLoaderInfoAsMemoryRanges() throws IOException {
        int n = 0;
        long l = this._loaderOffset;
        do {
            this.coreSeek(l += (long)n);
            n = this.coreReadInt();
            this.readLoaderInfoFlags();
            long l2 = this.coreReadAddress();
            this.coreReadAddress();
            this.coreReadAddress();
            long l3 = this.coreReadAddress();
            long l4 = this.coreReadAddress();
            if (0L == l2) continue;
            MemoryRange memoryRange = new MemoryRange(l3, l2, l4);
            this._memoryRanges.add(memoryRange);
        } while (0 != n && l + (long)n < this._loaderOffset + this._loaderSize);
    }

    private List readLoaderInfoAsModules(Builder builder, Object object) throws IOException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        long l = this._loaderOffset;
        do {
            Object object2;
            this.coreSeek(l += (long)n);
            n = this.coreReadInt();
            this.readLoaderInfoFlags();
            this.coreReadAddress();
            long l2 = this.coreReadAddress();
            long l3 = this.coreReadAddress();
            long l4 = this.coreReadAddress();
            long l5 = this.coreReadAddress();
            String string = this.readString();
            String string2 = this.readString();
            String string3 = string;
            if (0 < string2.length()) {
                string3 = string3 + "(" + string2 + ")";
            }
            Object object3 = builder.buildModuleSection(object, ".text", l2, l2 + l3);
            Object object4 = builder.buildModuleSection(object, ".data", l4, l4 + l5);
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            arrayList2.add(object3);
            arrayList2.add(object4);
            XCOFFReader xCOFFReader = this._openLibrary(builder, string, string2);
            this._additionalFileNames.add(string);
            if (null != xCOFFReader) {
                object2 = xCOFFReader.moduleProperties();
                List list = xCOFFReader.buildSymbols(builder, object, l2);
                arrayList.add(builder.buildModule(string3, (Properties)object2, arrayList2.iterator(), list.iterator(), l2));
                this.internalAddressSpace().mapRegion(l2, xCOFFReader.underlyingFile(), xCOFFReader.baseFileOffset(), l3);
                continue;
            }
            object2 = Collections.singletonList(builder.buildCorruptData(object, "unable to find module " + string3, l2));
            arrayList.add(builder.buildModule(string3, null, arrayList2.iterator(), object2.iterator(), l2));
        } while (0 != n && l + (long)n < this._loaderOffset + this._loaderSize);
        return arrayList;
    }

    private XCOFFReader _openLibrary(Builder builder, String string, String string2) {
        XCOFFReader xCOFFReader = null;
        ClosingFileReader closingFileReader = null;
        try {
            closingFileReader = builder.openFile(string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (null != closingFileReader) {
            long l = 0L;
            long l2 = 0L;
            try {
                try {
                    xCOFFReader = new XCOFFReader(closingFileReader);
                    l2 = closingFileReader.length();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    try {
                        ARReader aRReader = new ARReader(closingFileReader);
                        l2 = aRReader.sizeOfModule(string2);
                        l = aRReader.offsetOfModule(string2);
                        xCOFFReader = new XCOFFReader(closingFileReader, l, l2);
                    }
                    catch (IllegalArgumentException illegalArgumentException2) {
                        xCOFFReader = null;
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return xCOFFReader;
    }

    private void readUserInfo(Builder builder, Object object) throws IOException {
        Object object2;
        this.coreSeek(this.userInfoOffset());
        int n = this.coreReadInt();
        String string = "";
        try {
            this.coreSeekVirtual(this._structTopOfStackVirtualAddress);
        }
        catch (MemoryAccessException memoryAccessException) {
            return;
        }
        this.coreReadAddress();
        this.coreReadAddress();
        this.coreReadAddress();
        long l = this.coreReadAddress();
        long l2 = this.coreReadAddress();
        long l3 = this.coreReadAddress();
        int n2 = (int)l;
        if (n2 > 0) {
            object2 = new long[n2];
            try {
                this.coreSeekVirtual(l2);
                int n3 = 0;
                while ((long)n3 < l) {
                    object2[n3] = this.coreReadAddress();
                    ++n3;
                }
                n3 = 0;
                while ((long)n3 < l) {
                    try {
                        this.coreSeekVirtual((long)object2[n3]);
                        string = string + this.readString() + " ";
                    }
                    catch (MemoryAccessException memoryAccessException) {
                        // empty catch block
                    }
                    ++n3;
                }
            }
            catch (MemoryAccessException memoryAccessException) {
                string = null;
            }
        } else {
            string = null;
        }
        object2 = this.readLoaderInfoAsModules(builder, object);
        Object var13_13 = null;
        Iterator iterator = object2.iterator();
        if (iterator.hasNext()) {
            var13_13 = iterator.next();
        }
        List list = this.readThreads(builder, object);
        Object e = list.get(0);
        Properties properties = new Properties();
        properties = this.getEnvironmentVariables(l3);
        builder.buildProcess(object, String.valueOf(n), string, properties, e, list.iterator(), var13_13, iterator, this.pointerSize());
    }

    private Properties getEnvironmentVariables(long l) throws IOException {
        if (0L == l) {
            return null;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        try {
            this.coreSeekVirtual(l);
        }
        catch (MemoryAccessException memoryAccessException) {
            return null;
        }
        long l2 = this.coreReadAddress();
        while (l2 != 0L) {
            arrayList.add(l2);
            l2 = this.coreReadAddress();
        }
        Properties properties = new Properties();
        for (Long l3 : arrayList) {
            int n;
            String string = null;
            try {
                this.coreSeekVirtual(l3);
                string = this.readString();
            }
            catch (MemoryAccessException memoryAccessException) {
                continue;
            }
            if (null == string || (n = string.indexOf(61)) < 0) continue;
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            properties.put(string2, string3);
        }
        return properties;
    }

    private List readThreads(Builder builder, Object object) throws IOException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        long l = this.threadSize(216L);
        arrayList.add(this.readThread(builder, object, 216L));
        for (int i = 0; i < this._threadCount; ++i) {
            arrayList.add(this.readThread(builder, object, this._threadOffset + (long)i * l));
        }
        return arrayList;
    }

    private Object readThread(Builder builder, Object object, long l) throws IOException {
        this.coreSeek(l);
        long l2 = this.coreReadAddress();
        this.coreReadInt();
        int n = this.coreReadInt();
        int n2 = this.coreReadInt();
        int n3 = this.coreReadInt();
        int n4 = this.coreReadInt();
        int n5 = this.coreReadInt();
        int n6 = this.coreReadInt();
        int n7 = this.coreReadInt();
        int n8 = this.coreReadInt();
        int n9 = this.coreReadInt();
        this.coreReadSigset();
        this.coreReadSigset();
        this.coreReadInt();
        this.coreReadAddress();
        int n10 = 0xFF & this.coreReadByte();
        Map map = this.readRegisters(l);
        Properties properties = new Properties();
        properties.put("scheduling policy", Integer.toHexString(n));
        properties.put("current effective priority", Integer.toHexString(n2));
        properties.put("thread state", Integer.toHexString(n3));
        properties.put("thread flags", Integer.toHexString(n4));
        properties.put("suspend count", Integer.toHexString(n5));
        properties.put("type of thread wait", Integer.toHexString(n6));
        properties.put("wait channel", Integer.toHexString(n7));
        properties.put("processor usage", Integer.toHexString(n8));
        properties.put("processor on which I'm bound", Integer.toHexString(n9));
        properties.put("current/last signal taken", Integer.toHexString(n10));
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        long l3 = this.getStackPointerFrom(map);
        long l4 = this.getInstructionPointerFrom(map);
        if (0L == l4 || !this.isValidAddress(l4)) {
            l4 = this.getLinkRegisterFrom(map);
        }
        try {
            if (0L != l4 && 0L != l3 && this.isValidAddress(l4) && this.isValidAddress(l3)) {
                MemoryRange memoryRange = this.memoryRangeFor(l3);
                if (memoryRange != null) {
                    arrayList.add(builder.buildStackSection(object, memoryRange.getVirtualAddress(), memoryRange.getVirtualAddress() + memoryRange.getSize()));
                    arrayList2.add(builder.buildStackFrame(object, l3, l4));
                    IAbstractAddressSpace iAbstractAddressSpace = this.getAddressSpace();
                    long l5 = -1L;
                    while (memoryRange.contains(l3) && l5 != l3 && arrayList2.size() < 1024) {
                        l5 = l3;
                        l3 = iAbstractAddressSpace.getPointerAt(0, l3);
                        long l6 = 64 == this.pointerSize() ? 8 : 4;
                        long l7 = l3 + l6;
                        l4 = iAbstractAddressSpace.getPointerAt(0, l7 += l6);
                        arrayList2.add(builder.buildStackFrame(object, l3, l4));
                    }
                }
            } else {
                arrayList.add(builder.buildStackSection(object, this._stackRange.getVirtualAddress(), this._stackRange.getVirtualAddress() + this._stackRange.getSize()));
            }
        }
        catch (MemoryAccessException memoryAccessException) {
            // empty catch block
        }
        return builder.buildThread(String.valueOf(l2), this.registersAsList(builder, map).iterator(), arrayList.iterator(), arrayList2.iterator(), properties, n10);
    }

    private void coreReadSigset() throws IOException {
        this.coreReadBytes(this.is64Bit() ? 32 : 8);
    }

    private boolean isValidAddress(long l) {
        try {
            this.getAddressSpace().getByteAt(0, l);
            return true;
        }
        catch (MemoryAccessException memoryAccessException) {
            return false;
        }
    }

    protected MemoryRange memoryRangeFor(long l) {
        Iterator iterator = this._memoryRanges.iterator();
        MemoryRange memoryRange = null;
        while (null == memoryRange && iterator.hasNext()) {
            MemoryRange memoryRange2 = (MemoryRange)iterator.next();
            if (!memoryRange2.contains(l)) continue;
            memoryRange = memoryRange2;
        }
        return memoryRange;
    }

    private String readString() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        byte by = this.coreReadByte();
        while (0 != by) {
            stringBuffer.append(new String(new byte[]{by}, "ASCII"));
            by = this.coreReadByte();
        }
        return stringBuffer.toString();
    }

    private List registersAsList(Builder builder, Map map) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Map.Entry entry : map.entrySet()) {
            arrayList.add(builder.buildRegister((String)entry.getKey(), (Number)entry.getValue()));
        }
        return arrayList;
    }

    protected abstract Map readRegisters(long var1) throws IOException;

    protected abstract int readLoaderInfoFlags() throws IOException;

    protected abstract long userInfoOffset();

    protected abstract long threadSize(long var1);

    protected abstract int pointerSize();

    protected abstract long getStackPointerFrom(Map var1);

    protected abstract long getInstructionPointerFrom(Map var1);

    protected abstract long getLinkRegisterFrom(Map var1);

    protected abstract int sizeofTopOfStack();

    public Iterator getMemoryRanges() {
        return this._memoryRanges.iterator();
    }

    @Override
    public void extract(Builder builder) {
        try {
            Object object = builder.buildAddressSpace("AIX Address Space", 0);
            this.readUserInfo(builder, object);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        builder.setOSType("AIX");
        builder.setCPUType("PowerPC");
        builder.setCPUSubType(this.getProcessorSubtype());
        builder.setCreationTime(this.getCreationTime());
    }

    public String getProcessorSubtype() {
        switch (this._implementation) {
            case 1: {
                return "RS1";
            }
            case 2: {
                return "RSC";
            }
            case 4: {
                return "RS2";
            }
            case 8: {
                return "601";
            }
            case 32: {
                return "603";
            }
            case 16: {
                return "604";
            }
            case 64: {
                return "620";
            }
            case 128: {
                return "630";
            }
            case 256: {
                return "A35";
            }
            case 512: {
                return "RS64-II";
            }
            case 1024: {
                return "RS64-III";
            }
            case 2048: {
                return "POWER 4";
            }
            case 4096: {
                return "MPC7450";
            }
            case 8192: {
                return "POWER 5";
            }
        }
        return "";
    }

    public long getCreationTime() {
        return this._lastModified;
    }

    @Override
    public Iterator getAdditionalFileNames() {
        return this._additionalFileNames.iterator();
    }

    @Override
    protected MemoryRange[] getMemoryRangesAsArray() {
        return this._memoryRanges.toArray(new MemoryRange[this._memoryRanges.size()]);
    }

    private LayeredAddressSpace internalAddressSpace() {
        if (null == this._addressSpace) {
            IAbstractAddressSpace iAbstractAddressSpace = super.getAddressSpace();
            this._addressSpace = new LayeredAddressSpace(iAbstractAddressSpace, false, 64 == this.pointerSize());
        }
        return this._addressSpace;
    }

    @Override
    public IAbstractAddressSpace getAddressSpace() {
        return this.internalAddressSpace();
    }

    @Override
    protected boolean is64Bit() {
        return 64 == this.pointerSize();
    }

    @Override
    protected boolean isLittleEndian() {
        return false;
    }

    private void coreSeekVirtual(long l) throws MemoryAccessException, IOException {
        MemoryRange memoryRange = this.memoryRangeFor(l);
        if (null == memoryRange) {
            throw new MemoryAccessException(0, l);
        }
        long l2 = memoryRange.getFileOffset() + (l - memoryRange.getVirtualAddress());
        this.coreSeek(l2);
    }

    @Override
    public boolean isTruncated() {
        return this._isTruncated;
    }
}

