/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageStackFrame;
import com.ibm.dtfj.phd.PHDCorruptData;

public class PHDImageStackFrame
implements ImageStackFrame {
    private ImagePointer base;
    private CorruptData base_cd;
    private ImagePointer proc;
    private CorruptData proc_cd;
    private String procName;
    private CorruptData procName_cd;

    public PHDImageStackFrame(ImageAddressSpace imageAddressSpace, ImageStackFrame imageStackFrame) {
        try {
            this.base = imageAddressSpace.getPointer(imageStackFrame.getBasePointer().getAddress());
        }
        catch (CorruptDataException corruptDataException) {
            this.base_cd = new PHDCorruptData(imageAddressSpace, corruptDataException);
        }
        try {
            this.proc = imageAddressSpace.getPointer(imageStackFrame.getProcedureAddress().getAddress());
        }
        catch (CorruptDataException corruptDataException) {
            this.proc_cd = new PHDCorruptData(imageAddressSpace, corruptDataException);
        }
        try {
            this.procName = imageStackFrame.getProcedureName();
        }
        catch (CorruptDataException corruptDataException) {
            corruptDataException.getCorruptData();
            this.procName_cd = new PHDCorruptData(imageAddressSpace, corruptDataException);
        }
    }

    @Override
    public ImagePointer getBasePointer() throws CorruptDataException {
        if (this.base_cd != null) {
            throw new CorruptDataException(this.base_cd);
        }
        return this.base;
    }

    @Override
    public ImagePointer getProcedureAddress() throws CorruptDataException {
        if (this.proc_cd != null) {
            throw new CorruptDataException(this.proc_cd);
        }
        return this.proc;
    }

    @Override
    public String getProcedureName() throws CorruptDataException {
        if (this.procName_cd != null) {
            throw new CorruptDataException(this.procName_cd);
        }
        return this.procName;
    }
}

