/*
 * Decompiled with CFR 0.152.
 */
package sun.security.rsa;

import java.math.BigInteger;
import javax.crypto.BadPaddingException;
import jdk.crypto.jniprovider.NativeCrypto;
import sun.security.rsa.RSAPrivateCrtKeyImpl;
import sun.security.rsa.RSAPublicKeyImpl;

public final class NativeRSACore {
    private static NativeCrypto nativeCrypto = NativeCrypto.getNativeCrypto();

    public static int getByteLength(BigInteger bigInteger) {
        int n = bigInteger.bitLength();
        return n + 7 >> 3;
    }

    public static byte[] rsa(byte[] byArray, RSAPublicKeyImpl rSAPublicKeyImpl) throws BadPaddingException {
        return NativeRSACore.crypt_Native(byArray, rSAPublicKeyImpl);
    }

    public static byte[] rsa(byte[] byArray, RSAPrivateCrtKeyImpl rSAPrivateCrtKeyImpl, boolean bl) throws BadPaddingException {
        return NativeRSACore.crtCrypt_Native(byArray, rSAPrivateCrtKeyImpl, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] crypt_Native(byte[] byArray, RSAPublicKeyImpl rSAPublicKeyImpl) throws BadPaddingException {
        int n;
        byte[] byArray2;
        long l = rSAPublicKeyImpl.getNativePtr();
        if (l == -1L) {
            return null;
        }
        try {
            BigInteger bigInteger = rSAPublicKeyImpl.getModulus();
            byArray2 = new byte[NativeRSACore.getByteLength(bigInteger)];
            n = nativeCrypto.RSAEP(byArray, byArray.length, byArray2, l);
        }
        finally {
            rSAPublicKeyImpl.returnNativePtr(l);
        }
        if (n == -1) {
            return null;
        }
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] crtCrypt_Native(byte[] byArray, RSAPrivateCrtKeyImpl rSAPrivateCrtKeyImpl, boolean bl) throws BadPaddingException {
        byte[] byArray2;
        int n;
        long l = rSAPrivateCrtKeyImpl.getNativePtr();
        if (l == -1L) {
            return null;
        }
        try {
            BigInteger bigInteger = rSAPrivateCrtKeyImpl.getModulus();
            n = NativeRSACore.getByteLength(bigInteger);
            byArray2 = new byte[n];
            int n2 = bl ? n : -1;
            n = nativeCrypto.RSADP(byArray, byArray.length, byArray2, n2, l);
        }
        finally {
            rSAPrivateCrtKeyImpl.returnNativePtr(l);
        }
        if (n == -1) {
            return null;
        }
        if (n == -2) {
            throw new BadPaddingException("RSA private key operation failed");
        }
        return byArray2;
    }
}

