/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.util.RuntimeTypeResolutionUtils;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.types.I16;
import com.ibm.j9ddr.vm29.types.I32;
import com.ibm.j9ddr.vm29.types.I64;
import com.ibm.j9ddr.vm29.types.I8;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.U16;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.U64;
import com.ibm.j9ddr.vm29.types.U8;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedList;

public abstract class StructurePointer
extends AbstractPointer {
    private static final String nl = System.getProperty("line.separator");

    protected StructurePointer(long l) {
        super(l);
    }

    @Override
    public DataType at(long l) {
        throw new UnsupportedOperationException("StructurePointers are implicitly dereferenced.  Use add(long count) instead.");
    }

    @Override
    public DataType at(Scalar scalar) {
        throw new UnsupportedOperationException("StructurePointers are implicitly dereferenced.  Use add(Scalar count) instead.");
    }

    protected final I8 getI8Bitfield(int n, int n2) throws CorruptDataException {
        long l = StructurePointer.getCellOffset(n, 8);
        long l2 = this.getByteAtOffset(l);
        long l3 = StructurePointer.getBitfield(l2, n, n2, 8, true);
        return new I8(l3);
    }

    protected final I16 getI16Bitfield(int n, int n2) throws CorruptDataException {
        long l = StructurePointer.getCellOffset(n, 16);
        long l2 = this.getShortAtOffset(l);
        long l3 = StructurePointer.getBitfield(l2, n, n2, 16, true);
        return new I16(l3);
    }

    protected final I32 getI32Bitfield(int n, int n2) throws CorruptDataException {
        long l = StructurePointer.getCellOffset(n, 32);
        long l2 = this.getIntAtOffset(l);
        long l3 = StructurePointer.getBitfield(l2, n, n2, 32, true);
        return new I32(l3);
    }

    protected final I64 getI64Bitfield(int n, int n2) throws CorruptDataException {
        long l = StructurePointer.getCellOffset(n, 64);
        long l2 = this.getLongAtOffset(l);
        long l3 = StructurePointer.getBitfield(l2, n, n2, 64, true);
        return new I64(l3);
    }

    protected final U8 getU8Bitfield(int n, int n2) throws CorruptDataException {
        long l = StructurePointer.getCellOffset(n, 8);
        long l2 = this.getByteAtOffset(l);
        long l3 = StructurePointer.getBitfield(l2, n, n2, 8, false);
        return new U8(l3);
    }

    protected final U16 getU16Bitfield(int n, int n2) throws CorruptDataException {
        long l = StructurePointer.getCellOffset(n, 16);
        long l2 = this.getShortAtOffset(l);
        long l3 = StructurePointer.getBitfield(l2, n, n2, 16, false);
        return new U16(l3);
    }

    protected final U32 getU32Bitfield(int n, int n2) throws CorruptDataException {
        long l = StructurePointer.getCellOffset(n, 32);
        long l2 = this.getIntAtOffset(l);
        long l3 = StructurePointer.getBitfield(l2, n, n2, 32, false);
        return new U32(l3);
    }

    protected final U64 getU64Bitfield(int n, int n2) throws CorruptDataException {
        long l = StructurePointer.getCellOffset(n, 64);
        long l2 = this.getLongAtOffset(l);
        long l3 = StructurePointer.getBitfield(l2, n, n2, 64, false);
        return new U64(l3);
    }

    private static long getCellOffset(int n, int n2) {
        long l = n / n2;
        return l * (long)(n2 / 8);
    }

    private static long getBitfield(long l, int n, int n2, int n3, boolean bl) {
        int n4;
        switch (BITFIELD_FORMAT) {
            case 1: {
                n4 = 64 - n2 - n % n3;
                break;
            }
            case 2: {
                n4 = 64 - n3 + n % n3;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported bitfield format");
            }
        }
        long l2 = l << n4;
        int n5 = 64 - n2;
        if (bl) {
            return l2 >> n5;
        }
        return l2 >>> n5;
    }

    public StructurePointer getAsRuntimeType() {
        try {
            Method method = this.getClass().getMethod("_typeId", new Class[0]);
            U8Pointer u8Pointer = (U8Pointer)method.invoke((Object)this, new Object[0]);
            String string = u8Pointer.getCStringAtOffset(0L);
            if (u8Pointer.notNull()) {
                string = RuntimeTypeResolutionUtils.cleanTypeStr(string);
                Class<?> clazz = Class.forName(this.getClass().getPackage().getName() + "." + string + "Pointer");
                Method method2 = clazz.getMethod("cast", AbstractPointer.class);
                Object object = method2.invoke(null, this);
                return (StructurePointer)object;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this;
    }

    @Override
    public String formatFullInteractive() {
        StructureField[] structureFieldArray;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getTargetName());
        stringBuilder.append(" at ");
        stringBuilder.append("0x");
        stringBuilder.append(Long.toHexString(this.getAddress()));
        stringBuilder.append(" {");
        stringBuilder.append(nl);
        for (StructureField structureField : structureFieldArray = this.getStructureFields()) {
            stringBuilder.append("\t0x");
            stringBuilder.append(Integer.toHexString(structureField.offset));
            stringBuilder.append(": ");
            stringBuilder.append(structureField.type);
            stringBuilder.append(" ");
            stringBuilder.append(structureField.name);
            stringBuilder.append(" = ");
            if (structureField.cde != null) {
                stringBuilder.append("<FAULT: " + structureField.cde.getMessage() + ">");
            } else if (structureField.value != null) {
                stringBuilder.append(structureField.value.formatShortInteractive());
            } else {
                stringBuilder.append("null");
            }
            stringBuilder.append(nl);
        }
        stringBuilder.append("}");
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public StructureField[] getStructureFields() {
        StructureField[] structureFieldArray;
        LinkedList<StructureField> linkedList = new LinkedList<StructureField>();
        for (Class<?> clazz = this.getClass(); clazz != null && null != (structureFieldArray = clazz.getAnnotation(GeneratedPointerClass.class)); clazz = clazz.getSuperclass()) {
            for (Method method : clazz.getMethods()) {
                if (!method.isAnnotationPresent(GeneratedFieldAccessor.class)) continue;
                GeneratedFieldAccessor generatedFieldAccessor = method.getAnnotation(GeneratedFieldAccessor.class);
                Field field = null;
                try {
                    field = structureFieldArray.structureClass().getField(generatedFieldAccessor.offsetFieldName());
                }
                catch (SecurityException securityException) {
                    throw new Error("Unexpected security exception", securityException);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    continue;
                }
                int n = -1;
                try {
                    n = field.getInt(null);
                }
                catch (Exception exception) {
                    throw new Error(exception);
                }
                DataType dataType = null;
                CorruptDataException corruptDataException = null;
                try {
                    dataType = (DataType)method.invoke((Object)this, new Object[0]);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new RuntimeException(illegalArgumentException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException(illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Throwable throwable = invocationTargetException.getCause();
                    if (throwable instanceof CorruptDataException) {
                        corruptDataException = (CorruptDataException)throwable;
                    }
                    throw new RuntimeException(invocationTargetException);
                }
                linkedList.add(new StructureField(method.getName(), generatedFieldAccessor.declaredType(), n, dataType, corruptDataException));
            }
        }
        Collections.sort(linkedList);
        structureFieldArray = new StructureField[linkedList.size()];
        linkedList.toArray(structureFieldArray);
        return structureFieldArray;
    }

    public static class StructureField
    implements Comparable<StructureField> {
        public final int offset;
        public final String name;
        public final DataType value;
        public final String type;
        public final CorruptDataException cde;

        StructureField(String string, String string2, int n, DataType dataType, CorruptDataException corruptDataException) {
            this.name = string;
            this.offset = n;
            this.value = dataType;
            this.type = string2;
            this.cde = corruptDataException;
        }

        @Override
        public int compareTo(StructureField structureField) {
            return this.offset - structureField.offset;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.type);
            stringBuilder.append(" ");
            stringBuilder.append(this.name);
            stringBuilder.append(" (");
            if (this.cde == null) {
                stringBuilder.append(Integer.toHexString(this.offset));
            } else {
                stringBuilder.append("<FAULT: " + this.cde.getMessage() + ">");
            }
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
    }
}

