/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RASdumpAgentPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RASdumpFunctionsPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RASdumpQueuePointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.structure.J9RASdumpAgent;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;

public class ShowDumpAgentsCommand
extends Command {
    private static final UDATA DUMP_FACADE_KEY = UDATA.roundToSizeofU32(UDATA.cast(VoidPointer.cast(4207599322L)));
    private Map<Long, String> rasDumpEventsToNames = new HashMap<Long, String>();
    private long[] rasDumpEvents = new long[]{J9RASdumpAgent.J9RAS_DUMP_ON_GP_FAULT, J9RASdumpAgent.J9RAS_DUMP_ON_USER_SIGNAL, J9RASdumpAgent.J9RAS_DUMP_ON_ABORT_SIGNAL, J9RASdumpAgent.J9RAS_DUMP_ON_VM_STARTUP, J9RASdumpAgent.J9RAS_DUMP_ON_VM_SHUTDOWN, J9RASdumpAgent.J9RAS_DUMP_ON_CLASS_LOAD, J9RASdumpAgent.J9RAS_DUMP_ON_CLASS_UNLOAD, J9RASdumpAgent.J9RAS_DUMP_ON_EXCEPTION_THROW, J9RASdumpAgent.J9RAS_DUMP_ON_EXCEPTION_CATCH, J9RASdumpAgent.J9RAS_DUMP_ON_THREAD_START, J9RASdumpAgent.J9RAS_DUMP_ON_THREAD_BLOCKED, J9RASdumpAgent.J9RAS_DUMP_ON_THREAD_END, J9RASdumpAgent.J9RAS_DUMP_ON_GLOBAL_GC, J9RASdumpAgent.J9RAS_DUMP_ON_EXCEPTION_DESCRIBE, J9RASdumpAgent.J9RAS_DUMP_ON_SLOW_EXCLUSIVE_ENTER, J9RASdumpAgent.J9RAS_DUMP_ON_EXCEPTION_SYSTHROW, J9RASdumpAgent.J9RAS_DUMP_ON_TRACE_ASSERT, J9RASdumpAgent.J9RAS_DUMP_ON_OBJECT_ALLOCATION, J9RASdumpAgent.J9RAS_DUMP_ON_CORRUPT_CACHE, J9RASdumpAgent.J9RAS_DUMP_ON_USER2_SIGNAL};
    private int J9RAS_DUMP_KNOWN_EVENTS = this.rasDumpEvents.length;
    private Map<Long, String> rasDumpRequestsToNames = new HashMap<Long, String>();
    private long[] rasDumpRequests = new long[]{J9RASdumpAgent.J9RAS_DUMP_DO_MULTIPLE_HEAPS, J9RASdumpAgent.J9RAS_DUMP_DO_EXCLUSIVE_VM_ACCESS, J9RASdumpAgent.J9RAS_DUMP_DO_COMPACT_HEAP, J9RASdumpAgent.J9RAS_DUMP_DO_PREPARE_HEAP_FOR_WALK, J9RASdumpAgent.J9RAS_DUMP_DO_SUSPEND_OTHER_DUMPS, J9RASdumpAgent.J9RAS_DUMP_DO_ATTACH_THREAD, J9RASdumpAgent.J9RAS_DUMP_DO_PREEMPT_THREADS};
    private int J9RAS_DUMP_KNOWN_REQUESTS = this.rasDumpRequests.length;

    public ShowDumpAgentsCommand() {
        this.addCommand("showdumpagents", "", "print the dump agent settings in force when this dump was taken, like -Xdump:what");
        this.rasDumpEventsToNames.put(J9RASdumpAgent.J9RAS_DUMP_ON_GP_FAULT, "gpf");
        this.rasDumpEventsToNames.put(J9RASdumpAgent.J9RAS_DUMP_ON_USER_SIGNAL, "user");
        this.rasDumpEventsToNames.put(J9RASdumpAgent.J9RAS_DUMP_ON_USER2_SIGNAL, "user2");
        this.rasDumpEventsToNames.put(J9RASdumpAgent.J9RAS_DUMP_ON_ABORT_SIGNAL, "abort");
        this.rasDumpEventsToNames.put(J9RASdumpAgent.J9RAS_DUMP_ON_VM_STARTUP, "vmstart");
        this.rasDumpEventsToNames.put(J9RASdumpAgent.J9RAS_DUMP_ON_VM_SHUTDOWN, "vmstop");
        this.rasDumpEventsToNames.put(J9RASdumpAgent.J9RAS_DUMP_ON_CLASS_LOAD, "load");
        this.rasDumpEventsToNames.put(J9RASdumpAgent.J9RAS_DUMP_ON_CLASS_UNLOAD, "unload");
        this.rasDumpEventsToNames.put(J9RASdumpAgent.J9RAS_DUMP_ON_EXCEPTION_THROW, "throw");
        this.rasDumpEventsToNames.put(J9RASdumpAgent.J9RAS_DUMP_ON_EXCEPTION_CATCH, "catch");
        this.rasDumpEventsToNames.put(J9RASdumpAgent.J9RAS_DUMP_ON_THREAD_START, "thrstart");
        this.rasDumpEventsToNames.put(J9RASdumpAgent.J9RAS_DUMP_ON_THREAD_BLOCKED, "blocked");
        this.rasDumpEventsToNames.put(J9RASdumpAgent.J9RAS_DUMP_ON_THREAD_END, "thrstop");
        this.rasDumpEventsToNames.put(J9RASdumpAgent.J9RAS_DUMP_ON_GLOBAL_GC, "fullgc");
        this.rasDumpEventsToNames.put(J9RASdumpAgent.J9RAS_DUMP_ON_EXCEPTION_DESCRIBE, "uncaught");
        this.rasDumpEventsToNames.put(J9RASdumpAgent.J9RAS_DUMP_ON_SLOW_EXCLUSIVE_ENTER, "slow");
        this.rasDumpEventsToNames.put(J9RASdumpAgent.J9RAS_DUMP_ON_EXCEPTION_SYSTHROW, "systhrow");
        this.rasDumpEventsToNames.put(J9RASdumpAgent.J9RAS_DUMP_ON_TRACE_ASSERT, "traceassert");
        this.rasDumpEventsToNames.put(J9RASdumpAgent.J9RAS_DUMP_ON_OBJECT_ALLOCATION, "allocation");
        this.rasDumpEventsToNames.put(J9RASdumpAgent.J9RAS_DUMP_ON_CORRUPT_CACHE, "corruptcache");
        this.rasDumpRequestsToNames.put(J9RASdumpAgent.J9RAS_DUMP_DO_MULTIPLE_HEAPS, "multiple");
        this.rasDumpRequestsToNames.put(J9RASdumpAgent.J9RAS_DUMP_DO_EXCLUSIVE_VM_ACCESS, "exclusive");
        this.rasDumpRequestsToNames.put(J9RASdumpAgent.J9RAS_DUMP_DO_COMPACT_HEAP, "compact");
        this.rasDumpRequestsToNames.put(J9RASdumpAgent.J9RAS_DUMP_DO_PREPARE_HEAP_FOR_WALK, "prepwalk");
        this.rasDumpRequestsToNames.put(J9RASdumpAgent.J9RAS_DUMP_DO_SUSPEND_OTHER_DUMPS, "serial");
        this.rasDumpRequestsToNames.put(J9RASdumpAgent.J9RAS_DUMP_DO_ATTACH_THREAD, "attach");
        this.rasDumpRequestsToNames.put(J9RASdumpAgent.J9RAS_DUMP_DO_PREEMPT_THREADS, "preempt");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        try {
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            J9RASdumpAgentPointer j9RASdumpAgentPointer = J9RASdumpAgentPointer.NULL;
            printStream.println("Registered dump agents\n----------------------");
            while ((j9RASdumpAgentPointer = this.seekDumpAgent(j9JavaVMPointer, j9RASdumpAgentPointer, null)) != null && !j9RASdumpAgentPointer.isNull()) {
                this.printDumpAgent(j9JavaVMPointer, j9RASdumpAgentPointer, context, printStream);
                printStream.println("----------------------");
            }
            printStream.println();
        }
        catch (CorruptDataException corruptDataException) {
            corruptDataException.printStackTrace();
        }
    }

    private J9RASdumpAgentPointer seekDumpAgent(J9JavaVMPointer j9JavaVMPointer, J9RASdumpAgentPointer j9RASdumpAgentPointer, J9RASdumpFunctionsPointer j9RASdumpFunctionsPointer) throws CorruptDataException {
        J9RASdumpFunctionsPointer j9RASdumpFunctionsPointer2 = j9JavaVMPointer.j9rasDumpFunctions();
        J9RASdumpQueuePointer j9RASdumpQueuePointer = J9RASdumpQueuePointer.cast(j9RASdumpFunctionsPointer2);
        UDATA uDATA = UDATA.roundToSizeofU32(UDATA.cast(j9RASdumpQueuePointer.facade().reserved()));
        if (!DUMP_FACADE_KEY.equals(uDATA = uDATA.bitAnd(0xFFFFFFFFL))) {
            return null;
        }
        if (!j9RASdumpQueuePointer.isNull()) {
            J9RASdumpAgentPointer j9RASdumpAgentPointer2 = j9RASdumpAgentPointer;
            J9RASdumpAgentPointer j9RASdumpAgentPointer3 = j9RASdumpAgentPointer2 = j9RASdumpAgentPointer2 != null && !j9RASdumpAgentPointer2.isNull() ? j9RASdumpAgentPointer2.nextPtr() : j9RASdumpQueuePointer.agents();
            while (j9RASdumpAgentPointer2 != null && !j9RASdumpAgentPointer2.isNull() && j9RASdumpFunctionsPointer != null && !j9RASdumpFunctionsPointer.isNull() && j9RASdumpAgentPointer2.dumpFn().getAddress() != j9RASdumpFunctionsPointer.getAddress()) {
                j9RASdumpAgentPointer2 = j9RASdumpAgentPointer2.nextPtr();
            }
            j9RASdumpAgentPointer = j9RASdumpAgentPointer2;
            return j9RASdumpAgentPointer2;
        }
        j9RASdumpAgentPointer = J9RASdumpAgentPointer.NULL;
        return j9RASdumpAgentPointer;
    }

    private void printDumpAgent(J9JavaVMPointer j9JavaVMPointer, J9RASdumpAgentPointer j9RASdumpAgentPointer, Context context, PrintStream printStream) throws CorruptDataException {
        printStream.println("-Xdump:");
        String string = "<unknown>";
        String string2 = "<unknown>";
        try {
            string2 = j9RASdumpAgentPointer.dumpFn().getHexAddress();
            string = context.process.getProcedureNameForAddress(j9RASdumpAgentPointer.dumpFn().getAddress());
        }
        catch (DataUnavailableException dataUnavailableException) {
            // empty catch block
        }
        printStream.printf("dumpFn=%s (%s)\n", string2, string);
        printStream.print("    events=");
        this.printDumpEvents(j9JavaVMPointer, j9RASdumpAgentPointer.eventMask(), printStream);
        printStream.println(",");
        if (!j9RASdumpAgentPointer.detailFilter().isNull()) {
            printStream.printf("    filter=%s,\n", j9RASdumpAgentPointer.detailFilter().getCStringAtOffset(0L));
        }
        if (!j9RASdumpAgentPointer.subFilter().isNull()) {
            printStream.printf("    msg_filter=%s,\n", j9RASdumpAgentPointer.subFilter().getCStringAtOffset(0L));
        }
        printStream.printf("    label=%s,\n    range=%d..%d,\n    priority=%d,\n", !j9RASdumpAgentPointer.labelTemplate().isNull() ? j9RASdumpAgentPointer.labelTemplate().getCStringAtOffset(0L) : "-", j9RASdumpAgentPointer.startOnCount().intValue(), j9RASdumpAgentPointer.stopOnCount().intValue(), j9RASdumpAgentPointer.priority().intValue());
        printStream.print("    request=");
        this.printDumpRequests(j9JavaVMPointer, j9RASdumpAgentPointer.requestMask(), printStream);
        if (!j9RASdumpAgentPointer.dumpOptions().isNull()) {
            printStream.println(",");
            printStream.printf("    opts=%s", j9RASdumpAgentPointer.dumpOptions().getCStringAtOffset(0L));
        }
        printStream.println();
    }

    private void printDumpEvents(J9JavaVMPointer j9JavaVMPointer, UDATA uDATA, PrintStream printStream) {
        String string = "";
        for (int i = 0; i < this.J9RAS_DUMP_KNOWN_EVENTS; ++i) {
            if ((uDATA.longValue() & this.rasDumpEvents[i]) == 0L) continue;
            printStream.printf("%s%s", string, this.rasDumpEventsToNames.get(this.rasDumpEvents[i]));
            string = "+";
        }
    }

    private void printDumpRequests(J9JavaVMPointer j9JavaVMPointer, UDATA uDATA, PrintStream printStream) {
        String string = "";
        for (int i = 0; i < this.J9RAS_DUMP_KNOWN_REQUESTS; ++i) {
            if ((uDATA.longValue() & this.rasDumpRequests[i]) == 0L) continue;
            printStream.printf("%s%s", string, this.rasDumpRequestsToNames.get(this.rasDumpRequests[i]));
            string = "+";
        }
    }
}

