/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck;

import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.Check;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckReporter;

class ScanFormatter {
    protected static final int NUMBER_ELEMENTS_DISPLAYED_PER_LINE = 8;
    protected long _currentCount = 0L;
    protected boolean _displayedData = false;
    protected CheckReporter _reporter;

    public ScanFormatter(Check check, String string, AbstractPointer abstractPointer) {
        this._reporter = check.getReporter();
        this._reporter.println(String.format("<gc check: Start scan %s (%s)>", string, ScanFormatter.formatPointer(abstractPointer)));
    }

    public ScanFormatter(Check check, String string) {
        this._reporter = check.getReporter();
        this._reporter.println(String.format("<gc check: Start scan %s>", string));
    }

    static String formatPointer(AbstractPointer abstractPointer) {
        if (J9BuildFlags.J9VM_ENV_DATA64) {
            return String.format("%016X", abstractPointer.getAddress());
        }
        return String.format("%08X", abstractPointer.getAddress());
    }

    public void section(String string) {
        this._reporter.println(String.format("  <%s>", string));
        this._currentCount = 0L;
    }

    public void section(String string, AbstractPointer abstractPointer) {
        this._reporter.println(String.format("  <%s (%s)>", string, ScanFormatter.formatPointer(abstractPointer)));
        this._currentCount = 0L;
    }

    public void endSection() {
        if (0L != this._currentCount && this._displayedData) {
            this._reporter.println(">");
            this._currentCount = 0L;
        }
    }

    public void entry(AbstractPointer abstractPointer) {
        if (0L == this._currentCount) {
            this._reporter.print("    <");
            this._displayedData = true;
        }
        this._reporter.print(ScanFormatter.formatPointer(abstractPointer) + " ");
        ++this._currentCount;
        if (8L == this._currentCount) {
            this._reporter.println(">");
            this._currentCount = 0L;
        }
    }

    public void end(String string, AbstractPointer abstractPointer) {
        if (0L != this._currentCount && this._displayedData) {
            this._reporter.println(">");
        }
        this._reporter.println(String.format("<gc check: End scan %s (%s)>", string, ScanFormatter.formatPointer(abstractPointer)));
    }

    public void end(String string) {
        if (0L != this._currentCount && this._displayedData) {
            this._reporter.println(">");
        }
        this._reporter.println(String.format("<gc check: End scan %s>", string));
    }
}

