/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.view.dtfj.java;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.java.JavaVMInitArgs;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMInitArgsPointer;
import com.ibm.j9ddr.vm29.pointer.generated.JavaVMOptionPointer;
import com.ibm.j9ddr.vm29.view.dtfj.DTFJContext;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaVMOption;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DTFJJavaVMInitArgs
implements JavaVMInitArgs {
    private boolean isCachePopulated = false;
    private LinkedList<Object> options = new LinkedList();
    private Iterator corruptCache = null;
    private int version = 0;
    private boolean isCorrupt = false;
    private CorruptData cdata = null;
    private Logger log = DTFJContext.getLogger();
    private boolean ignoreFlag = false;

    public boolean getIgnoreUnrecognized() throws DataUnavailable, CorruptDataException {
        this.loadData();
        if (this.isCorrupt) {
            throw new CorruptDataException(this.cdata);
        }
        return this.ignoreFlag;
    }

    public Iterator getOptions() throws DataUnavailable {
        this.loadData();
        if (this.isCorrupt) {
            throw new DataUnavailable("The VM options are not available : " + this.cdata.toString());
        }
        if (this.corruptCache == null) {
            return this.options.iterator();
        }
        return this.corruptCache;
    }

    public int getVersion() throws DataUnavailable, CorruptDataException {
        this.loadData();
        if (this.isCorrupt) {
            throw new CorruptDataException(this.cdata);
        }
        return this.version;
    }

    private void loadData() {
        if (this.isCachePopulated || this.isCorrupt) {
            return;
        }
        J9VMInitArgsPointer j9VMInitArgsPointer = null;
        try {
            j9VMInitArgsPointer = DTFJContext.getVm().vmArgsArray();
            this.ignoreFlag = !j9VMInitArgsPointer.actualVMArgs().ignoreUnrecognized().eq(0L);
            this.version = j9VMInitArgsPointer.actualVMArgs().version().intValue();
        }
        catch (Throwable throwable) {
            this.isCorrupt = true;
            this.cdata = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
        }
        if (this.isCorrupt) {
            this.isCachePopulated = true;
            return;
        }
        try {
            int n = j9VMInitArgsPointer.nOptions().intValue();
            JavaVMOptionPointer javaVMOptionPointer = j9VMInitArgsPointer.actualVMArgs().options();
            for (int i = 0; i < n; ++i) {
                try {
                    DTFJJavaVMOption dTFJJavaVMOption = new DTFJJavaVMOption(javaVMOptionPointer);
                    this.options.add(dTFJJavaVMOption);
                    if (this.log.isLoggable(Level.FINE)) {
                        try {
                            this.log.fine(String.format("Found VM option %s", dTFJJavaVMOption.getOptionString()));
                        }
                        catch (Exception exception) {
                            this.log.warning(exception.getMessage());
                        }
                    }
                    javaVMOptionPointer = javaVMOptionPointer.add(1L);
                    continue;
                }
                catch (Throwable throwable) {
                    CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
                    this.options.add(corruptData);
                }
            }
        }
        catch (Throwable throwable) {
            CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
            this.corruptCache = J9DDRDTFJUtils.corruptIterator(corruptData);
        }
        this.isCachePopulated = true;
    }
}

