/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

abstract class ProgramOption {
    static final HashMap Configuration = new HashMap();
    static final List AnonymousArgs = new LinkedList();
    static final HashMap options = new HashMap();
    static HashMap defaultOptions = null;

    ProgramOption() {
    }

    abstract String getDescription();

    abstract String getName();

    abstract Object getValue();

    static Object getValue(String string) {
        return ((ProgramOption)Configuration.get(string)).getValue();
    }

    String getUsage() {
        return this.getName();
    }

    abstract void setValue(String var1) throws IllegalArgumentException;

    void setAutomatic() {
        throw new IllegalArgumentException("Value must be specified for " + this.getName());
    }

    void setDefault() {
        throw new IllegalArgumentException("No default value available for " + this.getName());
    }

    boolean required() {
        return false;
    }

    static void addOption(Class clazz) {
        try {
            ProgramOption programOption = (ProgramOption)clazz.newInstance();
            options.put(programOption.getName(), clazz);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void addArgument(String string) throws IllegalArgumentException {
        String string2 = string;
        String string3 = null;
        if (string.charAt(0) != '-') {
            AnonymousArgs.add(string);
            return;
        }
        string2 = string.substring(1);
        if (string2.equals("help")) {
            throw new IllegalArgumentException(ProgramOption.help());
        }
        if (defaultOptions == null) {
            defaultOptions = (HashMap)options.clone();
        }
        if (string2.indexOf(61) != -1) {
            string2 = string2.substring(0, string2.indexOf(61));
            string3 = string.substring(string.indexOf(61) + 1);
        }
        if (options.containsKey(string2)) {
            Class clazz = (Class)options.get(string2);
            try {
                ProgramOption programOption = (ProgramOption)clazz.newInstance();
                if (string3 != null) {
                    programOption.setValue(string3);
                } else {
                    programOption.setAutomatic();
                }
                Configuration.put(programOption.getName(), programOption);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw illegalArgumentException;
            }
            catch (Exception exception) {
                System.err.println("Error while constructing parser for command line option \"" + string2 + "\"");
            }
            defaultOptions.remove(string2);
            return;
        }
        throw new IllegalArgumentException("Usage error: unknown argument, \"" + string + "\"" + System.getProperty("line.separator") + System.getProperty("line.separator") + ProgramOption.help());
    }

    static void applyDefaults() {
        if (defaultOptions == null) {
            defaultOptions = (HashMap)options.clone();
        }
        for (Class clazz : defaultOptions.values()) {
            try {
                ProgramOption programOption = (ProgramOption)clazz.newInstance();
                programOption.setDefault();
                Configuration.put(programOption.getName(), programOption);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw illegalArgumentException;
            }
            catch (Exception exception) {
                System.err.println("Error while constructing default values");
            }
        }
    }

    public static String help() {
        StringBuffer stringBuffer = new StringBuffer("Usage: \n");
        StringBuffer stringBuffer2 = new StringBuffer("traceformat");
        StringBuffer stringBuffer3 = new StringBuffer("Option details:" + System.getProperty("line.separator") + System.getProperty("line.separator"));
        for (Class clazz : options.values()) {
            try {
                ProgramOption programOption = (ProgramOption)clazz.newInstance();
                String string = programOption.getName();
                String string2 = programOption.getUsage();
                if (programOption.required()) {
                    stringBuffer2.append(" " + string2);
                } else {
                    stringBuffer2.append(" [" + string2 + "]");
                }
                stringBuffer3.append(string + ": " + programOption.getDescription() + System.getProperty("line.separator") + System.getProperty("line.separator"));
            }
            catch (Exception exception) {
                System.err.println("Error while constructing default values");
            }
        }
        return stringBuffer.append(stringBuffer2).append(System.getProperty("line.separator") + System.getProperty("line.separator")).append(stringBuffer3).toString();
    }
}

