/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.memory;

import com.ibm.j9ddr.corereaders.memory.AbstractMemory;
import com.ibm.j9ddr.corereaders.memory.Addresses;
import com.ibm.j9ddr.corereaders.memory.BaseMemoryRange;
import com.ibm.j9ddr.corereaders.memory.IMemoryRange;
import com.ibm.j9ddr.corereaders.memory.IMemorySource;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MemorySourceTable {
    private static final Logger logger = Logger.getLogger("j9ddr.core_readers");
    private static final String FORCE_BINARY_CHOP_RESOLVER_SYSTEM_PROPERTY = "ddr.force.binary.address.resolver";
    private static final boolean FORCE_BINARY_CHOP_RESOLVER;
    private static final String ALLOW_THREE_TIER_TABLE_RESOLVER_PROPERTY = "ddr.allow.three.tier.address.resolver";
    private static final boolean ALLOW_THREE_TIER_TABLE_RESOLVER;
    static long tlbCacheHits;
    static long tlbCacheMisses;
    private IAddressResolverStrategy addressResolver;
    private final List<IMemorySource> rawMemorySources = new ArrayList<IMemorySource>();
    private List<IMemorySource> memorySources;

    public final void addMemorySource(IMemorySource iMemorySource) {
        this.rawMemorySources.add(iMemorySource);
        this.addressResolver = null;
    }

    public void removeMemorySource(IMemorySource iMemorySource) {
        this.rawMemorySources.remove(iMemorySource);
        this.addressResolver = null;
    }

    public final List<IMemoryRange> getMemorySources() {
        this.mergeOverlappingRanges();
        return new ArrayList<IMemoryRange>(this.memorySources);
    }

    public final IMemorySource getRangeForAddress(long l) {
        if (this.addressResolver == null) {
            this.pickAddressResolver();
        }
        return this.addressResolver.getRangeForAddress(l);
    }

    private void pickAddressResolver() {
        this.mergeOverlappingRanges();
        long l = 0L;
        int n = Integer.MAX_VALUE;
        long l2 = Integer.MAX_VALUE;
        for (IMemoryRange iMemoryRange : this.memorySources) {
            int n2;
            if (Addresses.greaterThan(iMemoryRange.getTopAddress(), l)) {
                l = iMemoryRange.getTopAddress();
            }
            if ((n2 = MemorySourceTable.getAlignment(iMemoryRange.getBaseAddress())) < n) {
                n = n2;
            }
            if (iMemoryRange.getSize() >= l2) continue;
            l2 = iMemoryRange.getSize();
        }
        logger.logp(Level.FINE, "MemoryRangeTable", "pickAddressResolver", "Picking address resolver. Highest Address = 0x{0}, worst alignment = {1} bit.", new Object[]{Long.toHexString(l), n});
        if (FORCE_BINARY_CHOP_RESOLVER) {
            logger.logp(Level.FINE, "MemoryRangeTable", "pickAddressResolver", "Selection overridden with {0}", FORCE_BINARY_CHOP_RESOLVER_SYSTEM_PROPERTY);
            this.addressResolver = new BinaryChopAddressResolver(this.memorySources);
        } else if (n >= 12 && l2 >= 4096L) {
            if (Addresses.lessThan(l, 0x100000000L)) {
                this.addressResolver = new FlatPageTableAddressResolver(this.memorySources, l, n);
            } else if (ALLOW_THREE_TIER_TABLE_RESOLVER) {
                logger.logp(Level.FINE, "MemoryRangeTable", "pickAddressResolver", "Three tier table resolver selected, allowed by {0} setting", ALLOW_THREE_TIER_TABLE_RESOLVER_PROPERTY);
                this.addressResolver = new ThreeTierPageTableAddressResolver(this.memorySources, l, n);
            }
        }
        if (this.addressResolver == null) {
            this.addressResolver = new BinaryChopAddressResolver(this.memorySources);
        }
        logger.logp(Level.FINE, "MemoryRangeTable", "pickAddressResolver", "Picked {0} as address resolver.", this.addressResolver.getClass().getSimpleName());
    }

    private void mergeOverlappingRanges() {
        this.memorySources = new ArrayList<IMemorySource>(this.rawMemorySources);
        Collections.sort(this.memorySources);
        if (this.memorySources.size() > 0) {
            ListIterator<IMemorySource> listIterator = this.memorySources.listIterator();
            IMemorySource iMemorySource = listIterator.next();
            while (listIterator.hasNext()) {
                IMemorySource iMemorySource2 = listIterator.next();
                if (iMemorySource2.overlaps(iMemorySource)) {
                    logger.logp(Level.FINE, "MemoryRangeTable", "mergeOverlappingRanges", "Address range {0} overlaps with {1}", new Object[]{iMemorySource2, iMemorySource});
                    if (iMemorySource.isSubRange(iMemorySource2)) {
                        logger.logp(Level.FINER, "MemoryRangeTable", "mergeOverlappingRanges", "Removing {0}", iMemorySource2);
                        listIterator.remove();
                        continue;
                    }
                    if (iMemorySource.isBacked() == iMemorySource2.isBacked()) {
                        logger.logp(Level.FINER, "MemoryRangeTable", "mergeOverlappingRanges", "Merging {0} and {1}", new Object[]{iMemorySource2, iMemorySource});
                        listIterator.remove();
                        listIterator.previous();
                        listIterator.remove();
                        MergedMemoryRange mergedMemoryRange = new MergedMemoryRange(iMemorySource, iMemorySource2);
                        listIterator.add(mergedMemoryRange);
                        iMemorySource = mergedMemoryRange;
                        continue;
                    }
                    iMemorySource = iMemorySource2;
                    continue;
                }
                iMemorySource = iMemorySource2;
            }
        }
    }

    static int getAlignment(long l) {
        int n = 0;
        for (int i = 0; i < 64 && (l & 1L) == 0L; ++i) {
            ++n;
            l >>= 1;
        }
        return n;
    }

    static {
        tlbCacheHits = 0L;
        tlbCacheMisses = 0L;
        String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(MemorySourceTable.FORCE_BINARY_CHOP_RESOLVER_SYSTEM_PROPERTY);
            }
        });
        logger.logp(Level.FINE, "MemoryRangeTable", "<clinit>", "System property {0} set to {1}", new Object[]{FORCE_BINARY_CHOP_RESOLVER_SYSTEM_PROPERTY, string});
        if (string != null && string.equalsIgnoreCase("true")) {
            FORCE_BINARY_CHOP_RESOLVER = true;
            logger.logp(Level.FINE, "MemoryRangeTable", "<clinit>", "BinaryChopResolver forced on.");
        } else {
            FORCE_BINARY_CHOP_RESOLVER = false;
            logger.logp(Level.FINE, "MemoryRangeTable", "<clinit>", "BinaryChopResolver NOT forced on.");
        }
        String string2 = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(MemorySourceTable.ALLOW_THREE_TIER_TABLE_RESOLVER_PROPERTY);
            }
        });
        logger.logp(Level.FINE, "MemoryRangeTable", "<clinit>", "System property {0} set to {1}", new Object[]{ALLOW_THREE_TIER_TABLE_RESOLVER_PROPERTY, string2});
        if (string2 != null && string2.equalsIgnoreCase("true")) {
            ALLOW_THREE_TIER_TABLE_RESOLVER = true;
            logger.logp(Level.FINE, "MemoryRangeTable", "<clinit>", "ThreeTierResolver selection allowed.");
        } else {
            ALLOW_THREE_TIER_TABLE_RESOLVER = false;
            logger.logp(Level.FINE, "MemoryRangeTable", "<clinit>", "ThreeTierResolver selection NOT allowed.");
        }
    }

    private static class ThreeTierPageTableAddressResolver
    implements IAddressResolverStrategy {
        private final Object[] pageTable;
        private final int pageTableSize;
        private final long alignment;
        private final int topLevelBits;
        private final int midTierBits;
        private final int bottomTierBits;

        public ThreeTierPageTableAddressResolver(List<IMemorySource> list, long l, int n) {
            this.alignment = n;
            long l2 = l >>> n;
            int n2 = (int)Math.ceil(Math.log(l2) / Math.log(2.0));
            if (n2 > 40) {
                this.midTierBits = 20;
                this.bottomTierBits = 20;
                this.topLevelBits = n2 - this.midTierBits - this.bottomTierBits;
            } else if (n2 > 20) {
                this.topLevelBits = 0;
                this.bottomTierBits = 20;
                this.midTierBits = n2 - this.bottomTierBits;
            } else {
                this.topLevelBits = 0;
                this.midTierBits = 0;
                this.bottomTierBits = n2;
            }
            this.pageTableSize = 1 << this.topLevelBits;
            this.pageTable = new Object[this.pageTableSize];
            for (IMemorySource iMemorySource : list) {
                long l3 = iMemorySource.getBaseAddress() >>> n;
                long l4 = iMemorySource.getTopAddress() >>> n;
                for (long i = l3; i <= l4; ++i) {
                    this.insert(i, iMemorySource);
                }
            }
        }

        private void insert(long l, IMemorySource iMemorySource) {
            IMemorySource[] iMemorySourceArray;
            int n = (int)(l & (long)((1 << this.bottomTierBits) - 1));
            long l2 = l >>> this.bottomTierBits;
            int n2 = (int)(l2 & (long)((1 << this.midTierBits) - 1));
            int n3 = (int)(l2 >>>= this.midTierBits);
            Object[] objectArray = (Object[])this.pageTable[n3];
            if (objectArray == null) {
                this.pageTable[n3] = objectArray = new Object[1 << this.midTierBits];
            }
            if (null == (iMemorySourceArray = (IMemorySource[])objectArray[n2])) {
                objectArray[n2] = iMemorySourceArray = new IMemorySource[1 << this.bottomTierBits];
            }
            iMemorySourceArray[n] = iMemorySource;
        }

        @Override
        public IMemorySource getRangeForAddress(long l) {
            long l2 = l >>> (int)this.alignment;
            int n = (int)(l2 & (long)((1 << this.bottomTierBits) - 1));
            long l3 = l2 >>> this.bottomTierBits;
            int n2 = (int)(l3 & (long)((1 << this.midTierBits) - 1));
            int n3 = (int)(l3 >>>= this.midTierBits);
            if (n3 < 0 || n3 >= this.pageTableSize) {
                return null;
            }
            Object[] objectArray = (Object[])this.pageTable[n3];
            if (objectArray == null) {
                return null;
            }
            IMemorySource[] iMemorySourceArray = (IMemorySource[])objectArray[n2];
            if (null == iMemorySourceArray) {
                return null;
            }
            return iMemorySourceArray[n];
        }
    }

    private static class FlatPageTableAddressResolver
    implements IAddressResolverStrategy {
        private final IMemorySource[] pageTable;
        private final long alignment;

        public FlatPageTableAddressResolver(List<IMemorySource> list, long l, int n) {
            this.alignment = n;
            long l2 = (l >>> n) + 1L;
            this.pageTable = new IMemorySource[(int)l2];
            for (IMemorySource iMemorySource : list) {
                int n2 = (int)(iMemorySource.getBaseAddress() >>> n);
                int n3 = (int)(iMemorySource.getTopAddress() >>> n);
                for (int i = n2; i <= n3; ++i) {
                    this.pageTable[i] = iMemorySource;
                }
            }
        }

        @Override
        public IMemorySource getRangeForAddress(long l) {
            int n = (int)(l >>> (int)this.alignment);
            if (n >= this.pageTable.length) {
                return null;
            }
            return this.pageTable[n];
        }
    }

    private static class BinaryChopAddressResolver
    implements IAddressResolverStrategy {
        private List<IMemorySource> memoryRanges;
        private IMemorySource tlbEntry1 = null;
        private long entry1HitCount = 0L;
        private IMemorySource tlbEntry2 = null;
        private long entry2HitCount = 0L;

        public BinaryChopAddressResolver(List<IMemorySource> list) {
            this.memoryRanges = list;
            Collections.sort(list);
        }

        @Override
        public IMemorySource getRangeForAddress(long l) {
            IMemorySource iMemorySource;
            int n = 0;
            int n2 = this.memoryRanges.size() - 1;
            IMemorySource iMemorySource2 = this.tlbCheck(l);
            if (iMemorySource2 != null) {
                if (AbstractMemory.RECORDING_CACHE_STATS) {
                    ++tlbCacheHits;
                }
                return iMemorySource2;
            }
            if (AbstractMemory.RECORDING_CACHE_STATS) {
                ++tlbCacheMisses;
            }
            while (true) {
                int n3;
                if (Addresses.greaterThan((iMemorySource = this.memoryRanges.get(n3 = (n + n2) / 2)).getBaseAddress(), l)) {
                    if (n == n2) {
                        return null;
                    }
                    n2 = n3;
                    continue;
                }
                if (!Addresses.lessThan(iMemorySource.getTopAddress(), l)) break;
                if (n2 == n) {
                    return null;
                }
                if (n3 == n) {
                    n = n2;
                    continue;
                }
                n = n3;
            }
            this.tlbInsert(iMemorySource);
            return iMemorySource;
        }

        private IMemorySource tlbCheck(long l) {
            if (this.tlbEntry1 != null && this.tlbEntry1.contains(l)) {
                ++this.entry1HitCount;
                return this.tlbEntry1;
            }
            if (this.tlbEntry2 != null && this.tlbEntry2.contains(l)) {
                ++this.entry2HitCount;
                return this.tlbEntry2;
            }
            return null;
        }

        private void tlbInsert(IMemorySource iMemorySource) {
            if (this.tlbEntry1 == null) {
                this.tlbEntry1 = iMemorySource;
            } else if (this.tlbEntry2 == null) {
                this.tlbEntry2 = iMemorySource;
            } else if (this.entry1HitCount >= this.entry2HitCount) {
                this.tlbEntry2 = iMemorySource;
            } else {
                this.tlbEntry1 = iMemorySource;
            }
            this.entry1HitCount = 0L;
            this.entry2HitCount = 0L;
        }
    }

    private static class DebugAddressResolverStrategy
    implements IAddressResolverStrategy {
        private final IAddressResolverStrategy trusted;
        private final IAddressResolverStrategy untrusted;

        public DebugAddressResolverStrategy(IAddressResolverStrategy iAddressResolverStrategy, IAddressResolverStrategy iAddressResolverStrategy2) {
            this.trusted = iAddressResolverStrategy;
            this.untrusted = iAddressResolverStrategy2;
        }

        @Override
        public IMemorySource getRangeForAddress(long l) {
            IMemorySource iMemorySource;
            IMemorySource iMemorySource2 = this.trusted.getRangeForAddress(l);
            if (iMemorySource2.equals(iMemorySource = this.untrusted.getRangeForAddress(l))) {
                return iMemorySource2;
            }
            throw new RuntimeException("Mismatch for address 0x" + Long.toHexString(l) + ". Trusted gave " + iMemorySource2 + ", untrusted gave " + iMemorySource);
        }
    }

    private static interface IAddressResolverStrategy {
        public IMemorySource getRangeForAddress(long var1);
    }

    private static class MergedMemoryRange
    extends BaseMemoryRange
    implements IMemorySource {
        private final IMemorySource lower;
        private final IMemorySource upper;

        public MergedMemoryRange(IMemorySource iMemorySource, IMemorySource iMemorySource2) {
            super(iMemorySource.getBaseAddress(), iMemorySource2.getTopAddress() - iMemorySource.getBaseAddress() + 1L);
            this.lower = iMemorySource;
            this.upper = iMemorySource2;
            if (iMemorySource.isBacked() != iMemorySource2.isBacked()) {
                throw new RuntimeException("Error: creating an instance of MergedMemoryRange where backed and unbacked memory sources are merged");
            }
        }

        @Override
        public int getAddressSpaceId() {
            return this.lower.getAddressSpaceId();
        }

        @Override
        public boolean isBacked() {
            return this.upper.isBacked();
        }

        @Override
        public int getBytes(long l, byte[] byArray, int n, int n2) throws MemoryFault {
            if (this.lower.contains(l) && this.lower.contains(l + (long)n2)) {
                return this.lower.getBytes(l, byArray, n, n2);
            }
            if (Addresses.greaterThan(l, this.lower.getTopAddress())) {
                return this.upper.getBytes(l, byArray, n, n2);
            }
            int n3 = (int)(this.lower.getTopAddress() - l + 1L);
            int n4 = this.lower.getBytes(l, byArray, n, n3);
            if (n4 == n3) {
                n4 += this.upper.getBytes(l + (long)n3, byArray, n + n3, n2 - n3);
            }
            return n4;
        }

        @Override
        public boolean isExecutable() {
            return this.lower.isExecutable() && this.upper.isExecutable();
        }

        @Override
        public boolean isReadOnly() {
            return this.lower.isReadOnly() && this.upper.isReadOnly();
        }

        @Override
        public boolean isShared() {
            return this.lower.isShared() && this.upper.isShared();
        }

        @Override
        public String getName() {
            String string = this.lower.getName();
            String string2 = this.upper.getName();
            if (string != null) {
                if (string2 != null) {
                    return string + " merged with " + string2;
                }
                return string;
            }
            if (string2 != null) {
                return string2;
            }
            return null;
        }
    }
}

