/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.AlgorithmPicker;
import com.ibm.j9ddr.vm29.j9.BaseAlgorithm;
import com.ibm.j9ddr.vm29.j9.IAlgorithm;
import com.ibm.j9ddr.vm29.j9.ROMHelp;
import com.ibm.j9ddr.vm29.j9.walkers.LineNumber;
import com.ibm.j9ddr.vm29.j9.walkers.LineNumberIterator;
import com.ibm.j9ddr.vm29.j9.walkers.LocalVariableTableIterator;
import com.ibm.j9ddr.vm29.pointer.SelfRelativePointer;
import com.ibm.j9ddr.vm29.pointer.U32Pointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9EnclosingObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodDebugInfoPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9SourceDebugExtensionPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9UTF8Pointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9MethodDebugInfoHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ROMClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.structure.J9MethodDebugInfo;
import com.ibm.j9ddr.vm29.structure.J9NonbuilderConstants;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.util.LinkedList;

public class OptInfo {
    private static IOptInfoImpl impl;
    private static final AlgorithmPicker<IOptInfoImpl> picker;

    private static IOptInfoImpl getImpl() {
        if (impl == null) {
            impl = picker.pickAlgorithm();
        }
        return impl;
    }

    public static int getLineNumberForROMClass(J9MethodPointer j9MethodPointer, UDATA uDATA) throws CorruptDataException {
        return OptInfo.getImpl().getLineNumberForROMClass(j9MethodPointer, uDATA);
    }

    public static J9MethodDebugInfoPointer getMethodDebugInfoForROMClass(J9MethodPointer j9MethodPointer) throws CorruptDataException {
        return ROMHelp.getMethodDebugInfoFromROMMethod(ROMHelp.getOriginalROMMethod(j9MethodPointer));
    }

    private static SelfRelativePointer getSRPPtr(U32Pointer u32Pointer, UDATA uDATA, long l) {
        if (!uDATA.anyBitsIn(l) || u32Pointer.isNull()) {
            return SelfRelativePointer.NULL;
        }
        return SelfRelativePointer.cast(u32Pointer.add(OptInfo.countBits(OptInfo.COUNT_MASK(new U32(uDATA), l)) - 1));
    }

    public static int countBits(U32 u32) {
        return Long.bitCount(u32.longValue());
    }

    public static U8Pointer getV1VariableTableForMethodDebugInfo(J9MethodDebugInfoPointer j9MethodDebugInfoPointer) throws CorruptDataException {
        LocalVariableTableIterator.checkVariableTableVersion();
        return U8Pointer.cast(OptInfo._getVariableTableForMethodDebugInfo(j9MethodDebugInfoPointer));
    }

    private static VoidPointer _getVariableTableForMethodDebugInfo(J9MethodDebugInfoPointer j9MethodDebugInfoPointer) throws CorruptDataException {
        if (!j9MethodDebugInfoPointer.varInfoCount().eq(0L)) {
            U32 u32 = U32Pointer.cast(j9MethodDebugInfoPointer).at(0L);
            if (u32.allBitsIn(1L)) {
                U32 u322 = J9MethodDebugInfoHelper.getLineNumberCompressedSize(j9MethodDebugInfoPointer);
                return VoidPointer.cast(U8Pointer.cast(j9MethodDebugInfoPointer).addOffset(J9MethodDebugInfo.SIZEOF).addOffset(u322));
            }
            return VoidPointer.cast(j9MethodDebugInfoPointer.srpToVarInfo());
        }
        return VoidPointer.NULL;
    }

    public static U32 COUNT_MASK(U32 u32, long l) {
        return u32.bitAnd((l << 1) - 1L);
    }

    public static String getSourceFileNameForROMClass(J9ROMClassPointer j9ROMClassPointer) throws CorruptDataException {
        return OptInfo.getOption(j9ROMClassPointer, J9NonbuilderConstants.J9_ROMCLASS_OPTINFO_SOURCE_FILE_NAME);
    }

    public static String getSimpleNameForROMClass(J9ROMClassPointer j9ROMClassPointer) throws CorruptDataException {
        return OptInfo.getOption(j9ROMClassPointer, J9NonbuilderConstants.J9_ROMCLASS_OPTINFO_SIMPLE_NAME);
    }

    public static U32Pointer getClassAnnotationsDataForROMClass(J9ROMClassPointer j9ROMClassPointer) throws CorruptDataException {
        VoidPointer voidPointer = OptInfo.getStructure(j9ROMClassPointer, J9NonbuilderConstants.J9_ROMCLASS_OPTINFO_CLASS_ANNOTATION_INFO);
        return U32Pointer.cast(voidPointer);
    }

    public static U32Pointer getClassTypeAnnotationsDataForROMClass(J9ROMClassPointer j9ROMClassPointer) throws CorruptDataException {
        VoidPointer voidPointer = OptInfo.getStructure(j9ROMClassPointer, J9NonbuilderConstants.J9_ROMCLASS_OPTINFO_TYPE_ANNOTATION_INFO);
        return U32Pointer.cast(voidPointer);
    }

    public static String getGenericSignatureForROMClass(J9ROMClassPointer j9ROMClassPointer) throws CorruptDataException {
        return OptInfo.getOption(j9ROMClassPointer, J9NonbuilderConstants.J9_ROMCLASS_OPTINFO_GENERIC_SIGNATURE);
    }

    public static J9EnclosingObjectPointer getEnclosingMethodForROMClass(J9ROMClassPointer j9ROMClassPointer) throws CorruptDataException {
        VoidPointer voidPointer = OptInfo.getStructure(j9ROMClassPointer, J9NonbuilderConstants.J9_ROMCLASS_OPTINFO_ENCLOSING_METHOD);
        if (voidPointer.notNull()) {
            return J9EnclosingObjectPointer.cast(voidPointer);
        }
        return J9EnclosingObjectPointer.NULL;
    }

    private static String getOption(J9ROMClassPointer j9ROMClassPointer, long l) throws CorruptDataException {
        VoidPointer voidPointer = OptInfo.getStructure(j9ROMClassPointer, l);
        if (voidPointer.notNull()) {
            return J9UTF8Helper.stringValue(J9UTF8Pointer.cast(voidPointer));
        }
        return null;
    }

    private static VoidPointer getStructure(J9ROMClassPointer j9ROMClassPointer, long l) throws CorruptDataException {
        SelfRelativePointer selfRelativePointer = OptInfo.getSRPPtr(J9ROMClassHelper.optionalInfo(j9ROMClassPointer), j9ROMClassPointer.optionalFlags(), l);
        if (selfRelativePointer.notNull()) {
            return VoidPointer.cast(selfRelativePointer.get());
        }
        return VoidPointer.NULL;
    }

    public static J9SourceDebugExtensionPointer getSourceDebugExtensionForROMClass(J9ROMClassPointer j9ROMClassPointer) throws CorruptDataException {
        SelfRelativePointer selfRelativePointer = OptInfo.getSRPPtr(J9ROMClassHelper.optionalInfo(j9ROMClassPointer), j9ROMClassPointer.optionalFlags(), J9NonbuilderConstants.J9_ROMCLASS_OPTINFO_SOURCE_DEBUG_EXTENSION);
        if (selfRelativePointer.notNull()) {
            return J9SourceDebugExtensionPointer.cast(selfRelativePointer.get());
        }
        return J9SourceDebugExtensionPointer.NULL;
    }

    private static U32Pointer getPermittedSubclassPointer(J9ROMClassPointer j9ROMClassPointer) throws CorruptDataException {
        SelfRelativePointer selfRelativePointer = OptInfo.getSRPPtr(J9ROMClassHelper.optionalInfo(j9ROMClassPointer), j9ROMClassPointer.optionalFlags(), J9NonbuilderConstants.J9_ROMCLASS_OPTINFO_PERMITTEDSUBCLASSES_ATTRIBUTE);
        if (selfRelativePointer.notNull()) {
            return U32Pointer.cast(selfRelativePointer.get());
        }
        return U32Pointer.NULL;
    }

    public static int getPermittedSubclassCount(J9ROMClassPointer j9ROMClassPointer) throws CorruptDataException {
        U32Pointer u32Pointer = OptInfo.getPermittedSubclassPointer(j9ROMClassPointer);
        if (u32Pointer.notNull()) {
            return u32Pointer.at(0L).intValue();
        }
        return 0;
    }

    public static J9UTF8Pointer getPermittedSubclassNameAtIndex(J9ROMClassPointer j9ROMClassPointer, int n) throws CorruptDataException {
        U32Pointer u32Pointer = OptInfo.getPermittedSubclassPointer(j9ROMClassPointer);
        if (u32Pointer.notNull()) {
            u32Pointer = u32Pointer.add(n + 1);
            SelfRelativePointer selfRelativePointer = SelfRelativePointer.cast(u32Pointer);
            return J9UTF8Pointer.cast(selfRelativePointer.get());
        }
        return J9UTF8Pointer.NULL;
    }

    public static int getLoadableDescriptorsCount(J9ROMClassPointer j9ROMClassPointer) throws CorruptDataException {
        U32Pointer u32Pointer = OptInfo.getLoadableDescriptorsInfoPointer(j9ROMClassPointer);
        if (u32Pointer.notNull()) {
            return u32Pointer.at(0L).intValue();
        }
        return 0;
    }

    private static U32Pointer getLoadableDescriptorsInfoPointer(J9ROMClassPointer j9ROMClassPointer) throws CorruptDataException {
        SelfRelativePointer selfRelativePointer = OptInfo.getSRPPtr(J9ROMClassHelper.optionalInfo(j9ROMClassPointer), j9ROMClassPointer.optionalFlags(), J9NonbuilderConstants.J9_ROMCLASS_OPTINFO_LOADABLEDESCRIPTORS_ATTRIBUTE);
        if (selfRelativePointer.notNull()) {
            return U32Pointer.cast(selfRelativePointer.get());
        }
        return U32Pointer.NULL;
    }

    public static J9UTF8Pointer getLoadableDescriptorAtIndex(J9ROMClassPointer j9ROMClassPointer, int n) throws CorruptDataException {
        U32Pointer u32Pointer = OptInfo.getLoadableDescriptorsInfoPointer(j9ROMClassPointer);
        if (u32Pointer.notNull()) {
            SelfRelativePointer selfRelativePointer = SelfRelativePointer.cast(u32Pointer.add(n + 1));
            return J9UTF8Pointer.cast(selfRelativePointer.get());
        }
        return J9UTF8Pointer.NULL;
    }

    static {
        picker = new AlgorithmPicker<IOptInfoImpl>("OPT_INFO_VERSION"){

            @Override
            protected Iterable<? extends IOptInfoImpl> allAlgorithms() {
                LinkedList<OptInfo_29_V0> linkedList = new LinkedList<OptInfo_29_V0>();
                linkedList.add(new OptInfo_29_V0());
                return linkedList;
            }
        };
    }

    private static class OptInfo_29_V0
    extends BaseAlgorithm
    implements IOptInfoImpl {
        protected OptInfo_29_V0() {
            super(90, 0);
        }

        @Override
        public int getLineNumberForROMClass(J9MethodPointer j9MethodPointer, UDATA uDATA) throws CorruptDataException {
            J9MethodDebugInfoPointer j9MethodDebugInfoPointer;
            UDATA uDATA2 = ROMHelp.J9_BYTECODE_SIZE_FROM_ROM_METHOD(ROMHelp.J9_ROM_METHOD_FROM_RAM_METHOD(j9MethodPointer));
            int n = -1;
            if ((uDATA.lt(uDATA2) || uDATA2.eq(0L)) && (j9MethodDebugInfoPointer = OptInfo.getMethodDebugInfoForROMClass(j9MethodPointer)).notNull()) {
                LineNumber lineNumber;
                LineNumberIterator lineNumberIterator = LineNumberIterator.lineNumberIteratorFor(j9MethodDebugInfoPointer);
                while (lineNumberIterator.hasNext() && !uDATA.lt((lineNumber = (LineNumber)lineNumberIterator.next()).getLocation())) {
                    n = lineNumber.getLineNumber().intValue();
                }
            }
            return n;
        }
    }

    private static interface IOptInfoImpl
    extends IAlgorithm {
        public int getLineNumberForROMClass(J9MethodPointer var1, UDATA var2) throws CorruptDataException;
    }
}

