/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.SimpleRootScanner;
import com.ibm.j9ddr.vm29.j9.gc.GCIterator;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class RootSet {
    private static RootSet[] _singletons = new RootSet[RootSetType.values().length];
    private ArrayList<J9ObjectPointer> _allRoots = new ArrayList();
    private ArrayList<VoidPointer> _allAddresses = new ArrayList();

    private RootSet(RootSetType rootSetType) throws CorruptDataException {
        RootSetScanner rootSetScanner = new RootSetScanner();
        switch (rootSetType) {
            case ALL: {
                rootSetScanner.scanAllSlots();
                break;
            }
            case STRONG_REACHABLE: {
                rootSetScanner.scanRoots();
                break;
            }
            case WEAK_REACHABLE: {
                rootSetScanner.scanClearable();
                break;
            }
            case ALL_SLOTS_EXCLUDING_STACK_SLOTS: {
                rootSetScanner.setScanStackSlots(false);
                rootSetScanner.scanAllSlots();
                break;
            }
            case STRONG_REACHABLE_EXCLUDING_STACK_SLOTS: {
                rootSetScanner.setScanStackSlots(false);
                rootSetScanner.scanRoots();
            }
            default: {
                throw new UnsupportedOperationException("Invalid rootSetType");
            }
        }
    }

    protected static RootSet from(RootSetType rootSetType, boolean bl) throws CorruptDataException {
        RootSet rootSet = bl ? (null == _singletons[rootSetType.getValue()] ? new RootSet(rootSetType) : _singletons[rootSetType.getValue()]) : new RootSet(rootSetType);
        if (null == _singletons[rootSetType.getValue()]) {
            RootSet._singletons[rootSetType.getValue()] = rootSet;
        }
        return rootSet;
    }

    public static List<J9ObjectPointer> allRoots(RootSetType rootSetType) throws CorruptDataException {
        RootSet rootSet = new RootSet(rootSetType);
        return Collections.unmodifiableList(rootSet._allRoots);
    }

    public GCIterator gcIterator(RootSetType rootSetType) throws CorruptDataException {
        final Iterator<J9ObjectPointer> iterator = this._allRoots.iterator();
        final Iterator<VoidPointer> iterator2 = this._allAddresses.iterator();
        return new GCIterator(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public VoidPointer nextAddress() {
                iterator.next();
                return (VoidPointer)iterator2.next();
            }

            @Override
            public Object next() {
                iterator2.next();
                return iterator.next();
            }
        };
    }

    public static GCIterator rootIterator(RootSetType rootSetType) throws CorruptDataException {
        RootSet rootSet = RootSet.from(rootSetType, true);
        return rootSet.gcIterator(rootSetType);
    }

    private class RootSetScanner
    extends SimpleRootScanner {
        protected RootSetScanner() throws CorruptDataException {
        }

        @Override
        protected void doClassSlot(J9ClassPointer j9ClassPointer, VoidPointer voidPointer) {
            if (j9ClassPointer.notNull()) {
                this.doClass(j9ClassPointer, voidPointer);
            }
        }

        @Override
        protected void doSlot(J9ObjectPointer j9ObjectPointer, VoidPointer voidPointer) {
            if (j9ObjectPointer.notNull()) {
                RootSet.this._allRoots.add(j9ObjectPointer);
                RootSet.this._allAddresses.add(voidPointer);
            }
        }

        @Override
        protected void doClass(J9ClassPointer j9ClassPointer, VoidPointer voidPointer) {
            J9ObjectPointer j9ObjectPointer = J9ObjectPointer.NULL;
            VoidPointer voidPointer2 = VoidPointer.NULL;
            try {
                j9ObjectPointer = j9ClassPointer.classObject();
                voidPointer2 = VoidPointer.cast(j9ClassPointer.classObjectEA());
            }
            catch (CorruptDataException corruptDataException) {
                EventManager.raiseCorruptDataEvent("Class: " + j9ClassPointer.getHexAddress() + " has invalid classObject slot", corruptDataException, false);
                return;
            }
            this.doSlot(j9ObjectPointer, voidPointer2);
        }
    }

    public static enum RootSetType {
        ALL(0),
        STRONG_REACHABLE(1),
        WEAK_REACHABLE(2),
        ALL_SLOTS_EXCLUDING_STACK_SLOTS(3),
        STRONG_REACHABLE_EXCLUDING_STACK_SLOTS(4);

        private final int value;

        private RootSetType(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }
    }
}

