/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageProcess;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.gc.GCExtensions;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RASPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import java.io.PrintStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RuntimeSettingsCommand
extends Command {
    private static final Pattern p = Pattern.compile("(\\d+[KMG]).*");
    private static final String usageInfo = "Prints VM information that can change during runtime (e.g. initial and current softmx values).";
    private static final int PADDING = 4;

    public RuntimeSettingsCommand() {
        this.addCommand("runtimesettings", "", usageInfo);
    }

    private void printUsage(PrintStream printStream) {
        printStream.println("runtimesettings - Prints VM information that can change during runtime (e.g. initial and current softmx values).");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        if (0 < stringArray.length) {
            printStream.println("!runtimesettings expects no args. Usage :");
            this.printUsage(printStream);
            return;
        }
        try {
            String string2 = "";
            String string3 = "not set";
            J9RASPointer j9RASPointer = DataType.getJ9RASPointer();
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(j9RASPointer);
            IProcess iProcess = j9JavaVMPointer.getProcess();
            J9DDRImageProcess j9DDRImageProcess = new J9DDRImageProcess(iProcess);
            String string4 = j9DDRImageProcess.getCommandLine();
            int n = string4.indexOf("-Xsoftmx");
            int n2 = "-Xsoftmx".length();
            int n3 = string4.indexOf(" ", n);
            if (-1 != n) {
                string3 = string4.substring(n + n2, n3);
                string3 = string3.toUpperCase();
            }
            Long l = GCExtensions.softMx().longValue();
            string2 = l.toString();
            Matcher matcher = p.matcher(string3);
            if (matcher.matches()) {
                string3 = matcher.group(1);
                string2 = this.qualifiedSize(l);
                matcher = p.matcher(string2);
                if (!matcher.matches()) {
                    string3 = this.sizeInBytes(string3);
                }
            } else {
                string2 = l.toString();
            }
            this.printTableOfEqualSpacedColumns(printStream, new String[]{"name", "initial value", "current value"}, new String[][]{{"-Xsoftmx", string3, string2}});
        }
        catch (DataUnavailable dataUnavailable) {
            printStream.println("COMMANDLINE is not available\n");
        }
        catch (com.ibm.dtfj.image.CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException("CorruptDataException occured while getting the commandline from process");
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }

    private void printTableOfEqualSpacedColumns(PrintStream printStream, String[] stringArray, String[][] stringArray2) {
        if (!this.isColumnNumbersValid(stringArray, stringArray2)) {
            printStream.println("Warning: the number of headers do not match the number of values");
            assert (false);
        } else {
            int n = this.getLongestStringLength(stringArray);
            for (int i = 0; i < stringArray2.length; ++i) {
                n = this.max(n, this.getLongestStringLength(stringArray2[i]));
            }
            this.printTableDivider(printStream, stringArray.length, n += 4);
            this.printTableRows(printStream, n, stringArray);
            this.printTableDivider(printStream, stringArray.length, n);
            for (String[] stringArray3 : stringArray2) {
                this.printTableRows(printStream, n, stringArray3);
                this.printTableDivider(printStream, stringArray.length, n);
            }
        }
    }

    private boolean isColumnNumbersValid(String[] stringArray, String[][] stringArray2) {
        for (int i = 0; i < stringArray2.length; ++i) {
            if (stringArray.length == stringArray2[i].length) continue;
            return false;
        }
        return true;
    }

    private void printTableRows(PrintStream printStream, int n, String[] stringArray) {
        for (int i = 0; i != stringArray.length; ++i) {
            int n2;
            printStream.print('|');
            int n3 = (n - stringArray[i].length()) / 2;
            for (n2 = 0; n2 != n3; ++n2) {
                printStream.print(' ');
            }
            printStream.print(stringArray[i]);
            for (n2 = 0; n2 != n3; ++n2) {
                printStream.print(' ');
            }
            if (0 != stringArray[i].length() % 2) continue;
            printStream.print(' ');
        }
        printStream.print("|\n");
    }

    private void printTableDivider(PrintStream printStream, int n, int n2) {
        for (int i = 0; i != n; ++i) {
            printStream.print('+');
            for (int j = 0; j != n2; ++j) {
                printStream.print('-');
            }
        }
        printStream.print("+\n");
    }

    private int max(int n, int n2) {
        if (n > n2) {
            return n;
        }
        return n2;
    }

    private int getLongestStringLength(String[] stringArray) {
        String string = stringArray[0];
        for (int i = 1; i < stringArray.length; ++i) {
            if (stringArray[i].length() <= string.length()) continue;
            string = stringArray[i];
        }
        return string.length();
    }

    private String sizeInBytes(String string) {
        Long l = Long.valueOf(string.substring(0, string.length() - 1));
        if (string.endsWith("K")) {
            l = l * 1024L;
        } else if (string.endsWith("M")) {
            l = l * 1024L * 1024L;
        } else if (string.endsWith("G")) {
            l = l * 1024L * 1024L * 1024L;
        } else assert (false);
        return l.toString();
    }

    private String qualifiedSize(Long l) {
        String string = "";
        if (0L == l % 1024L) {
            l = l / 1024L;
            string = "K";
            if (0L < l && 0L == l % 1024L) {
                l = l / 1024L;
                string = "M";
                if (0L < l && 0L == l % 1024L) {
                    l = l / 1024L;
                    string = "G";
                }
            }
        }
        return l + string;
    }
}

