/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.trace.format.api;

import com.ibm.jvm.trace.format.api.ByteStream;
import com.ibm.jvm.trace.format.api.TraceContext;
import java.io.UnsupportedEncodingException;
import java.nio.BufferUnderflowException;
import java.util.ArrayList;
import java.util.Properties;

public final class Message {
    TraceContext context;
    private int ptrSize;
    private int type;
    private String message;
    private String component;
    private boolean zero = false;
    private Arg[] parameterTypes;
    private Arg[] nonConstantParameterTypes;
    private int id;
    private int level;
    private Properties statistics = new Properties();

    public Message(int n, String string, int n2, int n3, String string2, String string3, TraceContext traceContext) {
        this.context = traceContext;
        this.type = n;
        this.message = string;
        this.component = string2;
        this.ptrSize = traceContext.getPointerSize();
        this.parameterTypes = this.parseMessageTemplate(null);
        this.nonConstantParameterTypes = this.filterTypes(this.parameterTypes);
        this.id = n2;
        this.level = n3;
        this.statistics.put("component", string2);
    }

    private Message(String string, int n) {
        this.message = string;
        this.ptrSize = n;
    }

    public void addStatistic(String string, long l) {
        long l2 = 0L;
        if (this.statistics.containsKey(string)) {
            l2 = (Long)this.statistics.get(string);
        }
        this.statistics.put(string, (Object)(l2 += l));
    }

    public Properties getStatistics() {
        return this.statistics;
    }

    public static Arg[] getArgumentDetails(String string, int n, StringBuffer stringBuffer) {
        Message message = new Message(string, n);
        Arg[] argArray = message.parseMessageTemplate(stringBuffer);
        return message.filterTypes(argArray);
    }

    private Arg[] filterTypes(Arg[] argArray) {
        int n = argArray.length;
        ArrayList<Arg> arrayList = new ArrayList<Arg>(n);
        for (int i = 0; i < n; ++i) {
            if (argArray[i] instanceof FixedStringArg) continue;
            arrayList.add(argArray[i]);
        }
        return Message.wrangleToArgArray(arrayList);
    }

    private static Arg[] wrangleToArgArray(ArrayList arrayList) {
        int n = arrayList.size();
        Arg[] argArray = new Arg[n];
        for (int i = 0; i < n; ++i) {
            argArray[i] = (Arg)arrayList.get(i);
        }
        return argArray;
    }

    protected static final void padBuffer(StringBuilder stringBuilder, int n, char c) {
        Message.padBuffer(stringBuilder, n, c, false);
    }

    protected static final void padBuffer(StringBuilder stringBuilder, int n, char c, boolean bl) {
        while (stringBuilder.length() < n) {
            if (bl) {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.insert(0, c);
        }
    }

    protected StringBuilder processPercents(String string, byte[] byArray, int n) {
        int n2 = this.parameterTypes.length;
        StringBuilder stringBuilder = new StringBuilder();
        ByteStream byteStream = this.context.createByteStream(byArray, n);
        int n3 = 0;
        try {
            for (n3 = 0; n3 < n2; ++n3) {
                this.parameterTypes[n3].format(byteStream, stringBuilder);
            }
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            this.context.warning(this, "BufferUnderflowException processing " + this.component + "." + this.id);
        }
        while (n3 < n2) {
            if (!(this.parameterTypes[n3] instanceof FixedStringArg)) {
                stringBuilder.append("<missing in trace>");
            } else {
                this.parameterTypes[n3].format(byteStream, stringBuilder);
            }
            ++n3;
        }
        return stringBuilder;
    }

    protected StringBuilder skipPercents(String string, byte[] byArray, int n) {
        int n2 = this.parameterTypes.length;
        StringBuilder stringBuilder = new StringBuilder();
        ByteStream byteStream = this.context.createByteStream(byArray, n);
        for (int i = 0; i < n2; ++i) {
            if (!(this.parameterTypes[i] instanceof FixedStringArg)) {
                stringBuilder.append("???");
                continue;
            }
            this.parameterTypes[i].format(byteStream, stringBuilder);
        }
        return stringBuilder;
    }

    protected void setPointerSize(int n) {
        this.ptrSize = n;
    }

    private static String readDigits(String string) {
        char[] cArray = new char[10];
        int n = 0;
        while (Character.isDigit(string.charAt(n))) {
            if (n >= cArray.length) continue;
            cArray[n] = string.charAt(n);
            ++n;
        }
        return new String(cArray, 0, n);
    }

    public String getMessage(byte[] byArray, int n, int n2) {
        String string = "";
        if (n < n2) {
            if (this.component == "ApplicationTrace") {
                n += 4;
            }
            return string + this.processPercents(this.message, byArray, n).toString();
        }
        return string + this.skipPercents(this.message, byArray, n).toString();
    }

    protected String getComponent() {
        return this.component;
    }

    protected int getLevel() {
        return this.level;
    }

    protected int getType() {
        return this.type;
    }

    protected String getFormattingTemplate() {
        return this.message;
    }

    protected Object[] parseMessage(byte[] byArray, int n) {
        int n2 = this.nonConstantParameterTypes.length;
        if (n2 == 0 || byArray == null) {
            return new Object[0];
        }
        Object[] objectArray = new Object[n2];
        ByteStream byteStream = this.context.createByteStream(byArray, n);
        for (int i = 0; i < n2; ++i) {
            objectArray[i] = this.nonConstantParameterTypes[i].getValue(byteStream);
        }
        return objectArray;
    }

    Arg[] parseMessageTemplate(StringBuffer stringBuffer) {
        ArrayList<Arg> arrayList = new ArrayList<Arg>();
        String string = this.message;
        int n = string.indexOf("%");
        String string2 = "";
        while (n != -1) {
            char c;
            String string3;
            FormatSpec formatSpec = null;
            if (n != 0) {
                arrayList.add(new FixedStringArg(string.substring(0, n)));
            }
            boolean bl = n > 1 ? "0x".equalsIgnoreCase(string.substring(n - 2, n)) : false;
            boolean bl2 = false;
            int n2 = 4;
            if ((string = string.substring(n + 1, string.length())).charAt(0) == '-') {
                formatSpec = new FormatSpec(true);
                string = string.substring(1, string.length());
            }
            if (string.charAt(0) == '0') {
                if (formatSpec == null) {
                    formatSpec = new FormatSpec();
                    formatSpec.setZeroPad(true);
                }
                string = string.substring(1, string.length());
            }
            if (Character.isDigit(string.charAt(0))) {
                if (formatSpec == null) {
                    formatSpec = new FormatSpec();
                }
                string3 = Message.readDigits(string);
                formatSpec.width = Integer.valueOf(string3);
                string = string.substring(string3.length(), string.length());
            }
            if (string.charAt(0) == '.') {
                if ((string = string.substring(1, string.length())).charAt(0) == '*') {
                    bl2 = true;
                    string = string.substring(1, string.length());
                } else {
                    if (formatSpec == null) {
                        formatSpec = new FormatSpec();
                    }
                    string3 = Message.readDigits(string);
                    formatSpec.precision = Integer.valueOf(string3);
                    string = string.substring(string3.length(), string.length());
                }
            }
            if ((c = string.charAt(0)) == 'l') {
                if (string.charAt(1) == 'l') {
                    n2 = 8;
                    string = string.substring(2, string.length());
                } else {
                    string = string.substring(1, string.length());
                }
            } else if (c == 'I' && string.charAt(1) == '6' && string.charAt(2) == '4') {
                n2 = 8;
                string = string.substring(3, string.length());
            } else if (c == 'h') {
                n2 = 2;
                string = string.substring(1, string.length());
            } else if (c == 'z') {
                n2 = -1;
                string = string.substring(1, string.length());
            }
            c = string.charAt(0);
            switch (c) {
                case 'p': {
                    if (!bl) {
                        arrayList.add(new FixedStringArg("0x"));
                    }
                    string = string.substring(1, string.length());
                    arrayList.add(new PointerArg(this.ptrSize));
                    break;
                }
                case 's': {
                    if (bl2) {
                        arrayList.add(new UTF8StringArg());
                    } else {
                        arrayList.add(new StringArg());
                    }
                    string = string.substring(1, string.length());
                    break;
                }
                case 'd': 
                case 'i': {
                    string = string.substring(1, string.length());
                    if (n2 == 4 || n2 == -1 && this.ptrSize == 4) {
                        arrayList.add(new I32_Arg(formatSpec, n2));
                        break;
                    }
                    arrayList.add(new I64_Arg(formatSpec, n2));
                    break;
                }
                case 'u': {
                    string = string.substring(1, string.length());
                    if (n2 == 4 || n2 == -1 && this.ptrSize == 4) {
                        arrayList.add(new U32_Arg(formatSpec, n2));
                        break;
                    }
                    arrayList.add(new U64_Arg(formatSpec, n2));
                    break;
                }
                case 'f': 
                case 'g': {
                    string = string.substring(1, string.length());
                    arrayList.add(new Double_Arg(formatSpec, this.ptrSize));
                    break;
                }
                case 'X': 
                case 'x': {
                    if (formatSpec == null) {
                        formatSpec = new FormatSpec();
                    }
                    formatSpec.setRadix(16);
                    if (!bl) {
                        formatSpec.addOxPrefix();
                    }
                    string = string.substring(1, string.length());
                    if (n2 == 4 || n2 == -1 && this.ptrSize == 4) {
                        arrayList.add(new U32_Arg(formatSpec, n2));
                        break;
                    }
                    arrayList.add(new U64_Arg(formatSpec, n2));
                    break;
                }
                case 'c': {
                    string = string.substring(1, string.length());
                    arrayList.add(new CharArg());
                    break;
                }
                case '%': {
                    string = string.substring(1, string.length());
                    arrayList.add(new FixedStringArg("%"));
                    break;
                }
                case ' ': 
                case '#': 
                case '+': {
                    if (stringBuffer != null) {
                        stringBuffer.append("Used a printf flag not supported " + c);
                    }
                    if (this.context != null) {
                        this.context.error(this, "Used a printf flag not supported " + c);
                    }
                    string = string.substring(1, string.length());
                    break;
                }
                default: {
                    if (stringBuffer != null) {
                        stringBuffer.append("error percent directive looked like => " + string);
                    }
                    if (this.context != null) {
                        this.context.error(this, "error percent directive looked like => " + string);
                    }
                    string = string.substring(1, string.length());
                }
            }
            n = string.indexOf("%");
            formatSpec = null;
        }
        if (string.length() > 0) {
            arrayList.add(new FixedStringArg(string));
        }
        int n3 = arrayList.size();
        Arg[] argArray = new Arg[n3];
        for (int i = 0; i < n3; ++i) {
            argArray[i] = (Arg)arrayList.get(i);
        }
        return argArray;
    }

    StringBuilder formatz(long l, FormatSpec formatSpec) {
        StringBuilder stringBuilder = new StringBuilder();
        if (formatSpec != null && formatSpec.needsOxPrefix()) {
            stringBuilder.append("0x");
        }
        String string = Long.toString(l, formatSpec != null ? formatSpec.getRadix() : 10);
        stringBuilder.append(string);
        if (formatSpec != null) {
            if (formatSpec.precision != null) {
                Message.padBuffer(stringBuilder, formatSpec.precision, '0');
            }
            if (formatSpec.width != null) {
                Message.padBuffer(stringBuilder, formatSpec.width, formatSpec.needsZeroPad() && !formatSpec.leftJustified ? (char)'0' : ' ', formatSpec.leftJustified);
            }
        }
        return stringBuilder;
    }

    class FormatSpec {
        protected Integer width;
        protected Integer precision;
        protected boolean leftJustified = false;
        private int radix = -1;
        private boolean addOxPrefix = false;
        private boolean zeroPad = false;

        public FormatSpec() {
            this(false);
        }

        public FormatSpec(boolean bl) {
            this.leftJustified = bl;
        }

        public void setRadix(int n) {
            this.radix = n;
        }

        public int getRadix() {
            return this.radix;
        }

        public void addOxPrefix() {
            this.addOxPrefix = true;
        }

        public boolean needsOxPrefix() {
            return this.addOxPrefix;
        }

        public void setZeroPad(boolean bl) {
            this.zeroPad = bl;
        }

        public boolean needsZeroPad() {
            return this.zeroPad;
        }

        public String toString() {
            return "FormatSpec w: " + this.width + " p:" + this.precision + " just: " + this.leftJustified;
        }
    }

    public class Double_Arg
    extends Arg {
        private FormatSpec fspec;

        Double_Arg(FormatSpec formatSpec, int n) {
            super(n);
            this.signature = "double";
            this.fspec = formatSpec;
        }

        @Override
        Object getValue(ByteStream byteStream) {
            return byteStream.getDouble();
        }

        @Override
        void format(ByteStream byteStream, StringBuilder stringBuilder) {
            Double d = (Double)this.getValue(byteStream);
            StringBuilder stringBuilder2 = new StringBuilder(d.toString());
            if (this.fspec != null && this.fspec.width != null) {
                Message.padBuffer(stringBuilder2, this.fspec.width, ' ', this.fspec.leftJustified);
            }
            stringBuilder.append((CharSequence)stringBuilder2);
        }
    }

    public class Float_Arg
    extends Arg {
        private FormatSpec fspec;

        Float_Arg(FormatSpec formatSpec, int n) {
            super(n);
            this.signature = "float";
            this.fspec = formatSpec;
        }

        @Override
        Object getValue(ByteStream byteStream) {
            return Float.valueOf(byteStream.getFloat());
        }

        @Override
        void format(ByteStream byteStream, StringBuilder stringBuilder) {
            Float f = (Float)this.getValue(byteStream);
            StringBuilder stringBuilder2 = new StringBuilder(f.toString());
            if (this.fspec != null && this.fspec.width != null) {
                Message.padBuffer(stringBuilder2, this.fspec.width, ' ', this.fspec.leftJustified);
            }
            stringBuilder.append((CharSequence)stringBuilder2);
        }
    }

    public class U64_Arg
    extends Arg {
        private FormatSpec fspec;

        U64_Arg(FormatSpec formatSpec, int n) {
            super(n);
            if (n == -1) {
                this.signature = "UDATA";
                this.sizeof = Message.this.ptrSize;
            } else {
                this.signature = "U_64";
            }
            this.fspec = formatSpec;
        }

        @Override
        Object getValue(ByteStream byteStream) {
            return byteStream.getLong();
        }

        @Override
        void format(ByteStream byteStream, StringBuilder stringBuilder) {
            Long l = (Long)this.getValue(byteStream);
            stringBuilder.append((CharSequence)Message.this.formatz(l, this.fspec));
        }
    }

    public class U32_Arg
    extends Arg {
        private FormatSpec fspec;

        U32_Arg(FormatSpec formatSpec, int n) {
            super(n);
            if (n == -1) {
                this.signature = "UDATA";
                this.sizeof = Message.this.ptrSize;
            } else {
                this.signature = "U_32";
            }
            this.fspec = formatSpec;
        }

        @Override
        Object getValue(ByteStream byteStream) {
            return byteStream.getUnsignedInt();
        }

        @Override
        void format(ByteStream byteStream, StringBuilder stringBuilder) {
            Long l = (Long)this.getValue(byteStream);
            stringBuilder.append((CharSequence)Message.this.formatz(l, this.fspec));
        }
    }

    public class I64_Arg
    extends Arg {
        private FormatSpec fspec;

        I64_Arg(FormatSpec formatSpec, int n) {
            super(n);
            if (n == -1) {
                this.signature = "IDATA";
                this.sizeof = Message.this.ptrSize;
            } else {
                this.signature = "I_64";
            }
            this.fspec = formatSpec;
        }

        @Override
        Object getValue(ByteStream byteStream) {
            return byteStream.getLong();
        }

        @Override
        void format(ByteStream byteStream, StringBuilder stringBuilder) {
            Long l = (Long)this.getValue(byteStream);
            stringBuilder.append((CharSequence)Message.this.formatz(l, this.fspec));
        }
    }

    public class I32_Arg
    extends Arg {
        private FormatSpec fspec;

        I32_Arg(FormatSpec formatSpec, int n) {
            super(n);
            if (n == -1) {
                this.signature = "IDATA";
                this.sizeof = Message.this.ptrSize;
            } else {
                this.signature = "I_32";
            }
            this.fspec = formatSpec;
        }

        @Override
        Object getValue(ByteStream byteStream) {
            return (long)byteStream.getInt();
        }

        @Override
        void format(ByteStream byteStream, StringBuilder stringBuilder) {
            Long l = (Long)this.getValue(byteStream);
            stringBuilder.append((CharSequence)Message.this.formatz(l, this.fspec));
        }
    }

    public class UTF8StringArg
    extends Arg {
        UTF8StringArg() {
            super(-1);
            this.signature = "const char *";
        }

        @Override
        Object getValue(ByteStream byteStream) {
            try {
                return byteStream.getUTF8String();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Message.this.context.error(this, "UTF-8 is reported as an invalid encoding!");
                return "see error output for details";
            }
        }

        @Override
        void format(ByteStream byteStream, StringBuilder stringBuilder) {
            String string = this.getValue(byteStream).toString();
            stringBuilder.append(string);
        }
    }

    public class StringArg
    extends Arg {
        StringArg() {
            super(-1);
            this.signature = "const char *";
        }

        @Override
        Object getValue(ByteStream byteStream) {
            return byteStream.getASCIIString();
        }

        @Override
        void format(ByteStream byteStream, StringBuilder stringBuilder) {
            String string = this.getValue(byteStream).toString();
            stringBuilder.append(string);
        }
    }

    public class FixedStringArg
    extends Arg {
        private String val;

        FixedStringArg(String string) {
            super(-1);
            this.signature = "const char *";
            this.val = string;
        }

        @Override
        Object getValue(ByteStream byteStream) {
            return null;
        }

        @Override
        void format(ByteStream byteStream, StringBuilder stringBuilder) {
            stringBuilder.append(this.val);
        }
    }

    public class PointerArg
    extends Arg {
        PointerArg(int n) {
            super(n);
            this.signature = "const void *";
        }

        @Override
        Object getValue(ByteStream byteStream) {
            return Message.this.ptrSize == 4 ? byteStream.getUnsignedInt() : byteStream.getLong();
        }

        @Override
        void format(ByteStream byteStream, StringBuilder stringBuilder) {
            Long l = (Long)this.getValue(byteStream);
            stringBuilder.append(Long.toHexString(l));
        }
    }

    public class CharArg
    extends Arg {
        CharArg() {
            super(1);
            this.signature = "char";
        }

        @Override
        Object getValue(ByteStream byteStream) {
            return Character.valueOf((char)byteStream.get());
        }

        @Override
        void format(ByteStream byteStream, StringBuilder stringBuilder) {
            Character c = (Character)this.getValue(byteStream);
            stringBuilder.append(c.charValue());
        }
    }

    public abstract class Arg {
        boolean zeroPad = false;
        int sizeof;
        String signature;

        Arg(int n) {
            this.sizeof = n;
        }

        abstract Object getValue(ByteStream var1);

        abstract void format(ByteStream var1, StringBuilder var2);

        public int sizeof() {
            return this.sizeof;
        }

        public String signature() {
            return this.signature;
        }

        void zeroPad(boolean bl) {
            this.zeroPad = bl;
        }
    }
}

