/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.utils;

import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.java.diagnostics.utils.Context;
import com.ibm.java.diagnostics.utils.DTFJImageBean;
import com.ibm.java.diagnostics.utils.IDTFJContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.commands.ICommand;
import com.ibm.java.diagnostics.utils.plugins.DTFJPluginManager;
import com.ibm.java.diagnostics.utils.plugins.LocalPriorityClassloader;
import com.ibm.java.diagnostics.utils.plugins.PluginConfig;
import com.ibm.java.diagnostics.utils.plugins.PluginLoader;
import com.ibm.java.diagnostics.utils.plugins.PluginManager;
import com.ibm.java.diagnostics.utils.plugins.PluginManagerLocator;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;

public class DTFJContext
extends Context
implements IDTFJContext,
PluginLoader {
    private final JavaRuntime rt;
    private final ImageAddressSpace space;
    private final ImageProcess proc;
    private final int major;
    private final int minor;
    private final Properties props = new Properties();
    private final DTFJImageBean bean;
    private final String apiLevel;
    private final boolean hasImage;
    private final ArrayList<PluginConfig> loadedPlugins = new ArrayList();
    private final ArrayList<PluginConfig> failedPlugins = new ArrayList();

    public DTFJContext(int n, int n2, Image image, ImageAddressSpace imageAddressSpace, ImageProcess imageProcess, JavaRuntime javaRuntime) {
        this.rt = javaRuntime;
        this.proc = imageProcess;
        this.space = imageAddressSpace;
        this.major = n;
        this.minor = n2;
        this.bean = new DTFJImageBean(image);
        this.hasImage = image != null;
        this.apiLevel = String.format("%d.%d", n, n2);
    }

    @Override
    public Properties getProperties() {
        return this.props;
    }

    @Override
    public int getMajorVersion() {
        return this.major;
    }

    @Override
    public int getMinorVersion() {
        return this.minor;
    }

    @Override
    public ImageAddressSpace getAddressSpace() {
        return this.space;
    }

    @Override
    public JavaRuntime getRuntime() {
        return this.rt;
    }

    @Override
    public ImageProcess getProcess() {
        return this.proc;
    }

    @Override
    public void refresh() {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.commands.clear();
        this.loadedPlugins.clear();
        this.failedPlugins.clear();
        this.addGlobalCommandsToContext();
        PluginManager pluginManager = PluginManagerLocator.getManager();
        DTFJPluginManager dTFJPluginManager = new DTFJPluginManager(pluginManager);
        try {
            pluginManager.refreshSearchPath();
            pluginManager.scanForClassFiles();
        }
        catch (CommandException commandException) {
            logger.log(Level.FINE, "Problem loading DTFJ View plugins: " + commandException.getMessage());
            logger.log(Level.FINEST, "Problem loading DTFJ View plugins: ", commandException);
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        LocalPriorityClassloader localPriorityClassloader = new LocalPriorityClassloader(pluginManager.getClasspath(), classLoader);
        for (PluginConfig pluginConfig : dTFJPluginManager.getPlugins(this.apiLevel, this.hasImage, this.rt != null)) {
            try {
                ICommand iCommand = pluginConfig.newInstance(localPriorityClassloader);
                this.loadedPlugins.add(pluginConfig);
                for (String string : iCommand.getCommandNames()) {
                    if (arrayList.contains(string)) {
                        logger.fine("Name space clash detected for " + pluginConfig.getClassName() + ". The command name " + string + " is already in use");
                        continue;
                    }
                    arrayList.add(string);
                }
                this.commands.add(iCommand);
            }
            catch (CommandException commandException) {
                this.failedPlugins.add(pluginConfig);
                logger.log(Level.FINE, "Failed to create a new plugin instance for " + pluginConfig.getClassName());
                logger.log(Level.FINEST, "Failed to create a new plugin instance: ", commandException);
            }
        }
    }

    @Override
    public DTFJImageBean getImage() {
        return this.bean;
    }

    @Override
    public boolean hasPropertyBeenSet(String string) {
        Object object = this.getProperties().get(string);
        if (object != null) {
            return Boolean.parseBoolean(object.toString());
        }
        return false;
    }

    @Override
    public ArrayList<PluginConfig> getPlugins() {
        return this.loadedPlugins;
    }

    @Override
    public ArrayList<PluginConfig> getPluginFailures() {
        return this.failedPlugins;
    }

    @Override
    public void loadPlugins() throws CommandException {
        this.refresh();
    }

    @Override
    public PluginLoader getPluginClassloader() {
        return this;
    }
}

