/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.Comparator;
import java.lang.invoke.ILGenMacros;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.ThunkKey;
import java.lang.invoke.ThunkKeyWithObjectArray;
import java.lang.invoke.ThunkTable;
import java.lang.invoke.ThunkTuple;

final class FilterArgumentsHandle
extends MethodHandle {
    private final MethodHandle next;
    private final int startPos;
    private final MethodHandle[] filters;
    private static final ThunkTable _thunkTable = new ThunkTable();

    protected FilterArgumentsHandle(MethodHandle methodHandle, int n, MethodHandle[] methodHandleArray, MethodType methodType) {
        super(methodType, (byte)29, FilterArgumentsHandle.infoAffectingThunks(n, methodHandleArray));
        this.next = methodHandle;
        this.startPos = n;
        this.filters = methodHandleArray;
    }

    FilterArgumentsHandle(FilterArgumentsHandle filterArgumentsHandle, MethodType methodType) {
        super(filterArgumentsHandle, methodType);
        this.next = filterArgumentsHandle.next;
        this.startPos = filterArgumentsHandle.startPos;
        this.filters = filterArgumentsHandle.filters;
    }

    public static FilterArgumentsHandle get(MethodHandle methodHandle, int n, MethodHandle[] methodHandleArray, MethodType methodType) {
        return new FilterArgumentsHandle(methodHandle, n, methodHandleArray, methodType);
    }

    @Override
    protected final ThunkTable thunkTable() {
        return _thunkTable;
    }

    private static native int numPrefixArgs();

    private static native int numSuffixArgs();

    private static native int numArgsToFilter();

    private static native int filterArguments(MethodHandle[] var0, int var1);

    private static Object[] infoAffectingThunks(int n, MethodHandle[] methodHandleArray) {
        Object[] objectArray = new Object[1 + methodHandleArray.length];
        objectArray[0] = n;
        for (int i = 0; i < methodHandleArray.length; ++i) {
            if (methodHandleArray[i] == null) continue;
            objectArray[i + 1] = ThunkKey.computeThunkableType(methodHandleArray[i].type);
        }
        return objectArray;
    }

    @Override
    protected final ThunkTuple computeThunks(Object object) {
        return this.thunkTable().get(new ThunkKeyWithObjectArray(ThunkKey.computeThunkableType(this.type()), (Object[])object));
    }

    @MethodHandle.FrameIteratorSkip
    private final int invokeExact_thunkArchetype_X(int n) {
        if (ILGenMacros.isShareableThunk()) {
            this.undoCustomizationLogic(this.next);
            this.undoCustomizationLogic(this.filters);
        }
        if (!ILGenMacros.isCustomThunk()) {
            this.doCustomizationLogic();
        }
        return ILGenMacros.invokeExact_X(this.next, ILGenMacros.placeholder(ILGenMacros.firstN(FilterArgumentsHandle.numPrefixArgs(), n), FilterArgumentsHandle.filterArguments(this.filters, ILGenMacros.middleN(FilterArgumentsHandle.numPrefixArgs(), FilterArgumentsHandle.numArgsToFilter(), n)), ILGenMacros.lastN(FilterArgumentsHandle.numSuffixArgs(), n)));
    }

    @Override
    MethodHandle cloneWithNewType(MethodType methodType) {
        return new FilterArgumentsHandle(this, methodType);
    }

    @Override
    final void compareWith(MethodHandle methodHandle, Comparator comparator) {
        if (methodHandle instanceof FilterArgumentsHandle) {
            ((FilterArgumentsHandle)methodHandle).compareWithFilterArguments(this, comparator);
        } else {
            comparator.fail();
        }
    }

    final void compareWithFilterArguments(FilterArgumentsHandle filterArgumentsHandle, Comparator comparator) {
        comparator.compareStructuralParameter(filterArgumentsHandle.startPos, this.startPos);
        comparator.compareStructuralParameter(filterArgumentsHandle.filters.length, this.filters.length);
        comparator.compareChildHandle(filterArgumentsHandle.next, this.next);
        for (int i = 0; i < filterArgumentsHandle.filters.length && i < this.filters.length; ++i) {
            comparator.compareChildHandle(filterArgumentsHandle.filters[i], this.filters[i]);
        }
    }
}

