/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SignatureException;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ECKeySizeParameterSpec;

public final class ECUtil {
    public static ECPoint decodePoint(byte[] byArray, EllipticCurve ellipticCurve) throws IOException {
        if (byArray.length == 0 || byArray[0] != 4) {
            throw new IOException("Only uncompressed point format supported");
        }
        int n = (byArray.length - 1) / 2;
        if (n != ellipticCurve.getField().getFieldSize() + 7 >> 3) {
            throw new IOException("Point does not match field size");
        }
        byte[] byArray2 = Arrays.copyOfRange(byArray, 1, 1 + n);
        byte[] byArray3 = Arrays.copyOfRange(byArray, n + 1, n + 1 + n);
        return new ECPoint(new BigInteger(1, byArray2), new BigInteger(1, byArray3));
    }

    public static byte[] encodePoint(ECPoint eCPoint, EllipticCurve ellipticCurve) {
        int n = ellipticCurve.getField().getFieldSize() + 7 >> 3;
        byte[] byArray = ECUtil.trimZeroes(eCPoint.getAffineX().toByteArray());
        byte[] byArray2 = ECUtil.trimZeroes(eCPoint.getAffineY().toByteArray());
        if (byArray.length > n || byArray2.length > n) {
            throw new RuntimeException("Point coordinates do not match field size");
        }
        byte[] byArray3 = new byte[1 + (n << 1)];
        byArray3[0] = 4;
        System.arraycopy((Object)byArray, 0, (Object)byArray3, n - byArray.length + 1, byArray.length);
        System.arraycopy((Object)byArray2, 0, (Object)byArray3, byArray3.length - byArray2.length, byArray2.length);
        return byArray3;
    }

    public static byte[] trimZeroes(byte[] byArray) {
        int n;
        for (n = 0; n < byArray.length - 1 && byArray[n] == 0; ++n) {
        }
        if (n == 0) {
            return byArray;
        }
        return Arrays.copyOfRange(byArray, n, byArray.length);
    }

    public static AlgorithmParameters getECParameters(Provider provider) {
        try {
            if (provider != null) {
                return AlgorithmParameters.getInstance("EC", provider);
            }
            return AlgorithmParameters.getInstance("EC");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
    }

    public static byte[] encodeECParameterSpec(Provider provider, ECParameterSpec eCParameterSpec) {
        AlgorithmParameters algorithmParameters = ECUtil.getECParameters(provider);
        try {
            algorithmParameters.init(eCParameterSpec);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new RuntimeException("Not a known named curve: " + eCParameterSpec);
        }
        try {
            return algorithmParameters.getEncoded();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static ECParameterSpec getECParameterSpec(Provider provider, ECParameterSpec eCParameterSpec) {
        AlgorithmParameters algorithmParameters = ECUtil.getECParameters(provider);
        try {
            algorithmParameters.init(eCParameterSpec);
            return algorithmParameters.getParameterSpec(ECParameterSpec.class);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            return null;
        }
    }

    public static ECParameterSpec getECParameterSpec(Provider provider, byte[] byArray) throws IOException {
        AlgorithmParameters algorithmParameters = ECUtil.getECParameters(provider);
        algorithmParameters.init(byArray);
        try {
            return algorithmParameters.getParameterSpec(ECParameterSpec.class);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            return null;
        }
    }

    public static ECParameterSpec getECParameterSpec(Provider provider, String string) {
        AlgorithmParameters algorithmParameters = ECUtil.getECParameters(provider);
        try {
            algorithmParameters.init(new ECGenParameterSpec(string));
            return algorithmParameters.getParameterSpec(ECParameterSpec.class);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            return null;
        }
    }

    public static ECParameterSpec getECParameterSpec(Provider provider, int n) {
        AlgorithmParameters algorithmParameters = ECUtil.getECParameters(provider);
        try {
            algorithmParameters.init(new ECKeySizeParameterSpec(n));
            return algorithmParameters.getParameterSpec(ECParameterSpec.class);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            return null;
        }
    }

    public static String getCurveName(Provider provider, ECParameterSpec eCParameterSpec) {
        ECGenParameterSpec eCGenParameterSpec;
        AlgorithmParameters algorithmParameters = ECUtil.getECParameters(provider);
        try {
            algorithmParameters.init(eCParameterSpec);
            eCGenParameterSpec = algorithmParameters.getParameterSpec(ECGenParameterSpec.class);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            return null;
        }
        if (eCGenParameterSpec == null) {
            return null;
        }
        return eCGenParameterSpec.getName();
    }

    public static boolean equals(ECParameterSpec eCParameterSpec, ECParameterSpec eCParameterSpec2) {
        if (eCParameterSpec == eCParameterSpec2) {
            return true;
        }
        if (eCParameterSpec == null || eCParameterSpec2 == null) {
            return false;
        }
        return eCParameterSpec.getCofactor() == eCParameterSpec2.getCofactor() && eCParameterSpec.getOrder().equals(eCParameterSpec2.getOrder()) && eCParameterSpec.getCurve().equals(eCParameterSpec2.getCurve()) && eCParameterSpec.getGenerator().equals(eCParameterSpec2.getGenerator());
    }

    public static byte[] encodeSignature(byte[] byArray) throws SignatureException {
        try {
            int n = byArray.length >> 1;
            byte[] byArray2 = new byte[n];
            System.arraycopy((Object)byArray, 0, (Object)byArray2, 0, n);
            BigInteger bigInteger = new BigInteger(1, byArray2);
            System.arraycopy((Object)byArray, n, (Object)byArray2, 0, n);
            BigInteger bigInteger2 = new BigInteger(1, byArray2);
            DerOutputStream derOutputStream = new DerOutputStream(byArray.length + 10);
            derOutputStream.putInteger(bigInteger);
            derOutputStream.putInteger(bigInteger2);
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            return derValue.toByteArray();
        }
        catch (Exception exception) {
            throw new SignatureException("Could not encode signature", exception);
        }
    }

    public static byte[] decodeSignature(byte[] byArray) throws SignatureException {
        try {
            DerInputStream derInputStream = new DerInputStream(byArray, 0, byArray.length, false);
            DerValue[] derValueArray = derInputStream.getSequence(2);
            if (derValueArray.length != 2 || derInputStream.available() != 0) {
                throw new IOException("Invalid encoding for signature");
            }
            BigInteger bigInteger = derValueArray[0].getPositiveBigInteger();
            BigInteger bigInteger2 = derValueArray[1].getPositiveBigInteger();
            byte[] byArray2 = ECUtil.trimZeroes(bigInteger.toByteArray());
            byte[] byArray3 = ECUtil.trimZeroes(bigInteger2.toByteArray());
            int n = Math.max(byArray2.length, byArray3.length);
            byte[] byArray4 = new byte[n << 1];
            System.arraycopy((Object)byArray2, 0, (Object)byArray4, n - byArray2.length, byArray2.length);
            System.arraycopy((Object)byArray3, 0, (Object)byArray4, byArray4.length - byArray3.length, byArray3.length);
            return byArray4;
        }
        catch (Exception exception) {
            throw new SignatureException("Invalid encoding for signature", exception);
        }
    }

    private ECUtil() {
    }
}

