/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm;

import com.ibm.jvm.LogPermission;
import com.ibm.oti.vm.VM;
import java.util.Objects;

public class Log {
    private static final String LEGACY_LOG_PERMISSION_PROPERTY = "com.ibm.jvm.enableLegacyLogSecurity";
    private static final LogPermission LOG_PERMISSION = new LogPermission();

    public static String QueryOptions() {
        Log.checkLegacySecurityPermssion();
        return Log.QueryOptionsImpl();
    }

    public static int SetOptions(String string) {
        Log.checkLegacySecurityPermssion();
        Objects.requireNonNull(string, "options");
        return Log.SetOptionsImpl(string);
    }

    private static void checkLegacySecurityPermssion() throws SecurityException {
        if (!"false".equalsIgnoreCase(VM.internalGetProperties().getProperty(LEGACY_LOG_PERMISSION_PROPERTY))) {
            Log.checkLogSecurityPermssion();
        }
    }

    private static void checkLogSecurityPermssion() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(LOG_PERMISSION);
        }
    }

    private Log() {
    }

    private static native String QueryOptionsImpl();

    private static native int SetOptionsImpl(String var0);
}

