/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.ByteArrayOutputStream;

public class BitArray {
    private byte[] repn;
    private int length;
    private static final int BITS_PER_UNIT = 8;
    private static final byte[][] NYBBLE = new byte[][]{{48, 48, 48, 48}, {48, 48, 48, 49}, {48, 48, 49, 48}, {48, 48, 49, 49}, {48, 49, 48, 48}, {48, 49, 48, 49}, {48, 49, 49, 48}, {48, 49, 49, 49}, {49, 48, 48, 48}, {49, 48, 48, 49}, {49, 48, 49, 48}, {49, 48, 49, 49}, {49, 49, 48, 48}, {49, 49, 48, 49}, {49, 49, 49, 48}, {49, 49, 49, 49}};
    private static final int BYTES_PER_LINE = 8;

    private static int subscript(int n) {
        return n / 8;
    }

    private static int position(int n) {
        return 1 << 7 - n % 8;
    }

    public BitArray(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("Negative length for BitArray");
        }
        this.length = n;
        this.repn = new byte[(n + 8 - 1) / 8];
    }

    public BitArray(int n, byte[] byArray) throws IllegalArgumentException {
        this(n, byArray, 0);
    }

    public BitArray(int n, byte[] byArray, int n2) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("Negative length for BitArray");
        }
        if ((byArray.length - n2) * 8 < n) {
            throw new IllegalArgumentException("Byte array too short to represent " + n + "-bit array");
        }
        this.length = n;
        int n3 = (n + 8 - 1) / 8;
        int n4 = n3 * 8 - n;
        byte by = (byte)(255 << n4);
        this.repn = new byte[n3];
        System.arraycopy((Object)byArray, n2, (Object)this.repn, 0, n3);
        if (n3 > 0) {
            int n5 = n3 - 1;
            this.repn[n5] = (byte)(this.repn[n5] & by);
        }
    }

    public BitArray(boolean[] blArray) {
        this.length = blArray.length;
        this.repn = new byte[(this.length + 7) / 8];
        for (int i = 0; i < this.length; ++i) {
            this.set(i, blArray[i]);
        }
    }

    private BitArray(BitArray bitArray) {
        this.length = bitArray.length;
        this.repn = (byte[])bitArray.repn.clone();
    }

    public boolean get(int n) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n >= this.length) {
            throw new ArrayIndexOutOfBoundsException(Integer.toString(n));
        }
        return (this.repn[BitArray.subscript(n)] & BitArray.position(n)) != 0;
    }

    public void set(int n, boolean bl) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n >= this.length) {
            throw new ArrayIndexOutOfBoundsException(Integer.toString(n));
        }
        int n2 = BitArray.subscript(n);
        int n3 = BitArray.position(n);
        if (bl) {
            int n4 = n2;
            this.repn[n4] = (byte)(this.repn[n4] | n3);
        } else {
            int n5 = n2;
            this.repn[n5] = (byte)(this.repn[n5] & ~n3);
        }
    }

    public int length() {
        return this.length;
    }

    public byte[] toByteArray() {
        return (byte[])this.repn.clone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof BitArray)) {
            return false;
        }
        BitArray bitArray = (BitArray)object;
        if (bitArray.length != this.length) {
            return false;
        }
        for (int i = 0; i < this.repn.length; ++i) {
            if (this.repn[i] == bitArray.repn[i]) continue;
            return false;
        }
        return true;
    }

    public boolean[] toBooleanArray() {
        boolean[] blArray = new boolean[this.length];
        for (int i = 0; i < this.length; ++i) {
            blArray[i] = this.get(i);
        }
        return blArray;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.repn.length; ++i) {
            n = 31 * n + this.repn[i];
        }
        return n ^ this.length;
    }

    public Object clone() {
        return new BitArray(this);
    }

    public String toString() {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (n = 0; n < this.repn.length - 1; ++n) {
            byteArrayOutputStream.write(NYBBLE[this.repn[n] >> 4 & 0xF], 0, 4);
            byteArrayOutputStream.write(NYBBLE[this.repn[n] & 0xF], 0, 4);
            if (n % 8 == 7) {
                byteArrayOutputStream.write(10);
                continue;
            }
            byteArrayOutputStream.write(32);
        }
        for (n = 8 * (this.repn.length - 1); n < this.length; ++n) {
            byteArrayOutputStream.write(this.get(n) ? 49 : 48);
        }
        return new String(byteArrayOutputStream.toByteArray());
    }

    public BitArray truncate() {
        for (int i = this.length - 1; i >= 0; --i) {
            if (!this.get(i)) continue;
            return new BitArray(i + 1, this.repn, 0);
        }
        return new BitArray(1);
    }
}

