/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Format2Tprof {
    final String Trc_JIT_Component_Name = "j9jit";
    final int Trc_JIT_Sampling_Id = 13;
    final int Trc_JIT_Sampling_Detail_Id = 14;
    final char FS = (char)9;
    final String TraceEntryPrefix = "SamplingLog";
    static int totalCount = 0;

    public void run(String[] stringArray) {
        if (stringArray.length < 1 || stringArray.length > 2) {
            System.err.println("Format2Tprof <trace format input> [tprof output]");
            return;
        }
        LinkedList linkedList = new LinkedList();
        if (!this.readAndFormat(stringArray, linkedList)) {
            System.err.println("No method sampling event found in the trace.  No output will be written.");
            return;
        }
        Collections.sort(linkedList);
        totalCount = linkedList.size();
        this.countSampleMethod(linkedList);
        Collections.sort(linkedList, new Comparator(){

            public int compare(Object object, Object object2) {
                MethodEntry methodEntry = (MethodEntry)object;
                MethodEntry methodEntry2 = (MethodEntry)object2;
                return methodEntry2.count - methodEntry.count;
            }
        });
        try {
            PrintStream printStream = System.out;
            if (stringArray.length == 2) {
                printStream = new PrintStream(new FileOutputStream(stringArray[1]));
            }
            this.generateTprofOutput(printStream, linkedList);
            if (stringArray.length == 2) {
                printStream.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Error opening output file");
            fileNotFoundException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        Format2Tprof format2Tprof = new Format2Tprof();
        format2Tprof.run(stringArray);
    }

    public void countSampleMethod(Collection collection) {
        Iterator iterator = collection.iterator();
        MethodEntry methodEntry = (MethodEntry)iterator.next();
        ++methodEntry.count;
        while (iterator.hasNext()) {
            MethodEntry methodEntry2 = (MethodEntry)iterator.next();
            if (methodEntry.equals(methodEntry2)) {
                iterator.remove();
            } else {
                methodEntry = methodEntry2;
            }
            ++methodEntry.count;
        }
    }

    public void generateTprofOutput(PrintStream printStream, Collection collection) {
        for (MethodEntry methodEntry : collection) {
            float f = (float)(methodEntry.count * 100) / (float)totalCount;
            String string = Float.toString(f).substring(0, 4) + "%";
            printStream.println(string + " " + methodEntry.count + " " + methodEntry.name);
        }
    }

    public MethodEntry getJittedMethod(String string) {
        int n;
        int n2 = string.indexOf(9);
        int n3 = n = n2 != -1 ? string.indexOf(9, n2 + 1) : -1;
        if (n2 == -1 || n == -1) {
            return null;
        }
        String string2 = string.substring(n2 + 1, n - 1);
        int n4 = string.indexOf(9, n + 1);
        if (n4 == -1) {
            return new MethodEntry(string2);
        }
        int n5 = string.indexOf(9, n4 + 1);
        if (n5 == -1) {
            return new MethodEntry(string2, string.substring(n4 + 1));
        }
        return new MethodEntry(string2, string.substring(n4 + 1, n5 - 1));
    }

    public boolean readAndFormat(String[] stringArray, List list) {
        boolean bl = false;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(stringArray[0]));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                String string2;
                MethodEntry methodEntry;
                int n = string.indexOf("SamplingLog");
                if (n == -1 || (methodEntry = this.getJittedMethod(string2 = string.substring(n))) == null) continue;
                bl = true;
                list.add(methodEntry);
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Error opening trace file");
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            System.err.println("Error processing trace file");
            iOException.printStackTrace();
        }
        return bl;
    }

    public class MethodEntry
    implements Comparable {
        public String name = null;
        public String offset = null;
        public int count = 0;

        public MethodEntry(String string, String string2) {
            this.name = string;
            this.offset = string2;
        }

        public MethodEntry(String string) {
            this.name = string;
        }

        public boolean equals(Object object) {
            MethodEntry methodEntry = (MethodEntry)object;
            return this.name.equals(methodEntry.name);
        }

        public int compareTo(Object object) {
            MethodEntry methodEntry = (MethodEntry)object;
            return this.name.compareTo(methodEntry.name);
        }
    }
}

