/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.image.j9.CorruptData;
import com.ibm.dtfj.java.j9.JavaAbstractClass;
import com.ibm.dtfj.java.j9.JavaArrayClass;
import com.ibm.dtfj.java.j9.JavaHeap;
import com.ibm.dtfj.java.j9.JavaObject;
import com.ibm.dtfj.java.j9.JavaRuntime;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class JavaHeapRegion {
    private JavaHeap _parentHeap;
    private JavaRuntime _javaVM;
    private int _objectAlignment;
    private int _minimumObjectSize;
    private Vector _extents = new Vector();
    private long _arrayletLeafSize;
    private HeapSection _section;

    public JavaHeapRegion(JavaRuntime javaRuntime, String string, ImagePointer imagePointer, int n, int n2, long l, JavaHeap javaHeap, ImagePointer imagePointer2, long l2) {
        this._parentHeap = javaHeap;
        this._javaVM = javaRuntime;
        this._objectAlignment = n;
        this._minimumObjectSize = n2;
        this._arrayletLeafSize = l;
        if (null != imagePointer2) {
            this._section = new HeapSection(imagePointer2, l2);
        }
    }

    public void addExtent(ImagePointer imagePointer, int n, int n2) {
        this._extents.add(new HeapExtent(imagePointer, n, n2));
    }

    public Iterator getSections() {
        List<Object> list = null;
        list = null != this._section ? Collections.singletonList(this._section) : this._extents;
        return list.iterator();
    }

    public Iterator getObjects() {
        return new ExtentWalker(this._parentHeap, this, this._javaVM, this._extents.iterator(), this._objectAlignment, this._minimumObjectSize);
    }

    public void addNewHeapRegionExtent(long l, long l2, int n) {
        ImagePointer imagePointer = this._javaVM.pointerInAddressSpace(l);
        int n2 = (int)(l2 - l);
        this.addExtent(imagePointer, n2, n);
    }

    public int getArrayletSpineSize() {
        return this._minimumObjectSize;
    }

    public long getArrayletLeafSize() {
        return this._arrayletLeafSize;
    }

    public com.ibm.dtfj.java.JavaObject getObjectAtAddress(ImagePointer imagePointer) throws CorruptDataException, IllegalArgumentException {
        JavaObject javaObject = null;
        if (null != imagePointer && 0L != imagePointer.getAddress()) {
            com.ibm.dtfj.java.JavaObject javaObject2 = this._javaVM.getSpecialObject(imagePointer);
            if (null != javaObject2) {
                return javaObject2;
            }
            if ((imagePointer.getAddress() & (long)(this._objectAlignment - 1)) != 0L) {
                throw new IllegalArgumentException("Invalid alignment for JavaObject should be " + this._objectAlignment + " aligned. Address = " + imagePointer.toString());
            }
            long l = 0L;
            long l2 = 0L;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            long l3 = 0L;
            l = this._parentHeap.getArrayletIdentificationBitmask();
            l2 = this._parentHeap.getArrayletIdentificationResult();
            n = this._parentHeap.getArrayletIdentificationWidth();
            n2 = this._parentHeap.getArrayletIdentificationOffset();
            n3 = this.getArrayletSpineSize();
            l3 = this.getArrayletLeafSize();
            boolean bl = false;
            if (0L != l2) {
                long l4 = 0L;
                if (4 == n) {
                    try {
                        l4 = 0xFFFFFFFFL & (long)imagePointer.getIntAt(n2);
                    }
                    catch (MemoryAccessException memoryAccessException) {
                        throw new CorruptDataException(new CorruptData("unable to access object flags", imagePointer));
                    }
                } else if (8 == n) {
                    try {
                        l4 = imagePointer.getLongAt(n2);
                    }
                    catch (MemoryAccessException memoryAccessException) {
                        throw new CorruptDataException(new CorruptData("unable to access object flags", imagePointer));
                    }
                } else {
                    System.err.println("Arraylet identification width is invalid: " + n + " (should be 4 or 8)");
                }
                bl = l2 == (l & l4);
            }
            javaObject = new JavaObject(this._javaVM, imagePointer, this._parentHeap, n3, l3, bl, this._objectAlignment);
        }
        return javaObject;
    }

    class ExtentWalker
    implements Iterator {
        private Iterator _extentIterator;
        private HeapExtent _currentExtent;
        private int _objectsRemainingInExtent;
        private long _nextOffsetInExtent;
        private int _alignment;
        private int _minimumObjectSize;

        public ExtentWalker(JavaHeap javaHeap, JavaHeapRegion javaHeapRegion2, JavaRuntime javaRuntime, Iterator iterator, int n, int n2) {
            JavaHeapRegion.this._parentHeap = javaHeap;
            JavaHeapRegion.this._javaVM = javaRuntime;
            this._extentIterator = iterator;
            this._alignment = n;
            this._minimumObjectSize = n2;
            this._advanceExtentMarker();
        }

        private void _advanceExtentMarker() {
            if (this._extentIterator.hasNext()) {
                this._currentExtent = (HeapExtent)this._extentIterator.next();
                this._nextOffsetInExtent = 0L;
                this._objectsRemainingInExtent = this._currentExtent.objectsInExtent();
            } else {
                this._currentExtent = null;
            }
        }

        @Override
        public boolean hasNext() {
            boolean bl = false;
            if (null != this._currentExtent) {
                if (this._objectsRemainingInExtent > 0) {
                    bl = true;
                } else {
                    this._advanceExtentMarker();
                    bl = null != this._currentExtent;
                }
            }
            return bl;
        }

        public Object next() {
            try {
                int n;
                int n2;
                ImagePointer imagePointer = this._currentExtent.getBaseAddress().add(this._nextOffsetInExtent);
                com.ibm.dtfj.java.JavaObject javaObject = null;
                try {
                    javaObject = JavaHeapRegion.this.getObjectAtAddress(imagePointer);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    CorruptData corruptData = new CorruptData("Invalid alignment for JavaObject : should be " + JavaHeapRegion.this._objectAlignment + " aligned", imagePointer);
                    throw new CorruptDataException(corruptData);
                }
                int n3 = (int)this.getSpaceOccupied((JavaObject)javaObject);
                JavaAbstractClass javaAbstractClass = (JavaAbstractClass)javaObject.getJavaClass();
                try {
                    n2 = 65536;
                    if (JavaHeapRegion.this._parentHeap.isSWH()) {
                        n2 = 4;
                    }
                    if (((n = javaAbstractClass.readFlagsFromInstance(javaObject)) & n2) == n2) {
                        n3 += javaAbstractClass.getHashcodeSlotSize();
                    }
                }
                catch (MemoryAccessException memoryAccessException) {
                    throw new CorruptDataException(new CorruptData("Flags in object header unreadable", imagePointer));
                }
                n2 = Math.max(n3, this._minimumObjectSize);
                n = n2 % this._alignment;
                int n4 = 0 == n ? 0 : this._alignment - n;
                this._nextOffsetInExtent += (long)(n2 += n4);
                --this._objectsRemainingInExtent;
                return javaObject;
            }
            catch (CorruptDataException corruptDataException) {
                this._advanceExtentMarker();
                return corruptDataException.getCorruptData();
            }
        }

        private long getSpaceOccupied(JavaObject javaObject) throws CorruptDataException {
            ImagePointer imagePointer = javaObject.getID();
            if (javaObject.isArraylet()) {
                JavaArrayClass javaArrayClass = (JavaArrayClass)javaObject.getJavaClass();
                int n = javaArrayClass.getFirstElementOffset();
                int n2 = JavaHeapRegion.this._javaVM.bytesPerPointer();
                try {
                    int n3 = javaArrayClass.getInstanceSize(javaObject);
                    long l = n3 - n;
                    int n4 = (int)(l / JavaHeapRegion.this._arrayletLeafSize);
                    long l2 = l % JavaHeapRegion.this._arrayletLeafSize;
                    int n5 = 0L == l2 ? n4 : n4 + 1;
                    String string = javaArrayClass.getLeafClass().getName();
                    boolean bl = 4 == JavaHeapRegion.this._objectAlignment && ("double".equals(string) || "long".equals(string));
                    long l3 = -1L;
                    if (n5 == 0) {
                        if (this._objectsRemainingInExtent > 1) {
                            ImagePointer imagePointer2 = imagePointer.getPointerAt(n);
                            ImagePointer imagePointer3 = null;
                            imagePointer3 = n2 == 8 || "double".equals(string) || "long".equals(string) ? imagePointer.getPointerAt(n + 8) : imagePointer.getPointerAt(n + 4);
                            l3 = imagePointer2.getAddress() == imagePointer3.getAddress() || imagePointer2.getAddress() == 0L ? (long)(n + n2) : (long)n;
                        }
                    } else {
                        l3 = n + n5 * n2;
                    }
                    long l4 = l3;
                    long l5 = imagePointer.getAddress() + l3;
                    boolean bl2 = false;
                    if (bl && n5 > 0) {
                        if (0L == l5 % 8L) {
                            bl2 = true;
                        } else {
                            l4 += 4L;
                            if (0L != (l5 += 4L) % 8L) {
                                throw new CorruptDataException(new CorruptData("Arraylet leaf pointer misaligned for object", imagePointer));
                            }
                        }
                    }
                    for (int i = 0; i < n5; ++i) {
                        ImagePointer imagePointer4 = imagePointer.getPointerAt(n + i * n2);
                        if (imagePointer4.getAddress() != l5) continue;
                        long l6 = JavaHeapRegion.this._arrayletLeafSize;
                        if (n4 == i) {
                            l6 = l2;
                        }
                        l4 += l6;
                        l5 += l6;
                    }
                    if (bl2) {
                        l4 += 4L;
                    }
                    return l4;
                }
                catch (MemoryAccessException memoryAccessException) {
                    throw new CorruptDataException(new CorruptData("failed to walk arraylet spine", memoryAccessException.getPointer()));
                }
            }
            long l = ((JavaAbstractClass)javaObject.getJavaClass()).getInstanceSize(javaObject);
            return l;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class HeapExtent
    extends HeapSection {
        private int _residentObjectCount;

        public HeapExtent(ImagePointer imagePointer, long l, int n) {
            super(imagePointer, l);
            this._residentObjectCount = n;
        }

        @Override
        public String getName() {
            return "Heap Extent at " + Long.toHexString(this.getBaseAddress().getAddress()) + " (" + this.getSize() + " bytes long)";
        }

        public int objectsInExtent() {
            return this._residentObjectCount;
        }

        @Override
        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof HeapExtent) {
                HeapExtent heapExtent = (HeapExtent)object;
                bl = super.equals(heapExtent) && this._residentObjectCount == heapExtent._residentObjectCount;
            }
            return bl;
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ this._residentObjectCount;
        }
    }

    class HeapSection
    implements ImageSection {
        private ImagePointer _base;
        private long _size;

        public HeapSection(ImagePointer imagePointer, long l) {
            if (null == imagePointer) {
                throw new IllegalArgumentException("Heap extents cannot have null base pointers");
            }
            this._base = imagePointer;
            this._size = l;
        }

        @Override
        public ImagePointer getBaseAddress() {
            return this._base;
        }

        @Override
        public long getSize() {
            return this._size;
        }

        @Override
        public String getName() {
            return "Heap extent at 0x" + Long.toHexString(this._base.getAddress()) + " (0x" + Long.toHexString(this._size) + " bytes)";
        }

        @Override
        public boolean isExecutable() throws DataUnavailable {
            return this._base.isExecutable();
        }

        @Override
        public boolean isReadOnly() throws DataUnavailable {
            return this._base.isReadOnly();
        }

        @Override
        public boolean isShared() throws DataUnavailable {
            return this._base.isShared();
        }

        @Override
        public Properties getProperties() {
            return this._base.getProperties();
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof HeapSection) {
                HeapSection heapSection = (HeapSection)object;
                bl = this._base.equals(heapSection._base) && this._size == heapSection._size;
            }
            return bl;
        }

        public int hashCode() {
            return (int)((long)this._base.hashCode() ^ this._size);
        }
    }
}

