/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.utils.commands;

import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandDescription;
import com.ibm.java.diagnostics.utils.commands.ICommand;
import com.ibm.java.diagnostics.utils.plugins.PluginConfig;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public abstract class BaseCommand
implements ICommand {
    protected static final String nl = System.getProperty("line.separator");
    protected static final String COMMAND_FORMAT = "%-25s %-20s %s\n";
    protected static final String SUBCOMMAND_FORMAT = "%25s %-20s %s\n";
    private static final String KEY_ID = ":";
    private final Map<String, CommandDescription> _commands = new LinkedHashMap<String, CommandDescription>();
    private final Map<String, CommandDescription> _subCommands = new LinkedHashMap<String, CommandDescription>();
    private boolean isDirty = false;
    private final Set<String> descriptions = new LinkedHashSet<String>();
    protected PluginConfig config;

    protected BaseCommand() {
    }

    public CommandDescription addCommand(String string, String string2, String string3) {
        this.isDirty = true;
        CommandDescription commandDescription = new CommandDescription(string, string2, string3);
        this._commands.put(string.toLowerCase(), commandDescription);
        return commandDescription;
    }

    public void addSubCommand(String string, String string2, String string3, String string4) {
        this.isDirty = true;
        CommandDescription commandDescription = new CommandDescription(string2, string3, string4);
        for (CommandDescription commandDescription2 : this._commands.values()) {
            if (!commandDescription2.getCommandName().toLowerCase().equals(string.toLowerCase())) continue;
            commandDescription.setParent(commandDescription2);
        }
        this._subCommands.put(string + KEY_ID + string2, commandDescription);
    }

    @Override
    public boolean recognises(String string, IContext iContext) {
        return this._commands.containsKey(string.toLowerCase());
    }

    @Override
    public Collection<String> getCommandDescriptions() {
        if (this.isDirty) {
            for (CommandDescription commandDescription : this._commands.values()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(String.format(COMMAND_FORMAT, commandDescription.getCommandName(), commandDescription.getArgumentDescription(), commandDescription.getHelpDescription()));
                for (CommandDescription commandDescription2 : this._subCommands.values()) {
                    if (commandDescription2.getParent() == null || !commandDescription2.getParent().getCommandName().equalsIgnoreCase(commandDescription.getCommandName())) continue;
                    stringBuilder.append(String.format(SUBCOMMAND_FORMAT, commandDescription2.getCommandName(), commandDescription2.getArgumentDescription(), commandDescription2.getHelpDescription()));
                }
                this.descriptions.add(stringBuilder.toString());
            }
        }
        return this.descriptions;
    }

    @Override
    public Collection<String> getCommandNames() {
        return this._commands.keySet();
    }

    @Override
    public PluginConfig getConfig() {
        return this.config;
    }

    public void setConfig(PluginConfig pluginConfig) {
        this.config = pluginConfig;
    }
}

