/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.gc.GCIterator;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.U32Pointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RAMClassRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RAMMethodHandleRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RAMMethodTypeRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RAMStringRefPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ROMClassHelper;
import com.ibm.j9ddr.vm29.structure.J9ConstantPool;
import com.ibm.j9ddr.vm29.structure.J9RAMConstantPoolItem;
import java.util.ArrayList;
import java.util.Iterator;

public class GCConstantPoolSlotIterator
extends GCIterator {
    protected Iterator<AbstractPointer> slotIterator;
    protected Iterator<VoidPointer> addressIterator;

    protected GCConstantPoolSlotIterator(J9ClassPointer j9ClassPointer, boolean bl, boolean bl2) throws CorruptDataException {
        this.initializeSlots_V1(j9ClassPointer, bl, bl2);
    }

    public static GCConstantPoolSlotIterator fromJ9Class(J9ClassPointer j9ClassPointer, boolean bl, boolean bl2) throws CorruptDataException {
        return new GCConstantPoolSlotIterator(j9ClassPointer, bl, bl2);
    }

    protected void initializeSlots_V1(J9ClassPointer j9ClassPointer, boolean bl, boolean bl2) throws CorruptDataException {
        U32Pointer u32Pointer = J9ROMClassHelper.cpShapeDescription(j9ClassPointer.romClass());
        PointerPointer pointerPointer = PointerPointer.cast(j9ClassPointer.ramConstantPool());
        long l = 0L;
        long l2 = j9ClassPointer.romClass().ramConstantPoolCount().longValue();
        long l3 = 0L;
        ArrayList<StructurePointer> arrayList = new ArrayList<StructurePointer>();
        ArrayList<VoidPointer> arrayList2 = new ArrayList<VoidPointer>();
        while (l2 > 0L) {
            StructurePointer structurePointer;
            StructurePointer structurePointer2;
            long l4;
            if (0L == l3) {
                l = u32Pointer.at(0L).longValue();
                u32Pointer = u32Pointer.add(1L);
                l3 = J9ConstantPool.J9_CP_DESCRIPTIONS_PER_U32;
            }
            if ((l4 = l & J9ConstantPool.J9_CP_DESCRIPTION_MASK) == J9ConstantPool.J9CPTYPE_STRING || l4 == J9ConstantPool.J9CPTYPE_ANNOTATION_UTF8) {
                if (bl2 && (structurePointer2 = ((J9RAMStringRefPointer)(structurePointer = J9RAMStringRefPointer.cast(pointerPointer))).stringObject()).notNull()) {
                    arrayList.add(structurePointer2);
                    arrayList2.add(VoidPointer.cast(((J9RAMStringRefPointer)structurePointer).stringObjectEA()));
                }
            } else if (l4 == J9ConstantPool.J9CPTYPE_METHOD_TYPE) {
                if (bl2 && (structurePointer2 = ((J9RAMMethodTypeRefPointer)(structurePointer = J9RAMMethodTypeRefPointer.cast(pointerPointer))).type()).notNull()) {
                    arrayList.add(structurePointer2);
                    arrayList2.add(VoidPointer.cast(((J9RAMMethodTypeRefPointer)structurePointer).typeEA()));
                }
            } else if (l4 == J9ConstantPool.J9CPTYPE_METHODHANDLE) {
                if (bl2 && (structurePointer2 = ((J9RAMMethodHandleRefPointer)(structurePointer = J9RAMMethodHandleRefPointer.cast(pointerPointer))).methodHandle()).notNull()) {
                    arrayList.add(structurePointer2);
                    arrayList2.add(VoidPointer.cast(((J9RAMMethodHandleRefPointer)structurePointer).methodHandleEA()));
                }
            } else if (l4 == J9ConstantPool.J9CPTYPE_CLASS && bl && (structurePointer2 = ((J9RAMClassRefPointer)(structurePointer = J9RAMClassRefPointer.cast(pointerPointer))).value()).notNull()) {
                arrayList.add(structurePointer2);
                arrayList2.add(VoidPointer.cast(((J9RAMClassRefPointer)structurePointer).valueEA()));
            }
            pointerPointer = pointerPointer.addOffset(J9RAMConstantPoolItem.SIZEOF);
            --l2;
            l >>= (int)J9ConstantPool.J9_CP_BITS_PER_DESCRIPTION;
            --l3;
        }
        this.slotIterator = arrayList.iterator();
        this.addressIterator = arrayList2.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.slotIterator.hasNext();
    }

    @Override
    public AbstractPointer next() {
        this.addressIterator.next();
        return this.slotIterator.next();
    }

    @Override
    public VoidPointer nextAddress() {
        this.slotIterator.next();
        return this.addressIterator.next();
    }
}

