/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive;

import com.ibm.j9ddr.vm29.tools.ddrinteractive.IClassWalkCallbacks;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.LinearDumper;
import java.io.PrintStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class ClassSummaryHelper {
    private final Map<String, Long> sizeStat = new HashMap<String, Long>();
    private int numberOfClasses = 0;
    private final String[] preferredOrder;

    public ClassSummaryHelper(String[] stringArray) {
        this.preferredOrder = stringArray;
    }

    public void addRegionsForClass(LinearDumper.J9ClassRegionNode j9ClassRegionNode) {
        ++this.numberOfClasses;
        ClassSummaryHelper.appendSizeStat(this.sizeStat, j9ClassRegionNode, "");
    }

    public void printStatistics(PrintStream printStream) {
        TreeMap<String, Long> treeMap = new TreeMap<String, Long>(new StringCompare(this.preferredOrder));
        treeMap.putAll(this.sizeStat);
        long l = 0L;
        for (Map.Entry entry : treeMap.entrySet()) {
            if (ClassSummaryHelper.getLevel((String)entry.getKey()) != 1) continue;
            l += ((Long)entry.getValue()).longValue();
        }
        printStream.println(String.format("%d classes, using: %d bytes or %d kB", this.numberOfClasses, l, l / 1024L));
        printStream.println(String.format("%-39s %-8s %-8s %-6s", "Section", "Byte", "kB", "%"));
        for (Map.Entry entry : treeMap.entrySet()) {
            printStream.println(ClassSummaryHelper.printSize((String)entry.getKey(), (Long)entry.getValue(), l));
        }
    }

    private static void appendSizeStat(Map<String, Long> map, LinearDumper.J9ClassRegionNode j9ClassRegionNode, String string) {
        String string2 = string;
        LinearDumper.J9ClassRegion j9ClassRegion = j9ClassRegionNode.getNodeValue();
        if (j9ClassRegion != null && (j9ClassRegion.getType() == IClassWalkCallbacks.SlotType.J9_SECTION_START || j9ClassRegion.getType() == IClassWalkCallbacks.SlotType.J9_Padding)) {
            Long l = map.get(string2 = string2 + "/" + j9ClassRegion.getName());
            if (l != null) {
                map.put(string2, l + j9ClassRegion.getLength());
            } else {
                map.put(string2, j9ClassRegion.getLength());
            }
        }
        for (LinearDumper.J9ClassRegionNode j9ClassRegionNode2 : j9ClassRegionNode.getChildren()) {
            ClassSummaryHelper.appendSizeStat(map, j9ClassRegionNode2, string2);
        }
    }

    private static String printSize(String string, Long l, long l2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = ClassSummaryHelper.getLevel(string);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("  ");
        }
        stringBuilder.append(string.substring(string.lastIndexOf(47) + 1));
        long l3 = l;
        double d = (double)l3 / 1024.0;
        double d2 = (double)l3 * 100.0 / (double)l2;
        return String.format("%-39s %-8d %-8.2f %-6.2f", stringBuilder, l3, d, d2);
    }

    private static int getLevel(String string) {
        int n = -1;
        int n2 = 0;
        while ((n = string.indexOf(47, n + 1)) >= 0) {
            ++n2;
        }
        return n2;
    }

    private static class StringCompare
    implements Comparator<String> {
        private final Map<String, Integer> preferredOrderMap = new HashMap<String, Integer>();

        public StringCompare(String[] stringArray) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.preferredOrderMap.put(stringArray[i], i);
            }
        }

        private int find(String string) {
            Integer n = this.preferredOrderMap.get(string.trim());
            if (n != null) {
                return n;
            }
            return Integer.MAX_VALUE;
        }

        private static String firstSegment(String string) {
            int n = string.indexOf(47) + 1;
            if (n <= 0) {
                throw new IllegalArgumentException();
            }
            int n2 = string.indexOf(47, n);
            String string2 = n2 < 0 ? string.substring(n) : string.substring(n, n2);
            return string2;
        }

        @Override
        public int compare(String string, String string2) {
            int n;
            String string3 = StringCompare.firstSegment(string);
            String string4 = StringCompare.firstSegment(string2);
            int n2 = this.find(string3);
            if (n2 != (n = this.find(string4))) {
                return Integer.compare(n2, n);
            }
            return string.compareTo(string2);
        }
    }
}

