/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.ObjectModel;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ArrayClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9IndexableObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.PrintObjectFieldsHelper;
import com.ibm.j9ddr.vm29.pointer.helper.ValueTypeHelper;
import java.io.PrintStream;

public class FlatObjectCommand
extends Command {
    public FlatObjectCommand() {
        this.addCommand("flatobject", "<addressOfContainer> [<fieldName1>[.<fieldName2>]...]", "Display a flattened representation of a j9object given an address.");
    }

    private void printHelp(PrintStream printStream) {
        printStream.println("Usage:");
        printStream.println("  !flatobject <addressOfContainer> [<fieldName1>[.<fieldName2>]...]");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        if (stringArray.length == 0) {
            this.printHelp(printStream);
            return;
        }
        this.printFlatObject(string, stringArray, context, printStream);
    }

    private void printFlatObject(String string, String[] stringArray, Context context, PrintStream printStream) {
        J9ClassPointer j9ClassPointer = null;
        AbstractPointer abstractPointer = null;
        String[] stringArray2 = stringArray[0].split("\\.");
        if (!ValueTypeHelper.getValueTypeHelper().areValueTypesSupported()) {
            printStream.println("<this core file does not support flattened types>");
            return;
        }
        try {
            long l = CommandUtils.parsePointer(stringArray2[0], J9BuildFlags.J9VM_ENV_DATA64);
            String string2 = null;
            if (1 < stringArray.length) {
                string2 = stringArray[1];
            }
            abstractPointer = J9ObjectPointer.cast(l);
            j9ClassPointer = J9ObjectHelper.clazz((J9ObjectPointer)abstractPointer);
            U8Pointer u8Pointer = U8Pointer.cast(abstractPointer).add(ObjectModel.getHeaderSize((J9ObjectPointer)abstractPointer));
            if (j9ClassPointer.isNull()) {
                printStream.println("<can not read RAM class address>");
                return;
            }
            if (J9ClassHelper.isArrayClass(j9ClassPointer)) {
                J9IndexableObjectPointer j9IndexableObjectPointer = J9IndexableObjectPointer.cast(abstractPointer);
                int n = J9IndexableObjectHelper.size(j9IndexableObjectPointer).intValue();
                if (ValueTypeHelper.getValueTypeHelper().isJ9ClassIsFlattened(j9ClassPointer)) {
                    if (null == string2) {
                        for (int i = 0; i < n; ++i) {
                            String string3 = "[" + i + "]";
                            String[] stringArray3 = new String[]{stringArray2[0], string3};
                            this.printFlatObject(string, stringArray3, context, printStream);
                        }
                    } else {
                        printStream.format("!flatobject %s %s {%n", abstractPointer.getHexAddress(), string2);
                        PrintObjectFieldsHelper.printJ9ObjectFields(printStream, 1, J9ArrayClassPointer.cast(j9ClassPointer).componentType(), u8Pointer, (J9ObjectPointer)abstractPointer, l, string2.split("\\."), true);
                        printStream.println("}");
                    }
                } else {
                    J9ObjectPointer[] j9ObjectPointerArray = (J9ObjectPointer[])J9IndexableObjectHelper.getData(j9IndexableObjectPointer);
                    for (int i = 0; i < n; ++i) {
                        String[] stringArray4 = new String[]{j9ObjectPointerArray[i].getHexAddress()};
                        this.printFlatObject(string, stringArray4, context, printStream);
                    }
                }
            } else {
                if (null != string2) {
                    printStream.format("!flatobject %s %s {%n", abstractPointer.getHexAddress(), string2);
                } else {
                    printStream.format("!flatobject %s {%n", abstractPointer.getHexAddress());
                }
                PrintObjectFieldsHelper.printJ9ObjectFields(printStream, 1, j9ClassPointer, u8Pointer, (J9ObjectPointer)abstractPointer, l, string2 == null ? null : string2.split("\\."), true);
                printStream.println("}");
            }
        }
        catch (MemoryFault memoryFault) {
            if (abstractPointer == null || j9ClassPointer == null) {
                printStream.format("Unable to read object with command !flatobject %s%n", stringArray2[0]);
            } else {
                printStream.format("Unable to read object clazz at %s (clazz = %s) with command !flatobject %s%n", abstractPointer.getHexAddress(), j9ClassPointer.getHexAddress(), stringArray2[0]);
            }
        }
        catch (CorruptDataException | DDRInteractiveCommandException exception) {
            printStream.println("Error for");
            exception.printStackTrace(printStream);
        }
    }
}

