/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.walkers.ClassSegmentIterator;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ITablePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.structure.J9ITable;
import com.ibm.j9ddr.vm29.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.PrintStream;

public class ITableSizeCommand
extends Command {
    private static final String nl = System.getProperty("line.separator");

    public ITableSizeCommand() {
        this.addCommand("itablesize", "", "Dump experimental iTable sizing");
    }

    public long iTableChainSize(J9ITablePointer j9ITablePointer, J9ITablePointer j9ITablePointer2) throws CorruptDataException {
        long l = 0L;
        J9ITablePointer j9ITablePointer3 = j9ITablePointer;
        while (!j9ITablePointer3.eq(j9ITablePointer2)) {
            l += J9ITable.SIZEOF;
            J9ClassPointer j9ClassPointer = j9ITablePointer3.interfaceClass();
            J9ROMClassPointer j9ROMClassPointer = j9ClassPointer.romClass();
            l += (long)(UDATA.SIZEOF * j9ROMClassPointer.romMethodCount().intValue());
            j9ITablePointer3 = j9ITablePointer3.next();
        }
        return l;
    }

    public long iTableExtendedSize(J9ITablePointer j9ITablePointer, J9ITablePointer j9ITablePointer2) throws CorruptDataException {
        long l = 0L;
        J9ITablePointer j9ITablePointer3 = j9ITablePointer;
        while (!j9ITablePointer3.eq(j9ITablePointer2)) {
            l += J9ITable.SIZEOF;
            J9ClassPointer j9ClassPointer = j9ITablePointer3.interfaceClass();
            J9ROMClassPointer j9ROMClassPointer = j9ClassPointer.romClass();
            J9ITablePointer j9ITablePointer4 = J9ITablePointer.cast(j9ClassPointer.iTable());
            do {
                l += (long)(UDATA.SIZEOF * j9ITablePointer4.interfaceClass().romClass().romMethodCount().intValue());
            } while (!(j9ITablePointer4 = j9ITablePointer4.next()).eq(J9ITablePointer.NULL));
            j9ITablePointer3 = j9ITablePointer3.next();
        }
        return l;
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        try {
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            ClassSegmentIterator classSegmentIterator = new ClassSegmentIterator(j9JavaVMPointer.classMemorySegments());
            while (classSegmentIterator.hasNext()) {
                J9ClassPointer j9ClassPointer = (J9ClassPointer)classSegmentIterator.next();
                int n = j9ClassPointer.classDepthAndFlags().bitAnd(J9JavaAccessFlags.J9AccClassDepthMask).intValue();
                J9ITablePointer j9ITablePointer = J9ITablePointer.NULL;
                J9ITablePointer j9ITablePointer2 = J9ITablePointer.cast(j9ClassPointer.iTable());
                if (0 != n) {
                    PointerPointer pointerPointer = j9ClassPointer.superclasses();
                    J9ClassPointer j9ClassPointer2 = J9ClassPointer.cast(pointerPointer.at(n - 1));
                    j9ITablePointer = J9ITablePointer.cast(j9ClassPointer2.iTable());
                }
                l += this.iTableChainSize(j9ITablePointer2, j9ITablePointer);
                l2 += this.iTableChainSize(j9ITablePointer, J9ITablePointer.NULL);
                l3 += this.iTableExtendedSize(j9ITablePointer2, j9ITablePointer);
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
        long l4 = l2 + l;
        double d = (double)l4 / (double)l;
        printStream.append("iTable duplication" + nl);
        printStream.append("------------------" + nl);
        printStream.append("current    iTable size : " + l + nl);
        printStream.append("additional iTable size : " + l2 + nl);
        printStream.append("total      iTable size : " + l4 + nl);
        printStream.append("growth factor          : " + d + nl);
        printStream.append(nl);
        d = (double)l3 / (double)l;
        printStream.append("iTable contains extends" + nl);
        printStream.append("-----------------------" + nl);
        printStream.append("current    iTable size : " + l + nl);
        printStream.append("new        iTable size : " + l3 + nl);
        printStream.append("growth factor          : " + d + nl);
        printStream.append(nl);
    }
}

