/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.lang.management.internal;

import com.ibm.java.lang.management.internal.ManagementUtils;
import com.ibm.java.lang.management.internal.StackTraceElementUtil;
import java.lang.management.MonitorInfo;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public final class MonitorInfoUtil {
    private static CompositeType compositeType;

    public static MonitorInfo[] fromArray(CompositeData[] compositeDataArray) {
        MonitorInfo[] monitorInfoArray = null;
        if (compositeDataArray != null) {
            String[] stringArray = new String[]{"className", "identityHashCode", "lockedStackFrame", "lockedStackDepth"};
            String[] stringArray2 = new String[]{"java.lang.String", "java.lang.Integer", CompositeData.class.getName(), "java.lang.Integer"};
            int n = compositeDataArray.length;
            monitorInfoArray = new MonitorInfo[n];
            for (int i = 0; i < n; ++i) {
                CompositeData compositeData = compositeDataArray[i];
                ManagementUtils.verifyFieldNumber(compositeData, 4);
                ManagementUtils.verifyFieldNames(compositeData, stringArray);
                ManagementUtils.verifyFieldTypes(compositeData, stringArray, stringArray2);
                monitorInfoArray[i] = MonitorInfo.from(compositeData);
            }
        }
        return monitorInfoArray;
    }

    public static CompositeType getCompositeType() {
        block3: {
            if (compositeType == null) {
                try {
                    String[] stringArray = new String[]{"className", "identityHashCode", "lockedStackFrame", "lockedStackDepth"};
                    String[] stringArray2 = new String[]{"className", "identityHashCode", "lockedStackFrame", "lockedStackDepth"};
                    OpenType[] openTypeArray = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER, StackTraceElementUtil.getCompositeType(), SimpleType.INTEGER};
                    compositeType = new CompositeType(MonitorInfo.class.getName(), MonitorInfo.class.getName(), stringArray, stringArray2, openTypeArray);
                }
                catch (OpenDataException openDataException) {
                    if (!ManagementUtils.VERBOSE_MODE) break block3;
                    openDataException.printStackTrace(System.err);
                }
            }
        }
        return compositeType;
    }

    public static CompositeData toCompositeData(MonitorInfo monitorInfo) {
        CompositeDataSupport compositeDataSupport;
        block3: {
            compositeDataSupport = null;
            if (monitorInfo != null) {
                CompositeType compositeType = MonitorInfoUtil.getCompositeType();
                String[] stringArray = new String[]{"className", "identityHashCode", "lockedStackFrame", "lockedStackDepth"};
                Object[] objectArray = new Object[]{monitorInfo.getClassName(), monitorInfo.getIdentityHashCode(), StackTraceElementUtil.toCompositeData(monitorInfo.getLockedStackFrame()), monitorInfo.getLockedStackDepth()};
                try {
                    compositeDataSupport = new CompositeDataSupport(compositeType, stringArray, objectArray);
                }
                catch (OpenDataException openDataException) {
                    if (!ManagementUtils.VERBOSE_MODE) break block3;
                    openDataException.printStackTrace(System.err);
                }
            }
        }
        return compositeDataSupport;
    }

    private MonitorInfoUtil() {
    }
}

