/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm;

import com.ibm.jvm.TracePermission;
import com.ibm.oti.vm.VM;
import java.util.Objects;

public final class Trace {
    public static final String EVENT = "0 ";
    public static final String EXCEPTION = "1 ";
    public static final String ENTRY = "2 ";
    public static final String EXIT = "4 ";
    public static final String EXCEPTION_EXIT = "5 ";
    private static final String LEGACY_TRACE_PERMISSION_PROPERTY = "com.ibm.jvm.enableLegacyTraceSecurity";
    private static final TracePermission TRACE_PERMISSION = new TracePermission();

    private Trace() {
    }

    @Deprecated
    public static void initializeTrace() {
    }

    private static native void initTraceImpl();

    public static int set(String string) {
        Trace.checkLegacySecurityPermssion();
        return Trace.setImpl(string);
    }

    public static void snap() {
        Trace.checkLegacySecurityPermssion();
        Trace.snapImpl();
    }

    public static void suspend() {
        Trace.checkLegacySecurityPermssion();
        Trace.suspendImpl();
    }

    public static void resume() {
        Trace.checkLegacySecurityPermssion();
        Trace.resumeImpl();
    }

    public static void suspendThis() {
        Trace.checkLegacySecurityPermssion();
        Trace.suspendThisImpl();
    }

    public static void resumeThis() {
        Trace.checkLegacySecurityPermssion();
        Trace.resumeThisImpl();
    }

    public static synchronized int registerApplication(String string, String[] stringArray) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(string, "name");
        Objects.requireNonNull(stringArray, "templates");
        return Trace.registerApplicationImpl(string, stringArray);
    }

    private static native int setImpl(String var0);

    private static native void snapImpl();

    private static native void suspendImpl();

    private static native void resumeImpl();

    private static native void suspendThisImpl();

    private static native void resumeThisImpl();

    private static native int registerApplicationImpl(String var0, String[] var1);

    private static void checkLegacySecurityPermssion() throws SecurityException {
        if (!"false".equalsIgnoreCase(VM.internalGetProperties().getProperty(LEGACY_TRACE_PERMISSION_PROPERTY))) {
            Trace.checkTraceSecurityPermssion();
        }
    }

    private static void checkTraceSecurityPermssion() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(TRACE_PERMISSION);
        }
    }

    public static void trace(int n, int n2) {
        Trace.checkLegacySecurityPermssion();
        Trace.traceImpl(n, n2);
    }

    public static void trace(int n, int n2, String string) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(string, "s1");
        Trace.traceImpl(n, n2, string);
    }

    public static void trace(int n, int n2, String string, String string2) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(string, "s1");
        Objects.requireNonNull(string2, "s2");
        Trace.traceImpl(n, n2, string, string2);
    }

    public static void trace(int n, int n2, String string, String string2, String string3) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(string, "s1");
        Objects.requireNonNull(string2, "s2");
        Objects.requireNonNull(string3, "s3");
        Trace.traceImpl(n, n2, string, string2, string3);
    }

    public static void trace(int n, int n2, String string, Object object) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(string, "s1");
        Objects.requireNonNull(object, "o1");
        Trace.traceImpl(n, n2, string, object);
    }

    public static void trace(int n, int n2, Object object, String string) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(object, "o1");
        Objects.requireNonNull(string, "s1");
        Trace.traceImpl(n, n2, object, string);
    }

    public static void trace(int n, int n2, String string, int n3) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(string, "s1");
        Trace.traceImpl(n, n2, string, n3);
    }

    public static void trace(int n, int n2, int n3, String string) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(string, "s1");
        Trace.traceImpl(n, n2, n3, string);
    }

    public static void trace(int n, int n2, String string, long l) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(string, "s1");
        Trace.traceImpl(n, n2, string, l);
    }

    public static void trace(int n, int n2, long l, String string) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(string, "s1");
        Trace.traceImpl(n, n2, l, string);
    }

    public static void trace(int n, int n2, String string, byte by) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(string, "s1");
        Trace.traceImpl(n, n2, string, by);
    }

    public static void trace(int n, int n2, byte by, String string) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(string, "s1");
        Trace.traceImpl(n, n2, by, string);
    }

    public static void trace(int n, int n2, String string, char c) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(string, "s1");
        Trace.traceImpl(n, n2, string, c);
    }

    public static void trace(int n, int n2, char c, String string) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(string, "s1");
        Trace.traceImpl(n, n2, c, string);
    }

    public static void trace(int n, int n2, String string, float f) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(string, "s1");
        Trace.traceImpl(n, n2, string, f);
    }

    public static void trace(int n, int n2, float f, String string) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(string, "s1");
        Trace.traceImpl(n, n2, f, string);
    }

    public static void trace(int n, int n2, String string, double d) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(string, "s1");
        Trace.traceImpl(n, n2, string, d);
    }

    public static void trace(int n, int n2, double d, String string) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(string, "s1");
        Trace.traceImpl(n, n2, d, string);
    }

    public static void trace(int n, int n2, Object object) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(object, "o1");
        Trace.traceImpl(n, n2, object);
    }

    public static void trace(int n, int n2, Object object, Object object2) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(object, "o1");
        Objects.requireNonNull(object2, "o2");
        Trace.traceImpl(n, n2, object, object2);
    }

    public static void trace(int n, int n2, int n3) {
        Trace.checkLegacySecurityPermssion();
        Trace.traceImpl(n, n2, n3);
    }

    public static void trace(int n, int n2, int n3, int n4) {
        Trace.checkLegacySecurityPermssion();
        Trace.traceImpl(n, n2, n3, n4);
    }

    public static void trace(int n, int n2, int n3, int n4, int n5) {
        Trace.checkLegacySecurityPermssion();
        Trace.traceImpl(n, n2, n3, n4, n5);
    }

    public static void trace(int n, int n2, long l) {
        Trace.checkLegacySecurityPermssion();
        Trace.traceImpl(n, n2, l);
    }

    public static void trace(int n, int n2, long l, long l2) {
        Trace.checkLegacySecurityPermssion();
        Trace.traceImpl(n, n2, l, l2);
    }

    public static void trace(int n, int n2, long l, long l2, long l3) {
        Trace.checkLegacySecurityPermssion();
        Trace.traceImpl(n, n2, l, l2, l3);
    }

    public static void trace(int n, int n2, byte by) {
        Trace.checkLegacySecurityPermssion();
        Trace.traceImpl(n, n2, by);
    }

    public static void trace(int n, int n2, byte by, byte by2) {
        Trace.checkLegacySecurityPermssion();
        Trace.traceImpl(n, n2, by, by2);
    }

    public static void trace(int n, int n2, byte by, byte by2, byte by3) {
        Trace.checkLegacySecurityPermssion();
        Trace.traceImpl(n, n2, by, by2, by3);
    }

    public static void trace(int n, int n2, char c) {
        Trace.checkLegacySecurityPermssion();
        Trace.traceImpl(n, n2, c);
    }

    public static void trace(int n, int n2, char c, char c2) {
        Trace.checkLegacySecurityPermssion();
        Trace.traceImpl(n, n2, c, c2);
    }

    public static void trace(int n, int n2, char c, char c2, char c3) {
        Trace.checkLegacySecurityPermssion();
        Trace.traceImpl(n, n2, c, c2, c3);
    }

    public static void trace(int n, int n2, float f) {
        Trace.checkLegacySecurityPermssion();
        Trace.traceImpl(n, n2, f);
    }

    public static void trace(int n, int n2, float f, float f2) {
        Trace.checkLegacySecurityPermssion();
        Trace.traceImpl(n, n2, f, f2);
    }

    public static void trace(int n, int n2, float f, float f2, float f3) {
        Trace.checkLegacySecurityPermssion();
        Trace.traceImpl(n, n2, f, f2, f3);
    }

    public static void trace(int n, int n2, double d) {
        Trace.checkLegacySecurityPermssion();
        Trace.traceImpl(n, n2, d);
    }

    public static void trace(int n, int n2, double d, double d2) {
        Trace.checkLegacySecurityPermssion();
        Trace.traceImpl(n, n2, d, d2);
    }

    public static void trace(int n, int n2, double d, double d2, double d3) {
        Trace.checkLegacySecurityPermssion();
        Trace.traceImpl(n, n2, d, d2, d3);
    }

    public static void trace(int n, int n2, String string, Object object, String string2) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(string, "s1");
        Objects.requireNonNull(object, "o1");
        Objects.requireNonNull(string2, "s2");
        Trace.traceImpl(n, n2, string, object, string2);
    }

    public static void trace(int n, int n2, Object object, String string, Object object2) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(object, "o1");
        Objects.requireNonNull(string, "s1");
        Objects.requireNonNull(object2, "o2");
        Trace.traceImpl(n, n2, object, string, object2);
    }

    public static void trace(int n, int n2, String string, int n3, String string2) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(string, "s1");
        Objects.requireNonNull(string2, "s2");
        Trace.traceImpl(n, n2, string, n3, string2);
    }

    public static void trace(int n, int n2, int n3, String string, int n4) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(string, "s1");
        Trace.traceImpl(n, n2, n3, string, n4);
    }

    public static void trace(int n, int n2, String string, long l, String string2) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(string, "s1");
        Objects.requireNonNull(string2, "s2");
        Trace.traceImpl(n, n2, string, l, string2);
    }

    public static void trace(int n, int n2, long l, String string, long l2) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(string, "s1");
        Trace.traceImpl(n, n2, l, string, l2);
    }

    public static void trace(int n, int n2, String string, byte by, String string2) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(string, "s1");
        Objects.requireNonNull(string2, "s2");
        Trace.traceImpl(n, n2, string, by, string2);
    }

    public static void trace(int n, int n2, byte by, String string, byte by2) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(string, "s1");
        Trace.traceImpl(n, n2, by, string, by2);
    }

    public static void trace(int n, int n2, String string, char c, String string2) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(string, "s1");
        Objects.requireNonNull(string2, "s2");
        Trace.traceImpl(n, n2, string, c, string2);
    }

    public static void trace(int n, int n2, char c, String string, char c2) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(string, "s1");
        Trace.traceImpl(n, n2, c, string, c2);
    }

    public static void trace(int n, int n2, String string, float f, String string2) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(string, "s1");
        Objects.requireNonNull(string2, "s2");
        Trace.traceImpl(n, n2, string, f, string2);
    }

    public static void trace(int n, int n2, float f, String string, float f2) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(string, "s1");
        Trace.traceImpl(n, n2, f, string, f2);
    }

    public static void trace(int n, int n2, String string, double d, String string2) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(string, "s1");
        Objects.requireNonNull(string2, "s2");
        Trace.traceImpl(n, n2, string, d, string2);
    }

    public static void trace(int n, int n2, double d, String string, double d2) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(string, "s1");
        Trace.traceImpl(n, n2, d, string, d2);
    }

    private static native void traceImpl(int var0, int var1);

    private static native void traceImpl(int var0, int var1, String var2);

    private static native void traceImpl(int var0, int var1, String var2, String var3);

    private static native void traceImpl(int var0, int var1, String var2, String var3, String var4);

    private static native void traceImpl(int var0, int var1, String var2, Object var3);

    private static native void traceImpl(int var0, int var1, Object var2, String var3);

    private static native void traceImpl(int var0, int var1, String var2, int var3);

    private static native void traceImpl(int var0, int var1, int var2, String var3);

    private static native void traceImpl(int var0, int var1, String var2, long var3);

    private static native void traceImpl(int var0, int var1, long var2, String var4);

    private static native void traceImpl(int var0, int var1, String var2, byte var3);

    private static native void traceImpl(int var0, int var1, byte var2, String var3);

    private static native void traceImpl(int var0, int var1, String var2, char var3);

    private static native void traceImpl(int var0, int var1, char var2, String var3);

    private static native void traceImpl(int var0, int var1, String var2, float var3);

    private static native void traceImpl(int var0, int var1, float var2, String var3);

    private static native void traceImpl(int var0, int var1, String var2, double var3);

    private static native void traceImpl(int var0, int var1, double var2, String var4);

    private static native void traceImpl(int var0, int var1, Object var2);

    private static native void traceImpl(int var0, int var1, Object var2, Object var3);

    private static native void traceImpl(int var0, int var1, int var2);

    private static native void traceImpl(int var0, int var1, int var2, int var3);

    private static native void traceImpl(int var0, int var1, int var2, int var3, int var4);

    private static native void traceImpl(int var0, int var1, long var2);

    private static native void traceImpl(int var0, int var1, long var2, long var4);

    private static native void traceImpl(int var0, int var1, long var2, long var4, long var6);

    private static native void traceImpl(int var0, int var1, byte var2);

    private static native void traceImpl(int var0, int var1, byte var2, byte var3);

    private static native void traceImpl(int var0, int var1, byte var2, byte var3, byte var4);

    private static native void traceImpl(int var0, int var1, char var2);

    private static native void traceImpl(int var0, int var1, char var2, char var3);

    private static native void traceImpl(int var0, int var1, char var2, char var3, char var4);

    private static native void traceImpl(int var0, int var1, float var2);

    private static native void traceImpl(int var0, int var1, float var2, float var3);

    private static native void traceImpl(int var0, int var1, float var2, float var3, float var4);

    private static native void traceImpl(int var0, int var1, double var2);

    private static native void traceImpl(int var0, int var1, double var2, double var4);

    private static native void traceImpl(int var0, int var1, double var2, double var4, double var6);

    private static native void traceImpl(int var0, int var1, String var2, Object var3, String var4);

    private static native void traceImpl(int var0, int var1, Object var2, String var3, Object var4);

    private static native void traceImpl(int var0, int var1, String var2, int var3, String var4);

    private static native void traceImpl(int var0, int var1, int var2, String var3, int var4);

    private static native void traceImpl(int var0, int var1, String var2, long var3, String var5);

    private static native void traceImpl(int var0, int var1, long var2, String var4, long var5);

    private static native void traceImpl(int var0, int var1, String var2, byte var3, String var4);

    private static native void traceImpl(int var0, int var1, byte var2, String var3, byte var4);

    private static native void traceImpl(int var0, int var1, String var2, char var3, String var4);

    private static native void traceImpl(int var0, int var1, char var2, String var3, char var4);

    private static native void traceImpl(int var0, int var1, String var2, float var3, String var4);

    private static native void traceImpl(int var0, int var1, float var2, String var3, float var4);

    private static native void traceImpl(int var0, int var1, String var2, double var3, String var5);

    private static native void traceImpl(int var0, int var1, double var2, String var4, double var5);

    @Deprecated
    public static native long getMicros();

    static {
        Trace.initTraceImpl();
    }
}

