/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SoftAudioPusher;
import com.sun.media.sound.SoftMixingClip;
import com.sun.media.sound.SoftMixingDataLine;
import com.sun.media.sound.SoftMixingMainMixer;
import com.sun.media.sound.SoftMixingMixerProvider;
import com.sun.media.sound.SoftMixingSourceDataLine;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;

public final class SoftMixingMixer
implements Mixer {
    static final String INFO_NAME = "Gervill Sound Mixer";
    static final String INFO_VENDOR = "OpenJDK Proposal";
    static final String INFO_DESCRIPTION = "Software Sound Mixer";
    static final String INFO_VERSION = "1.0";
    static final Mixer.Info info = new Info();
    final Object control_mutex = this;
    boolean implicitOpen = false;
    private boolean open = false;
    private SoftMixingMainMixer mainmixer = null;
    private AudioFormat format = new AudioFormat(44100.0f, 16, 2, true, false);
    private SourceDataLine sourceDataLine = null;
    private SoftAudioPusher pusher = null;
    private AudioInputStream pusher_stream = null;
    private final float controlrate = 147.0f;
    private final long latency = 100000L;
    private final boolean jitter_correction = false;
    private final List<LineListener> listeners = new ArrayList<LineListener>();
    private final Line.Info[] sourceLineInfo = new Line.Info[2];

    public SoftMixingMixer() {
        ArrayList<AudioFormat> arrayList = new ArrayList<AudioFormat>();
        for (int i = 1; i <= 2; ++i) {
            arrayList.add(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 8, i, i, -1.0f, false));
            arrayList.add(new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, 8, i, i, -1.0f, false));
            for (int j = 16; j < 32; j += 8) {
                arrayList.add(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, j, i, i * j / 8, -1.0f, false));
                arrayList.add(new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, j, i, i * j / 8, -1.0f, false));
                arrayList.add(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, j, i, i * j / 8, -1.0f, true));
                arrayList.add(new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, j, i, i * j / 8, -1.0f, true));
            }
            arrayList.add(new AudioFormat(AudioFormat.Encoding.PCM_FLOAT, -1.0f, 32, i, i * 4, -1.0f, false));
            arrayList.add(new AudioFormat(AudioFormat.Encoding.PCM_FLOAT, -1.0f, 32, i, i * 4, -1.0f, true));
            arrayList.add(new AudioFormat(AudioFormat.Encoding.PCM_FLOAT, -1.0f, 64, i, i * 8, -1.0f, false));
            arrayList.add(new AudioFormat(AudioFormat.Encoding.PCM_FLOAT, -1.0f, 64, i, i * 8, -1.0f, true));
        }
        AudioFormat[] audioFormatArray = arrayList.toArray(new AudioFormat[arrayList.size()]);
        this.sourceLineInfo[0] = new DataLine.Info(SourceDataLine.class, audioFormatArray, -1, -1);
        this.sourceLineInfo[1] = new DataLine.Info(Clip.class, audioFormatArray, -1, -1);
    }

    @Override
    public Line getLine(Line.Info info) throws LineUnavailableException {
        if (!this.isLineSupported(info)) {
            throw new IllegalArgumentException("Line unsupported: " + info);
        }
        if (info.getLineClass() == SourceDataLine.class) {
            return new SoftMixingSourceDataLine(this, (DataLine.Info)info);
        }
        if (info.getLineClass() == Clip.class) {
            return new SoftMixingClip(this, (DataLine.Info)info);
        }
        throw new IllegalArgumentException("Line unsupported: " + info);
    }

    @Override
    public int getMaxLines(Line.Info info) {
        if (info.getLineClass() == SourceDataLine.class) {
            return -1;
        }
        if (info.getLineClass() == Clip.class) {
            return -1;
        }
        return 0;
    }

    @Override
    public Mixer.Info getMixerInfo() {
        return info;
    }

    @Override
    public Line.Info[] getSourceLineInfo() {
        Line.Info[] infoArray = new Line.Info[this.sourceLineInfo.length];
        System.arraycopy((Object)this.sourceLineInfo, 0, (Object)infoArray, 0, this.sourceLineInfo.length);
        return infoArray;
    }

    @Override
    public Line.Info[] getSourceLineInfo(Line.Info info) {
        ArrayList<Line.Info> arrayList = new ArrayList<Line.Info>();
        for (int i = 0; i < this.sourceLineInfo.length; ++i) {
            if (!info.matches(this.sourceLineInfo[i])) continue;
            arrayList.add(this.sourceLineInfo[i]);
        }
        return arrayList.toArray(new Line.Info[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Line[] getSourceLines() {
        Line[] lineArray;
        Object object = this.control_mutex;
        synchronized (object) {
            if (this.mainmixer == null) {
                return new Line[0];
            }
            SoftMixingDataLine[] softMixingDataLineArray = this.mainmixer.getOpenLines();
            lineArray = new Line[softMixingDataLineArray.length];
            for (int i = 0; i < lineArray.length; ++i) {
                lineArray[i] = softMixingDataLineArray[i];
            }
        }
        return lineArray;
    }

    @Override
    public Line.Info[] getTargetLineInfo() {
        return new Line.Info[0];
    }

    @Override
    public Line.Info[] getTargetLineInfo(Line.Info info) {
        return new Line.Info[0];
    }

    @Override
    public Line[] getTargetLines() {
        return new Line[0];
    }

    @Override
    public boolean isLineSupported(Line.Info info) {
        if (info != null) {
            for (int i = 0; i < this.sourceLineInfo.length; ++i) {
                if (!info.matches(this.sourceLineInfo[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isSynchronizationSupported(Line[] lineArray, boolean bl) {
        return false;
    }

    @Override
    public void synchronize(Line[] lineArray, boolean bl) {
        throw new IllegalArgumentException("Synchronization not supported by this mixer.");
    }

    @Override
    public void unsynchronize(Line[] lineArray) {
        throw new IllegalArgumentException("Synchronization not supported by this mixer.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLineListener(LineListener lineListener) {
        Object object = this.control_mutex;
        synchronized (object) {
            this.listeners.add(lineListener);
        }
    }

    private void sendEvent(LineEvent lineEvent) {
        LineListener[] lineListenerArray;
        if (this.listeners.size() == 0) {
            return;
        }
        for (LineListener lineListener : lineListenerArray = this.listeners.toArray(new LineListener[this.listeners.size()])) {
            lineListener.update(lineEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.isOpen()) {
            return;
        }
        this.sendEvent(new LineEvent(this, LineEvent.Type.CLOSE, -1L));
        SoftAudioPusher softAudioPusher = null;
        AudioInputStream audioInputStream = null;
        Object object = this.control_mutex;
        synchronized (object) {
            if (this.pusher != null) {
                softAudioPusher = this.pusher;
                audioInputStream = this.pusher_stream;
                this.pusher = null;
                this.pusher_stream = null;
            }
        }
        if (softAudioPusher != null) {
            softAudioPusher.stop();
            try {
                audioInputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        object = this.control_mutex;
        synchronized (object) {
            if (this.mainmixer != null) {
                this.mainmixer.close();
            }
            this.open = false;
            if (this.sourceDataLine != null) {
                this.sourceDataLine.drain();
                this.sourceDataLine.close();
                this.sourceDataLine = null;
            }
        }
    }

    @Override
    public Control getControl(Control.Type type) {
        throw new IllegalArgumentException("Unsupported control type : " + type);
    }

    @Override
    public Control[] getControls() {
        return new Control[0];
    }

    @Override
    public Line.Info getLineInfo() {
        return new Line.Info(Mixer.class);
    }

    @Override
    public boolean isControlSupported(Control.Type type) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpen() {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.open;
        }
    }

    @Override
    public void open() throws LineUnavailableException {
        if (this.isOpen()) {
            this.implicitOpen = false;
            return;
        }
        this.open(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(SourceDataLine sourceDataLine) throws LineUnavailableException {
        if (this.isOpen()) {
            this.implicitOpen = false;
            return;
        }
        Object object = this.control_mutex;
        synchronized (object) {
            try {
                if (sourceDataLine != null) {
                    this.format = sourceDataLine.getFormat();
                }
                AudioInputStream audioInputStream = this.openStream(this.getFormat());
                if (sourceDataLine == null) {
                    Object object2 = SoftMixingMixerProvider.mutex;
                    synchronized (object2) {
                        SoftMixingMixerProvider.lockthread = Thread.currentThread();
                    }
                    try {
                        object2 = AudioSystem.getMixer(null);
                        if (object2 != null) {
                            DataLine.Info info = null;
                            AudioFormat audioFormat = null;
                            Line.Info[] infoArray = object2.getSourceLineInfo();
                            block19: for (int i = 0; i < infoArray.length; ++i) {
                                if (infoArray[i].getLineClass() != SourceDataLine.class) continue;
                                DataLine.Info info2 = (DataLine.Info)infoArray[i];
                                AudioFormat[] audioFormatArray = info2.getFormats();
                                for (int j = 0; j < audioFormatArray.length; ++j) {
                                    AudioFormat audioFormat2 = audioFormatArray[j];
                                    if (audioFormat2.getChannels() != 2 && audioFormat2.getChannels() != -1 || !audioFormat2.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED) && !audioFormat2.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED) || audioFormat2.getSampleRate() != -1.0f && (double)audioFormat2.getSampleRate() != 48000.0 || audioFormat2.getSampleSizeInBits() != -1 && audioFormat2.getSampleSizeInBits() != 16) continue;
                                    info = info2;
                                    int n = audioFormat2.getChannels();
                                    boolean bl = audioFormat2.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED);
                                    float f = audioFormat2.getSampleRate();
                                    boolean bl2 = audioFormat2.isBigEndian();
                                    int n2 = audioFormat2.getSampleSizeInBits();
                                    if (n2 == -1) {
                                        n2 = 16;
                                    }
                                    if (n == -1) {
                                        n = 2;
                                    }
                                    if (f == -1.0f) {
                                        f = 48000.0f;
                                    }
                                    audioFormat = new AudioFormat(f, n2, n, bl, bl2);
                                    break block19;
                                }
                            }
                            if (audioFormat != null) {
                                this.format = audioFormat;
                                sourceDataLine = (SourceDataLine)object2.getLine(info);
                            }
                        }
                        if (sourceDataLine == null) {
                            sourceDataLine = AudioSystem.getSourceDataLine(this.format);
                        }
                    }
                    finally {
                        object2 = SoftMixingMixerProvider.mutex;
                        synchronized (object2) {
                            SoftMixingMixerProvider.lockthread = null;
                        }
                    }
                    if (sourceDataLine == null) {
                        throw new IllegalArgumentException("No line matching " + info.toString() + " is supported.");
                    }
                }
                this.getClass();
                double d = 100000.0;
                if (!sourceDataLine.isOpen()) {
                    int n = this.getFormat().getFrameSize() * (int)((double)this.getFormat().getFrameRate() * (d / 1000000.0));
                    sourceDataLine.open(this.getFormat(), n);
                    this.sourceDataLine = sourceDataLine;
                }
                if (!sourceDataLine.isActive()) {
                    sourceDataLine.start();
                }
                int n = 512;
                try {
                    n = audioInputStream.available();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                int n3 = sourceDataLine.getBufferSize();
                n3 -= n3 % n;
                if (n3 < 3 * n) {
                    n3 = 3 * n;
                }
                this.pusher = new SoftAudioPusher(sourceDataLine, audioInputStream, n);
                this.pusher_stream = audioInputStream;
                this.pusher.start();
            }
            catch (LineUnavailableException lineUnavailableException) {
                if (this.isOpen()) {
                    this.close();
                }
                throw new LineUnavailableException(lineUnavailableException.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioInputStream openStream(AudioFormat audioFormat) throws LineUnavailableException {
        if (this.isOpen()) {
            throw new LineUnavailableException("Mixer is already open");
        }
        Object object = this.control_mutex;
        synchronized (object) {
            this.open = true;
            this.implicitOpen = false;
            if (audioFormat != null) {
                this.format = audioFormat;
            }
            this.mainmixer = new SoftMixingMainMixer(this);
            this.sendEvent(new LineEvent(this, LineEvent.Type.OPEN, -1L));
            return this.mainmixer.getInputStream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLineListener(LineListener lineListener) {
        Object object = this.control_mutex;
        synchronized (object) {
            this.listeners.remove(lineListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLatency() {
        Object object = this.control_mutex;
        synchronized (object) {
            return 100000L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioFormat getFormat() {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.format;
        }
    }

    float getControlRate() {
        return 147.0f;
    }

    SoftMixingMainMixer getMainMixer() {
        if (!this.isOpen()) {
            return null;
        }
        return this.mainmixer;
    }

    private static class Info
    extends Mixer.Info {
        Info() {
            super(SoftMixingMixer.INFO_NAME, SoftMixingMixer.INFO_VENDOR, SoftMixingMixer.INFO_DESCRIPTION, SoftMixingMixer.INFO_VERSION);
        }
    }
}

