/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders;

import com.ibm.j9ddr.corereaders.ICore;
import com.ibm.j9ddr.corereaders.memory.IMemorySource;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import javax.imageio.stream.ImageInputStream;

public abstract class AbstractCoreReader
implements ICore {
    protected ImageInputStream _fileReader;
    protected Collection<? extends IMemorySource> _memoryRanges = new ArrayList<IMemorySource>();
    protected File coreFile;

    protected AbstractCoreReader() {
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof AbstractCoreReader)) {
            return false;
        }
        AbstractCoreReader abstractCoreReader = (AbstractCoreReader)object;
        if (this.coreFile == null) {
            if (abstractCoreReader.coreFile != null) {
                return false;
            }
            return this._fileReader.equals(abstractCoreReader._fileReader);
        }
        if (abstractCoreReader.coreFile == null) {
            return false;
        }
        return this.coreFile.equals(abstractCoreReader.coreFile);
    }

    public int hashCode() {
        if (this.coreFile == null) {
            return super.hashCode();
        }
        return this.coreFile.hashCode();
    }

    public void setReader(ImageInputStream imageInputStream) throws IOException {
        this._fileReader = imageInputStream;
    }

    public long readLong() throws IOException {
        return this._fileReader.readLong();
    }

    public int readInt() throws IOException {
        return this._fileReader.readInt();
    }

    public short readShort() throws IOException {
        return this._fileReader.readShort();
    }

    public byte readByte() throws IOException {
        return this._fileReader.readByte();
    }

    public void seek(long l) throws IOException {
        this._fileReader.seek(l);
    }

    public byte[] readBytes(int n) throws IOException {
        byte[] byArray = new byte[n];
        this._fileReader.readFully(byArray);
        return byArray;
    }

    public void readFully(byte[] byArray) throws IOException {
        this._fileReader.readFully(byArray);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this._fileReader.readFully(byArray, n, n2);
    }

    protected boolean checkOffset(long l) throws IOException {
        boolean bl;
        long l2 = this._fileReader.getStreamPosition();
        try {
            this._fileReader.seek(l);
            this._fileReader.readByte();
            bl = true;
        }
        catch (IOException iOException) {
            bl = false;
        }
        this._fileReader.seek(l2);
        return bl;
    }

    protected String readString() throws IOException {
        byte by;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((by = this.readByte()) != 0) {
            byteArrayOutputStream.write(by);
        }
        return new String(byteArrayOutputStream.toByteArray(), StandardCharsets.US_ASCII);
    }

    public static String format(int n) {
        return "0x" + Integer.toHexString(n);
    }

    public static String format(long l) {
        return "0x" + Long.toHexString(l);
    }

    protected static long readLong(byte[] byArray, int n) {
        return 0xFF00000000000000L & (long)byArray[n + 0] << 56 | 0xFF000000000000L & (long)byArray[n + 1] << 48 | 0xFF0000000000L & (long)byArray[n + 2] << 40 | 0xFF00000000L & (long)byArray[n + 3] << 32 | 0xFF000000L & (long)byArray[n + 4] << 24 | 0xFF0000L & (long)byArray[n + 5] << 16 | 0xFF00L & (long)byArray[n + 6] << 8 | 0xFFL & (long)byArray[n + 7];
    }

    protected static int readInt(byte[] byArray, int n) {
        return 0xFF000000 & byArray[n + 0] << 24 | 0xFF0000 & byArray[n + 1] << 16 | 0xFF00 & byArray[n + 2] << 8 | 0xFF & byArray[n + 3];
    }

    @Override
    public void close() throws IOException {
        if (this._fileReader != null) {
            this._fileReader.close();
        }
    }
}

