/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.minidump.unwind;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.memory.IMemoryRange;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.corereaders.memory.ISymbol;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.corereaders.memory.Module;
import com.ibm.j9ddr.corereaders.minidump.unwind.RuntimeFunction;
import com.ibm.j9ddr.corereaders.minidump.unwind.UnwindInfo;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

public class UnwindModule
extends Module {
    private List<RuntimeFunction> runtimeFunctionEntries;

    public UnwindModule(IProcess iProcess, String string, List<? extends ISymbol> list, Collection<? extends IMemoryRange> collection, long l, Properties properties) {
        super(iProcess, string, list, collection, l, properties);
    }

    public UnwindModule(IProcess iProcess, String string, List<? extends ISymbol> list, Collection<? extends IMemoryRange> collection, long l, Properties properties, List<RuntimeFunction> list2) {
        super(iProcess, string, list, collection, l, properties);
        this.runtimeFunctionEntries = list2;
        Collections.sort(list2);
    }

    public RuntimeFunction getUnwindDataForAddress(long l) throws MemoryFault {
        RuntimeFunction runtimeFunction = null;
        for (RuntimeFunction runtimeFunction2 : this.runtimeFunctionEntries) {
            if (!runtimeFunction2.contains(l)) continue;
            runtimeFunction = runtimeFunction2;
            while (runtimeFunction.getUnwindInfoAddress() % 2L != 0L) {
                int n = this.process.getIntAt(--l + this.getLoadAddress());
                int n2 = this.process.getIntAt(l + this.getLoadAddress() + 4L);
                int n3 = this.process.getIntAt(l + this.getLoadAddress() + 4L);
                runtimeFunction = new RuntimeFunction(n, n2, n3);
            }
            break block0;
        }
        return runtimeFunction;
    }

    public void dumpUndwindInfo(PrintStream printStream) {
        if (this.runtimeFunctionEntries == null) {
            printStream.println("No undwind info available for module " + this.getName());
        }
        printStream.println("Dumping unwind info for: " + this.getName());
        try {
            for (RuntimeFunction runtimeFunction : this.runtimeFunctionEntries) {
                printStream.format("Found ImageRuntimeFunctionEntry %s%n", runtimeFunction);
                if (runtimeFunction.getUnwindInfoAddress() % 2L != 0L) continue;
                UnwindInfo unwindInfo = new UnwindInfo(this.process.getAddressSpace(), this, runtimeFunction.getUnwindInfoAddress());
                printStream.println(unwindInfo);
                printStream.println();
            }
        }
        catch (CorruptDataException corruptDataException) {
            corruptDataException.printStackTrace(printStream);
        }
    }
}

