/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools;

import com.ibm.j9ddr.tools.store.J9DDRStructureStore;
import com.ibm.j9ddr.tools.store.StructureKey;
import com.ibm.j9ddr.tools.store.StructureMismatchError;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;

public class AddStructureBlob {
    private static final String PROP_DDR_ORDER = "ddr.order";
    HashMap<String, String> opts = new HashMap();

    public AddStructureBlob() {
        this.initArgs();
    }

    private void initArgs() {
        this.opts.put("-d", null);
        this.opts.put("-f", null);
        this.opts.put("-k", null);
        this.opts.put("-s", null);
        this.opts.put("-c", "");
    }

    public static void main(String[] stringArray) {
        AddStructureBlob addStructureBlob = new AddStructureBlob();
        addStructureBlob.parseArgs(stringArray);
        addStructureBlob.run();
    }

    private String[] loadSpecNames() {
        String string = this.opts.get("-c");
        if (null == string || string.length() == 0) {
            return new String[0];
        }
        Properties properties = new Properties();
        File file = new File(string);
        if (file.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
                String string2 = properties.getProperty(PROP_DDR_ORDER);
                if (null == string2) {
                    String string3 = String.format("The cache properties file [%s] specified by the -c option does not specify a %s key", file.getAbsolutePath(), PROP_DDR_ORDER);
                    throw new IllegalArgumentException(string3);
                }
                return string2.split(",");
            }
            catch (Exception exception) {
                String string4 = String.format("The cache properties file [%s] specified by the -c option could not be read", file.getAbsolutePath());
                throw new IllegalArgumentException(string4, exception);
            }
        }
        String string5 = String.format("The cache properties file [%s] specified by the -c option does not exist", file.getAbsolutePath());
        throw new IllegalArgumentException(string5);
    }

    private void run() {
        String string = this.opts.get("-d");
        String string2 = this.opts.get("-s");
        if (string2 == null) {
            string2 = "superset.dat";
        }
        try {
            J9DDRStructureStore j9DDRStructureStore = new J9DDRStructureStore(string, string2);
            String string3 = this.opts.get("-c");
            if (null == string3 || string3.length() == 0) {
                this.addFromFile(j9DDRStructureStore);
            } else {
                this.addFromPropertiesFile(j9DDRStructureStore);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (StructureMismatchError structureMismatchError) {
            structureMismatchError.printStackTrace();
        }
    }

    private void addFromFile(J9DDRStructureStore j9DDRStructureStore) throws IOException, StructureMismatchError {
        String string = this.opts.get("-d");
        String string2 = this.opts.get("-f");
        String string3 = this.opts.get("-k");
        String string4 = this.opts.get("-s");
        if (string3 == null) {
            File[] fileArray;
            File file = new File(string2);
            if (file.isDirectory()) {
                fileArray = file.listFiles();
            } else {
                fileArray = new File[]{file};
                file = file.getParentFile();
            }
            for (File file2 : fileArray) {
                if (file2.exists()) {
                    j9DDRStructureStore.add(null, file2.getPath(), false);
                    j9DDRStructureStore.updateSuperset();
                    System.out.println("Added " + file2.getName() + " to superset " + string4 + " in " + string);
                    continue;
                }
                System.out.println("WARNING : The specified structure file " + file2.getName() + " does not exist and was ignored");
            }
        } else {
            StructureKey structureKey = new StructureKey(string3);
            j9DDRStructureStore.add(structureKey, string2, true);
            j9DDRStructureStore.updateSuperset();
            System.out.format("Added %s to %s/%s as %s%n", string2, string, j9DDRStructureStore.getSuperSetFileName(), string3);
        }
    }

    private void addFromPropertiesFile(J9DDRStructureStore j9DDRStructureStore) throws IOException, StructureMismatchError {
        String string = this.opts.get("-d");
        String string2 = this.opts.get("-k");
        File file = new File(this.opts.get("-f"));
        String[] stringArray = this.loadSpecNames();
        File[] fileArray = new File[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            fileArray[i] = new File(file, stringArray[i]);
        }
        for (File file2 : fileArray) {
            if (file2.exists()) {
                StructureKey structureKey = new StructureKey(file2.getName() + "." + string2);
                j9DDRStructureStore.add(structureKey, file2.getPath(), false);
                j9DDRStructureStore.updateSuperset();
                System.out.format("Added %s to %s/%s as %s%n", file2.getAbsolutePath(), string, j9DDRStructureStore.getSuperSetFileName(), structureKey);
                continue;
            }
            System.out.println("WARNING : The specified structure file " + file2.getName() + " does not exist and was ignored");
        }
    }

    private void parseArgs(String[] stringArray) {
        if (stringArray.length == 0 || stringArray.length % 2 != 0) {
            System.out.println("Not enough options specified as program arguments");
            System.out.println(" args [" + stringArray.length + "]");
            AddStructureBlob.printHelp();
            System.exit(1);
        }
        for (int i = 0; i < stringArray.length; i += 2) {
            if (this.opts.containsKey(stringArray[i])) {
                this.opts.put(stringArray[i], stringArray[i + 1]);
                continue;
            }
            System.out.println("Invalid option : " + stringArray[i]);
            AddStructureBlob.printHelp();
            System.exit(1);
        }
        for (String string : this.opts.keySet()) {
            String string2 = this.opts.get(string);
            if (string2 != null || string.equals("-k") || string.equals("-s")) continue;
            System.err.println("The option " + string + " has not been set.\n");
            AddStructureBlob.printHelp();
            System.exit(1);
        }
    }

    private static void printHelp() {
        System.out.println("Usage :\n\njava AddStructureBlob -d <directory name> -f <structure file name> [-s <superset file name>] [-k <structure key>]\n");
    }
}

