/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools;

import com.ibm.j9ddr.BytecodeGenerator;
import com.ibm.j9ddr.CTypeParser;
import com.ibm.j9ddr.StructureReader;
import com.ibm.j9ddr.StructureTypeManager;
import com.ibm.j9ddr.tools.FlagStructureList;
import com.ibm.j9ddr.tools.store.J9DDRStructureStore;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PointerGenerator {
    private static final String BEGIN_USER_IMPORTS = "[BEGIN USER IMPORTS]";
    private static final String END_USER_IMPORTS = "[END USER IMPORTS]";
    private static final String BEGIN_USER_CODE = "[BEGIN USER CODE]";
    private static final String END_USER_CODE = "[END USER CODE]";
    private final Map<String, String> opts = new HashMap<String, String>();
    StructureReader structureReader;
    File outputDir;
    File outputDirHelpers;
    private boolean cacheClass;
    private boolean cacheFields;
    private boolean generalizeSimpleTypes;
    private Properties cacheProperties;
    private int errorCount;
    private StructureTypeManager typeManager;
    private static final Pattern offsetPattern = Pattern.compile("^(.+)_v\\d+$");
    private static final Pattern ConstPattern = Pattern.compile("\\s*\\bconst\\s+");
    private static final Pattern TypeTagPattern = Pattern.compile("\\s*\\b(class|enum|struct)\\s+");

    public PointerGenerator() {
        this.opts.put("-p", null);
        this.opts.put("-o", null);
        this.opts.put("-f", null);
        this.opts.put("-v", null);
        this.opts.put("-s", "superset.dat");
        this.opts.put("-h", null);
        this.opts.put("-u", "true");
        this.opts.put("-c", "");
        this.opts.put("-l", "false");
        this.opts.put("-a", null);
    }

    public static void main(String[] stringArray) throws Exception {
        PointerGenerator pointerGenerator = new PointerGenerator();
        pointerGenerator.parseArgs(stringArray);
        pointerGenerator.generateClasses();
        if (pointerGenerator.errorCount == 0) {
            System.out.println("Pointer class generation complete");
        } else {
            System.out.println("Pointer class generation failed");
            System.exit(1);
        }
    }

    private void generateClasses() {
        Object object2;
        Object object3;
        String string = this.opts.get("-f");
        String string2 = this.opts.get("-s");
        try {
            object3 = new J9DDRStructureStore(string, string2);
            System.out.println("superset directory name : " + string);
            System.out.println("superset file name : " + ((J9DDRStructureStore)object3).getSuperSetFileName());
            object2 = ((J9DDRStructureStore)object3).getSuperset();
            Throwable object4 = null;
            try {
                this.structureReader = new StructureReader((InputStream)object2);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                throw throwable;
            }
            finally {
                if (object2 != null) {
                    if (object4 != null) {
                        try {
                            ((InputStream)object2).close();
                        }
                        catch (Throwable iOException) {
                            object4.addSuppressed(iOException);
                        }
                    } else {
                        ((InputStream)object2).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            ++this.errorCount;
            System.out.println("Problem with file: " + string);
            iOException.printStackTrace();
            return;
        }
        this.structureReader.removeReservedTypeNames();
        object3 = this.opts.get("-a");
        if (object3 != null) {
            try {
                object2 = new FileInputStream((String)object3);
                Throwable throwable = null;
                try {
                    this.structureReader.loadAuxFieldInfo((InputStream)object2);
                }
                catch (Throwable throwable3) {
                    Throwable throwable4 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (object2 != null) {
                        if (throwable != null) {
                            try {
                                ((InputStream)object2).close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            ((InputStream)object2).close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                ++this.errorCount;
                System.out.println("Problem with file: " + (String)object3);
                iOException.printStackTrace();
                return;
            }
        }
        this.outputDir = this.getOutputDir("-p");
        if (this.opts.get("-h") != null) {
            this.outputDirHelpers = this.getOutputDir("-h");
        }
        this.typeManager = new StructureTypeManager(this.structureReader.getStructures());
        for (StructureReader.StructureDescriptor structureDescriptor : this.structureReader.getStructures()) {
            String string3;
            try {
                if (FlagStructureList.isFlagsStructure(structureDescriptor.getName())) {
                    this.generateBuildFlags(structureDescriptor);
                    continue;
                }
                this.generateClass(structureDescriptor);
            }
            catch (FileNotFoundException fileNotFoundException) {
                ++this.errorCount;
                string3 = String.format("File not found processing: %s: %s", structureDescriptor.getPointerName(), fileNotFoundException.getMessage());
                System.out.println(string3);
            }
            catch (IOException iOException) {
                ++this.errorCount;
                string3 = String.format("IOException processing: %s: %s", structureDescriptor.getPointerName(), iOException.getMessage());
                System.out.println(string3);
            }
        }
    }

    private void generateBuildFlags(StructureReader.StructureDescriptor structureDescriptor) throws IOException {
        Object object;
        Object object2;
        Closeable closeable;
        String string = structureDescriptor.getName();
        boolean bl = "29".equals(this.opts.get("-v")) && BytecodeGenerator.shouldUseCNameFor(string);
        File file = new File(this.outputDir, string + ".java");
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        this.collectMergeData(file, arrayList, arrayList2);
        byte[] byArray = null;
        int n = 0;
        if (file.exists()) {
            n = (int)file.length();
            byArray = new byte[n];
            closeable = new FileInputStream(file);
            object2 = null;
            try {
                ((FileInputStream)closeable).read(byArray);
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                if (closeable != null) {
                    if (object2 != null) {
                        try {
                            ((FileInputStream)closeable).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object2).addSuppressed(throwable);
                        }
                    } else {
                        ((FileInputStream)closeable).close();
                    }
                }
            }
        }
        closeable = new ByteArrayOutputStream(n);
        object2 = new PrintWriter((OutputStream)closeable);
        Object object3 = null;
        try {
            object = structureDescriptor.getConstants();
            PointerGenerator.writeCopyright((PrintWriter)object2);
            ((PrintWriter)object2).format("package %s;%n", this.opts.get("-p"));
            PointerGenerator.writeBuildFlagImports((PrintWriter)object2, bl);
            ((PrintWriter)object2).println();
            this.writeClassComment((PrintWriter)object2, string);
            ((PrintWriter)object2).format("public final class %s {%n", string);
            ((PrintWriter)object2).println();
            ((PrintWriter)object2).println("\t// Do not instantiate constant classes");
            ((PrintWriter)object2).format("\tprivate %s() {%n", string);
            ((PrintWriter)object2).format("\t}%n", new Object[0]);
            ((PrintWriter)object2).println();
            PointerGenerator.writeBuildFlags((PrintWriter)object2, object, bl);
            ((PrintWriter)object2).println();
            PointerGenerator.writeBuildFlagsStaticInitializer((PrintWriter)object2, string, object, bl);
            ((PrintWriter)object2).println("}");
        }
        catch (Throwable throwable) {
            object3 = throwable;
            throw throwable;
        }
        finally {
            if (object2 != null) {
                if (object3 != null) {
                    try {
                        ((PrintWriter)object2).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object3).addSuppressed(throwable);
                    }
                } else {
                    ((PrintWriter)object2).close();
                }
            }
        }
        object2 = ((ByteArrayOutputStream)closeable).toByteArray();
        if (null == byArray || !Arrays.equals(byArray, (byte[])object2)) {
            object3 = new FileOutputStream(file);
            object = null;
            try {
                ((FileOutputStream)object3).write((byte[])object2);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (object3 != null) {
                    if (object != null) {
                        try {
                            ((FileOutputStream)object3).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((FileOutputStream)object3).close();
                    }
                }
            }
        }
    }

    private static void writeBuildFlagsStaticInitializer(PrintWriter printWriter, String string, List<StructureReader.ConstantDescriptor> list, boolean bl) {
        printWriter.println("\tstatic {");
        printWriter.println("\t\tHashSet<String> flags$ = new HashSet<>();");
        printWriter.println();
        printWriter.println("\t\ttry {");
        printWriter.println("\t\t\tClassLoader loader$ = " + string + ".class.getClassLoader();");
        printWriter.println("\t\t\tif (!(loader$ instanceof com.ibm.j9ddr.J9DDRClassLoader)) {");
        printWriter.println("\t\t\t\tthrow new IllegalArgumentException(\"Cannot determine the runtime loader\");");
        printWriter.println("\t\t\t}");
        printWriter.println("\t\t\tClass<?> runtimeClass = ((com.ibm.j9ddr.J9DDRClassLoader) loader$).loadClassRelativeToStream(\"structure." + string + "\", false);");
        printWriter.println("\t\t\tfor (Field field : runtimeClass.getFields()) {");
        printWriter.println("\t\t\t\tif (field.getLong(runtimeClass) != 0) {");
        if (bl) {
            printWriter.println("\t\t\t\t\tflags$.add(BytecodeGenerator.getFlagCName(field.getName()));");
        } else {
            printWriter.println("\t\t\t\t\tflags$.add(field.getName());");
        }
        printWriter.println("\t\t\t\t}");
        printWriter.println("\t\t\t}");
        printWriter.println("\t\t} catch (ClassNotFoundException | IllegalAccessException e) {");
        printWriter.println("\t\t\tthrow new IllegalArgumentException(String.format(\"Can not initialize flags from core file.%n%s\", e.getMessage()));");
        printWriter.println("\t\t}");
        printWriter.println();
        for (StructureReader.ConstantDescriptor constantDescriptor : list) {
            String string2 = constantDescriptor.getName();
            String string3 = bl ? BytecodeGenerator.getFlagCName(string2) : string2;
            printWriter.format("\t\t%s = flags$.contains(\"%s\")", string3, string3);
            if (bl && !string2.equals(string3)) {
                printWriter.format(" || flags$.contains(\"%s\")", string2);
            }
            printWriter.println(";");
        }
        printWriter.println("\t}");
    }

    private void generateClass(StructureReader.StructureDescriptor structureDescriptor) throws IOException {
        Object object;
        Object object2;
        Closeable closeable;
        File file = new File(this.outputDir, structureDescriptor.getPointerName() + ".java");
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (this.opts.get("-u").equals("true")) {
            this.collectMergeData(file, arrayList, arrayList2);
        } else {
            this.setCacheStatusFromPropertyFile(structureDescriptor);
        }
        if (this.cacheClass || this.cacheFields) {
            System.out.println("Caching enabled for " + structureDescriptor.getName() + "=" + this.cacheClass + "," + this.cacheFields);
        }
        int n = 0;
        byte[] byArray = null;
        if (file.exists()) {
            n = (int)file.length();
            byArray = new byte[n];
            closeable = new FileInputStream(file);
            object2 = null;
            try {
                ((FileInputStream)closeable).read(byArray);
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                if (closeable != null) {
                    if (object2 != null) {
                        try {
                            ((FileInputStream)closeable).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object2).addSuppressed(throwable);
                        }
                    } else {
                        ((FileInputStream)closeable).close();
                    }
                }
            }
        }
        closeable = new ByteArrayOutputStream(n);
        object2 = new PrintWriter((OutputStream)closeable);
        Object object3 = null;
        try {
            PointerGenerator.writeCopyright((PrintWriter)object2);
            ((PrintWriter)object2).println();
            this.writeGeneratedWarning((PrintWriter)object2);
            ((PrintWriter)object2).format("package %s;%n", this.opts.get("-p"));
            ((PrintWriter)object2).println();
            if (this.opts.get("-u").equals("true")) {
                PointerGenerator.writerUserData(BEGIN_USER_IMPORTS, END_USER_IMPORTS, arrayList, (PrintWriter)object2);
            }
            ((PrintWriter)object2).println();
            this.writeImports((PrintWriter)object2, structureDescriptor);
            ((PrintWriter)object2).println();
            this.writeClassComment((PrintWriter)object2, structureDescriptor.getPointerName());
            ((PrintWriter)object2).format("@com.ibm.j9ddr.GeneratedPointerClass(structureClass=%s.class)", structureDescriptor.getName());
            ((PrintWriter)object2).println();
            object = structureDescriptor.getSuperName();
            if (((String)object).isEmpty()) {
                object = "Structure";
            }
            ((PrintWriter)object2).format("public class %s extends %sPointer {%n", structureDescriptor.getPointerName(), object);
            ((PrintWriter)object2).println();
            ((PrintWriter)object2).println("\t// NULL");
            ((PrintWriter)object2).format("\tpublic static final %s NULL = new %s(0);%n", structureDescriptor.getPointerName(), structureDescriptor.getPointerName());
            ((PrintWriter)object2).println();
            if (this.cacheClass) {
                ((PrintWriter)object2).println("\t// Class Cache");
                if (this.opts.get("-u").equals("false")) {
                    ((PrintWriter)object2).println("\tprivate static final boolean CACHE_CLASS = true;");
                }
                ((PrintWriter)object2).format("\tprivate static HashMap<Long, %s> CLASS_CACHE = new HashMap<>();%n", structureDescriptor.getPointerName());
                ((PrintWriter)object2).println();
            }
            if (this.cacheFields && this.opts.get("-u").equals("false")) {
                ((PrintWriter)object2).println("\tprivate static final boolean CACHE_FIELDS = true;");
            }
            if (this.opts.get("-u").equals("true")) {
                PointerGenerator.writerUserData(BEGIN_USER_CODE, END_USER_CODE, arrayList2, (PrintWriter)object2);
            }
            ((PrintWriter)object2).println();
            this.writeConstructor((PrintWriter)object2, structureDescriptor);
            if (this.cacheClass) {
                ((PrintWriter)object2).println("\t// Caching support methods");
                ((PrintWriter)object2).println();
                this.generateCacheSupportMethods((PrintWriter)object2, structureDescriptor);
            }
            ((PrintWriter)object2).println("\t// Implementation methods");
            ((PrintWriter)object2).println();
            this.generateImplementationMethods((PrintWriter)object2, structureDescriptor);
            ((PrintWriter)object2).println("}");
        }
        catch (Throwable throwable) {
            object3 = throwable;
            throw throwable;
        }
        finally {
            if (object2 != null) {
                if (object3 != null) {
                    try {
                        ((PrintWriter)object2).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object3).addSuppressed(throwable);
                    }
                } else {
                    ((PrintWriter)object2).close();
                }
            }
        }
        object2 = ((ByteArrayOutputStream)closeable).toByteArray();
        if (null == byArray || !Arrays.equals(byArray, (byte[])object2)) {
            object3 = new FileOutputStream(file);
            object = null;
            try {
                ((FileOutputStream)object3).write((byte[])object2);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (object3 != null) {
                    if (object != null) {
                        try {
                            ((FileOutputStream)object3).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((FileOutputStream)object3).close();
                    }
                }
            }
        }
        if (this.outputDirHelpers != null && arrayList2.size() > 4) {
            object3 = new File(this.outputDirHelpers, structureDescriptor.getPointerName() + ".java");
            object = new PrintWriter((File)object3);
            Throwable throwable = null;
            try {
                for (String string : arrayList) {
                    ((PrintWriter)object).println(string);
                }
                for (String string : arrayList2) {
                    ((PrintWriter)object).println(string);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((PrintWriter)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((PrintWriter)object).close();
                    }
                }
            }
        }
    }

    private void setCacheStatusFromPropertyFile(StructureReader.StructureDescriptor structureDescriptor) {
        String string = this.opts.get("-c");
        if (string == null || string.isEmpty()) {
            this.cacheClass = false;
            this.cacheFields = false;
        } else {
            Object object;
            Object object2;
            Object object3;
            block19: {
                if (this.cacheProperties == null) {
                    this.cacheProperties = new Properties();
                    object3 = new File(string);
                    if (((File)object3).exists()) {
                        try {
                            object2 = new FileInputStream((File)object3);
                            object = null;
                            try {
                                this.cacheProperties.load((InputStream)object2);
                                break block19;
                            }
                            catch (Throwable throwable) {
                                object = throwable;
                                throw throwable;
                            }
                            finally {
                                if (object2 != null) {
                                    if (object != null) {
                                        try {
                                            ((FileInputStream)object2).close();
                                        }
                                        catch (Throwable throwable) {
                                            ((Throwable)object).addSuppressed(throwable);
                                        }
                                    } else {
                                        ((FileInputStream)object2).close();
                                    }
                                }
                            }
                        }
                        catch (Exception exception) {
                            String string2 = String.format("The cache properties file [%s] specified by the -c option could not be read", ((File)object3).getAbsolutePath());
                            throw new IllegalArgumentException(string2, exception);
                        }
                    }
                    String string3 = String.format("The cache properties file [%s] specified by the -c option does not exist", ((File)object3).getAbsolutePath());
                    throw new IllegalArgumentException(string3);
                }
            }
            if (((String[])(object2 = ((String)(object3 = this.cacheProperties.getProperty(structureDescriptor.getName(), "false,false"))).split(","))).length != 2) {
                object = String.format("The cache properties file [%s] contains an invalid setting for the key [%s]. The value should be in the format <boolean>,<boolean>", string);
                throw new IllegalArgumentException((String)object);
            }
            this.cacheClass = Boolean.parseBoolean(object2[0]);
            this.cacheFields = Boolean.parseBoolean(object2[1]);
        }
    }

    private void generateCacheSupportMethods(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor) {
        if (this.cacheClass) {
            printWriter.format("\tprivate static void setCache(Long address, %s clazz) {%n", structureDescriptor.getPointerName());
            printWriter.format("\t\tCLASS_CACHE.put(address, clazz);%n", new Object[0]);
            printWriter.format("\t}%n", new Object[0]);
            printWriter.println();
            printWriter.format("\tprivate static %s checkCache(Long address) {%n", structureDescriptor.getPointerName());
            printWriter.format("\t\treturn CLASS_CACHE.get(address);%n", new Object[0]);
            printWriter.format("\t}%n", new Object[0]);
            printWriter.println();
        }
    }

    private static void writeBuildFlags(PrintWriter printWriter, List<StructureReader.ConstantDescriptor> list, boolean bl) {
        printWriter.println("\t// Build Flags");
        for (StructureReader.ConstantDescriptor constantDescriptor : list) {
            String string = constantDescriptor.getName();
            if (bl) {
                string = BytecodeGenerator.getFlagCName(string);
            }
            printWriter.format("\tpublic static final boolean %s;%n", string);
        }
    }

    private void collectMergeData(File file, List<String> list, List<String> list2) throws IOException {
        if (file.exists()) {
            Throwable object = null;
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
                String n;
                while ((n = bufferedReader.readLine()) != null) {
                    if (n.contains(BEGIN_USER_IMPORTS)) {
                        PointerGenerator.collectUserData(list, bufferedReader, END_USER_IMPORTS);
                        continue;
                    }
                    if (!n.contains(BEGIN_USER_CODE)) continue;
                    PointerGenerator.collectUserData(list2, bufferedReader, END_USER_CODE);
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                throw throwable;
            }
        }
        this.cacheClass = false;
        this.cacheFields = false;
        for (String string : list2) {
            int n = 0;
            n = string.indexOf("private static final boolean CACHE_FIELDS");
            if (n != -1) {
                this.cacheFields |= PointerGenerator.getFlagValue(string, n);
            }
            if ((n = string.indexOf("private static final boolean CACHE_CLASS")) == -1) continue;
            this.cacheClass |= PointerGenerator.getFlagValue(string, n);
        }
    }

    private static boolean getFlagValue(String string, int n) {
        int n2;
        int n3 = string.indexOf("=", n);
        if (n3 != -1 && (n2 = string.indexOf(";", n3)) != -1) {
            String string2 = string.substring(n3 + 1, n2).trim();
            return Boolean.parseBoolean(string2);
        }
        return false;
    }

    private static void collectUserData(List<String> list, BufferedReader bufferedReader, String string) throws IOException {
        String string2;
        while ((string2 = bufferedReader.readLine()) != null && !string2.contains(string)) {
            list.add(string2);
        }
    }

    private static void writerUserData(String string, String string2, List<String> list, PrintWriter printWriter) {
        printWriter.print("/*");
        printWriter.print(string);
        printWriter.println("*/");
        for (String string3 : list) {
            printWriter.println(string3);
        }
        printWriter.print("/*");
        printWriter.print(string2);
        printWriter.println("*/");
    }

    private void writeGeneratedWarning(PrintWriter printWriter) {
        printWriter.println("/*");
        printWriter.println(" * WARNING!!! GENERATED FILE");
        printWriter.println(" *");
        printWriter.println(" * This class is generated.");
        printWriter.println(" * Do not use the Eclipse \"Organize Imports\" feature on this class.");
        if (this.opts.get("-u").equals("true")) {
            printWriter.println(" *");
            printWriter.println(" * It can contain user content, but that content must be delimited with the");
            printWriter.println(" * the tags");
            printWriter.println(" * [BEGIN USER IMPORTS]");
            printWriter.println(" * [END USER IMPORTS]");
            printWriter.println(" *");
            printWriter.println(" * or");
            printWriter.println(" *");
            printWriter.println(" * [BEGIN USER CODE]");
            printWriter.println(" * [END USER CODE]");
            printWriter.println(" *");
            printWriter.println(" * These tags are entered as comments.  Characters before [ and after ] are ignored.");
            printWriter.println(" * Lines between the tags are inserted into the newly generated file.");
            printWriter.println(" *");
            printWriter.println(" * IMPORTS are combined and inserted above newly generated imports.  CODE is combined");
            printWriter.println(" * and inserted immediately after the class declaration");
            printWriter.println(" *");
            printWriter.println(" * All lines outside these tags are lost and replaced with newly generated code.");
        }
        printWriter.println(" */");
    }

    private void writeClassComment(PrintWriter printWriter, String string) {
        printWriter.println("/**");
        printWriter.format(" * Structure: %s%n", string);
        printWriter.println(" *");
        printWriter.println(" * A generated implementation of a VM structure");
        printWriter.println(" *");
        if (this.opts.get("-u").equals("true")) {
            printWriter.println(" * This class contains generated code and MAY contain hand written user code.");
            printWriter.println(" *");
            printWriter.println(" * Hand written user code must be contained at the top of");
            printWriter.println(" * the class file, specifically above");
            printWriter.println(" * the comment line containing WARNING!!! GENERATED CODE");
            printWriter.println(" *");
            printWriter.println(" * ALL code below the GENERATED warning will be replaced with new generated code");
            printWriter.println(" * each time the PointerGenerator utility is run.");
            printWriter.println(" *");
            printWriter.format(" * The generated code will provide getters for all elements in the %s%n", string);
            printWriter.println(" * structure.  Where possible, meaningful return types are inferred.");
            printWriter.println(" *");
            printWriter.println(" * The user may add methods to provide meaningful return types where only pointers");
            printWriter.println(" * could be automatically inferred.");
        } else {
            printWriter.println(" * Do not place hand written user code in this class as it will be overwritten.");
        }
        printWriter.println(" */");
    }

    private void generateImplementationMethods(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor) {
        List<StructureReader.FieldDescriptor> list = structureDescriptor.getFields();
        Collections.sort(list);
        block23: for (StructureReader.FieldDescriptor fieldDescriptor : list) {
            if (PointerGenerator.omitFieldImplementation(structureDescriptor, fieldDescriptor)) continue;
            if (fieldDescriptor.isRequired() && !fieldDescriptor.isPresent()) {
                ++this.errorCount;
                System.out.printf("Missing required field: %s.%s%n", structureDescriptor.getName(), fieldDescriptor.getName());
                continue;
            }
            String string = fieldDescriptor.getType();
            int n = this.typeManager.getType(string);
            switch (n) {
                case 120: {
                    this.writeStructureMethod(printWriter, structureDescriptor, fieldDescriptor);
                    continue block23;
                }
                case 121: {
                    this.writeStructurePointerMethod(printWriter, structureDescriptor, fieldDescriptor);
                    continue block23;
                }
                case 110: {
                    this.writePointerMethod(printWriter, structureDescriptor, fieldDescriptor);
                    continue block23;
                }
                case 113: {
                    this.writeArrayMethod(printWriter, structureDescriptor, fieldDescriptor);
                    continue block23;
                }
                case 111: {
                    this.writeSRPMethod(printWriter, structureDescriptor, fieldDescriptor, false);
                    continue block23;
                }
                case 112: {
                    this.writeSRPMethod(printWriter, structureDescriptor, fieldDescriptor, true);
                    continue block23;
                }
                case 114: {
                    this.writeSRPPointerMethod(printWriter, structureDescriptor, fieldDescriptor, false);
                    continue block23;
                }
                case 115: {
                    this.writeSRPPointerMethod(printWriter, structureDescriptor, fieldDescriptor, true);
                    continue block23;
                }
                case 130: {
                    this.writeFJ9ObjectMethod(printWriter, structureDescriptor, fieldDescriptor);
                    continue block23;
                }
                case 131: {
                    this.writeFJ9ObjectPointerMethod(printWriter, structureDescriptor, fieldDescriptor);
                    continue block23;
                }
                case 132: {
                    this.writeJ9ObjectClassMethod(printWriter, structureDescriptor, fieldDescriptor);
                    continue block23;
                }
                case 133: {
                    this.writeJ9ObjectClassPointerMethod(printWriter, structureDescriptor, fieldDescriptor);
                    continue block23;
                }
                case 134: {
                    this.writeJ9ObjectMonitorMethod(printWriter, structureDescriptor, fieldDescriptor);
                    continue block23;
                }
                case 135: {
                    this.writeJ9ObjectMonitorPointerMethod(printWriter, structureDescriptor, fieldDescriptor);
                    continue block23;
                }
                case 0: {
                    this.writeStructureMethod(printWriter, structureDescriptor, fieldDescriptor);
                    continue block23;
                }
                case 100: {
                    this.writeBoolMethod(printWriter, structureDescriptor, fieldDescriptor);
                    continue block23;
                }
                case 102: {
                    this.writeDoubleMethod(printWriter, structureDescriptor, fieldDescriptor);
                    continue block23;
                }
                case 103: {
                    this.writeFloatMethod(printWriter, structureDescriptor, fieldDescriptor);
                    continue block23;
                }
                case 101: {
                    this.writeEnumMethod(printWriter, structureDescriptor, fieldDescriptor);
                    continue block23;
                }
                case 105: {
                    this.writeEnumPointerMethod(printWriter, structureDescriptor, fieldDescriptor);
                    continue block23;
                }
                case 104: {
                    int n2 = string.indexOf(58);
                    if (n2 == -1) {
                        throw new IllegalArgumentException(String.format("%s is not a bitfield", fieldDescriptor));
                    }
                    this.writeBitFieldMethod(printWriter, structureDescriptor, fieldDescriptor, fieldDescriptor.getName());
                    continue block23;
                }
            }
            if (1 <= n && n <= 99) {
                this.writeSimpleTypeMethod(printWriter, structureDescriptor, fieldDescriptor, n);
                continue;
            }
            String string2 = String.format("Unhandled structure type: %s->%s %s", structureDescriptor.getPointerName(), fieldDescriptor.getName(), string);
            System.out.println(string2);
        }
    }

    private void writeSRPPointerMethod(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor, StructureReader.FieldDescriptor fieldDescriptor, boolean bl) {
        String string;
        String string2 = fieldDescriptor.getName();
        String string3 = string = bl ? "WideSelfRelativePointer" : "SelfRelativePointer";
        if (this.cacheFields) {
            printWriter.format("\tprivate %s %s_cache;%n", string, string2);
        }
        this.writeMethodSignature(printWriter, string, string2, fieldDescriptor, true);
        this.writeMethodReturn(printWriter, string2, "%s.cast(getPointerAtOffset(%s._%sOffset_))", string, structureDescriptor.getName(), this.getOffsetConstant(fieldDescriptor));
        PointerGenerator.writeMethodClose(printWriter, fieldDescriptor);
        this.writeEAMethod(printWriter, "PointerPointer", structureDescriptor, fieldDescriptor);
    }

    private void writeBitFieldMethod(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor, StructureReader.FieldDescriptor fieldDescriptor, String string) {
        CTypeParser cTypeParser = new CTypeParser(fieldDescriptor.getType());
        String string2 = cTypeParser.getCoreType();
        if (string.isEmpty()) {
            printWriter.format("\t// %s %s%n", fieldDescriptor.getDeclaredType(), fieldDescriptor.getName());
            printWriter.println();
            return;
        }
        if (this.cacheFields) {
            printWriter.format("\tprivate %s %s_cache;%n", string2, string);
        }
        this.writeMethodSignature(printWriter, this.generalizeSimpleType(string2), string, fieldDescriptor, true);
        this.writeMethodReturn(printWriter, string, "get%sBitfield(%s._%s_s_, %s._%s_b_)", string2, structureDescriptor.getName(), string, structureDescriptor.getName(), string);
        PointerGenerator.writeMethodClose(printWriter, fieldDescriptor);
    }

    static boolean omitFieldImplementation(StructureReader.StructureDescriptor structureDescriptor, StructureReader.FieldDescriptor fieldDescriptor) {
        String string = structureDescriptor.getPointerName() + "." + fieldDescriptor.getName();
        return string.contains("#");
    }

    private void writeMethodSignature(PrintWriter printWriter, String string, String string2, StructureReader.FieldDescriptor fieldDescriptor, boolean bl) {
        boolean bl2;
        printWriter.format("\t// %s %s%n", fieldDescriptor.getDeclaredType(), fieldDescriptor.getDeclaredName());
        if (bl) {
            printWriter.format("\t@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName=\"_%sOffset_\", declaredType=\"%s\")", this.getOffsetConstant(fieldDescriptor), fieldDescriptor.getDeclaredType());
            printWriter.println();
        }
        String string3 = (bl2 = fieldDescriptor.isOptional()) ? "CorruptDataException, NoSuchFieldException" : "CorruptDataException";
        printWriter.format("\tpublic %s %s() throws %s {%n", string, string2, string3);
        if (bl2) {
            printWriter.println("\ttry {");
        }
    }

    private void writeEAMethod(PrintWriter printWriter, String string, StructureReader.StructureDescriptor structureDescriptor, StructureReader.FieldDescriptor fieldDescriptor) {
        String string2 = fieldDescriptor.getName() + "EA";
        if (this.cacheFields) {
            printWriter.format("\tprivate %s %s_cache;%n", string, string2);
        }
        this.writeMethodSignature(printWriter, this.generalizeSimplePointer(string), string2, fieldDescriptor, false);
        this.writeMethodReturn(printWriter, string2, "%s.cast(nonNullFieldEA(%s._%sOffset_))", string, structureDescriptor.getName(), this.getOffsetConstant(fieldDescriptor));
        PointerGenerator.writeMethodClose(printWriter, fieldDescriptor);
    }

    private void writeEnumEAMethod(PrintWriter printWriter, String string, StructureReader.StructureDescriptor structureDescriptor, StructureReader.FieldDescriptor fieldDescriptor) {
        String string2 = fieldDescriptor.getName() + "EA";
        if (this.cacheFields) {
            printWriter.format("\tprivate %s %s_cache;%n", string, string2);
        }
        this.writeMethodSignature(printWriter, string, string2, fieldDescriptor, false);
        this.writeMethodReturn(printWriter, string2, "%s.cast(nonNullFieldEA(%s._%sOffset_), %s.class)", string, structureDescriptor.getName(), this.getOffsetConstant(fieldDescriptor), PointerGenerator.getEnumType(fieldDescriptor.getType()));
        PointerGenerator.writeMethodClose(printWriter, fieldDescriptor);
    }

    private String getOffsetConstant(StructureReader.FieldDescriptor fieldDescriptor) {
        String string = fieldDescriptor.getName();
        if (this.opts.get("-l").equals("true")) {
            return PointerGenerator.getOffsetConstant(string);
        }
        return string;
    }

    public static String getOffsetConstant(String string) {
        Matcher matcher = offsetPattern.matcher(string);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return string;
    }

    private void writeSRPEAMethod(PrintWriter printWriter, String string, StructureReader.StructureDescriptor structureDescriptor, StructureReader.FieldDescriptor fieldDescriptor) {
        String string2 = fieldDescriptor.getName() + "EA";
        if (this.cacheFields) {
            printWriter.format("\tprivate %s %s_cache;%n", string, string2);
        }
        this.writeMethodSignature(printWriter, string, string2, fieldDescriptor, false);
        this.writeMethodReturn(printWriter, string2, "%s.cast(nonNullFieldEA(%s._%sOffset_))", string, structureDescriptor.getName(), this.getOffsetConstant(fieldDescriptor));
        PointerGenerator.writeMethodClose(printWriter, fieldDescriptor);
    }

    private static void writeMethodClose(PrintWriter printWriter, StructureReader.FieldDescriptor fieldDescriptor) {
        if (fieldDescriptor.isOptional()) {
            printWriter.println("\t} catch (NoClassDefFoundError | NoSuchFieldError e) {");
            printWriter.println("\t\tthrow new NoSuchFieldException();");
            printWriter.println("\t}");
        }
        printWriter.println("\t}");
        printWriter.println();
    }

    private void writePointerMethod(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor, StructureReader.FieldDescriptor fieldDescriptor) {
        String string = fieldDescriptor.getName();
        String string2 = PointerGenerator.getPointerType(fieldDescriptor.getType());
        if (this.cacheFields) {
            printWriter.format("\tprivate %s %s_cache;%n", string2, string);
        }
        this.writeMethodSignature(printWriter, this.generalizeSimplePointer(string2), string, fieldDescriptor, true);
        this.writeMethodReturn(printWriter, string, "%s.cast(getPointerAtOffset(%s._%sOffset_))", string2, structureDescriptor.getName(), this.getOffsetConstant(fieldDescriptor));
        PointerGenerator.writeMethodClose(printWriter, fieldDescriptor);
        this.writeEAMethod(printWriter, "PointerPointer", structureDescriptor, fieldDescriptor);
    }

    private static String getPointerType(String string) {
        int n;
        String string2 = ConstPattern.matcher(string).replaceAll("").trim();
        if (string2.indexOf(42, (n = string2.indexOf(42)) + 1) > 0) {
            return "PointerPointer";
        }
        if ((string2 = string2.substring(0, n).trim()).equals("bool")) {
            return "BoolPointer";
        }
        if (string2.equals("double")) {
            return "DoublePointer";
        }
        if (string2.equals("float")) {
            return "FloatPointer";
        }
        if (string2.equals("void")) {
            return "VoidPointer";
        }
        return string2 + "Pointer";
    }

    private void writeArrayMethod(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor, StructureReader.FieldDescriptor fieldDescriptor) {
        try {
            String string = fieldDescriptor.getType();
            String string2 = this.getArrayType(string);
            if (string2 == null) {
                String string3 = String.format("Unhandled array type: %s->%s %s", structureDescriptor.getPointerName(), fieldDescriptor.getName(), string);
                System.out.println(string3);
            } else if (string2.equals("EnumPointer")) {
                this.writeEnumEAMethod(printWriter, string2, structureDescriptor, fieldDescriptor);
            } else {
                this.writeEAMethod(printWriter, string2, structureDescriptor, fieldDescriptor);
            }
        }
        catch (RuntimeException runtimeException) {
            ++this.errorCount;
            if (this.errorCount < 100) {
                runtimeException.printStackTrace();
            }
            throw runtimeException;
        }
    }

    private static String getEnumType(String string) {
        int n = 0;
        int n2 = string.length();
        if (string.startsWith("enum ")) {
            n = "enum ".length();
        }
        if (string.endsWith("[]")) {
            n2 -= 2;
        }
        return string.substring(n, n2);
    }

    private String getArrayType(String string) {
        String string2 = string.substring(0, string.lastIndexOf(91)).trim();
        int n = this.typeManager.getType(string2);
        switch (n) {
            case 100: {
                return "BoolPointer";
            }
            case 101: {
                return "EnumPointer";
            }
            case 102: {
                return "DoublePointer";
            }
            case 103: {
                return "FloatPointer";
            }
            case 104: {
                break;
            }
            case 110: 
            case 113: 
            case 121: 
            case 131: 
            case 133: 
            case 135: {
                return "PointerPointer";
            }
            case 111: 
            case 112: {
                break;
            }
            case 120: {
                return PointerGenerator.removeTypeTags(string2) + "Pointer";
            }
            case 130: {
                return "ObjectReferencePointer";
            }
            case 132: {
                return "ObjectClassReferencePointer";
            }
            case 134: {
                return "ObjectMonitorReferencePointer";
            }
            default: {
                if (1 > n || n > 99) break;
                return string2 + "Pointer";
            }
        }
        return null;
    }

    private void writeBoolMethod(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor, StructureReader.FieldDescriptor fieldDescriptor) {
        String string = fieldDescriptor.getName();
        if (this.cacheFields) {
            printWriter.format("\tprivate Boolean %s_cache;%n", string);
        }
        this.writeMethodSignature(printWriter, "boolean", string, fieldDescriptor, true);
        this.writeMethodReturn(printWriter, string, "getBoolAtOffset(%s._%sOffset_)", structureDescriptor.getName(), this.getOffsetConstant(fieldDescriptor));
        PointerGenerator.writeMethodClose(printWriter, fieldDescriptor);
        this.writeEAMethod(printWriter, "BoolPointer", structureDescriptor, fieldDescriptor);
    }

    private void writeDoubleMethod(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor, StructureReader.FieldDescriptor fieldDescriptor) {
        String string = fieldDescriptor.getName();
        if (this.cacheFields) {
            printWriter.format("\tprivate Double %s_cache;%n", string);
        }
        this.writeMethodSignature(printWriter, "double", string, fieldDescriptor, true);
        this.writeMethodReturn(printWriter, string, "getDoubleAtOffset(%s._%sOffset_)", structureDescriptor.getName(), this.getOffsetConstant(fieldDescriptor));
        PointerGenerator.writeMethodClose(printWriter, fieldDescriptor);
        this.writeEAMethod(printWriter, "DoublePointer", structureDescriptor, fieldDescriptor);
    }

    private void writeEnumMethod(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor, StructureReader.FieldDescriptor fieldDescriptor) {
        String string = fieldDescriptor.getName();
        String string2 = this.getOffsetConstant(fieldDescriptor);
        String string3 = PointerGenerator.getEnumType(fieldDescriptor.getType());
        if (this.cacheFields) {
            printWriter.format("\tprivate Long %s_cache;%n", string);
        }
        this.writeMethodSignature(printWriter, "long", string, fieldDescriptor, true);
        String string4 = structureDescriptor.getName();
        if (this.cacheFields) {
            printWriter.format("\t\tif (CACHE_FIELDS) {%n", new Object[0]);
            printWriter.format("\t\t\tif (%s_cache == null) {%n", string);
            printWriter.format("\t\t\t\tif (%s.SIZEOF == 1) {%n", string3);
            printWriter.format("\t\t\t\t\t%s_cache = Long.valueOf(getByteAtOffset(%s._%sOffset_));%n", string, string4, string2);
            printWriter.format("\t\t\t\t} else if (%s.SIZEOF == 2) {%n", string3);
            printWriter.format("\t\t\t\t\t%s_cache = Long.valueOf(getShortAtOffset(%s._%sOffset_));%n", string, string4, string2);
            printWriter.format("\t\t\t\t} else if (%s.SIZEOF == 4) {%n", string3);
            printWriter.format("\t\t\t\t\t%s_cache = Long.valueOf(getIntAtOffset(%s._%sOffset_));%n", string, string4, string2);
            printWriter.format("\t\t\t\t} else if (%s.SIZEOF == 8) {%n", string3);
            printWriter.format("\t\t\t\t\t%s_cache = Long.valueOf(getLongAtOffset(%s._%sOffset_));%n", string, string4, string2);
            printWriter.format("\t\t\t\t} else {%n", new Object[0]);
            printWriter.format("\t\t\t\t\tthrow new IllegalArgumentException(\"Unexpected ENUM size in core file\");%n", new Object[0]);
            printWriter.format("\t\t\t\t}%n", new Object[0]);
            printWriter.format("\t\t\t}%n", new Object[0]);
            printWriter.format("\t\t\treturn %s_cache.longValue();%n", string);
            printWriter.format("\t\t}%n", new Object[0]);
        }
        printWriter.format("\t\tif (%s.SIZEOF == 1) {%n", string3);
        printWriter.format("\t\t\treturn getByteAtOffset(%s._%sOffset_);%n", string4, string2);
        printWriter.format("\t\t} else if (%s.SIZEOF == 2) {%n", string3);
        printWriter.format("\t\t\treturn getShortAtOffset(%s._%sOffset_);%n", string4, string2);
        printWriter.format("\t\t} else if (%s.SIZEOF == 4) {%n", string3);
        printWriter.format("\t\t\treturn getIntAtOffset(%s._%sOffset_);%n", string4, string2);
        printWriter.format("\t\t} else if (%s.SIZEOF == 8) {%n", string3);
        printWriter.format("\t\t\treturn getLongAtOffset(%s._%sOffset_);%n", string4, string2);
        printWriter.format("\t\t} else {%n", new Object[0]);
        printWriter.format("\t\t\tthrow new IllegalArgumentException(\"Unexpected ENUM size in core file\");%n", new Object[0]);
        printWriter.format("\t\t}%n", new Object[0]);
        PointerGenerator.writeMethodClose(printWriter, fieldDescriptor);
        this.writeEnumEAMethod(printWriter, "EnumPointer", structureDescriptor, fieldDescriptor);
    }

    private void writeEnumPointerMethod(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor, StructureReader.FieldDescriptor fieldDescriptor) {
        String string = fieldDescriptor.getName();
        String string2 = "EnumPointer";
        String string3 = fieldDescriptor.getType();
        String string4 = PointerGenerator.getEnumType(string3.substring(0, string3.indexOf(42)));
        if (this.cacheFields) {
            printWriter.format("\tprivate %s %s_cache;%n", string2, string);
        }
        this.writeMethodSignature(printWriter, string2, string, fieldDescriptor, true);
        this.writeMethodReturn(printWriter, string, "%s.cast(getPointerAtOffset(%s._%sOffset_), %s.class)", string2, structureDescriptor.getName(), this.getOffsetConstant(fieldDescriptor), string4);
        PointerGenerator.writeMethodClose(printWriter, fieldDescriptor);
        this.writeEAMethod(printWriter, "PointerPointer", structureDescriptor, fieldDescriptor);
    }

    private void writeFloatMethod(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor, StructureReader.FieldDescriptor fieldDescriptor) {
        String string = fieldDescriptor.getName();
        if (this.cacheFields) {
            printWriter.format("\tprivate Float %s_cache;%n", string);
        }
        this.writeMethodSignature(printWriter, "float", string, fieldDescriptor, true);
        this.writeMethodReturn(printWriter, string, "getFloatAtOffset(%s._%sOffset_)", structureDescriptor.getName(), this.getOffsetConstant(fieldDescriptor));
        PointerGenerator.writeMethodClose(printWriter, fieldDescriptor);
        this.writeEAMethod(printWriter, "FloatPointer", structureDescriptor, fieldDescriptor);
    }

    private String generalizeSimpleType(String string) {
        if (this.generalizeSimpleTypes) {
            if ("I32".equals(string) || "I64".equals(string)) {
                return "IDATA";
            }
            if ("U32".equals(string) || "U64".equals(string)) {
                return "UDATA";
            }
        }
        return string;
    }

    private String generalizeSimplePointer(String string) {
        if (this.generalizeSimpleTypes) {
            if ("I32Pointer".equals(string) || "I64Pointer".equals(string)) {
                return "IDATAPointer";
            }
            if ("U32Pointer".equals(string) || "U64Pointer".equals(string)) {
                return "UDATAPointer";
            }
        }
        return string;
    }

    private void writeSimpleTypeMethod(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor, StructureReader.FieldDescriptor fieldDescriptor, int n) {
        String string = fieldDescriptor.getName();
        String string2 = this.getOffsetConstant(fieldDescriptor);
        String string3 = fieldDescriptor.getType();
        String string4 = this.generalizeSimpleType(string3);
        if (this.cacheFields) {
            printWriter.format("\tprivate %s %s_cache;%n", string3, string);
        }
        this.writeMethodSignature(printWriter, string4, string, fieldDescriptor, true);
        String string5 = StructureTypeManager.simpleTypeAccessorMap.get(n);
        switch (n) {
            case 5: 
            case 10: {
                this.writeMethodReturn(printWriter, string, "%s(%s._%sOffset_)", string5, structureDescriptor.getName(), string2);
                break;
            }
            default: {
                this.writeMethodReturn(printWriter, string, "new %s(%s(%s._%sOffset_))", string3, string5, structureDescriptor.getName(), string2);
            }
        }
        PointerGenerator.writeMethodClose(printWriter, fieldDescriptor);
        this.writeEAMethod(printWriter, string4 + "Pointer", structureDescriptor, fieldDescriptor);
    }

    private static String removeTypeTags(String string) {
        return TypeTagPattern.matcher(string).replaceAll("").trim();
    }

    private void writeSRPMethod(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor, StructureReader.FieldDescriptor fieldDescriptor, boolean bl) {
        String string;
        String string2 = fieldDescriptor.getName();
        String string3 = this.getOffsetConstant(fieldDescriptor);
        String string4 = fieldDescriptor.getType();
        String string5 = bl ? "J9WSRP" : "J9SRP";
        int n = string5.length();
        String string6 = bl ? "getPointerAtOffset" : "getIntAtOffset";
        String string7 = null;
        string7 = string4.startsWith(string5) && string4.startsWith("(", n) ? string4.substring(n + 1, string4.length() - 1).trim() : "void";
        int n2 = this.typeManager.getType(string7);
        switch (n2) {
            case 120: {
                string = PointerGenerator.removeTypeTags(string7) + "Pointer";
                break;
            }
            case 0: {
                string = "VoidPointer";
                break;
            }
            case 111: {
                string = "SelfRelativePointer";
                break;
            }
            case 112: {
                string = "WideSelfRelativePointer";
                break;
            }
            default: {
                if (1 <= n2 && n2 <= 99) {
                    string = string7 + "Pointer";
                    break;
                }
                throw new RuntimeException("Unexpected SRP reference type: " + n2 + " from " + string4);
            }
        }
        if (this.cacheFields) {
            printWriter.format("\tprivate %s %s_cache;%n", string, string2);
        }
        this.writeMethodSignature(printWriter, this.generalizeSimplePointer(string), string2, fieldDescriptor, true);
        String string8 = String.format("%s.cast(address + (%s._%sOffset_ + nextAddress))", string, structureDescriptor.getName(), string3);
        if (this.cacheFields) {
            printWriter.format("\t\tif (CACHE_FIELDS) {%n", new Object[0]);
            printWriter.format("\t\t\tif (%s_cache == null) {%n", string2);
            printWriter.format("\t\t\t\tlong nextAddress = %s(%s._%sOffset_);%n", string6, structureDescriptor.getName(), string3);
            printWriter.format("\t\t\t\tif (nextAddress == 0) {%n", new Object[0]);
            printWriter.format("\t\t\t\t\t%s_cache = %s.NULL;%n", string2, string);
            printWriter.format("\t\t\t\t} else {%n", new Object[0]);
            printWriter.format("\t\t\t\t\t%s_cache = %s;%n", string2, string8);
            printWriter.format("\t\t\t\t}%n", new Object[0]);
            printWriter.format("\t\t\t}%n", new Object[0]);
            printWriter.format("\t\t\treturn %s_cache;%n", string2);
            printWriter.format("\t\t}%n", new Object[0]);
        }
        printWriter.format("\t\tlong nextAddress = %s(%s._%sOffset_);%n", string6, structureDescriptor.getName(), string3);
        printWriter.format("\t\tif (nextAddress == 0) {%n", new Object[0]);
        printWriter.format("\t\t\treturn %s.NULL;%n", string);
        printWriter.format("\t\t}%n", new Object[0]);
        printWriter.format("\t\treturn %s;%n", string8);
        PointerGenerator.writeMethodClose(printWriter, fieldDescriptor);
        this.writeSRPEAMethod(printWriter, bl ? "WideSelfRelativePointer" : "SelfRelativePointer", structureDescriptor, fieldDescriptor);
    }

    private void writeStructurePointerMethod(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor, StructureReader.FieldDescriptor fieldDescriptor) {
        String string = fieldDescriptor.getType();
        String string2 = string.substring(0, string.indexOf(42));
        String string3 = PointerGenerator.removeTypeTags(string2) + "Pointer";
        String string4 = fieldDescriptor.getName();
        if (this.cacheFields) {
            printWriter.format("\tprivate %s %s_cache;%n", string3, string4);
        }
        this.writeMethodSignature(printWriter, string3, string4, fieldDescriptor, true);
        this.writeMethodReturn(printWriter, string4, "%s.cast(getPointerAtOffset(%s._%sOffset_))", string3, structureDescriptor.getName(), this.getOffsetConstant(fieldDescriptor));
        PointerGenerator.writeMethodClose(printWriter, fieldDescriptor);
        this.writeEAMethod(printWriter, "PointerPointer", structureDescriptor, fieldDescriptor);
    }

    private void writeFJ9ObjectMethod(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor, StructureReader.FieldDescriptor fieldDescriptor) {
        String string = "J9ObjectPointer";
        String string2 = fieldDescriptor.getName();
        if (this.cacheFields) {
            printWriter.format("\tprivate %s %s_cache;%n", string, string2);
        }
        this.writeMethodSignature(printWriter, string, string2, fieldDescriptor, true);
        this.writeMethodReturn(printWriter, string2, "getObjectReferenceAtOffset(%s._%sOffset_)", structureDescriptor.getName(), this.getOffsetConstant(fieldDescriptor));
        PointerGenerator.writeMethodClose(printWriter, fieldDescriptor);
        this.writeEAMethod(printWriter, "ObjectReferencePointer", structureDescriptor, fieldDescriptor);
    }

    private void writeFJ9ObjectPointerMethod(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor, StructureReader.FieldDescriptor fieldDescriptor) {
        String string = "ObjectReferencePointer";
        String string2 = fieldDescriptor.getName();
        if (this.cacheFields) {
            printWriter.format("\tprivate %s %s_cache;%n", string, string2);
        }
        this.writeMethodSignature(printWriter, string, string2, fieldDescriptor, true);
        this.writeMethodReturn(printWriter, string2, "%s.cast(getPointerAtOffset(%s._%sOffset_))", string, structureDescriptor.getName(), this.getOffsetConstant(fieldDescriptor));
        PointerGenerator.writeMethodClose(printWriter, fieldDescriptor);
        this.writeEAMethod(printWriter, "PointerPointer", structureDescriptor, fieldDescriptor);
    }

    private void writeJ9ObjectClassMethod(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor, StructureReader.FieldDescriptor fieldDescriptor) {
        String string = "J9ClassPointer";
        String string2 = fieldDescriptor.getName();
        if (this.cacheFields) {
            printWriter.format("\tprivate %s %s_cache;%n", string, string2);
        }
        this.writeMethodSignature(printWriter, string, string2, fieldDescriptor, true);
        this.writeMethodReturn(printWriter, string2, "getObjectClassAtOffset(%s._%sOffset_)", structureDescriptor.getName(), this.getOffsetConstant(fieldDescriptor));
        PointerGenerator.writeMethodClose(printWriter, fieldDescriptor);
        this.writeEAMethod(printWriter, "ObjectClassReferencePointer", structureDescriptor, fieldDescriptor);
    }

    private void writeJ9ObjectClassPointerMethod(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor, StructureReader.FieldDescriptor fieldDescriptor) {
        String string = "ObjectClassReferencePointer";
        String string2 = fieldDescriptor.getName();
        this.writeMethodSignature(printWriter, string, string2, fieldDescriptor, true);
        printWriter.println("\t\t// j9objectclass_t* method goes here");
        printWriter.println("\t\treturn null;");
        PointerGenerator.writeMethodClose(printWriter, fieldDescriptor);
        this.writeEAMethod(printWriter, "PointerPointer", structureDescriptor, fieldDescriptor);
    }

    private void writeJ9ObjectMonitorMethod(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor, StructureReader.FieldDescriptor fieldDescriptor) {
        String string = "J9ObjectMonitorPointer";
        String string2 = fieldDescriptor.getName();
        if (this.cacheFields) {
            printWriter.format("\tprivate %s %s_cache;%n", string, string2);
        }
        this.writeMethodSignature(printWriter, string, string2, fieldDescriptor, true);
        this.writeMethodReturn(printWriter, string2, "getObjectMonitorAtOffset(%s._%sOffset_)", structureDescriptor.getName(), this.getOffsetConstant(fieldDescriptor));
        PointerGenerator.writeMethodClose(printWriter, fieldDescriptor);
        this.writeEAMethod(printWriter, "ObjectMonitorReferencePointer", structureDescriptor, fieldDescriptor);
    }

    private void writeJ9ObjectMonitorPointerMethod(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor, StructureReader.FieldDescriptor fieldDescriptor) {
        String string = "ObjectMonitorReferencePointer";
        String string2 = fieldDescriptor.getName();
        this.writeMethodSignature(printWriter, string, string2, fieldDescriptor, true);
        printWriter.println("\t\t// j9objectmonitor_t* method goes here");
        printWriter.println("\t\treturn null;");
        PointerGenerator.writeMethodClose(printWriter, fieldDescriptor);
        this.writeEAMethod(printWriter, "PointerPointer", structureDescriptor, fieldDescriptor);
    }

    private void writeStructureMethod(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor, StructureReader.FieldDescriptor fieldDescriptor) {
        String string = fieldDescriptor.getType();
        String string2 = string.equals("void") ? "VoidPointer" : PointerGenerator.removeTypeTags(string) + "Pointer";
        String string3 = fieldDescriptor.getName();
        if (this.cacheFields) {
            printWriter.format("\tprivate %s %s_cache;%n", string2, string3);
        }
        this.writeMethodSignature(printWriter, string2, string3, fieldDescriptor, true);
        this.writeMethodReturn(printWriter, string3, "%s.cast(nonNullFieldEA(%s._%sOffset_))", string2, structureDescriptor.getName(), this.getOffsetConstant(fieldDescriptor));
        PointerGenerator.writeMethodClose(printWriter, fieldDescriptor);
        this.writeEAMethod(printWriter, "PointerPointer", structureDescriptor, fieldDescriptor);
    }

    private void writeMethodReturn(PrintWriter printWriter, String string, String string2, Object ... objectArray) {
        String string3 = String.format(string2, objectArray);
        if (this.cacheFields) {
            printWriter.format("\t\tif (CACHE_FIELDS) {%n", new Object[0]);
            printWriter.format("\t\t\tif (%s_cache == null) {%n", string);
            printWriter.format("\t\t\t\t%s_cache = %s;%n", string, string3);
            printWriter.format("\t\t\t}%n", new Object[0]);
            printWriter.format("\t\t\treturn %s_cache;%n", string);
            printWriter.format("\t\t}%n", new Object[0]);
        }
        printWriter.format("\t\treturn %s;%n", string3);
    }

    private void writeConstructor(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor) {
        String string = structureDescriptor.getPointerName();
        String string2 = structureDescriptor.getName();
        printWriter.println("\t// Do not call this constructor.  Use static method cast instead.");
        printWriter.format("\tprotected %s(long address) {%n", string);
        printWriter.println("\t\tsuper(address);");
        printWriter.println("\t}");
        printWriter.println();
        printWriter.format("\tpublic static %s cast(AbstractPointer structure) {%n", string);
        printWriter.format("\t\treturn cast(structure.getAddress());%n", new Object[0]);
        printWriter.println("\t}");
        printWriter.println();
        printWriter.format("\tpublic static %s cast(UDATA udata) {%n", string);
        printWriter.format("\t\treturn cast(udata.longValue());%n", new Object[0]);
        printWriter.println("\t}");
        printWriter.println();
        printWriter.format("\tpublic static %s cast(long address) {%n", string);
        printWriter.format("\t\tif (address == 0) {%n", new Object[0]);
        printWriter.format("\t\t\treturn NULL;%n", new Object[0]);
        printWriter.format("\t\t}%n", new Object[0]);
        if (this.cacheClass) {
            printWriter.format("\t\tif (CACHE_CLASS) {%n", new Object[0]);
            printWriter.format("\t\t\t%s clazz = checkCache(address);%n", string);
            printWriter.format("\t\t\tif (null == clazz) {%n", new Object[0]);
            printWriter.format("\t\t\t\tclazz = new %s(address);%n", string, string);
            printWriter.format("\t\t\t\tsetCache(address, clazz);%n", new Object[0]);
            printWriter.format("\t\t\t}%n", new Object[0]);
            printWriter.format("\t\t\treturn clazz;%n", new Object[0]);
            printWriter.format("\t\t}%n", new Object[0]);
        }
        printWriter.format("\t\treturn new %s(address);%n", string, string);
        printWriter.println("\t}");
        printWriter.println();
        printWriter.format("\tpublic %s add(long count) {%n", string);
        printWriter.format("\t\treturn %s.cast(address + (%s.SIZEOF * count));%n", string, string2);
        printWriter.format("\t}%n", new Object[0]);
        printWriter.println();
        printWriter.format("\tpublic %s add(Scalar count) {%n", string);
        printWriter.format("\t\treturn add(count.longValue());%n", string);
        printWriter.format("\t}%n", new Object[0]);
        printWriter.println();
        printWriter.format("\tpublic %s addOffset(long offset) {%n", string);
        printWriter.format("\t\treturn %s.cast(address + offset);%n", string);
        printWriter.format("\t}%n", new Object[0]);
        printWriter.println();
        printWriter.format("\tpublic %s addOffset(Scalar offset) {%n", string);
        printWriter.format("\t\treturn addOffset(offset.longValue());%n", string);
        printWriter.format("\t}%n", new Object[0]);
        printWriter.println();
        printWriter.format("\tpublic %s sub(long count) {%n", string);
        printWriter.format("\t\treturn %s.cast(address - (%s.SIZEOF * count));%n", string, string2);
        printWriter.format("\t}%n", new Object[0]);
        printWriter.println();
        printWriter.format("\tpublic %s sub(Scalar count) {%n", string);
        printWriter.format("\t\treturn sub(count.longValue());%n", string);
        printWriter.format("\t}%n", new Object[0]);
        printWriter.println();
        printWriter.format("\tpublic %s subOffset(long offset) {%n", string);
        printWriter.format("\t\treturn %s.cast(address - offset);%n", string);
        printWriter.format("\t}%n", new Object[0]);
        printWriter.println();
        printWriter.format("\tpublic %s subOffset(Scalar offset) {%n", string);
        printWriter.format("\t\treturn subOffset(offset.longValue());%n", string);
        printWriter.format("\t}%n", new Object[0]);
        printWriter.println();
        printWriter.format("\tpublic %s untag(long mask) {%n", string);
        printWriter.format("\t\treturn %s.cast(address & ~mask);%n", string);
        printWriter.format("\t}%n", new Object[0]);
        printWriter.println();
        printWriter.format("\tpublic %s untag() {%n", string);
        printWriter.format("\t\treturn untag(UDATA.SIZEOF - 1);%n", new Object[0]);
        printWriter.format("\t}%n", new Object[0]);
        printWriter.println();
        printWriter.format("\tprotected long sizeOfBaseType() {%n", new Object[0]);
        printWriter.format("\t\treturn %s.SIZEOF;%n", string2);
        printWriter.format("\t}%n", new Object[0]);
        printWriter.println();
    }

    private void writeImports(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor) {
        if (structureDescriptor.getFields().size() > 0) {
            printWriter.println("import com.ibm.j9ddr.CorruptDataException;");
        }
        String string = this.opts.get("-v");
        printWriter.format("import com.ibm.j9ddr.vm%s.pointer.*;%n", string);
        printWriter.format("import com.ibm.j9ddr.vm%s.structure.*;%n", string);
        printWriter.format("import com.ibm.j9ddr.vm%s.types.*;%n", string);
        if (this.cacheClass) {
            printWriter.println("import java.util.HashMap;");
        }
    }

    private static void writeBuildFlagImports(PrintWriter printWriter, boolean bl) {
        printWriter.println();
        if (bl) {
            printWriter.println("import com.ibm.j9ddr.BytecodeGenerator;");
        }
        printWriter.println("import java.lang.reflect.Field;");
        printWriter.println("import java.util.HashSet;");
    }

    private void parseArgs(String[] stringArray) {
        if (stringArray.length == 0 || stringArray.length % 2 != 0) {
            PointerGenerator.printHelp();
            System.exit(1);
        }
        for (int i = 0; i < stringArray.length; i += 2) {
            if (this.opts.containsKey(stringArray[i])) {
                this.opts.put(stringArray[i], stringArray[i + 1]);
                continue;
            }
            System.out.println("Invalid option : " + stringArray[i]);
            PointerGenerator.printHelp();
            System.exit(1);
        }
        for (Map.Entry<String, String> entry : this.opts.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if (string2 != null || string.equals("-a") || string.equals("-h") || string.equals("-s")) continue;
            System.err.println("The option " + string + " has not been set.");
            PointerGenerator.printHelp();
            System.exit(1);
        }
        this.generalizeSimpleTypes = "29".equals(this.opts.get("-v"));
    }

    private static void printHelp() {
        System.out.println("Usage: PointerGenerator {option value} ...");
        System.out.println("  required:");
        System.out.println("    -p <package name>         : package name for generated classes, e.g. com.ibm.j9ddr.vm29.pointer.generated");
        System.out.println("    -o <output path>          : where to write class files (path to base of package hierarchy, e.g. C:\\src\\)");
        System.out.println("    -f <superset folder>      : folder containing superset file");
        System.out.println("    -v <vm version>           : VM version for which the pointers are generated, e.g. 29 (corresponds to the stub package name)");
        System.out.println("  optional:");
        System.out.println("    -s <superset file>        : superset file (default: superset.dat)");
        System.out.println("    -h <helper class package> : package for pointer helper files to be generated in from user code");
        System.out.println("    -u <user code support>    : enable user code support (true or false; default: true)");
        System.out.println("    -c <cache properties>     : cache control properties file");
        System.out.println("    -l <legacy mode>          : true or false indicating if legacy DDR is used");
        System.out.println("    -r <path>                 : path to superset file for restricting available constants");
        System.out.println("    -a <path>                 : path to auxiliary field information");
    }

    private File getOutputDir(String string) {
        String string2 = this.opts.get("-o").replace('\\', '/');
        if (!string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        string2 = string2 + this.opts.get(string).replace('.', '/');
        System.out.println("Writing generated classes to " + string2);
        File file = new File(string2);
        file.mkdirs();
        return file;
    }

    private static void writeCopyright(PrintWriter printWriter) {
        printWriter.println("/*");
        printWriter.println(" * Copyright IBM Corp. and others 1991");
        printWriter.println(" *");
        printWriter.println(" * This program and the accompanying materials are made available under");
        printWriter.println(" * the terms of the Eclipse Public License 2.0 which accompanies this");
        printWriter.println(" * distribution and is available at https://www.eclipse.org/legal/epl-2.0/");
        printWriter.println(" * or the Apache License, Version 2.0 which accompanies this distribution");
        printWriter.println(" * and is available at https://www.apache.org/licenses/LICENSE-2.0.");
        printWriter.println(" *");
        printWriter.println(" * This Source Code may also be made available under the following");
        printWriter.println(" * Secondary Licenses when the conditions for such availability set");
        printWriter.println(" * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU");
        printWriter.println(" * General Public License, version 2 with the GNU Classpath");
        printWriter.println(" * Exception [1] and GNU General Public License, version 2 with the");
        printWriter.println(" * OpenJDK Assembly Exception [2].");
        printWriter.println(" *");
        printWriter.println(" * [1] https://www.gnu.org/software/classpath/license.html");
        printWriter.println(" * [2] https://openjdk.org/legal/assembly-exception.html");
        printWriter.println(" *");
        printWriter.println(" * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0");
        printWriter.println(" */");
    }
}

