/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive;

import com.ibm.j9ddr.corereaders.memory.IMemoryRange;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import java.io.PrintStream;
import java.util.Collection;

public class MemoryRangesCommand
extends Command {
    public MemoryRangesCommand() {
        this.addCommand("ranges", "", "Prints list of available memory ranges");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        IProcess iProcess = context.process;
        String string2 = "0x%0" + iProcess.bytesPerPointer() * 2 + "x%" + (16 - iProcess.bytesPerPointer()) + "s";
        Collection<? extends IMemoryRange> collection = iProcess.getMemoryRanges();
        if (collection != null && !collection.isEmpty()) {
            printStream.println("Base                  Top                   Size");
            for (IMemoryRange iMemoryRange : collection) {
                printStream.format(string2, iMemoryRange.getBaseAddress(), " ");
                printStream.format(string2, iMemoryRange.getTopAddress(), " ");
                printStream.format(string2, iMemoryRange.getSize(), " ");
                printStream.println();
            }
        } else {
            printStream.println("No memory ranges found (Note: this has not yet been implemented for execution from a native debugger such as gdb)");
        }
    }
}

