/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive.commands;

import com.ibm.j9ddr.command.CommandParser;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;

public class ForeachCommand
extends Command {
    public static String[] foreachArgs = null;

    public ForeachCommand() {
        this.addCommand("foreach", "", "build up a list of elements to operate on ");
        this.addCommand("do", "<command>", "repeat a command for each element in the list");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        if (string.equals("!do")) {
            boolean bl = false;
            boolean bl2 = false;
            String string2 = null;
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals("help")) {
                    printStream.println("The !do command is used to repeat a command on the elements gathered by the !foreach command.");
                    printStream.println("Syntax:\t!do [echo] [quiet] [token=<token>] <cmd> [args]");
                    printStream.println();
                    printStream.println("\techo\t\tOutput each command before it is run.");
                    printStream.println("\tquiet\t\tSuppress delimiters between command outputs.");
                    printStream.println("\ttoken=<chars>\tSpecify a substitution token. Occurrencs of this string in the args will be replaced by the current element.");
                    return;
                }
                if (stringArray[n].equals("echo")) {
                    bl = true;
                    ++n;
                    continue;
                }
                if (stringArray[n].equals("quiet")) {
                    bl2 = true;
                    ++n;
                    continue;
                }
                if (!stringArray[n].startsWith("token=")) break;
                string2 = stringArray[n].substring("token=".length());
                ++n;
            }
            if (n >= stringArray.length) {
                printStream.println("The do command requires another command to repeat.");
                return;
            }
            if (null == foreachArgs || 0 == foreachArgs.length) {
                printStream.println("Element list is empty. Use the foreach command to populate it.");
                return;
            }
            for (int i = 0; i < foreachArgs.length; ++i) {
                if (!bl2 && i > 0) {
                    printStream.println("========================================");
                }
                try {
                    Object[] objectArray = null == string2 ? this.substituteArgs(stringArray, n, i) : this.substituteArgs(stringArray, n, i, string2);
                    if (bl) {
                        System.out.println("> " + stringArray[n] + " " + Arrays.toString(objectArray));
                    }
                    CommandParser commandParser = new CommandParser(stringArray[n], (String[])objectArray);
                    context.execute(commandParser, printStream);
                    continue;
                }
                catch (ParseException parseException) {
                    parseException.printStackTrace(printStream);
                    continue;
                }
                catch (Throwable throwable) {
                    printStream.println("Exception while executing " + stringArray[n] + " " + foreachArgs[i]);
                    throwable.printStackTrace(printStream);
                }
            }
        } else if (string.equals("!foreach")) {
            String[] stringArray2;
            if (stringArray.length > 0) {
                printStream.println("The !foreach command takes no arguments, but will read lines from the console until it encounters a blank line.");
                printStream.println("These lines can then be used as arguments to commands specified using !do.");
                return;
            }
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            while (true) {
                try {
                    stringArray2 = bufferedReader.readLine();
                }
                catch (IOException iOException) {
                    break;
                }
                if (0 == stringArray2.length()) break;
                arrayList.add(stringArray2);
            }
            stringArray2 = new String[arrayList.size()];
            arrayList.toArray(stringArray2);
            foreachArgs = stringArray2;
        }
    }

    private String[] substituteArgs(String[] stringArray, int n, int n2) {
        String[] stringArray2 = new String[stringArray.length - n];
        System.arraycopy(stringArray, n + 1, stringArray2, 0, stringArray.length - n - 1);
        stringArray2[stringArray2.length - 1] = foreachArgs[n2];
        return stringArray2;
    }

    private String[] substituteArgs(String[] stringArray, int n, int n2, String string) {
        String[] stringArray2 = new String[stringArray.length - n - 1];
        System.arraycopy(stringArray, n + 1, stringArray2, 0, stringArray.length - n - 1);
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = stringArray2[i].replace(string, foreachArgs[n2]);
        }
        return stringArray2;
    }
}

