/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.gc.GCIterator;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MonitorEnterRecordPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMThreadPointer;
import java.util.NoSuchElementException;

public class GCVMThreadMonitorRecordSlotIterator
extends GCIterator {
    protected J9MonitorEnterRecordPointer monitorRecord;
    protected J9MonitorEnterRecordPointer jniMonitorRecord;

    protected GCVMThreadMonitorRecordSlotIterator(J9VMThreadPointer j9VMThreadPointer) throws CorruptDataException {
        this.monitorRecord = j9VMThreadPointer.monitorEnterRecords();
        this.jniMonitorRecord = j9VMThreadPointer.jniMonitorEnterRecords();
    }

    public static GCVMThreadMonitorRecordSlotIterator fromJ9VMThread(J9VMThreadPointer j9VMThreadPointer) throws CorruptDataException {
        return new GCVMThreadMonitorRecordSlotIterator(j9VMThreadPointer);
    }

    @Override
    public boolean hasNext() {
        return this.monitorRecord.notNull() || this.jniMonitorRecord.notNull();
    }

    @Override
    public J9ObjectPointer next() {
        if (this.hasNext()) {
            try {
                J9ObjectPointer j9ObjectPointer;
                if (this.monitorRecord.notNull()) {
                    j9ObjectPointer = this.monitorRecord.object();
                    this.monitorRecord = this.monitorRecord.next();
                } else {
                    j9ObjectPointer = this.jniMonitorRecord.object();
                    this.jniMonitorRecord = this.jniMonitorRecord.next();
                }
                return j9ObjectPointer;
            }
            catch (CorruptDataException corruptDataException) {
                EventManager.raiseCorruptDataEvent("Error getting next item", corruptDataException, false);
                return null;
            }
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }

    @Override
    public VoidPointer nextAddress() {
        if (this.hasNext()) {
            try {
                VoidPointer voidPointer;
                if (this.monitorRecord.notNull()) {
                    voidPointer = VoidPointer.cast(this.monitorRecord.objectEA());
                    this.monitorRecord = this.monitorRecord.next();
                } else {
                    voidPointer = VoidPointer.cast(this.jniMonitorRecord.objectEA());
                    this.jniMonitorRecord = this.jniMonitorRecord.next();
                }
                return voidPointer;
            }
            catch (CorruptDataException corruptDataException) {
                EventManager.raiseCorruptDataEvent("Error getting next item", corruptDataException, false);
                return null;
            }
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }
}

