/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.util.PatternString;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.walkers.ClassSegmentIterator;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import java.io.PrintStream;

public class ClassForNameCommand
extends Command {
    public ClassForNameCommand() {
        this.addCommand("classforname", "<name>", "find the class corresponding to name (with wildcards)");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        if (stringArray.length == 0) {
            this.printUsage(printStream);
            return;
        }
        try {
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            ClassSegmentIterator classSegmentIterator = new ClassSegmentIterator(j9JavaVMPointer.classMemorySegments());
            int n = 0;
            String string2 = stringArray[0];
            PatternString patternString = new PatternString(string2);
            printStream.format("Searching for classes named '%1$s' in VM=%2$s%n", string2, Long.toHexString(j9JavaVMPointer.getAddress()));
            while (classSegmentIterator.hasNext()) {
                J9ClassPointer j9ClassPointer = (J9ClassPointer)classSegmentIterator.next();
                String string3 = J9ClassHelper.getJavaName(j9ClassPointer);
                if (!patternString.isMatch(string3)) continue;
                ++n;
                String string4 = j9ClassPointer.getHexAddress();
                printStream.format("!j9class %1$s named %2$s%n", string4, string3);
            }
            printStream.format("Found %1$d class(es) named %2$s%n", n, string2);
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }

    private void printUsage(PrintStream printStream) {
        printStream.println("classforname <name> - find the class corresponding to name (with wildcards)");
    }
}

