/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.walkers.ClassSegmentIterator;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.LinearDumper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.RamClassWalker;
import java.io.PrintStream;

public class DumpAllRamClassLinearCommand
extends Command {
    public DumpAllRamClassLinearCommand() {
        this.addCommand("dumpallramclasslinear", "[nestingThreshold]", "cfdump all J9RAMClass using the Linear RAM Class Dumper");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        if (stringArray.length > 1) {
            throw new DDRInteractiveCommandException("This debug extension accepts none or one argument!");
        }
        long l = stringArray.length == 1 ? Long.valueOf(stringArray[0]) : 1L;
        try {
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            if (null == j9JavaVMPointer) {
                throw new DDRInteractiveCommandException("Unable to find the VM in core dump!");
            }
            printStream.println();
            printStream.println("!j9javavm " + j9JavaVMPointer.getHexAddress());
            printStream.println();
            ClassSegmentIterator classSegmentIterator = new ClassSegmentIterator(j9JavaVMPointer.classMemorySegments());
            while (classSegmentIterator.hasNext()) {
                J9ClassPointer j9ClassPointer = (J9ClassPointer)classSegmentIterator.next();
                printStream.println("!dumpramclasslinear " + j9ClassPointer.getHexAddress());
                printStream.format("RAM Class '%s' at %s%n%n", J9ClassHelper.getJavaName(j9ClassPointer), j9ClassPointer.getHexAddress());
                RamClassWalker ramClassWalker = new RamClassWalker(j9ClassPointer, context);
                new LinearDumper().gatherLayoutInfo(printStream, ramClassWalker, l);
                printStream.println();
            }
        }
        catch (CorruptDataException corruptDataException) {
            corruptDataException.printStackTrace();
        }
    }
}

